<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<style>
    table {
      width: 100%;
    }

    /* Media query para pantallas pequeñas (móviles) */
    @media (max-width: 768px) {
      #ctnActaAsignacion {
        font-size: 9px!important; /* Ajusta el tamaño de la fuente en pantallas pequeñas */
        width: 100%!important;
      }
    
      table {
        width: 100%;
        font-size: 8px; /* Reduce el tamaño de la fuente en las tablas */
      }
    
      h2, h3, h4, h5 {
        font-size: 14px; /* Reduce el tamaño de los encabezados */
      }
    
      img {
        max-width: 100%;
        height: auto; /* Asegura que las imágenes no excedan el ancho de la pantalla */
      }
    
      td, th {
        padding: 3px; /* Reduce el padding de las celdas de la tabla */
      }
    
      /* Ajuste de la columna con imagen para que no se desborde */
      td[rowspan="2"] {
        width: 100%;
        text-align: center;
      }
    
      /* Ajusta la visualización de la firma y los botones */
      /*table, div {*/
      /*  margin-top: 10px;*/
      /*}*/
    
      /* Ajuste de las tablas para que se adapten mejor */
      table, th, td {
        /*border: 1px solid #ccc;*/
        text-align: center;
      }
    }
</style>
<div class="main-content">
	<div class="page-content">
		
		<div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card mt-n4 mx-n4 mb-n5">
                        <div class="bg-sistema color-white">
                            <div class="card-body pb-4 mb-5">
                                <div class="row">
                                    <div class="col-md">
                                        <div class="row align-items-center px-3">
                                            <div class="col-md">
                                                <h4 class="fw-semibold color-white" id="ticket-title">#<?= $idReposicion ?> - <?= ucwords(mb_strtolower($informacionReposicion['NombreAdjudicado'])).' | '.$informacionReposicion['MatriculaAdjudicado'] ?></h4>
                                                <div class="hstack gap-3 flex-wrap">
                                                    <div class="text-muted color-white">Receptor: <span id="ticket-client"><?= ucwords(mb_strtolower($informacionReposicion['NombreReceptor'])) ?></span></div>
                                                    <div class="vr"></div>
                                                    <div class="text-muted color-white">Fecha de reposición : <span class="fw-medium"><?= date("d-m-Y", strtotime($informacionReposicion['FechaCrea'])) ?></span></div>
                                                    <div class="vr"></div>
                                                    <div class="text-muted color-white">Fecha de firma : <span class="fw-medium"><?= $informacionReposicion['FechaRegistroFirma'] != '' && $informacionReposicion['FechaRegistroFirma'] != null ? date("d-m-Y H:i:s", strtotime($informacionReposicion['FechaRegistroFirma'])) : "Pendiente de Firma" ?></span></div>
                                                    <!--<div class="text-muted">Due Date : <span class="fw-medium" id="due-date">29 Dec, 2021</span></div>-->
                                                    <!--<div class="vr"></div>-->
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                    <!--end col-->
                                    <div class="col-md-auto mt-md-0 mt-4 d-flex justify-content-end align-items-center">
                                        <div class="hstack gap-1 flex-wrap">
                                            <?php
                                            if(in_array("EXCREP", $permisos))
                                            {
                                            ?>
                                            <button type="button" class="btn bg-rosa px-2 py-1" data-bs-target="#mdlExcepcionReposicion" data-id="<?= $idReposicion ?>" id="btnExcepcionReposicion" data-toggle="tooltip" data-placement="top" title="Generar Excepción a la reposición" aria-label="Generar Excepción a la reposición">
            									<i class="mdi mdi-currency-usd" style="font-size: 18px; color: #FFF"></i>
            								</button>
            								<?php
                                            }
                                            
                                            if($informacionReposicion['FechaRegistroFirma'] != '' && $informacionReposicion['FechaRegistroFirma'] != null)
                                            {
                                            ?>
                                            <button type="button" class="btn bg-warning px-2 py-1" data-id="<?= $idReposicion ?>" data-cod="<?= $informacionReposicion['TokenLinkFirma'] ?>" data-accion="download" id="btnDescargarPDFActaReposicion" data-toggle="tooltip" data-placement="top" title="Descargar PDF Acta Reposición" aria-label="Descargar PDF Acta Reposición">
            									<i class="mdi mdi-file-pdf-box" style="font-size: 18px; color: #FFF"></i>
            								</button>
            								<?php
            								}
            								?>
                                            <button type="button" class="btn bg-celeste px-2 py-1" data-id="<?= $idReposicion ?>" id="btnEnviarCorreoReposicion" data-toggle="tooltip" data-placement="top" title="Enviar Correo" aria-label="Enviar Correo">
            									<i class="mdi mdi-email-fast-outline" style="font-size: 18px; color: #FFF"></i>
            								</button>
                                            <a href="<?= $baseUrl.'/'.$previo ?>" class="btn btn-danger px-2 py-1" data-tooltip="tooltip" title="Volver">
                                                <i class="mdi mdi-arrow-left-circle" style="font-size: 18px; color: #FFF"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <!--end col-->
                                </div>
                                <!--end row-->
                            </div><!-- end card body -->
                        </div>
                    </div><!-- end card -->
                </div><!-- end col -->
            </div><!-- end row -->

            <div class="row">
                <div class="col-xxl-9">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Acta de Reposición</h5>
                        </div>
                        <div class="card-body">
                            <div class="px-2 d-flex justify-content-center">
                                <?= $actaReposicion ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Información de la Reposición</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive table-card">
                                <table class="table table-borderless align-middle mb-0">
                                    <tbody>
                                        <tr>
                                            <td class="fw-medium"># Reposición</td>
                                            <td>#<?= $informacionReposicion['IDReposicion'] ?></td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Usuario Adjudicado</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= ucwords(mb_strtolower($informacionReposicion['NombreAdjudicado'])) ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Matrícula Adjudicado</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $informacionReposicion['MatriculaAdjudicado'] ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Dirección Adjudicado</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $informacionReposicion['DireccionUsuarioAdjudicado'] ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Área Adjudicado</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $informacionReposicion['AreaUsuarioAdjudicado'] ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Fecha Adjudicado</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= date("d-m-Y", strtotime($informacionReposicion['FechaCrea'])) ?>
                                            </td>
                                        </tr>
                                        <tr class="<?= $informacionReposicion['FechaRegistroFirma'] != '' && $informacionReposicion['FechaRegistroFirma'] != null ? "bg-success" : "bg-warning" ?> color-white">
                                            <td class="fw-medium">Fecha de Firma</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $informacionReposicion['FechaRegistroFirma'] != '' && $informacionReposicion['FechaRegistroFirma'] != null ? date("d-m-Y H:i:s", strtotime($informacionReposicion['FechaRegistroFirma'])) : "Pendiente de Firma" ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Usuario Receptor</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= ucwords(mb_strtolower($informacionReposicion['NombreReceptor'])) ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!--end card-body-->
                    </div>
                    <!--end card-->
                    
                    <div class="card">
                        <div class="card-header d-flex align-items-center">
                            <h6 class="card-title mb-0 flex-grow-1">Adjuntos</h6>
                            <div class="d-flex">
                                <?php
                                if (in_array("ADJREP", $permisos))
                                {
                                ?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center px-2 py-1 color-white" data-bs-toggle="modal" data-bs-target="#agregarAdjuntoReposicion" data-form="#formAdjuntarDocumentoReposicion" id="btnAdjuntarDocumentoReposicion">
									<i class="mdi mdi-plus-circle" style="font-size: 18px;"></i>
								</button>
                                <?php
                                }
                                ?>

                            </div>
                        </div>
                        <div class="card-body">
                            <?php
                            if(isset($listaAdjunto) && !empty($listaAdjunto))
                            {
                                foreach($listaAdjunto as $adjuntos)
                                {
                                    if($adjuntos['Firma'] != "Y")
                                    {
                                    ?>
                                    <div class="d-flex align-items-center border border-dashed p-2 rounded mb-2">
                                        <div class="flex-shrink-0 avatar-sm">
                                            <div class="avatar-title bg-light rounded">
                                                <i class="mdi mdi-paperclip fs-20 text-primary"></i>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <h6 class="mb-1"><a><?= $adjuntos['Nombre'].'.'.$adjuntos['Extension'] ?></a></h6>
                                            <!--<small class="text-muted">3.2 MB</small>-->
                                        </div>
                                        <div class="hstack gap-3 fs-16">
                                            <a href='<?= base_url().'/'.$baseDinamic.'/docs/ActaReposicion/'.date("Y", strtotime($adjuntos['FechaCrea'])).'/'.date("m", strtotime($adjuntos['FechaCrea'])).'/'.$adjuntos['IDReposicion'].'-'.$adjuntos['IDAdjuntoReposicion'].'.'.$adjuntos['Extension'] ?>' download='<?= $adjuntos['Nombre'].'.'.$adjuntos['Extension'] ?>' class="text-muted"><i class="ri-download-2-line"></i></a>
                                        </div>
                                    </div>
                                    <?php
                                    }
                                }
                            }
                            else
                            {
                            ?>
                            <div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
                	            <div class="col-xxl-10 col-md-12 col-12 ">
                        	        <div class="alert alert-info alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN ADJUNTOS</strong> - No hay adjuntos relacionados.
                                    </div>
                                </div>
                        	</div>
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
                <!--end col-->
            </div>
            <!--end row-->

        </div><!-- container-fluid -->
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
        pondAdjuntoReposicion = FilePond.create(
            document.querySelector("#fileAdjuntoReposicion"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false
            }
        );
	});
</script>
<?php $this->endSection(); ?>

<!-- Modal Adjuntar Documento -->
<div class="modal fade zoomIn" id="agregarAdjuntoReposicion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleagregarAdjuntoReposicion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleagregarAdjuntoReposicion">Adjuntar documento a reposición</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioAdjuntarDocumentoReposicion" id="formAdjuntarDocumentoReposicion" autocomplete="off" action="<?= $baseUrl ?>/adjuntar-documento-reposicion/<?= $idReposicion ?>" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<label for="txtNombreAdjunto_i" class="form-label">Nombre</label>
						<div class="input-group">
							<input type="text" class="form-control" aria-label="Nombre" id="txtNombreAdjunto_i" name="txtNombreAdjunto_i">
						</div>
					</div>
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<div>
							<label for="txtObservacionAdjunto_i" class="form-label">Observación</label>
							<textarea class="form-control" id="txtObservacionAdjunto_i" name="txtObservacionAdjunto_i" rows="4"></textarea>
						</div>
					</div>
					<div class="col-12 mb-4 justify-content-center">
						<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
						    <h5 class="color-sistema m-0" for="chkAdjuntoFirma">¿Adjunto reemplaza firma?</h5>
						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkAdjuntoFirma">
								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" id="chkAdjuntoFirma" name="chkAdjuntoFirma">
								<label class="form-check-label m-0" for="chkAdjuntoFirma"></label>
							</div>
						</div>
					</div>
    				<h5 class="mb-3">Seleccione Adjunto:</h5>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-10 m-0 p-0">
					        <input type="file" id="fileAdjuntoReposicion" class="filepond" name="fileAdjuntoReposicion" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Excepción Reposición -->
<div class="modal fade zoomIn" id="mdlExcepcionReposicion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlExcepcionReposicion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlExcepcionReposicion">Agregar Excepción</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioExcepcionReposicion" id="formExcepcionReposicion" autocomplete="off" action="<?= $baseUrl ?>/registro-excepcion-reposicion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<input type="hidden" name="txtIDReposicion_exrep" value="<?= $idReposicion ?>">
				<div class="modal-body" id="ctnExcepcionReposicion">
					
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>



<?php $this->endSection(); ?>