<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<style>
    table {
      width: 100%;
    }

    /* Media query para pantallas pequeñas (móviles) */
    @media (max-width: 768px) {
      #ctnActaAsignacion {
        font-size: 9px!important; /* Ajusta el tamaño de la fuente en pantallas pequeñas */
        width: 100%!important;
      }
    
      table {
        width: 100%;
        font-size: 8px; /* Reduce el tamaño de la fuente en las tablas */
      }
    
      h2, h3, h4, h5 {
        font-size: 14px; /* Reduce el tamaño de los encabezados */
      }
    
      img {
        max-width: 100%;
        height: auto; /* Asegura que las imágenes no excedan el ancho de la pantalla */
      }
    
      td, th {
        padding: 3px; /* Reduce el padding de las celdas de la tabla */
      }
    
      /* Ajuste de la columna con imagen para que no se desborde */
      td[rowspan="2"] {
        width: 100%;
        text-align: center;
      }
    
      /* Ajusta la visualización de la firma y los botones */
      /*table, div {*/
      /*  margin-top: 10px;*/
      /*}*/
    
      /* Ajuste de las tablas para que se adapten mejor */
      table, th, td {
        /*border: 1px solid #ccc;*/
        text-align: center;
      }
    }
</style>
<div class="main-content">
	<div class="page-content">
		
		<div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card mt-n4 mx-n4">
                        <div class="bg-sistema color-white">
                            <div class="card-body pb-0">
                                <div class="row">
                                    <div class="col-md">
                                        <div class="row align-items-center px-3">
                                            <div class="col-md">
                                                <h4 class="fw-semibold color-white" id="ticket-title">#<?= $idDevolucion ?> - <?= ucwords(mb_strtolower($informacionDevolucion['NombreUsuario'])).' | '.$informacionDevolucion['MatriculaUsuario'] ?></h4>
                                                <div class="hstack gap-3 flex-wrap">
                                                    <div class="text-muted color-white">Receptor: <span id="ticket-client"><?= ucwords(mb_strtolower($informacionDevolucion['NombreReceptor'])) ?></span></div>
                                                    <div class="vr"></div>
                                                    <div class="text-muted color-white">Fecha de devolución : <span class="fw-medium"><?= date("d-m-Y", strtotime($informacionDevolucion['FechaCrea'])) ?></span></div>
                                                    <div class="vr"></div>
                                                    <div class="text-muted color-white">Fecha de firma : <span class="fw-medium"><?= $informacionDevolucion['FechaRegistroFirma'] != '' && $informacionDevolucion['FechaRegistroFirma'] != null ? date("d-m-Y H:i:s", strtotime($informacionDevolucion['FechaRegistroFirma'])) : "Pendiente de Firma" ?></span></div>
                                                    <!--<div class="text-muted">Due Date : <span class="fw-medium" id="due-date">29 Dec, 2021</span></div>-->
                                                    <!--<div class="vr"></div>-->
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                    <!--end col-->
                                    <div class="col-md-auto mt-md-0 mt-4 d-flex justify-content-end align-items-center">
                                        <div class="hstack gap-1 flex-wrap">
                                            <?php 
                                            if($informacionDevolucion['FechaRegistroFirma'] != '' && $informacionDevolucion['FechaRegistroFirma'] != null)
                                            {
                                            ?>
                                            <button type="button" class="btn bg-warning px-2 py-1" data-id="<?= $idDevolucion ?>" data-cod="<?= $informacionDevolucion['TokenLinkFirma'] ?>" data-accion="download" id="btnDescargarPDFActaDevolucion" data-toggle="tooltip" data-placement="top" title="Descargar PDF Acta Devolución" aria-label="Descargar PDF Acta Devolución">
            									<i class="mdi mdi-file-pdf-box" style="font-size: 18px; color: #FFF"></i>
            								</button>
            								<?php
            								}
            								?>
                                            <button type="button" class="btn bg-celeste px-2 py-1" data-id="<?= $idDevolucion ?>" id="btnEnviarCorreoDevolucion" data-toggle="tooltip" data-placement="top" title="Enviar Correo" aria-label="Enviar Correo">
            									<i class="mdi mdi-email-fast-outline" style="font-size: 18px; color: #FFF"></i>
            								</button>
                                            <a href="<?= $baseUrl.'/'.$previo ?>" class="btn btn-danger px-2 py-1" data-tooltip="tooltip" title="Volver">
                                                <i class="mdi mdi-arrow-left-circle" style="font-size: 18px; color: #FFF"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <!--end col-->
                                </div>
                                <!--end row-->
                                <ul class="nav nav-tabs-custom border-bottom-0 mt-2" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link active fw-semibold" data-bs-toggle="tab" href="#actaDevolucion" role="tab" aria-selected="true">
                                            Acta de Devolución
                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link fw-semibold" data-bs-toggle="tab" href="#detalleElementos" role="tab" aria-selected="false" tabindex="-1" data-devolucion="<?= $informacionDevolucion['IDDevolucion'] ?>" onclick="return recargarDetalleElementosActaDevolucion(this)">
                                            Detalle de Elementos
                                        </a>
                                    </li>
                                </ul>
                            </div><!-- end card body -->
                        </div>
                    </div><!-- end card -->
                </div><!-- end col -->
            </div><!-- end row -->

            <div class="row">
                <div class="col-xxl-9">
                    <div class="tab-content text-muted">
                        <div class="tab-pane fade show active" id="actaDevolucion" role="tabpanel">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Elementos Devueltos</h5>
                                </div>
                                <div class="card-body">
                                    <div class="px-2 d-flex justify-content-center">
                                        <?= $actaDevolucion ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="detalleElementos" role="tabpanel">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Detalle de Elementos de Devolución</h4>
                                    <div class="flex-shrink-0">
                                        <?php
        								if (in_array("VALDEV", $permisos)) 
        								{
        								?>
                                        <button type="button" class="btn bg-primary px-2 py-1" data-tooltip="tooltip" title="Validar Activos" data-bs-target="#mdlValidarActivosDevolucion" data-form="#formValidarActivosDevolucion" id="btnValidarActivosDevueltos" data-devolucion="<?= $idDevolucion ?>">
                                            <i class="mdi mdi-refresh" style="font-size: 18px; color: #FFF"></i>
                                        </button>
                                        <?php
        								}
        								?>
                                    </div>
                                </div><!-- end card header -->
                                <div class="card-body">
                                    <!--<div class="px-2 d-flex justify-content-center">-->
                                        <table id="tblDetalleElementosDevolucion" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
                            			    <thead>
                                                <tr>
                                                    <th class="">Código</th>
                                                    <th class="">Tipo Elemento</th>
                                                    <th class="">Elemento</th>
                                                    <th class="">Motivo Devolución</th>
                                                    <th class="">Observación</th>
                                                    <th class="">¿Validado?</th>
                                                    <th class="">¿Generó Reposición?</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    <!--</div>-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Información de la Devolución</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive table-card">
                                <table class="table table-borderless align-middle mb-0">
                                    <tbody>
                                        <tr>
                                            
                                            <td class="fw-medium"># Devolución</td>
                                            <td>#<?= $informacionDevolucion['IDDevolucion'] ?></td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Usuario Entregante</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= ucwords(mb_strtolower($informacionDevolucion['NombreUsuario'])) ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Matrícula Entregante</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $informacionDevolucion['MatriculaUsuario'] ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Dirección Entregante</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $informacionDevolucion['DireccionUsuarioDevolucion'] ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Área Entregante</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $informacionDevolucion['AreaUsuarioDevolucion'] ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Fecha Devolución</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= date("d-m-Y", strtotime($informacionDevolucion['FechaCrea'])) ?>
                                            </td>
                                        </tr>
                                        <tr class="<?= $informacionDevolucion['FechaRegistroFirma'] != '' && $informacionDevolucion['FechaRegistroFirma'] != null ? "bg-success" : "bg-warning" ?> color-white">
                                            <td class="fw-medium">Fecha de Firma</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $informacionDevolucion['FechaRegistroFirma'] != '' && $informacionDevolucion['FechaRegistroFirma'] != null ? date("d-m-Y H:i:s", strtotime($informacionDevolucion['FechaRegistroFirma'])) : "Pendiente de Firma" ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Usuario Receptor</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= ucwords(mb_strtolower($informacionDevolucion['NombreReceptor'])) ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!--end card-body-->
                    </div>
                    <!--end card-->
                    
                    <div class="card">
                        <div class="card-header d-flex align-items-center">
                            <h6 class="card-title mb-0 flex-grow-1">Adjuntos</h6>
                            <div class="d-flex">
                                <?php
                                if (in_array("ADJDEV", $permisos))
                                {
                                ?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center px-2 py-1 color-white" data-bs-toggle="modal" data-bs-target="#agregarAdjuntoDevolucion" data-form="#formAdjuntarDocumentoDevolucion" id="btnAdjuntarDocumentoDevolucion">
									<i class="mdi mdi-plus-circle" style="font-size: 18px;"></i>
								</button>
                                <?php
                                }
                                ?>

                            </div>
                        </div>
                        <div class="card-body">
                            <?php
                            if(isset($listaAdjunto) && !empty($listaAdjunto))
                            {
                                foreach($listaAdjunto as $adjuntos)
                                {
                                ?>
                                <div class="d-flex align-items-center border border-dashed p-2 rounded mb-2">
                                    <div class="flex-shrink-0 avatar-sm">
                                        <div class="avatar-title bg-light rounded">
                                            <i class="mdi mdi-paperclip fs-20 text-primary"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h6 class="mb-1"><a><?= $adjuntos['Nombre'].'.'.$adjuntos['Extension'] ?></a></h6>
                                        <!--<small class="text-muted">3.2 MB</small>-->
                                    </div>
                                    <div class="hstack gap-3 fs-16">
                                        <a href='<?= base_url().'/'.$baseDinamic.'/docs/ActaDevolucion/'.$adjuntos['IDDevolucion'].'-'.$adjuntos['IDAdjuntoDevolucion'].'.'.$adjuntos['Extension'] ?>' download='<?= $adjuntos['Nombre'].'.'.$adjuntos['Extension'] ?>' class="text-muted"><i class="ri-download-2-line"></i></a>
                                    </div>
                                </div>
                                <?php
                                }
                            }
                            else
                            {
                            ?>
                            <div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
                	            <div class="col-xxl-10 col-md-12 col-12 ">
                        	        <div class="alert alert-info alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN ADJUNTOS</strong> - No hay adjuntos relacionados.
                                    </div>
                                </div>
                        	</div>
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
                <!--end col-->
            </div>
            <!--end row-->

        </div><!-- container-fluid -->
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () 
	{
        pondAdjuntoDevolucion = FilePond.create(
            document.querySelector("#fileAdjuntoDevolucion"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false
            }
        );
        
    	$('.cboSituacionRealActivoDevuelto').select2({
            dropdownParent: $('#mdlValidarActivosDevolucion .modal-body'),
            placeholder: "Seleccione una opción",
            allowClear: true
        });
        
	});
</script>
<?php $this->endSection(); ?>

<!-- Modal Adjuntar Documento -->
<div class="modal fade zoomIn" id="agregarAdjuntoDevolucion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleagregarAdjuntoDevolucion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleagregarAdjuntoDevolucion">Adjuntar documento a devolución</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioAdjuntarDocumentoDevolucion" id="formAdjuntarDocumentoDevolucion" autocomplete="off" action="<?= $baseUrl ?>/adjuntar-documento-devolucion/<?= $idDevolucion ?>" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<label for="txtNombreAdjunto_i" class="form-label">Nombre</label>
						<div class="input-group">
							<input type="text" class="form-control" aria-label="Nombre" id="txtNombreAdjunto_i" name="txtNombreAdjunto_i">
						</div>
					</div>
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<div>
							<label for="txtObservacionAdjunto_i" class="form-label">Observación</label>
							<textarea class="form-control" id="txtObservacionAdjunto_i" name="txtObservacionAdjunto_i" rows="4"></textarea>
						</div>
					</div>
					<div class="col-12 mb-4 justify-content-center">
						<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
						    <h5 class="color-sistema m-0" for="chkAdjuntoFirma">¿Adjunto reemplaza firma?</h5>
						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkAdjuntoFirma">
								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" id="chkAdjuntoFirma" name="chkAdjuntoFirma">
								<label class="form-check-label m-0" for="chkAdjuntoFirma"></label>
							</div>
						</div>
					</div>
    				<h5 class="mb-3">Seleccione Adjunto:</h5>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-10 m-0 p-0">
					        <input type="file" id="fileAdjuntoDevolucion" class="filepond" name="fileAdjuntoDevolucion" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Validar Recepción de Activo -->
<div class="modal fade zoomIn" id="mdlValidarActivoDevolucion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlValidarActivoDevolucion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlValidarActivoDevolucion">Validar Activo Devuelto</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioValidarActivoDevolucion" id="formValidarActivoDevolucion" autocomplete="off" action="<?= $baseUrl ?>/validacion-detalle-devolucion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row">
					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
                            <div class="col-12">
                                <h5 class="mb-1">Recepción de elemento</h5>
                                <p class="color-red m-0">Por favor, seleccione si recepcionó el elemento:</p>
                            </div>
                            <div class="row col-12 g-4 m-0 p-0">
                                <div class="col-lg-6 col-sm-6 px-3">
                                    <div>
                                        <div class="form-check card-radio">
                                            <input id="rdbtnActivoRecibido_vda" name="txtRecepcionElemento_vda" type="radio" class="form-check-input">
                                            <label class="form-check-label" for="rdbtnActivoRecibido_vda">
                                                <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-up align-bottom"></i></span>
                                                <span class="fs-14 text-wrap">Recepcionado</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-sm-6 px-3">
                                    <div>
                                        <div class="form-check card-radio">
                                            <input id="rdbtnActivoNoRecibido_vda" name="txtRecepcionElemento_vda" type="radio" class="form-check-input">
                                            <label class="form-check-label" for="rdbtnActivoNoRecibido_vda">
                                                <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-down align-bottom"></i></span>
                                                <span class="fs-14 text-wrap">No Recepcionado</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="collapse m-0 p-0" id="ctnEstadoRealDevolucion" style="">
                            <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                <div class="col-12">
                                    <h5 class="mb-1">Estado Real de recepción</h5>
                                    <p class="color-red m-0">¿El estado real es el indicado en el acta de devolución?:</p>
                                </div>
                                <div class="row col-12 g-4 m-0 p-0">
                                    <div class="col-lg-6 col-sm-6 px-3">
                                        <div>
                                            <div class="form-check card-radio">
                                                <input id="rdbtnEstadoRealActivo_vda" name="txtEstadoRealDevolucionActivo_vda" type="radio" class="form-check-input">
                                                <label class="form-check-label" for="rdbtnEstadoRealActivo_vda">
                                                    <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-up align-bottom"></i></span>
                                                    <span class="fs-14 text-wrap">Si</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 col-sm-6 px-3">
                                        <div>
                                            <div class="form-check card-radio">
                                                <input id="rdbtnEstadoNoRealActivo_vda" name="txtEstadoRealDevolucionActivo_vda" type="radio" class="form-check-input">
                                                <label class="form-check-label" for="rdbtnEstadoNoRealActivo_vda">
                                                    <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-down align-bottom"></i></span>
                                                    <span class="fs-14 text-wrap">No</span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="collapse m-0 p-0" id="ctnInformeRecepcionActivo" style="">
                            <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                <div class="col-12">
                                    <h5 class="mb-2">Información para generar Informe de Recepción</h5>
                                </div>
                                <div class="col-12 m-0 p-0 px-3">
                                    <div class="row col-12 card border shadow-none m-0 p-0">
                                        <!--<div class="row col-12 gy-3">-->
                                        <!--    <div class="col-md-12">-->
                                        <!--        <label for="cc-name" class="form-label">Name on card</label>-->
                                        <!--        <input type="text" class="form-control" id="cc-name" placeholder="Enter name">-->
                                        <!--        <small class="text-muted">Full name as displayed on card</small>-->
                                        <!--    </div>-->
    
                                        <!--    <div class="col-md-6">-->
                                        <!--        <label for="cc-number" class="form-label">Credit card number</label>-->
                                        <!--        <input type="text" class="form-control" id="cc-number" placeholder="xxxx xxxx xxxx xxxx">-->
                                        <!--    </div>-->
    
                                        <!--    <div class="col-md-3">-->
                                        <!--        <label for="cc-expiration" class="form-label">Expiration</label>-->
                                        <!--        <input type="text" class="form-control" id="cc-expiration" placeholder="MM/YY">-->
                                        <!--    </div>-->
    
                                        <!--    <div class="col-md-3">-->
                                        <!--        <label for="cc-cvv" class="form-label">CVV</label>-->
                                        <!--        <input type="text" class="form-control" id="cc-cvv" placeholder="xxx">-->
                                        <!--    </div>-->
                                        <!--</div>-->
                                        <div class="col-xxl-6 col-md-12 col-12 mb-2">
                                            <div>
                                                <label for="txtSituacionRealDevuelto" class="form-label">Estado real del activo devuelto</label>
                                                <select class="form-select select2-situacionelementodevolucion" aria-label="Estado real Activo" id="txtSituacionRealDevuelto" name="txtSituacionRealDevuelto" required>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-12 col-12 mb-2">
                							<div>
                								<label class="form-label" >Tipo de Informe</label>
                								<input type="text" class="form-control" style="color: #0000FF" value="Devolución de Activo" disabled >
                							</div>
                						</div>
                                    </div>
                                </div>
                            </div>
                        </div>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Validar Todos Recepción Activos -->
<div class="modal fade zoomIn" id="mdlValidarActivosDevolucion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlValidarActivosDevolucion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlValidarActivosDevolucion">Validar Activos Devueltos</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioValidarDevolucionActivo" id="formValidarActivosDevolucion" autocomplete="off" action="<?= $baseUrl ?>/registro-validacion-activos-devolucion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<input type="hidden" name="txtIDDevolucion_vda" value="<?= $idDevolucion ?>">
				<div class="modal-body" id="ctnActivosValidarDevolucion">
					
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>