<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
            <div class="position-relative mx-n4 mt-n4">
                <div class="profile-wid-bg profile-setting-img">
                    <div class="overlay-content">
                        <div class="text-end p-3">
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xxl-3">
                    <div class="card mt-n5">
                        <div class="card-body p-4">
                            <div class="text-center">
                                <div class="profile-user position-relative d-inline-block mx-auto  mb-4">
                                    <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/users/user-dummy-img.jpg" class="rounded-circle avatar-xl img-thumbnail user-profile-image" alt="user-profile-image">
                                    <div class="avatar-xs p-0 rounded-circle profile-photo-edit">
                                        <input id="profile-img-file-input" type="file" class="profile-img-file-input">
                                        <label for="profile-img-file-input" class="profile-photo-edit avatar-xs">
                                            <span class="avatar-title rounded-circle bg-light text-body">
                                                <i class="ri-camera-fill"></i>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <h5 class="fs-16 mb-1"><?= ucwords(mb_strtolower($informacionUsuario['Nombres'].' '.$informacionUsuario['Apellidos'])) ?></h5>
                                <p class="text-muted mb-0"><?= mb_strtoupper($informacionUsuario['Matricula']) ?> | <?= ucwords(mb_strtolower($informacionUsuario['Cargo'])) ?></p>
                            </div>
                        </div>
                    </div>
                    <!--end card-->
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title mb-3">Información de Contacto</h5>
                            <div class="table-responsive">
                                <table class="table table-borderless mb-0">
                                    <tbody>
                                        <tr>
                                            <th class="ps-0" scope="row">Perfil :</th>
                                            <td class="text-muted"><?= ucwords(mb_strtolower($perfilUsuario['Perfil'])) ?></td>
                                        </tr>
                                        <tr>
                                            <th class="ps-0" scope="row">Matrícula :</th>
                                            <td class="text-muted"><?= mb_strtoupper($informacionUsuario['Matricula']) ?></td>
                                        </tr>
                                        <tr>
                                            <th class="ps-0" scope="row">Usuario :</th>
                                            <td class="text-muted"><?= $informacionUsuario['Usuario'] ?></td>
                                        </tr>
                                        <tr>
                                            <th class="ps-0" scope="row">Correo Corporativo :</th>
                                            <td class="text-muted"><?= $informacionUsuario['Correo'] ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div><!-- end card body -->
                    </div>
                    <!--end card-->
                </div>
                <!--end col-->
                <div class="col-xxl-9">
                    <div class="card mt-xxl-n5">
                        <div class="card-header">
                            <ul class="nav nav-tabs-custom rounded card-header-tabs border-bottom-0" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active d-flex justify-content-center align-items-center" data-bs-toggle="tab" href="#informacionPersonal" role="tab" aria-selected="true">
                                        <i class="mdi mdi-badge-account-horizontal-outline align-bottom me-1" style="font-size: 14px;"></i> Información Personal
                                    </a>
                                </li>
                                <?php
                                if(!empty($delegacionesUsuario))
                                {
                                ?>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link d-flex justify-content-center align-items-center" data-bs-toggle="tab" href="#delegacionesUsuario" role="tab" aria-selected="false" tabindex="-1">
                                        <i class="mdi mdi-domain align-bottom me-1" style="font-size: 14px;"></i> Delegaciones a Cargo
                                    </a>
                                </li>
                                <?php
                                }
                                ?>
                            </ul>
                        </div>
                        <div class="card-body p-4">
                            <div class="tab-content">
                                <div class="tab-pane active show" id="informacionPersonal" role="tabpanel">
                                    <form action="javascript:void(0);">
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Matrícula</label>
                                                    <input type="text" class="form-control" placeholder="Matrícula..." value="<?= mb_strtoupper($informacionUsuario['Matricula']) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Fecha de Ingreso</label>
                                                    <input type="date" class="form-control" placeholder="Fecha de Ingreso..." value="<?= date("Y-m-d", strtotime($informacionUsuario['FechaIngreso'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Nombres</label>
                                                    <input type="text" class="form-control" placeholder="Nombres..." value="<?= ucwords(mb_strtolower($informacionUsuario['Nombres'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Apellidos</label>
                                                    <input type="text" class="form-control" placeholder="Apellidos..." value="<?= ucwords(mb_strtolower($informacionUsuario['Apellidos'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Dirección</label>
                                                    <input type="text" class="form-control" placeholder="Dirección..." value="<?= ucwords(mb_strtolower($informacionUsuario['Direccion'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Área</label>
                                                    <input type="text" class="form-control" placeholder="Área..." value="<?= ucwords(mb_strtolower($informacionUsuario['Area'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Subárea</label>
                                                    <input type="text" class="form-control" placeholder="Subárea..." value="<?= ucwords(mb_strtolower($informacionUsuario['Subarea'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label class="form-label">Cargo</label>
                                                    <input type="text" class="form-control" placeholder="Cargo..." value="<?= ucwords(mb_strtolower($informacionUsuario['Cargo'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Delegación</label>
                                                    <input type="text" class="form-control" placeholder="Delegación..." value="<?= ucwords(mb_strtolower($informacionUsuario['Delegacion'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-4">
                                                <div class="mb-3">
                                                    <label class="form-label">CC</label>
                                                    <input type="text" class="form-control" placeholder="CC..." value="<?= ucwords(mb_strtolower($informacionUsuario['CC'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-4">
                                                <div class="mb-3">
                                                    <label class="form-label">LN</label>
                                                    <input type="text" class="form-control" placeholder="LN..." value="<?= ucwords(mb_strtolower($informacionUsuario['LN'])) ?>" disabled>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </form>
                                </div>
                                <!--end tab-pane-->
                                <div class="tab-pane" id="delegacionesUsuario" role="tabpanel">
                                    <table id="tblDelegacionesUsuario" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
        								<thead>
        									<tr>
        										<th class="text-center align-middle">Delegación</th>
        										<th class="text-center align-middle">CC</th>
        										<th class="text-center align-middle">LN</th>
        									</tr>
        								</thead>
        								<tbody>
        									<?php 
        									foreach($delegacionesUsuario as $items){ ?>
        									<tr>
        										<td class="text-center align-middle"><?= $items['Delegacion'] ?></td>
        										<td class="text-center align-middle"><?= $items['CC'] ?></td>
        										<td class="text-center align-middle"><?= $items['LN'] ?></td>
        									</tr>
        									<?php } ?>
        								</tbody>
        							</table>
        							<?= $this->section('js'); ?>
        							<script>
        							    $(document).ready(function() {
                                            // Inicialización correcta de DataTable
                                            $('#tblDelegacionesUsuario').DataTable({
                                                order: [[1, 'asc']],  // Ordenar por la segunda columna (índice 1) de forma ascendente
                                                pageLength: 20        // Número de filas por página
                                            });
                                        });
        							</script>
        							<?php $this->endSection(); ?>
                                </div>
                                <!--end tab-pane-->
                            </div>
                        </div>
                    </div>
                </div>
                <!--end col-->
            </div>
            <!--end row-->

        </div>
        <!-- container-fluid -->
    </div><!-- End Page-content -->

    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <script>document.write(new Date().getFullYear())</script> © Verisure Peru.
                </div>
                <div class="col-sm-6">
                    <div class="text-sm-end d-none d-sm-block">
                        Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- end main content-->
<?php $this->endSection(); ?>