<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioModel extends Model {
/*    protected $table = 'usuario';
    protected $primaryKey = 'id_usuario';
    protected $allowedFields = ['id_usuario','usuario','contrasena','perfil_id','nombres','apellidos','tipo_documento','numero_documento','correo_electronico','token','fecha_caducidad_token','fecha_solicitud_recuperacion','fecha_cambio_contrasena','fecha_registro','fecha_actualizacion','eliminacion_logica'];
*/
    protected $DBGroup = 'baseT';
    protected $table = 'tblusuario';
    protected $primaryKey = 'IdUsuario';
    protected $allowedFields = ['IdArea','IdPerfil','Matricula','Nombres','Apellidos','TipoDocumento','NumeroDoc','Telefono','Demo','Cargo','Categoria','Instalador','CC','LN','Manager','TipoUsuario','Correo','Usuario','Password','FechaIngreso','FechaCese','Estado','FTE','Foto','FechaHoraREG','FechaHoraMODIF','RMKT','Token','Estrellas','TCTV','RemarketingTV','TC','Push','Pull','Equipo','RemarketingTC', 'IDCargo', 'IDManager', 'IDSubarea','IDDelegacion', 'brevete', 'numero_placa','UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    public function obtenerUsuario($idUsuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Matricula,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.FechaCese,
            tblusuario.IDManager,
            tblusuario.FechaIngreso,
            tblusuario.FTE,
            tblusuario.IDSubarea,
            estructura_subarea.Subarea,
            estructura_subarea.IDArea,
            estructura_area.Area,
            estructura_area.IDDireccion,
            estructura_direccion.Direccion,
            tblusuario.IDCargo,
            cargos.Cargo,
            tblusuario.IDDelegacion,
            estructura_delegacion.CC,
            estructura_delegacion.LN,
            estructura_delegacion.Delegacion');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.IdUsuario', $idUsuario);
        $datos = $this->first();
        return $datos;
    }
    
    public function validarIngresoUsuario($usuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Matricula,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.Password,
            tblusuario.IDDelegacion,
            tblusuario.IDSubarea,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            tblusuario.IDCargo,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.Usuario', $usuario);
        $datos = $this->first();
        return $datos;
    }

    public function validarSistemaUsuario($idUsuario, $raiz)
    {
        $this->select('tblusuario.IdUsuario,
            usuario_sistemas.IDSistema,
            sistemas.Sistema,
            sistemas.Estado');
        $this->join('usuario_sistemas', 'tblusuario.IdUsuario = usuario_sistemas.IdUsuario');
        $this->join('sistemas', 'usuario_sistemas.IDSistema = sistemas.IDSistema');
        $this->where('usuario_sistemas.IdUsuario', $idUsuario);
        $this->where('sistemas.Raiz', $raiz);
        $datos = $this->first();
        return $datos;
    }
    
    public function listaGeneralUsuario($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'tblusuario.IdUsuario', 
            2 => 'tblusuario.Matricula', 
            3 => 'tblusuario.NumeroDoc', 
            5 => 'tblusuario.Usuario', 
            6 => 'tblusuario.Estado');
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('tblusuario.IdUsuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            CONCAT(tblusuario.Nombres, " ",tblusuario.Apellidos) AS nombre_usuario,
            tblusuario.Matricula,
            tblusuario.NumeroDoc,
            tblusuario.Usuario,
            tblusuario.Estado');
            
        // $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        // $this->join('cuentacontable_subcategorias', 'ordencompra.IDSubcategoria = cuentacontable_subcategorias.IDSubcategoriaCC', 'left');
        // $this->join('cuentacontable_categorias', 'cuentacontable_subcategorias.IDCategoriaCC = cuentacontable_categorias.IDCategoriaCC', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if($k == 1)
                {
                    $this->orLike('CONCAT(tblusuario.Nombres, " ", tblusuario.Apellidos)', $get['search']['value']);
                }
                else if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        return $result;
    }

    // public function listaGeneralUsuario($orderBy,$where,$length,$start) {
    //     $sSelect = "tblusuario.IdUsuario,CONCAT(tblusuario.Nombres, ' ', tblusuario.Apellidos) as nombre_usuario,tblusuario.Matricula,tblusuario.NumeroDoc,dbCOMPRAS.perfil.Perfil AS perfil_usuario, tblusuario.Usuario,tblusuario.Estado, 'SININFO' AS acciones_usuario";
    //     $sTable = "tblusuario LEFT JOIN dbCOMPRAS.usuario_perfil ON tblusuario.IdUsuario = dbCOMPRAS.usuario_perfil.IdUsuario LEFT JOIN dbCOMPRAS.perfil ON dbCOMPRAS.usuario_perfil.IDPerfil = dbCOMPRAS.perfil.IDPerfil";
    //     $whereRespuesta = $where==""?"":"WHERE (".$where ."')";
    //     $consulta = "SELECT " . $sSelect ." FROM ".  $sTable . " " .$whereRespuesta ."  " . $orderBy . " LIMIT ". $length ." OFFSET " .$start;
        
    //     $obtieneConsulta = $this->db->query($consulta);
    //     $consultaTotal = "SELECT count(IdUsuario) as total FROM tblusuario";
    //     $totalRegistros = $this->db->query($consultaTotal);
    //     $obtieneTotalRegistros = $totalRegistros->getResultArray();
        
    //     if ($obtieneConsulta->getNumRows() > 0) {
    //         $datos = [
    //             // 'draw' => "4",
    //             'data' => $obtieneConsulta->getResultArray(),
    //             'recordsTotal' => $obtieneTotalRegistros[0]['total'],
    //             'recordsFiltered' => (int)(($obtieneTotalRegistros[0]['total']*$length)/$length)
    //         ];
    //         return $datos;
    //     } else {
    //         return FALSE;
    //     }
    // }

    public function buscarUsuario($idUsuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Matricula,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.IDDelegacion,
            tblusuario.IDSubarea,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.IdUsuario', $idUsuario);
        $datos = $this->first();
        return $datos;
    }

    public function buscarUsuarioXusuario($usuario)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Matricula,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.IDSubarea,
            tblusuario.IDDelegacion,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            tblusuario.IDCargo,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.Usuario', $usuario);
        $datos = $this->first();
        return $datos;
    }

    public function buscarUsuarioXmatricula($matricula)
    {
        $this->select('tblusuario.IdUsuario,
            tblusuario.Matricula,
            tblusuario.Usuario,
            tblusuario.Nombres,
            tblusuario.Apellidos,
            tblusuario.TipoDocumento,
            tblusuario.NumeroDoc,
            tblusuario.Correo,
            tblusuario.Estado,
            tblusuario.IDSubarea,
            tblusuario.IDDelegacion,
            tblusuario.brevete,
            tblusuario.numero_placa,
            estructura_area.IDArea,
            estructura_area.Area,
            estructura_direccion.IDDireccion,
            estructura_direccion.Direccion,
            estructura_delegacion.CC,
            cargos.Cargo');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('tblusuario.Matricula', $matricula);
        $datos = $this->first();
        return $datos;
    }

    public function listadoUsuariosSelect($variable, $cc = '', $estado = '')
    {
        $this->select('
        tblusuario.IdUsuario,
        tblusuario.Matricula,
        tblusuario.Nombres,
        tblusuario.Apellidos,
        tblusuario.NumeroDoc,
        estructura_delegacion.CC');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where("(tblusuario.Matricula LIKE '%".$variable."%' OR 
            tblusuario.Nombres LIKE '%".$variable."%' OR
            tblusuario.Apellidos LIKE '%".$variable."%' OR 
            tblusuario.Usuario LIKE '%".$variable."%' OR 
            CONCAT(tblusuario.Nombres, ' ',tblusuario.Apellidos) LIKE '%".$variable."%' OR 
            tblusuario.NumeroDoc LIKE '%".$variable."%')");

        if($cc != '')
        {
            $this->where('estructura_delegacion.CC', $cc);
        }
        
        if($estado != '')
        {
            $this->where('tblusuario.Estado', $estado);
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listaGeneralUsuarios($array) 
    {
        $this->select('
        tblusuario.IdUsuario,
        tblusuario.Matricula,
        tblusuario.Nombres,
        tblusuario.Apellidos,
        CONCAT(tblusuario.Nombres, " ", tblusuario.Apellidos) AS "NombreCompleto",
        tblusuario.NumeroDoc,
        estructura_delegacion.CC,
        tblusuario.Estado');
        $this->join('estructura_delegacion', 'tblusuario.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->join('estructura_subarea', 'tblusuario.IDSubarea = estructura_subarea.IDSubarea', 'left');
        $this->join('estructura_area', 'estructura_subarea.IDArea = estructura_area.IDArea', 'left');
        $this->join('estructura_direccion', 'estructura_area.IDDireccion = estructura_direccion.IDDireccion', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');

        if(isset($array['estado']) && $array['estado'] != '')
        {
            $this->where("tblusuario.Estado", $array['estado']);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
}
