<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioDelegacionModel extends Model {
    
    protected $DBGroup          = 'baseT';
    protected $table            = 'usuario_delegaciones';
    protected $primaryKey       = 'IDUsuario';
    protected $allowedFields    = ['IDUsuario', 'IDDelegacion', 'UsuarioRegistra', 'FechaRegistra', 'Localhost'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes   = false;
    
    public function listarDelegacionesXUsuario($idUsuario)
    {
        $this->select('usuario_delegaciones.IDUsuario,
            usuario_delegaciones.IDDelegacion,
            estructura_delegacion.CC,
            estructura_delegacion.LN,
            estructura_delegacion.Delegacion');
        $this->join('estructura_delegacion', 'usuario_delegaciones.IDDelegacion = estructura_delegacion.IDDelegacion', 'left');
        $this->where('usuario_delegaciones.IDUsuario', $idUsuario);
        $datos = $this->findAll();
        return $datos;
    }
    
}
