<?php
namespace App\Models\URES;
use CodeIgniter\Model;

class KitsTrabajoElementosModel extends Model
{
    protected $table      = 'kit_trabajo_elementos';
    protected $primaryKey = 'IDKitTrabajo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDKitTrabajo', 'IDElementoTrabajo', 'Detalle', 'UsuarioRegistra', 'FechaRegistra', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarElementosKitTrabajo($idKitTrabajo)
    {
        $this->select('kit_trabajo_elementos.IDKitTrabajo,
            kit_trabajo_elementos.IDElementoTrabajo,
            elementos_trabajo.SKU,
            elementos_trabajo.Nombre,
            elementos_trabajo.MonedaReposicion,
            elementos_trabajo.PrecioReposicion');
        $this->join('elementos_trabajo', 'kit_trabajo_elementos.IDElementoTrabajo = elementos_trabajo.IDElementoTrabajo', 'left');
        
        $this->where('kit_trabajo_elementos.IDKitTrabajo', $idKitTrabajo);
        
        
        $datos = $this->findAll();
        return $datos;
    }
}