<?php
namespace App\Models\URES;
use CodeIgniter\Model;

class KitsDemoModel extends Model
{
    protected $table      = 'kit_demo';
    protected $primaryKey = 'IDItemKitDemo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['CodigoKitDemo', 'IDElementoDemo', 'Serie', 'Detalle', 'FechaCompra', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralViewKitDemo($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_kit_demo');
        
        $fields = array(
            0 => 'IDItemKitDemo', 
            1 => 'CodigoKitDemo', 
            2 => 'Nombre', 
            3 => 'SKU', 
            4 => 'Detalle', 
            5 => 'MatriculaAsignado', 
            6 => 'UsuarioAsignado', 
            8 => 'FechaAsignado', 
            9 => 'Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $sql = $builder->getCompiledSelect();
        $totalRecords = $this->db->query($sql)->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_kit_demo');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            if(in_array($get['search']['value'], array("No Asignado", "no asignado", "No asignado", "NO ASIGNADO")))
            {
                $builder->where("IDAsignado IS NULL");
            }
            else
            {
                $builder->groupStart(); // Inicia un grupo de condiciones
            
                foreach ($get['columns'] as $k => $column) 
                {
                    // Si la columna es la 2 o la 4 (que son CONCAT)
                    if ($k == 7) 
                    {
                        $builder->orLike("CONCAT(NombresAsignado, ' ', ApellidosAsignado)", $get['search']['value']);
                    } 
                    else 
                    {
                        if(array_key_exists($k, $fields))
                        {
                            // Para los otros campos, aplica la búsqueda normal
                            $builder->orLike($fields[$k], $get['search']['value']);
                        }
                        
                    }
                }
                
                $builder->groupEnd(); // Finaliza el grupo de condiciones
                
            }
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $sql = $builder->getCompiledSelect();
        $filteredRecords = $this->db->query($sql)->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_kit_demo');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            if(in_array($get['search']['value'], array("No Asignado", "no asignado", "No asignado", "NO ASIGNADO")))
            {
                $builder->where("IDAsignado IS NULL");
            }
            else
            {
                $builder->groupStart(); // Inicia un grupo de condiciones
            
                foreach ($get['columns'] as $k => $column) 
                {
                    // Si la columna es la 2 o la 4 (que son CONCAT)
                    if ($k == 7) 
                    {
                        $builder->orLike("CONCAT(NombresAsignado, ' ', ApellidosAsignado)", $get['search']['value']);
                    } 
                    else 
                    {
                        if(array_key_exists($k, $fields))
                        {
                            // Para los otros campos, aplica la búsqueda normal
                            $builder->orLike($fields[$k], $get['search']['value']);
                        }
                        
                    }
                }
                
                $builder->groupEnd(); // Finaliza el grupo de condiciones
            }
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        $sql = $builder->getCompiledSelect();
        // echo $sql; exit;
        $result = $this->db->query($sql)->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    public function listarKitsDemo($estado)
    {
        $this->select('kit_demo.IDItemKitDemo,
            kit_demo.CodigoKitDemo,
            kit_demo.IDElementoDemo,
            elementos_demo.SKU,
            elementos_demo.Nombre,
            kit_demo.Serie,
            kit_demo.Detalle,
            kit_demo.FechaCompra,
            kit_demo.Estado,
            asignacion.UsuarioAsignado, 
            asignacion.FechaAsignado, 
            asignacion.FechaCrea AS "FechaCreaAsignado"');
        $this->join('elementos_demo', 'kit_demo.IDElementoDemo = elementos_demo.IDElementoDemo', 'left');
        $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado, asignaciones.FechaAsignado, asignaciones.FechaCrea FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="KITDEMO") AS asignacion', 'kit_demo.IDItemKitDemo = asignacion.IDElemento', 'left');
        
        
        if($estado != '')
        {
            $this->where('kit_demo.Estado', $estado);
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listarKitDemoXCodigoKitXNoAsignado($codigoKitDemo)
    {
        $this->select('kit_demo.IDItemKitDemo,
            kit_demo.CodigoKitDemo,
            kit_demo.IDElementoDemo,
            elementos_demo.SKU,
            elementos_demo.Nombre,
            elementos_demo.PrecioReposicion,
            elementos_demo.MonedaReposicion,
            kit_demo.Serie,
            kit_demo.Detalle,
            kit_demo.FechaCompra,
            kit_demo.Estado');
        $this->join('elementos_demo', 'kit_demo.IDElementoDemo = elementos_demo.IDElementoDemo', 'left');
        $this->where('kit_demo.CodigoKitDemo', $codigoKitDemo);
        $this->where('kit_demo.Estado', "ACT");
        $this->where('kit_demo.IDItemKitdemo NOT IN (SELECT
                    kit_demo.IDItemKitDemo
                FROM 
                    asignaciones_detalle
                INNER JOIN 
                	kit_demo ON asignaciones_detalle.IDElemento = kit_demo.IDItemKitDemo AND asignaciones_detalle.TipoElemento = "KITDEMO"
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL)');
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerKitDemoAsignadoUsuario($idUsuario)
    {
        $consulta = "SELECT DISTINCT
            kit_demo.CodigoKitDemo
        FROM 
            asignaciones_detalle
        INNER JOIN 
        	asignaciones ON asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion
        INNER JOIN 
        	kit_demo ON asignaciones_detalle.IDElemento = kit_demo.IDItemKitDemo AND asignaciones_detalle.TipoElemento = 'KITDEMO'
        LEFT JOIN 
            devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
        WHERE 
            devoluciones_detalle.IDDevolucion IS NULL AND asignaciones.UsuarioAsignado = '".$idUsuario."'";

        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }

    public function listarKitDemoDisponibles($variable)
    {
        $consulta = "SELECT DISTINCT
            kit_demo.CodigoKitDemo
        FROM 
            kit_demo
        WHERE   
            (kit_demo.CodigoKitDemo LIKE '%".$variable."%') AND
            kit_demo.Estado IN ('ACT') AND 
            kit_demo.CodigoKitDemo NOT IN (SELECT DISTINCT
                    kit_demo.CodigoKitDemo
                FROM 
                    asignaciones_detalle
                INNER JOIN 
                	kit_demo ON asignaciones_detalle.IDElemento = kit_demo.IDItemKitDemo AND asignaciones_detalle.TipoElemento = 'KITDEMO'
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL)";

        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
    
    public function obtenerItemKitDemo($idItemKitDemo)
    {
        $this->select('kit_demo.IDItemKitDemo,
            kit_demo.CodigoKitDemo,
            kit_demo.IDElementoDemo,
            elementos_demo.SKU,
            elementos_demo.Nombre,
            elementos_demo.PrecioReposicion,
            elementos_demo.MonedaReposicion,
            kit_demo.Serie,
            kit_demo.Detalle,
            kit_demo.FechaCompra,
            kit_demo.Estado');
        $this->join('elementos_demo', 'kit_demo.IDElementoDemo = elementos_demo.IDElementoDemo', 'left');
        $this->where('kit_demo.IDItemKitDemo', $idItemKitDemo);

        $datos = $this->first();
        return $datos;
    }

}