<?php
namespace App\Models\Solicitudes;
use CodeIgniter\Model;

class SolicitudReposicionModel extends Model
{
    protected $table      = 'solicitud_reposicion';
    protected $primaryKey = 'IDSolicitudReposicion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDDetalleAsignacion', 'Observacion', 'Excepcion', 'AreaEncargada', 'MotivoReposicion', 'IDUsuarioAdjudicado', 'GeneraReposicion', 'DescargoEvaluacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'IDDireccionEstado', 'IDAreaEstado', 'IDSubareaEstado', 'IDDelegacionEstado', 'IDPerfilEstado', 'IDCargoEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerInformacionSolicitudReposicion($array)
    {
        $builder = $this->db->table('vista_listar_solicitudes_reposicion');
        
        if(!empty($array))
        {
            if(isset($array['IDSolicitudReposicion']) && !empty($array['IDSolicitudReposicion']))
            {
                $builder->where('IDSolicitudReposicion', $array['IDSolicitudReposicion']);
            }
            
        }
        
        $sql = $builder->getCompiledSelect();
        
        if(isset($array["return"]) && $array['return'] == 'row')
        {
            $datos = $this->db->query($sql)->getRowArray();
        }
        else
        {
            $datos = $this->db->query($sql)->getResultArray();
        }
        
        return $datos;
    }
    
    public function listarSolicitudesReposicionServerside($get, $adicionales)
    {
        /*
        * ----------------------------
        * SETEAMOS VISTA A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_solicitudes_reposicion');
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'IDSolicitudReposicion', 
            1 => 'FechaCrea', 
            2 => 'FechaModifica',
            7 => 'Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $totalQuery = $builder->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder->select('IDSolicitudReposicion,
            Observacion,
            MotivoReposicion,
            FechaCrea,
            FechaModifica,
            Estado,
            NombresAdjudicado,
            ApellidosAdjudicado,
            MatriculaAdjudicado,
            NombresSolicitante,
            ApellidosSolicitante,
            MatriculaSolicitante,
            TipoEquipo,
            Marca,
            Modelo,
            Serie');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $filteredQuery = $builder->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder->select('IDSolicitudReposicion,
            Observacion,
            MotivoReposicion,
            FechaCrea,
            FechaModifica,
            Estado,
            NombresAdjudicado,
            ApellidosAdjudicado,
            MatriculaAdjudicado,
            NombresSolicitante,
            ApellidosSolicitante,
            MatriculaSolicitante,
            TipoEquipo,
            Marca,
            Modelo,
            Serie');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $builder->get()->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    public function timelineSolicitudReposicion($array)
    {
        $builder = $this->db->table('vista_timeline_solicitud_reposicion');
        
        if(!empty($array))
        {
            if(isset($array['IDSolicitudReposicion']) && !empty($array['IDSolicitudReposicion']))
            {
                $builder->where('IDSolicitudReposicion_ALTER', $array['IDSolicitudReposicion']);
            }
            
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        return $datos;
    }
    
    public function listarSolicitudesReposicion($array)
    {
        $this->select('solicitud_reposicion.IDSolicitudReposicion,
            solicitud_reposicion.IDDetalleAsignacion, 
            solicitud_reposicion.Observacion, 
            solicitud_reposicion.AreaEncargada, 
            solicitud_reposicion.MotivoReposicion, 
            solicitud_reposicion.IDUsuarioAdjudicado, 
            solicitud_reposicion.UsuarioCrea, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            solicitud_reposicion.FechaCrea, 
            solicitud_reposicion.FechaModifica,
            solicitud_reposicion.Estado,
            devoluciones_detalle.IDDevolucion');
        $this->join('asignaciones_detalle', 'solicitud_reposicion.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        // $this->where('asignaciones_detalle.IDDetalleAsignacion', $idDetalleAsignacion);

        $this->orderBy("solicitud_reposicion.IDSolicitudReposicion", "DESC");
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerSolicitudReposicion($idSolicitud)
    {
        $this->select('solicitud_reposicion.IDSolicitudReposicion,
            solicitud_reposicion.IDDetalleAsignacion,
            solicitud_reposicion.Observacion, 
            solicitud_reposicion.AreaEncargada, 
            solicitud_reposicion.MotivoReposicion, 
            solicitud_reposicion.IDUsuarioAdjudicado, 
            solicitud_reposicion.GeneraReposicion, 
            solicitud_reposicion.DescargoEvaluacion, 
            solicitud_reposicion.UsuarioCrea, 
            solicitud_reposicion.FechaCrea, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            solicitud_reposicion.FechaModifica,
            solicitud_reposicion.Estado,
            solicitud_reposicion.FechaEstado,
            devoluciones_detalle.IDDetalleDevolucion,
            devoluciones_detalle.IDDevolucion,
            reposiciones_detalle.IDDetalleReposicion,
            reposiciones_detalle.IDReposicion');
        $this->join('asignaciones_detalle', 'solicitud_reposicion.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('reposiciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = reposiciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('solicitud_reposicion.IDSolicitudReposicion', $idSolicitud);

        $datos = $this->first();
        return $datos;
    }
    
}