<?php
namespace App\Models;
use CodeIgniter\Model;

class RegionDepartamentoModel extends Model
{
    protected $DBGroup      = 'baseT';
    protected $table        = 'region_departamento';
    protected $primaryKey   = 'IDDepartamento';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Departamento', 'IDPais', 'CodigoINEI', 'CodUbigeoReniec', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerDepartamento($idDepartamento)
    {
        $this->select('region_departamento.IDDepartamento,
            region_departamento.Departamento,
            region_departamento.IDPais,
            region_pais.Pais');
        $this->join('region_pais', 'region_departamento.IDPais = region_pais.IDPais', 'left');
        $this->where('region_departamento.IDDepartamento', $idDepartamento);

        $datos = $this->first();
        return $datos;
    }
    
}