<?php
namespace App\Models\IT;
use CodeIgniter\Model;

class LineasModel extends Model
{
    protected $table      = 'lineas';
    protected $primaryKey = 'IDLinea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Numero', 'ICCID', 'FechaEstado', 'UsuarioEstado', 'Estado', 'Situacion', 'Transito', 'MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
 
    public function listadoLineas($array)
    {
        $builder = $this->db->table('vista_listar_lineas');
        
        if(!empty($array))
        {
            if(isset($array['estado']) && $array['estado'] != '' && $array['estado'] != null)
            {
                $builder->where('Estado_Linea', $array['estado']);
            }
            
            if(isset($array['libre']) && $array['libre'] == 'Y')
            {
                $builder->where('IDAsignado IS NULL');
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    public function listaGeneralViewLineas($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_lineas');
        
        $fields = array(
            0 => 'IDLinea', 
            1 => 'Numero', 
            2 => 'ICCID', 
            3 => 'Operador', 
            4 => 'Plan', 
            5 => 'Estado_Contrato', 
            6 => 'Estado_Linea', 
            7 => 'UsuarioAsignado', 
            8 => 'MatriculaAsignado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $sql = $builder->getCompiledSelect();
        $totalRecords = $this->db->query($sql)->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_lineas');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            if(in_array($get['search']['value'], array("No Asignado", "no asignado", "No asignado", "NO ASIGNADO")))
            {
                $builder->where("IDAsignado IS NULL");
            }
            else
            {
                $builder->groupStart(); // Inicia un grupo de condiciones
            
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                }
                
                $builder->orLike("NombreAsignado", $get['search']['value']);
                
                $builder->groupEnd(); // Finaliza el grupo de condiciones
                
            }
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $sql = $builder->getCompiledSelect();
        $filteredRecords = $this->db->query($sql)->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_lineas');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            if(in_array($get['search']['value'], array("No Asignado", "no asignado", "No asignado")))
            {
                $builder->where("IDAsignado IS NULL");
            }
            else
            {
                $builder->groupStart(); // Inicia un grupo de condiciones
            
                foreach ($get['columns'] as $k => $column) 
                {
                    if(array_key_exists($k, $fields))
                    {
                        $builder->orLike($fields[$k], $get['search']['value']);
                    }
                }
                
                $builder->orLike("NombreAsignado", $get['search']['value']);
                
                $builder->groupEnd(); // Finaliza el grupo de condiciones
                
            }
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        $sql = $builder->getCompiledSelect();
        // echo $sql; exit;
        $result = $this->db->query($sql)->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    // public function listarLineas()
    // {
    //     $this->select('
    //         lineas.IDLinea,
    //         lineas.Numero,
    //         lineas.ICCID,
    //         operadores.Operador,
    //         operadores_planes.Plan,
    //         lineas_contrato.Estado AS "ESTADO_CONTRATO",
    //         lineas.Estado AS "ESTADO_LINEA",
    //         asignacion.UsuarioAsignado');
    //     $this->join('lineas_contrato', 'lineas.IDLinea = lineas_contrato.IDLinea AND lineas_contrato.Estado = "VIGENTE"', 'left');
    //     $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
    //     $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
    //     $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="LINEA") AS asignacion', 'lineas.IDLinea = asignacion.IDElemento', 'left');
    //     //$this->where('lineas_seguro.IDLinea', $idLinea);

    //     $datos = $this->findAll();
    //     return $datos;
    // }

    // public function listadoLineasFiltro($array)
    // {
    //     $this->select('
    //         lineas.IDLinea,
    //         lineas.Numero,
    //         lineas.ICCID,
    //         operadores.Operador,
    //         operadores_planes.Plan,
    //         lineas_contrato.Estado AS "ESTADO_CONTRATO",
    //         lineas.Estado AS "ESTADO_LINEA",
    //         asignacion.UsuarioAsignado');
    //     $this->join('lineas_contrato', 'lineas.IDLinea = lineas_contrato.IDLinea AND lineas_contrato.Estado = "VIGENTE"', 'left');
    //     $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
    //     $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
    //     $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="LINEA") AS asignacion', 'lineas.IDLinea = asignacion.IDElemento', 'left');
    //     //$this->where('lineas_seguro.IDLinea', $idLinea);

    //     if(isset($array['estado']) && $array['estado'] != '' && $array['estado'] != null)
    //     {
    //         $this->where('lineas.Estado', $array['estado']);
    //     }
        
    //     if(isset($array['libre']) && $array['libre'] == 'Y')
    //     {
    //         $this->where('asignacion.UsuarioAsignado IS NULL');
    //     }
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }

    public function obtenerLinea($idLinea)
    {
        $this->select('
            lineas.IDLinea,
            lineas.Numero,
            lineas.ICCID,
            operadores.Operador,
            operadores_planes.Plan,
            lineas_contrato.Estado AS "ESTADO_CONTRATO",
            lineas_contrato.InicioContrato,
            lineas.Estado AS "ESTADO_LINEA"');
        $this->join('lineas_contrato', 'lineas.IDLinea = lineas_contrato.IDLinea AND lineas_contrato.Estado = "VIGENTE"', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->where('lineas.IDLinea', $idLinea);

        $datos = $this->first();
        return $datos;
    }

    public function listarLineasDisponibles($variable)
    {
        $consulta = "SELECT 
            lineas.IDLinea, 
            lineas.Numero, 
            operadores_planes.Plan,
            operadores.Operador
        FROM
            lineas 
        INNER JOIN 
            lineas_contrato ON lineas.IDLinea = lineas_contrato.IDLinea
        INNER JOIN 
            operadores_planes ON lineas_contrato.IDPlan = operadores_planes.IDPlan
        INNER JOIN 
            operadores ON operadores_planes.IDOperador = operadores.IDOperador
        WHERE 
            (lineas.Numero LIKE '%".$variable."%' OR operadores_planes.Plan LIKE '%".$variable."%' OR operadores.Operador LIKE '%".$variable."%') AND
            lineas.Estado IN ('ACT', 'SUS') AND 
            lineas_contrato.Estado = 'VIGENTE' AND 
            lineas.IDLinea NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL AND 
                    asignaciones_detalle.TipoElemento = 'LINEA') AND 
            lineas.IDLinea NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.Estado = 'REGIS' AND 
                    asignaciones_detalle.TipoElemento = 'LINEA')";
        
        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
    
}