<?php
namespace App\Models\IT;
use CodeIgniter\Model;

class LineasContratoModel extends Model
{
    protected $table      = 'lineas_contrato';
    protected $primaryKey = 'IDContrato';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDLinea', 'IDPlan', 'InicioContrato', 'FinalContrato', 'DiaFacturacion', 'Permanencia', 'PeriodoPermanencia', 'EquipoAsociado', 'MontoCuota', 'MontoDeducible', 'FechaPagoDeducible', 'FechaEstado', 'UsuarioEstado', 'Estado', 'Situacion', 'MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listaGeneralContratos($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'lineas_contrato.IDContrato', 
            1 => 'lineas.Numero', 
            2 => 'operadores.Operador',
            3 => 'operadores_planes.Plan',
            4 => 'lineas_contrato.InicioContrato',
            7 => 'moviles.IMEI',
            9 => 'lineas_contrato.Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            lineas_contrato.IDContrato,
            lineas_contrato.IDLinea,
            lineas.Numero,
            lineas_contrato.IDPlan,
            operadores_planes.Plan,
            operadores_planes.IDOperador,
            operadores.Operador,
            lineas_contrato.EquipoAsociado,
            moviles.IMEI,
            moviles.PrecioCompra,
            lineas_contrato.InicioContrato,
            lineas_contrato.DiaFacturacion,
            lineas_contrato.Permanencia,
            lineas_contrato.PeriodoPermanencia,
            lineas_contrato.MontoCuota,
            lineas_contrato.Estado');
            
        $this->join('lineas', 'lineas_contrato.IDLinea = lineas.IDLinea', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->join('moviles', 'lineas_contrato.EquipoAsociado = moviles.IDMovil', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDLinea']) && $adicionales['IDLinea'] != "TOTAL")
        {
            $this->where("lineas_contrato.IDLinea", $adicionales['IDLinea']);
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            lineas_contrato.IDContrato,
            lineas_contrato.IDLinea,
            lineas.Numero,
            lineas_contrato.IDPlan,
            operadores_planes.Plan,
            operadores_planes.IDOperador,
            operadores.Operador,
            lineas_contrato.EquipoAsociado,
            moviles.IMEI,
            moviles.PrecioCompra,
            lineas_contrato.InicioContrato,
            lineas_contrato.DiaFacturacion,
            lineas_contrato.Permanencia,
            lineas_contrato.PeriodoPermanencia,
            lineas_contrato.MontoCuota,
            lineas_contrato.Estado');
            
        $this->join('lineas', 'lineas_contrato.IDLinea = lineas.IDLinea', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->join('moviles', 'lineas_contrato.EquipoAsociado = moviles.IDMovil', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDLinea']) && $adicionales['IDLinea'] != "TOTAL")
        {
            $this->where("lineas_contrato.IDLinea", $adicionales['IDLinea']);
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function obtenerContrato($idContrato)
    {
        $this->select('
            lineas_contrato.IDContrato,
            lineas_contrato.IDLinea,
            lineas_contrato.IDPlan,
            operadores.IDOperador,
            operadores.Operador,
            operadores_planes.Plan,
            operadores_planes.PrecioPlan,
            operadores_planes.PrecioFinal,
            lineas_contrato.InicioContrato,
            lineas_contrato.PeriodoPermanencia,
            lineas_contrato.EquipoAsociado,
            lineas_contrato.DiaFacturacion,
            moviles.IMEI,
            moviles.PrecioCompra,
            moviles.PrecioLista,
            lineas_contrato.Estado,
            lineas_contrato.Permanencia,
            lineas_contrato.MontoCuota');
        $this->join('moviles', 'lineas_contrato.EquipoAsociado = moviles.IDMovil', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->where('lineas_contrato.IDContrato', $idContrato);

        $datos = $this->first();
        return $datos;
    }
    
    // public function listarContratosXLinea($idLinea)
    // {
    //     $this->select('
    //         lineas_contrato.IDContrato,
    //         lineas_contrato.IDLinea,
    //         lineas_contrato.IDPlan,
    //         operadores.Operador,
    //         operadores_planes.Plan,
    //         operadores_planes.PrecioFinal,
    //         lineas_contrato.InicioContrato,
    //         lineas_contrato.PeriodoPermanencia,
    //         lineas_contrato.EquipoAsociado,
    //         lineas_contrato.DiaFacturacion,
    //         moviles.IMEI,
    //         moviles.PrecioCompra,
    //         moviles.PrecioLista,
    //         lineas_contrato.Estado,
    //         lineas_contrato.Permanencia,
    //         lineas_contrato.MontoCuota');
    //     $this->join('moviles', 'lineas_contrato.EquipoAsociado = moviles.IDMovil', 'left');
    //     $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
    //     $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
    //     $this->where('lineas_contrato.IDLinea', $idLinea);

    //     $datos = $this->findAll();
    //     return $datos;
    // }
    
    public function obtenerContratosXEquipo($idEquipo)
    {
        $this->select('
            lineas_contrato.IDContrato,
            lineas_contrato.IDLinea,
            lineas_contrato.IDPlan,
            operadores.Operador,
            operadores_planes.Plan,
            operadores_planes.PrecioFinal,
            lineas_contrato.InicioContrato,
            lineas_contrato.PeriodoPermanencia,
            lineas_contrato.EquipoAsociado,
            lineas_contrato.DiaFacturacion,
            moviles.IMEI,
            moviles.PrecioCompra,
            moviles.PrecioLista,
            lineas_contrato.Estado,
            lineas_contrato.Permanencia,
            lineas_contrato.MontoCuota');
        $this->join('moviles', 'lineas_contrato.EquipoAsociado = moviles.IDMovil', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->where('lineas_contrato.EquipoAsociado', $idEquipo);

        $datos = $this->first();
        return $datos;
    }
}