<?php
namespace App\Models\IT;
use CodeIgniter\Model;

class HardwareModel extends Model
{
    protected $table      = 'hardware';
    protected $primaryKey = 'IDHardware';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDModelo', 'Serie', 'Hostname', 'TAG', 'Procesador', 'GeneracionProcesador', 'RAM', 'TipoRam', 'HDD', 'SSD', 'Pulgadas', 'InicioGarantia', 'FinalGarantia', 'FinalVidaUtil', 'Detalle', 'Albaran', 'EstadoNavision', 'UsuarioEstadoNavision', 'FechaEstadoNavision', 'IDSubarea', 'Factura', 'OrdenCompra', 'FechaCompra', 'MonedaCompra','PrecioCompra', 'IDDireccion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'Situacion', 'Transito', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerHardware($idHardware)
    {
        $this->select('
            hardware.IDHardware,
            hardware.IDModelo,
            hardware.Hostname,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria,
            hardware.Serie,
            hardware.TAG,
            hardware.Procesador,
            hardware.GeneracionProcesador,
            hardware.RAM,
            hardware.TipoRam,
            hardware.HDD,
            hardware.SSD,
            hardware.Pulgadas,
            hardware.InicioGarantia,
            hardware.FinalGarantia,
            hardware.FinalVidaUtil,
            hardware.Detalle,
            hardware.Albaran,
            hardware.IDSubarea,
            dbMASTERUSUARIO.estructura_subarea.IDArea,
            dbMASTERUSUARIO.estructura_area.IDDireccion,
            hardware.Factura,
            hardware.OrdenCompra,
            hardware.FechaCompra,
            hardware.PrecioCompra,
            hardware.MonedaCompra,
            hardware.IDDireccion AS "IDUbicacion_SUNAT",
            hardware.Estado,
            "" AS UsuarioAsignado,
            dbMASTERUSUARIO.direccion.Nombre AS "Ubicacion"');
        $this->join('marcas_dispositivos', 'hardware.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->join('dbMASTERUSUARIO.estructura_subarea', 'hardware.IDSubarea = dbMASTERUSUARIO.estructura_subarea.IDSubarea', 'left');
        $this->join('dbMASTERUSUARIO.estructura_area', 'dbMASTERUSUARIO.estructura_subarea.IDArea = dbMASTERUSUARIO.estructura_area.IDArea', 'left');
        $this->join('dbMASTERUSUARIO.estructura_direccion', 'dbMASTERUSUARIO.estructura_area.IDDireccion = dbMASTERUSUARIO.estructura_direccion.IDDireccion', 'left');
        $this->join('dbMASTERUSUARIO.direccion', 'hardware.IDDireccion = dbMASTERUSUARIO.direccion.id_direccion', 'left');
        $this->where('hardware.IDHardware', $idHardware);
        
        $datos = $this->first();
        return $datos;
    }
    
    public function obtenerHardwareXValores($array)
    {
        $this->select('
            hardware.IDHardware,
            hardware.IDModelo,
            hardware.Hostname,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria,
            hardware.Serie,
            hardware.TAG,
            hardware.Procesador,
            hardware.GeneracionProcesador,
            hardware.RAM,
            hardware.TipoRam,
            hardware.HDD,
            hardware.SSD,
            hardware.Pulgadas,
            hardware.InicioGarantia,
            hardware.FinalGarantia,
            hardware.FinalVidaUtil,
            hardware.Detalle,
            hardware.Albaran,
            hardware.IDSubarea,
            dbMASTERUSUARIO.estructura_subarea.IDArea,
            dbMASTERUSUARIO.estructura_area.IDDireccion,
            hardware.Factura,
            hardware.OrdenCompra,
            hardware.FechaCompra,
            hardware.PrecioCompra,
            hardware.MonedaCompra,
            hardware.IDDireccion AS "IDUbicacion_SUNAT",
            hardware.Estado,
            "" AS UsuarioAsignado,
            dbMASTERUSUARIO.direccion.Nombre AS "Ubicacion"');
        $this->join('marcas_dispositivos', 'hardware.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->join('dbMASTERUSUARIO.estructura_subarea', 'hardware.IDSubarea = dbMASTERUSUARIO.estructura_subarea.IDSubarea', 'left');
        $this->join('dbMASTERUSUARIO.estructura_area', 'dbMASTERUSUARIO.estructura_subarea.IDArea = dbMASTERUSUARIO.estructura_area.IDArea', 'left');
        $this->join('dbMASTERUSUARIO.estructura_direccion', 'dbMASTERUSUARIO.estructura_area.IDDireccion = dbMASTERUSUARIO.estructura_direccion.IDDireccion', 'left');
        $this->join('dbMASTERUSUARIO.direccion', 'hardware.IDDireccion = dbMASTERUSUARIO.direccion.id_direccion', 'left');
        
        if(!empty($array))
        {
            if(isset($array['IDHardware']) && !empty($array['IDHardware']))
            {
                $this->where('hardware.IDHardware', $array['IDHardware']);
            }
            
            if(isset($array['Serie']) && !empty($array['Serie']))
            {
                $this->where('hardware.Serie', $array['Serie']);
            }
        }
        
        $datos = $this->first();
        return $datos;
    }
    
    public function listaGeneralViewHardware($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_hardware');
        
        $fields = array(
            0 => 'IDHardware', 
            1 => 'Hostname', 
            2 => 'Estado', 
            3 => 'Marca', 
            4 => 'Modelo', 
            5 => 'Serie', 
            6 => 'MatriculaAsignado', 
            7 => 'NombreAsignado', 
            8 => 'UsuarioAsignado', 
            9 => 'Subarea', 
            10 => 'UbicacionAlmacen', 
            11 => 'Detalle', 
            12 => 'EstadoNavision', 
            13 => 'FinalGarantia', 
            14 => 'PrecioCompra');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $sql = $builder->getCompiledSelect();
        $totalRecords = $this->db->query($sql)->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_hardware');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if (valor_valido($get['marcaFiltro'] ?? null)) {
            $builder->where('IDMarca', $get['marcaFiltro']);
        }
        
        if (valor_valido($get['modeloFiltro'] ?? null)) {
            $builder->where('IDModelo', $get['modeloFiltro']);
        }
        
        if (valor_valido($get['estadosFiltro'] ?? null)) {
            $builder->whereIn('Estado', $get['estadosFiltro']);
        }
        
        if (valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDSubareaReserva', $get['subareaFiltro']);
        }
        
        if (valor_valido($get['areaFiltro'] ?? null) && !valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDAreaReserva', $get['areaFiltro']);
        }
        
        if (valor_valido($get['direccionFiltro'] ?? null) && !valor_valido($get['areaFiltro'] ?? null) && !valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDDireccionReserva', $get['direccionFiltro']);
        }
        
        if (valor_valido($get['asignadosFiltro'] ?? null) && $get['asignadosFiltro'] == "N") {
            $builder->where("IDAsignado IS NULL", null, false);
        }
        else if (valor_valido($get['asignadosFiltro'] ?? null) && $get['asignadosFiltro'] == "Y") {
            $builder->where("IDAsignado IS NOT NULL", null, false);
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
        
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->orLike("NombreAsignado", $get['search']['value']);
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $sql = $builder->getCompiledSelect();
        $filteredRecords = $this->db->query($sql)->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_listar_hardware');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if (valor_valido($get['marcaFiltro'] ?? null)) {
            $builder->where('IDMarca', $get['marcaFiltro']);
        }
        
        if (valor_valido($get['modeloFiltro'] ?? null)) {
            $builder->where('IDModelo', $get['modeloFiltro']);
        }
        
        if (valor_valido($get['estadosFiltro'] ?? null)) {
            $builder->whereIn('Estado', $get['estadosFiltro']);
        }
        
        if (valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDSubareaReserva', $get['subareaFiltro']);
        }
        
        if (valor_valido($get['areaFiltro'] ?? null) && !valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDAreaReserva', $get['areaFiltro']);
        }
        
        if (valor_valido($get['direccionFiltro'] ?? null) && !valor_valido($get['areaFiltro'] ?? null) && !valor_valido($get['subareaFiltro'] ?? null)) {
            $builder->where('IDDireccionReserva', $get['direccionFiltro']);
        }
        
        if (valor_valido($get['asignadosFiltro'] ?? null) && $get['asignadosFiltro'] == "N") {
            $builder->where("IDAsignado IS NULL", null, false);
        }
        else if (valor_valido($get['asignadosFiltro'] ?? null) && $get['asignadosFiltro'] == "Y") {
            $builder->where("IDAsignado IS NOT NULL", null, false);
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
        
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->orLike("NombreAsignado", $get['search']['value']);
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        $sql = $builder->getCompiledSelect();
        // echo $sql; exit;
        $result = $this->db->query($sql)->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }

    public function listadoPendientesMoverNavision()
    {
        $this->select('
            hardware.IDHardware,
            hardware.EstadoNavision,
            marcas_dispositivos.Modelo,
            marcas.Marca,
            subtipo.HabilitadoNavision,
            subtipo.nombre_subtipo,
            tipo.nombre_tipo,
            categoria.nombre_categoria,
            hardware.Serie,
            hardware.Estado,
            asignaciones.FechaAsignado,
            asignaciones.FechaCrea,
            asignaciones.UsuarioAsignado,
            asignaciones.DelegacionAsignado');
            
        $this->join('marcas_dispositivos', 'hardware.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        
        $this->join('(SELECT 
              ad.IDElemento,
              MIN(ad.IDDetalleAsignacion) AS PrimeraAsignacion
              FROM 
              asignaciones_detalle ad 
              WHERE 
              ad.TipoElemento = "HARDWARE"
              GROUP BY 
              ad.IDElemento) AS primeraasignacion', 'hardware.IDHardware = primeraasignacion.IDElemento', 'left');
               
        $this->join('asignaciones_detalle', 'primeraasignacion.PrimeraAsignacion = asignaciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion', 'left');
        
        // $this->where('hardware.Estado', "ACT");
        $this->where('hardware.EstadoNavision', "NOM");
        $this->where('subtipo.HabilitadoNavision', "Y");
        $this->where('primeraasignacion.PrimeraAsignacion IS NOT NULL');
        
        $datos = $this->findAll();
        return $datos;
    }
    
    // public function listadoHardware($estado)
    // {
    //     $this->select('
    //         hardware.IDHardware,
    //         hardware.IDModelo,
    //         hardware.Hostname,
    //         marcas_dispositivos.Modelo,
    //         marcas.Marca,
    //         subtipo.nombre_subtipo,
    //         subtipo.HabilitadoNavision,
    //         tipo.nombre_tipo,
    //         categoria.nombre_categoria,
    //         hardware.Serie,
    //         hardware.TAG,
    //         hardware.Procesador,
    //         hardware.GeneracionProcesador,
    //         hardware.RAM,
    //         hardware.TipoRam,
    //         hardware.HDD,
    //         hardware.SSD,
    //         hardware.Pulgadas,
    //         hardware.InicioGarantia,
    //         hardware.FinalGarantia,
    //         hardware.FinalVidaUtil,
    //         hardware.Detalle,
    //         hardware.Albaran,
    //         hardware.EstadoNavision,
    //         hardware.FechaEstadoNavision,
    //         hardware.IDSubarea,
    //         hardware.Factura,
    //         hardware.OrdenCompra,
    //         hardware.FechaCompra,
    //         hardware.PrecioCompra,
    //         hardware.MonedaCompra,
    //         hardware.IDDireccion,
    //         hardware.Estado,
    //         asignacion.UsuarioAsignado AS UsuarioAsignado');
    //     $this->join('marcas_dispositivos', 'hardware.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
    //     $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
    //     $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
    //     $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
    //     $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
    //     $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="HARDWARE") AS asignacion', 'hardware.IDHardware = asignacion.IDElemento', 'left');
        
    //     if($estado != '')
    //     {
    //         $this->where('hardware.Estado', $estado);
    //     }
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }

    public function listarHardwareDisponibles($variable, $subarea)
    {
        $consulta = "SELECT 
            hardware.IDHardware,
            hardware.IDModelo,
            hardware.Hostname,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            subtipo.nombre_subtipo,
            tipo.nombre_tipo,
            categoria.nombre_categoria,
            hardware.Serie,
            hardware.TAG,
            hardware.Procesador,
            hardware.GeneracionProcesador,
            hardware.RAM,
            hardware.TipoRam,
            hardware.HDD,
            hardware.SSD,
            hardware.Pulgadas,
            hardware.InicioGarantia,
            hardware.FinalGarantia,
            hardware.FinalVidaUtil,
            hardware.Detalle,
            hardware.Albaran,
            hardware.IDSubarea,
            hardware.Factura,
            hardware.OrdenCompra,
            hardware.FechaCompra,
            hardware.PrecioCompra,
            hardware.MonedaCompra
        FROM 
            hardware 
        INNER JOIN 
            marcas_dispositivos ON hardware.IDModelo = marcas_dispositivos.IDDispositivo 
        INNER JOIN
        	marcas ON marcas_dispositivos.IDMarca = marcas.IDMarca
        LEFT JOIN
            subtipo ON marcas_dispositivos.Subtipo = subtipo.id_subtipo
        LEFT JOIN
            tipo ON subtipo.id_tipo = tipo.id_tipo
        LEFT JOIN
            categoria ON tipo.id_categoria = categoria.id_categoria
        WHERE   
            (marcas_dispositivos.Modelo LIKE '%".$variable."%' OR marcas.Marca LIKE '%".$variable."%' OR subtipo.nombre_subtipo LIKE '%".$variable."%' OR tipo.nombre_tipo LIKE '%".$variable."%' OR categoria.nombre_categoria LIKE '%".$variable."%' OR hardware.Serie LIKE '%".$variable."%' OR hardware.Hostname LIKE '%".$variable."%') AND
            (hardware.IDSubarea = '".$subarea."' OR hardware.IDSubarea = '' OR hardware.IDSubarea IS NULL) AND
            hardware.Estado IN ('ACT') AND 
            hardware.IDHardware NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL AND 
                    asignaciones_detalle.TipoElemento = 'HARDWARE') AND
            hardware.IDHardware NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.Estado = 'REGIS' AND 
                    asignaciones_detalle.TipoElemento = 'HARDWARE')";

        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
    
}