<?php
namespace App\Models\Configuracion;
use CodeIgniter\Model;

class OperadoresPlanesModel extends Model
{
    protected $table      = 'operadores_planes';
    protected $primaryKey = 'IDPlan';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDOperador', 'Plan', 'PlanOperador', 'PrecioPlan', 'PorcentajeDescuento', 'PrecioFinal', 'GBPlan', 'Observacion', 'FechaEstado', 'UsuarioEstado', 'Estado', 'MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralPlanes($get, $adicionales) 
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'operadores_planes.IDPlan', 
            1 => 'operadores.Operador', 
            2 => 'operadores_planes.Plan',
            3 => 'operadores_planes.PlanOperador',
            4 => 'operadores_planes.PrecioPlan',
            5 => 'operadores_planes.PorcentajeDescuento',
            6 => 'operadores_planes.PrecioFinal',
            7 => 'operadores_planes.GBPlan',
            8 => 'operadores_planes.Observacion',
            9 => 'operadores_planes.Estado');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('
            operadores_planes.IDPlan,
            operadores_planes.IDOperador,
            operadores.Operador,
            operadores_planes.Plan,
            operadores_planes.PlanOperador,
            operadores_planes.PrecioPlan,
            operadores_planes.PorcentajeDescuento,
            operadores_planes.PrecioFinal,
            operadores_planes.GBPlan,
            operadores_planes.Observacion,
            operadores_planes.Estado');
            
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
                
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDOperador']) && $adicionales['IDOperador'] != "TOTAL")
        {
            $this->where("operadores_planes.IDOperador", $adicionales['IDOperador']);
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('
            operadores_planes.IDPlan,
            operadores_planes.IDOperador,
            operadores.Operador,
            operadores_planes.Plan,
            operadores_planes.PlanOperador,
            operadores_planes.PrecioPlan,
            operadores_planes.PorcentajeDescuento,
            operadores_planes.PrecioFinal,
            operadores_planes.GBPlan,
            operadores_planes.Observacion,
            operadores_planes.Estado');
            
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
                
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        if(isset($adicionales['IDOperador']) && $adicionales['IDOperador'] != "TOTAL")
        {
            $this->where("operadores_planes.IDOperador", $adicionales['IDOperador']);
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }


}