<?php
namespace App\Models\Cargos;
use CodeIgniter\Model;

class ReposicionesCronogramaPagoModel extends Model
{
    protected $table      = 'reposiciones_cronograma_pagos';
    protected $primaryKey = 'IDCronogramaPago';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDDetalleReposicion', 'NroCuota', 'MesCuota', 'AnioCuota', 'MontoCuota', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerDescuentosMes($mes, $anio)
    {
        $this->select('reposiciones_cronograma_pagos.IDCronogramaPago,
            reposiciones_cronograma_pagos.IDReposicion,
            reposiciones_cronograma_pagos.NroCuota,
            (SELECT MAX(reposiciones_cronograma_pagos.NroCuota) FROM reposiciones_cronograma_pagos WHERE reposiciones_cronograma_pagos.IDReposicion = reposiciones.IDReposicion ) AS "UltimaCuota",
            reposiciones_cronograma_pagos.MesCuota,
            reposiciones_cronograma_pagos.AnioCuota,
            reposiciones_cronograma_pagos.MontoCuota,
            reposiciones_cronograma_pagos.Observacion,
            reposiciones_cronograma_pagos.Cobrado,
            reposiciones_cronograma_pagos.FechaCobro,
            reposiciones_cronograma_pagos.MontoCobro,
            reposiciones_cronograma_pagos.ObservacionCobro,
            reposiciones.UsuarioAdjudicado');
        $this->join('reposiciones', 'reposiciones_cronograma_pagos.IDReposicion  = reposiciones.IDReposicion');
        $this->where('reposiciones_cronograma_pagos.MesCuota', $mes);
        $this->where('reposiciones_cronograma_pagos.AnioCuota', $anio);
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerDescuentosPendientesMes($mes, $anio)
    {
        $this->select('reposiciones_cronograma_pagos.IDCronogramaPago,
            reposiciones_cronograma_pagos.IDReposicion,
            reposiciones_cronograma_pagos.NroCuota,
            (SELECT MAX(reposiciones_cronograma_pagos.NroCuota) FROM reposiciones_cronograma_pagos WHERE reposiciones_cronograma_pagos.IDReposicion = reposiciones.IDReposicion ) AS "UltimaCuota",
            reposiciones_cronograma_pagos.MesCuota,
            reposiciones_cronograma_pagos.AnioCuota,
            reposiciones_cronograma_pagos.MontoCuota,
            reposiciones_cronograma_pagos.Observacion,
            reposiciones_cronograma_pagos.Cobrado,
            reposiciones_cronograma_pagos.FechaCobro,
            reposiciones_cronograma_pagos.MontoCobro,
            reposiciones_cronograma_pagos.ObservacionCobro,
            reposiciones.UsuarioAdjudicado');
        $this->join('reposiciones', 'reposiciones_cronograma_pagos.IDReposicion  = reposiciones.IDReposicion');
        $this->where('reposiciones_cronograma_pagos.MesCuota', $mes);
        $this->where('reposiciones_cronograma_pagos.AnioCuota', $anio);
        $this->where('reposiciones_cronograma_pagos.Cobrado', "N");
        
        $datos = $this->findAll();
        return $datos;
    }
}