<?php
namespace App\Models\Cargos;
use CodeIgniter\Model;

class InformeDevolucionModel extends Model
{
    protected $table      = 'informe_devolucion';
    protected $primaryKey = 'IDInforme';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['TipoInforme', 'IDDevolucion', 'UsuarioCrea', 'IDDireccionCrea', 'IDAreaCrea', 'IDSubareaCrea', 'IDDelegacionCrea', 'IDCargoCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    
    public function listarInformesDevolucionServerside($get, $adicionales)
    {
        /*
        * ----------------------------
        * SETEAMOS VISTA A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_informes_devolucion');
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'IDInforme', 
            3 => 'FechaInforme', 
            5 => 'CargoInforme',
            6 => 'FechaDevolucion');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $totalQuery = $builder->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder->select('IDInforme,
            TipoInforme,
            FechaInforme,
            NombresUsuarioInforme,
            ApellidosUsuarioInforme,
            DocumentoUsuarioInforme,
            MatriculaUsuarioInforme,
            CCInforme,
            LNInforme,
            DelegacionInforme,
            DireccionInforme,
            AreaInforme,
            SubareaInforme,
            CargoInforme,
            IDDevolucion,
            FechaDevolucion');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $filteredQuery = $builder->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder->select('IDInforme,
            TipoInforme,
            FechaInforme,
            NombresUsuarioInforme,
            ApellidosUsuarioInforme,
            DocumentoUsuarioInforme,
            MatriculaUsuarioInforme,
            CCInforme,
            LNInforme,
            DelegacionInforme,
            DireccionInforme,
            AreaInforme,
            SubareaInforme,
            CargoInforme,
            IDDevolucion,
            FechaDevolucion');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $builder->get()->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    public function obtenerInformacionInformesDevolucion($array)
    {
        $builder = $this->db->table('vista_listar_informes_devolucion');
        
        if(!empty($array))
        {
            if(isset($array['IDInforme']) && !empty($array['IDInforme']))
            {
                $builder->where('IDInforme', $array['IDInforme']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        
        if(isset($array["return"]) && $array['return'] == 'row')
        {
            $datos = $this->db->query($sql)->getRowArray();
        }
        else
        {
            $datos = $this->db->query($sql)->getResultArray();
        }
        
        return $datos;
    }
    

}