<?php
namespace App\Models\Cargos;
use CodeIgniter\Model;

class InformeDevolucionDetalleModel extends Model
{
    protected $table      = 'informe_devolucion_detalle';
    protected $primaryKey = 'IDDetalleInforme';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDInforme', 'IDDetalleAsignacion', 'MotivoRealDevolucion', 'Introduccion', 'UsuarioCrea', 'IDDireccionCrea', 'IDAreaCrea', 'IDSubareaCrea', 'IDDelegacionCrea', 'IDCargoCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerInformacionDetalleInformeDevolucion($array)
    {
        $builder = $this->db->table('vista_detalle_informe_devolucion');
        
        if(!empty($array))
        {
            if(isset($array['IDInforme']) && !empty($array['IDInforme']))
            {
                $builder->where('IDInforme', $array['IDInforme']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        
        if(isset($array["return"]) && $array['return'] == 'row')
        {
            $datos = $this->db->query($sql)->getRowArray();
        }
        else
        {
            $datos = $this->db->query($sql)->getResultArray();
        }
        
        return $datos;
    }
    
}