<?php
namespace App\Models\Cargos;
use CodeIgniter\Model;

class InformeDevolucionDetalleAdjuntosModel extends Model
{
    protected $table      = 'informe_devolucion_detalle_adjuntos';
    protected $primaryKey = 'IDAdjuntoDetalle';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDDetalleInforme', 'Nombre', 'Extension', 'Token', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarAdjuntosDetalleInformeDevolucion($array)
    {
        $this->select('informe_devolucion_detalle_adjuntos.IDAdjuntoDetalle,
            informe_devolucion_detalle_adjuntos.Nombre,
            informe_devolucion_detalle_adjuntos.Extension,
            informe_devolucion_detalle_adjuntos.Token,
            informe_devolucion_detalle_adjuntos.Observacion,
            informe_devolucion_detalle_adjuntos.IDDetalleInforme,
            informe_devolucion_detalle_adjuntos.FechaCrea,
            informe_devolucion_detalle.IDInforme');
        $this->join('informe_devolucion_detalle', 'informe_devolucion_detalle_adjuntos.IDDetalleInforme = informe_devolucion_detalle.IDDetalleInforme','left');
        
        if(!empty($array))
        {
            if(isset($array["arrayIDDetalleInforme"]) && !empty($array['arrayIDDetalleInforme']))
            {
                $this->whereIn('informe_devolucion_detalle_adjuntos.IDDetalleInforme', $array['arrayIDDetalleInforme']);
            }
            
            if(isset($array["arrayExtension"]) && !empty($array['arrayExtension']))
            {
                $this->whereIn('informe_devolucion_detalle_adjuntos.Extension', $array['arrayExtension']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
    }


}