<?php
namespace App\Models\Cargos;
use CodeIgniter\Model;

class DevolucionesDetalleModel extends Model
{
    protected $table      = 'devoluciones_detalle';
    protected $primaryKey = 'IDDetalleDevolucion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDDevolucion', 'IDDetalleAsignacion', 'MotivoDevolucion', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'Localhost', 'Estado', 'UsuarioValidacion', 'ElementoRecibido', 'ObservacionValidado', 'FechaValidado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoDetalleActaDevolucion($array)
    {
        $builder = $this->db->table('vista_detalle_acta_devolucion');
        
        if(!empty($array))
        {
            if(isset($array["IDDevolucion"]) && $array['IDDevolucion'] != "" && $array['IDDevolucion'] != NULL)
            {
                $builder->where('IDDevolucion', $array['IDDevolucion']);
            }
            
            if(isset($array["InicioGrafico"]) && !empty($array["InicioGrafico"]))
            {
                $builder->where('FechaRegistroDevolucion >=', $array['InicioGrafico']);
            }
            
            if(isset($array["FinalGrafico"]) && !empty($array["FinalGrafico"]))
            {
                $builder->where('FechaRegistroDevolucion <=', $array['FinalGrafico']);
            }
            
            if(isset($array["TipoElemento"]) && !empty($array["TipoElemento"]))
            {
                $builder->where('TipoElemento', $array['TipoElemento']);
            }
            
            if(isset($array["Estado"]) && !empty($array["Estado"]))
            {
                $builder->where('Estado', $array["Estado"]);
            }
            
            if(isset($array["MotivoDevolucion"]) && !empty($array["MotivoDevolucion"]))
            {
                $builder->where('MotivoDevolucion', $array["MotivoDevolucion"]);
            }
            
            if(isset($array["RangoValidacion"]) && !empty($array["RangoValidacion"]))
            {
                if($array["RangoValidacion"] == "mas10")
                {
                    $builder->where('DATEDIFF(NOW(), FechaRegistroDevolucion) > 10', null, false);
                }
                else
                {
                    $builder->where('DATEDIFF(NOW(), FechaRegistroDevolucion) <= 10', null, false);
                }
            }
            
            if(isset($array['arrayIDDelegacionActa']) && !empty($array['arrayIDDelegacionActa']))
            {
                $builder->whereIn('IDDelegacionActaDevolucion', $array['arrayIDDelegacionActa']);
            }
            
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    public function cantidadPendientesValidacion($array)
    {
        $builder = $this->db->table('vista_detalle_acta_devolucion');
        
        $builder->select('TipoElemento,
            COUNT(CASE WHEN DATEDIFF(NOW(), FechaRegistroDevolucion) > 10 THEN 1 END) AS Mas10dias,
            COUNT(CASE WHEN DATEDIFF(NOW(), FechaRegistroDevolucion) <= 10 THEN 1 END) AS Menos10dias');
        
        $builder->where('Estado', "REGIS");
        $builder->where('MotivoDevolucion', "DEV");
        
        if(!empty($array))
        {
            if(isset($array['InicioBusqueda']) && !empty($array['InicioBusqueda']))
            {
                $builder->where('DATE(FechaRegistroDevolucion) >= ', $array['InicioBusqueda']);
            }
            
            if(isset($array['FinalBusqueda']) && !empty($array['FinalBusqueda']))
            {
                $builder->where('DATE(FechaRegistroDevolucion) <= ', $array['FinalBusqueda']);
            }
            
            if(isset($array['arrayIDDelegacionActa']) && !empty($array['arrayIDDelegacionActa']))
            {
                $builder->whereIn('IDDelegacionActaDevolucion', $array['arrayIDDelegacionActa']);
            }
            
        }
        
        $builder->groupBy('TipoElemento');
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    // public function listarDetalleDevolucion($idDevolucion)
    // {
    //     $this->select('devoluciones_detalle.IDDetalleDevolucion,
    //         devoluciones_detalle.IDDevolucion,
    //         devoluciones_detalle.MotivoDevolucion,
    //         devoluciones_detalle.Observacion,
    //         devoluciones_detalle.Estado,
    //         devoluciones_detalle.ObservacionValidado,
    //         devoluciones_detalle.FechaValidado,
    //         asignaciones_detalle.IDDetalleAsignacion,
    //         asignaciones_detalle.TipoElemento,
    //         asignaciones_detalle.IDElemento,
    //         reposiciones_detalle.IDReposicion');
    //     $this->join('asignaciones_detalle', 'devoluciones_detalle.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion','left');
    //     $this->join('reposiciones_detalle', 'devoluciones_detalle.IDDetalleAsignacion = reposiciones_detalle.IDDetalleAsignacion','left');
    //     $this->where('devoluciones_detalle.IDDevolucion', $idDevolucion);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }

}