<?php
namespace App\Models\Cargos;
use CodeIgniter\Model;

class AsignacionesModel extends Model
{
    protected $table      = 'asignaciones';
    protected $primaryKey = 'IDAsignacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['UsuarioAsignado', 'CargoAsignado', 'DireccionAsignado', 'AreaAsignado', 'SubareaAsignado', 'DelegacionAsignado','FechaAsignado', 'TipoAsignado', 'Observacion', 'UsuarioRemitente', 'CargoRemitente', 'DireccionRemitente', 'AreaRemitente', 'SubareaRemitente', 'DelegacionRemitente', 'Legales', 'TokenLinkFirma', 'LiberadoFirma', 'FechaRegistroFirma', 'ConceptoRegistroFirma','UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerInformacionActaAsignacion($array)
    {
        $builder = $this->db->table('vista_listar_asignaciones_full');
        
        if(!empty($array))
        {
            if(isset($array['IDAsignacion']) && !empty($array['IDAsignacion']))
            {
                $builder->where('IDAsignacion', $array['IDAsignacion']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getRowArray();
        
        return $datos;
    }
    
    public function listarActasAsignacion($array)
    {
        $builder = $this->db->table('vista_listar_asignaciones_full');
        
        if(!empty($array))
        {
            if(isset($array['InicioBusqueda']) && !empty($array['InicioBusqueda']))
            {
                $builder->where('DATE(FechaCrea) >= ', $array['InicioBusqueda']);
            }
            
            if(isset($array['FinalBusqueda']) && !empty($array['FinalBusqueda']))
            {
                $builder->where('DATE(FechaCrea) <= ', $array['FinalBusqueda']);
            }
            
            if(isset($array['FechaBusqueda']) && !empty($array['FechaBusqueda']))
            {
                $builder->where('DATE(FechaCrea)', $array['FechaBusqueda']);
            }
            
            if(array_key_exists('FechaFirma', $array))
            {
                if($array['FechaFirma'] === null)
                {
                    $builder->where('FechaRegistroFirma IS NULL');
                }
                else
                {
                    $builder->where('DATE(FechaRegistroFirma)', $array['FechaFirma']);
                }
                
            }
            
            if(isset($array['TipoElemento']) && !empty($array['TipoElemento']))
            {
                $builder->like('TIPOS_ELEMENTO', $array['TipoElemento']);
            }
            
            if(isset($array['Activos']) && !empty($array['Activos']))
            {
                $builder->groupStart(); // Inicia un grupo de condiciones
                
                foreach($array['Activos'] as $index => $activo)
                {
                    if ($index == 0) 
                    {
                        $builder->like('TIPOS_ELEMENTO', $activo); // primer like
                    } 
                    else 
                    {
                        $builder->orLike('TIPOS_ELEMENTO', $activo); // luego orLike
                    }
                }
                
                $builder->groupEnd(); // Finaliza el grupo de condiciones
            }
            
            if(isset($array['arrayIDDelegacionActa']) && !empty($array['arrayIDDelegacionActa']))
            {
                $builder->whereIn('IDDelegacionActaAsignado', $array['arrayIDDelegacionActa']);
            }
            
        }
        
        $sql = $builder->getCompiledSelect();
        
        if(isset($array["return"]) && $array['return'] == 'row')
        {
            $datos = $this->db->query($sql)->getRowArray();
        }
        else
        {
            $datos = $this->db->query($sql)->getResultArray();
        }
        
        return $datos;
    }
    
    
    public function listarAsignacionesServerside($get, $adicionales)
    {
        /*
        * ----------------------------
        * SETEAMOS VISTA A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_listar_asignaciones_full');
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'IDAsignacion', 
            1 => 'MatriculaAsignado', 
            2 => 'NombreAsignado', 
            3 => 'FechaAsignado', 
            4 => 'TipoAsignado', 
            5 => 'Observacion', 
            6 => 'NombreRemitente', 
            7 => 'TIPOS_ELEMENTO');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $totalQuery = $builder->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder->select('IDAsignacion,
            UsuarioAsignado,
            TIPOS_ELEMENTO,
            CANTIDAD_DETALLE,
            FechaAsignado,
            TokenLinkFirma,
            TipoAsignado,
            Observacion,
            FechaRegistroFirma,
            UsuarioRemitente,
            NombreAsignado,
            MatriculaAsignado,
            NombreRemitente,
            CCAsignado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($adicionales) && !empty($adicionales))
        {
            if(in_array($adicionales['IDPerfil'], array(3)))
            {
                if(isset($adicionales['Delegaciones']) && !empty($adicionales['Delegaciones']))
                {
                    $builder->whereIn('IDDelegacionUsuarioAsignado', $adicionales['Delegaciones']);
                }
                else if(isset($adicionales['CCAsignado']) && !empty($adicionales['CCAsignado']))
                {
                    $builder->whereIn('CCAsignado', $adicionales['CCAsignado']);
                }
                else
                {
                    $builder->where('1 = 0'); // Si quieres asegurarte que no devuelva nada
                }
            }
            
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $filteredQuery = $builder->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder->select('IDAsignacion,
            UsuarioAsignado,
            TIPOS_ELEMENTO,
            CANTIDAD_DETALLE,
            FechaAsignado,
            TokenLinkFirma,
            TipoAsignado,
            Observacion,
            FechaRegistroFirma,
            UsuarioRemitente,
            NombreAsignado,
            MatriculaAsignado,
            NombreRemitente,
            CCAsignado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($adicionales) && !empty($adicionales))
        {
            if(in_array($adicionales['IDPerfil'], array(3)))
            {
                if(isset($adicionales['Delegaciones']) && !empty($adicionales['Delegaciones']))
                {
                    $builder->whereIn('IDDelegacionUsuarioAsignado', $adicionales['Delegaciones']);
                }
                else if(isset($adicionales['CCAsignado']) && !empty($adicionales['CCAsignado']))
                {
                    $builder->whereIn('CCAsignado', $adicionales['CCAsignado']);
                }
                else
                {
                    $builder->where('1 = 0'); // Si quieres asegurarte que no devuelva nada
                }
            }
            
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $builder->get()->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    public function listarUsuariosAsignacionesActivas()
    {
        $this->select('asignaciones.UsuarioAsignado,
        COUNT(asignaciones.IDAsignacion) AS "CANTIDAD_ELEMENTOS"');
        $this->join('asignaciones_detalle', 'asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('devoluciones_detalle.IDDevolucion IS NULL');
        $this->groupBy('asignaciones.UsuarioAsignado');
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listarAsignacionesUsuario($idAsignado)
    {
        $this->select('asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            COUNT(asignaciones_detalle.IDDetalleAsignacion) AS "CANTIDAD_DETALLE",
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado,
            asignaciones.Observacion,
            asignaciones.UsuarioRemitente');
        $this->join('asignaciones_detalle', 'asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('devoluciones_detalle.IDDevolucion IS NULL');
        $this->where('asignaciones.UsuarioAsignado',$idAsignado);
        $this->groupBy('asignaciones.IDAsignacion');

        $datos = $this->findAll();
        return $datos;
    }

    /*public function listarAsignaciones()
    {
        $this->select('asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            COUNT(asignaciones_detalle.IDDetalleAsignacion) AS "CANTIDAD_DETALLE",
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado,
            asignaciones.Observacion,
            asignaciones.FechaRegistroFirma,
            asignaciones.UsuarioRemitente');
        $this->join('asignaciones_detalle', 'asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('devoluciones_detalle.IDDevolucion IS NULL');
        $this->groupBy('asignaciones.IDAsignacion');

        $datos = $this->findAll();
        return $datos;
    }*/
    
    public function listarReporteTotalAsignaciones($array)
    {
        $builder = $this->db->table('vista_reporte_total_asignaciones');
        if(!empty($array))
        {
            if(isset($array["Estado"]) && $array['Estado'] != "")
            {
                $builder->where('Estado_Usuario', $array['Estado']);
            }
            
            if(isset($array["usuario"]) && $array['usuario'] != "" && $array['usuario'] != NULL)
            {
                $builder->where('IdUsuario', $array['usuario']);
            }
            
            if(isset($array["activos"]) && $array['activos'] != "" && $array['activos'] != NULL)
            {
                $builder->whereIn('ELEMENTO', $array['activos']);
            }
        }
        
        // if(!empty($cc))
        // {
        //     $builder->whereIn('CCAsignado', $cc);
        // }
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    public function listarReporteTotalAsignacionesServersideIT($get, $adicionales)
    {
        /*
        * ----------------------------
        * SETEAMOS VISTA A UTILIZAR
        * ----------------------------
        */
    
        $builder = $this->db->table('vista_reporte_total_asignaciones');
        
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'Matricula', 
            1 => 'Usuario', 
            2 => 'NOMBRE', 
            3 => 'Subarea', 
            4 => 'Area', 
            5 => 'Direccion', 
            6 => 'CC', 
            7 => 'LN', 
            8 => 'ELEMENTO', 
            9 => 'TIPO', 
            10 => 'MARCA', 
            11 => 'MODELO', 
            12 => 'SERIE', 
            14 => 'IDAsignacion');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS total");
        $totalQuery = $builder->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_reporte_total_asignaciones');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($get["txtColaboradorFiltro_i"]) && $get['txtColaboradorFiltro_i'] != "" && $get['txtColaboradorFiltro_i'] != NULL)
        {
            $builder->where('IdUsuario', $get['txtColaboradorFiltro_i']);
        }
        
        if(isset($get["elementosFiltro"]) && !empty($get['elementosFiltro']) )
        {
            $builder->whereIn('ELEMENTO', $get['elementosFiltro']);
        }
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $builder->select("COUNT(*) AS filtered");
        $filteredQuery = $builder->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $builder = $this->db->table('vista_reporte_total_asignaciones');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if(isset($get["txtColaboradorFiltro_i"]) && $get['txtColaboradorFiltro_i'] != "" && $get['txtColaboradorFiltro_i'] != NULL)
        {
            $builder->where('IdUsuario', $get['txtColaboradorFiltro_i']);
        }
        
        if(isset($get["elementosFiltro"]) && !empty($get['elementosFiltro']) )
        {
            $builder->whereIn('ELEMENTO', $get['elementosFiltro']);
        }
        
        if ($get['search']['value'] != "") 
        {
            $builder->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $builder->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $builder->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $builder->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        $builder->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $builder->get()->getResultArray();
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw'              => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal'      => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered'   => $filteredRecords, // Total de registros después de aplicar filtros
            'data'              => $result // Los datos actuales para mostrar
        ];
    }
    
    public function cantidadAsignacionesPendientesFirmaCreacion($array)
    {
        $builder = $this->db->table('vista_listar_asignaciones_full');
        
        if(isset($array['GroupBy']) && !empty($array['GroupBy']))
        {
            if($array['GroupBy'] == "CC")
            {
                $builder->select('COUNT(*) AS "TotalPendiente", CCAsignado');
            }
            else if($array['GroupBy'] == "Activos")
            {
                $builder->select('SUM(CASE WHEN FIND_IN_SET("LINEA", TIPOS_ELEMENTO) > 0 THEN 1 ELSE 0 END) AS LINEA,
                    SUM(CASE WHEN FIND_IN_SET("MOVIL", TIPOS_ELEMENTO) > 0 THEN 1 ELSE 0 END) AS MOVIL,
                    SUM(CASE WHEN FIND_IN_SET("ACCESORIOIT", TIPOS_ELEMENTO) > 0 THEN 1 ELSE 0 END) AS "ACCESORIO IT",
                    SUM(CASE WHEN FIND_IN_SET("TARJETA", TIPOS_ELEMENTO) > 0 THEN 1 ELSE 0 END) AS TARJETA,
                    SUM(CASE WHEN FIND_IN_SET("HARDWARE", TIPOS_ELEMENTO) > 0 THEN 1 ELSE 0 END) AS HARDWARE,
                    SUM(CASE WHEN FIND_IN_SET("KITDEMO", TIPOS_ELEMENTO) > 0 THEN 1 ELSE 0 END) AS "KIT DEMO",
                    SUM(CASE WHEN FIND_IN_SET("ELEMENTOTRABAJO", TIPOS_ELEMENTO) > 0 THEN 1 ELSE 0 END) AS "ELEMENTO TRABAJO"');
            }
            else
            {
                $builder->select('COUNT(*) AS "TotalPendiente", DATE(FechaCrea) AS "FechaCreacion"');
            }
        }
        else
        {
            $builder->select('COUNT(*) AS "TotalPendiente", DATE(FechaCrea) AS "FechaCreacion"');
        }
        
        $builder->where('FechaRegistroFirma IS NULL');
        
        if(!empty($array))
        {
            if(isset($array['InicioBusqueda']) && !empty($array['InicioBusqueda']))
            {
                $builder->where('FechaCrea >= ', $array['InicioBusqueda']);
            }
            
            if(isset($array['FinalBusqueda']) && !empty($array['FinalBusqueda']))
            {
                $builder->where('FechaCrea <= ', $array['FinalBusqueda']);
            }
            
            if(isset($array['FechaBusqueda']) && !empty($array['FechaBusqueda']))
            {
                $builder->where('DATE(FechaCrea)', $array['FechaBusqueda']);
            }
            
            if(isset($array['TipoElemento']) && !empty($array['TipoElemento']))
            {
                $builder->like('TIPOS_ELEMENTO', $array['TipoElemento']);
            }
            
            if(isset($array['ActivosBusqueda']) && !empty($array['ActivosBusqueda']))
            {
                $builder->groupStart(); // Inicia un grupo de condiciones
                
                foreach($array['ActivosBusqueda'] as $index => $activo)
                {
                    if ($index == 0) 
                    {
                        $builder->like('TIPOS_ELEMENTO', $activo); // primer like
                    } 
                    else 
                    {
                        $builder->orLike('TIPOS_ELEMENTO', $activo); // luego orLike
                    }
                }
                
                $builder->groupEnd(); // Finaliza el grupo de condiciones
            }
            
            // if(isset($array['area']) && !empty($array['area']))
            // {
            //     if($array['area'] == 'IT')
            //     {
            //         $builder->notLike('TIPOS_ELEMENTO', 'KITDEMO');
            //         $builder->notLike('TIPOS_ELEMENTO', 'ELEMENTOTRABAJO');
            //     }
            //     else
            //     {
            //         $builder->like('TIPOS_ELEMENTO', 'KITDEMO');
            //         $builder->like('TIPOS_ELEMENTO', 'ELEMENTOTRABAJO');
            //     }
            // }
            
            if(isset($array['arrayIDDelegacionActa']) && !empty($array['arrayIDDelegacionActa']))
            {
                $builder->whereIn('IDDelegacionActaAsignado', $array['arrayIDDelegacionActa']);
            }
            
        }
        
        if(isset($array['GroupBy']) && !empty($array['GroupBy']))
        {
            if($array['GroupBy'] == "CC")
            {
                $builder->groupBy('CCAsignado');
            }
            else if($array['GroupBy'] == "Activos")
            {
            }
            else
            {
                $builder->groupBy('DATE(FechaCrea)');
            }
        }
        else
        {
            $builder->groupBy('DATE(FechaCrea)');
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
}