<?php
namespace App\Models\Cargos;
use CodeIgniter\Model;

class AsignacionesDetalleModel extends Model
{
    protected $table      = 'asignaciones_detalle';
    protected $primaryKey = 'IDDetalleAsignacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDAsignacion', 'TipoElemento', 'IDElemento', 'Observacion', 'MonedaReposicion', 'MontoReposicion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoDetalleActaAsignacion($array)
    {
        $builder = $this->db->table('vista_detalle_acta_asignacion');
        
        if(!empty($array))
        {
            if(isset($array["IDAsignacion"]) && $array['IDAsignacion'] != "" && $array['IDAsignacion'] != NULL)
            {
                $builder->where('IDAsignacion', $array['IDAsignacion']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    public function listadoHistoricoAsignacioneElemento($array)
    {
        $builder = $this->db->table('vista_asignados_elemento');
        
        if(!empty($array))
        {
            if(isset($array["TipoElemento"]) && $array['TipoElemento'] != "" && $array['TipoElemento'] != NULL)
            {
                $builder->where('TipoElemento', $array['TipoElemento']);
            }
            
            if(isset($array["IDElemento"]) && $array['IDElemento'] != "" && $array['IDElemento'] != NULL)
            {
                $builder->where('IDElemento', $array['IDElemento']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
    public function validarElementoAsignado($tipo, $id)
    {
        $this->select('asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado, 
            asignaciones.UsuarioRemitente');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('asignaciones_detalle.TipoElemento', $tipo);
        $this->where('asignaciones_detalle.IDElemento', $id);
        $this->where('devoluciones_detalle.IDDevolucion IS NULL');

        $datos = $this->findAll();
        return $datos;
    }
    
    public function listarDetalleElementosAsignados($array)
    {
        $builder = $this->db->table('vista_asignados_detalle_elementos_total');
        
        if(!empty($array))
        {
            if(isset($array["IDDevolucion"]) && $array['IDDevolucion'] != "" && $array['IDDevolucion'] != NULL)
            {
                $builder->where('IDDevolucion', $array['IDDevolucion']);
            }
            else if(isset($array["IDDevolucion"]) && $array['IDDevolucion'] === '')
            {
                $builder->where('IDDevolucion IS NULL');
            }
            
            if(isset($array["UsuarioAsignado"]) && $array['UsuarioAsignado'] != "" && $array['UsuarioAsignado'] != NULL)
            {
                $builder->where('UsuarioAsignado', $array['UsuarioAsignado']);
            }
            
            if(isset($array["IDDetalleAsignacion"]) && $array['IDDetalleAsignacion'] != "" && $array['IDDetalleAsignacion'] != NULL)
            {
                $builder->where('IDDetalleAsignacion', $array['IDDetalleAsignacion']);
            }
            
            if(isset($array["TipoCategoria"]) && $array['TipoCategoria'] != "" && $array['TipoCategoria'] != NULL)
            {
                $builder->where('TipoCategoria', $array['TipoCategoria']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        
        if(isset($array["return"]) && $array['return'] == 'row')
        {
            $datos = $this->db->query($sql)->getRowArray();
        }
        else
        {
            $datos = $this->db->query($sql)->getResultArray();
        }
        
        return $datos;
    }
    
    public function obtenerDispositivosRobadosUsuario($idUsuario, $tipoElemento, $idElemento = '', $tipoCategoria = '')
    {
        $this->select('asignaciones_detalle.IDDetalleAsignacion, 
            asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado, 
            asignaciones.UsuarioRemitente,
            devoluciones_detalle.*');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('hardware', 'asignaciones_detalle.TipoElemento = "HARDWARE" AND asignaciones_detalle.IDElemento = hardware.IDHardware', 'left');
        $this->join('marcas_dispositivos', 'hardware.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->where('asignaciones.UsuarioAsignado', $idUsuario);
        $this->where('devoluciones_detalle.MotivoDevolucion', "ROB");
        
        // Aplicar el filtro por categoría SOLO si se pasa como parámetro y el TipoElemento es 'HARDWARE'
        if ($tipoCategoria != '') 
        {
            // Se asegura que esta condición solo aplique cuando el tipo de elemento es 'HARDWARE'
            $this->groupStart();
                $this->where('asignaciones_detalle.TipoElemento', $tipoElemento);
                $this->where('tipo.nombre_tipo', $tipoCategoria);
            $this->groupEnd();
        }
        else
        {
            $this->where('asignaciones_detalle.TipoElemento', $tipoElemento);
        }
        
        if($idElemento != '')
        {
            $this->where('asignaciones_detalle.IDElemento', $idElemento);
        }

        $datos = $this->findAll();
        return $datos;
        
        // $this->get();
        // return $this->getLastQuery();
        
    }
    
    public function obtenerDispositivosMotivoDevolucionUsuario($array)
    {
        $this->select('asignaciones_detalle.IDDetalleAsignacion, 
            asignaciones.IDAsignacion, 
            asignaciones.UsuarioAsignado, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            asignaciones.FechaAsignado, 
            asignaciones.TipoAsignado, 
            asignaciones.UsuarioRemitente,
            reposiciones_detalle.IDReposicion,
            devoluciones_detalle.*');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('reposiciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = reposiciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('hardware', 'asignaciones_detalle.TipoElemento = "HARDWARE" AND asignaciones_detalle.IDElemento = hardware.IDHardware', 'left');
        $this->join('marcas_dispositivos', 'hardware.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        
        if(!empty($array))
        {
            if(isset($array["IDUsuarioAsignado"]) && !empty($array['IDUsuarioAsignado']) )
            {
                $this->where('asignaciones.UsuarioAsignado', $array['IDUsuarioAsignado']);
            }
            
            if(isset($array["MotivoDevolucion"]) && !empty($array['MotivoDevolucion']) )
            {
                $this->where('devoluciones_detalle.MotivoDevolucion', $array['MotivoDevolucion']);
            }
            
            if(isset($array["TipoElemento"]) && !empty($array['TipoElemento']) )
            {
                $this->where('asignaciones_detalle.TipoElemento', $array['TipoElemento']);
            }
            
            if(isset($array["TipoCategoria"]) && !empty($array['TipoCategoria']) )
            {
                $this->where('tipo.nombre_tipo', $array['TipoCategoria']);
            }
            
            if(isset($array["IDElemento"]) && !empty($array['IDElemento']) )
            {
                $this->where('asignaciones_detalle.IDElemento', $array['IDElemento']);
            }
            
            if(isset($array["SoloReposicion"]) && $array["SoloReposicion"] == "Y" )
            {
                $this->where('reposiciones_detalle.IDDetalleReposicion IS NOT NULL');
            }
        }
        
        $datos = $this->findAll();
        return $datos;
        
        // $this->get();
        // return $this->getLastQuery();
        
    }
}