<?php

namespace App\Libraries;

use \App\Libraries\Complementos;

class PlantillasPDF 
{
    public function __construct()
    {
        $this->complementos = new Complementos();
    }

    public function formatoActaAsignacion_V1($array)
    {
        $html = '';
        
        $html = '<div id="ctnActaAsignacion" style="font-size: 11px; '.$array['asignacion']['widthActa'].'">
            <table cellspacing="1" style="width: 100%;">
				<tr>
					<td rowspan="2" style="width:23%; text-align:center">
					    <img src="'.$array['asignacion']['baseURL'].'/'.$array['basePublic'].'/images/LOGO-VERISURE-FULL.png" alt="" style="max-width: 100%; height: auto;">
					    <br>
					</td>
					<td rowspan="2" style="width:54%; text-align: center; border-left-width: thin; border-bottom-width: thin; border-right-width: thin; border-top-width: thin; border-left-style: none; border-bottom-style: none; border-right-style: none; border-top-style: none; font-size: 10px;">
					    <p>&nbsp;</p>
						<h2>ACTA DE ASIGNACIÓN DE EQUIPOS</h2>
                        <h3 style="font-weigth: normal;">'.$array['asignacion']['nombreAreaActaAsignacion'].'</h3>
						<p>&nbsp;</p>
					</td>
					<td rowspan="2" style="width:23%; border: 1px solid #000; border-radius: 20px:">
					    <h2 style="font-weigth: normal; text-align: center;">'.$array['asignacion']['nombreAreaActaAsignacion'].'</h2>
					</td>
				</tr>
			</table>
            <div style="">
                <h3 >Datos del Colaborador:</h3>
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">DNI</th>
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">APELLIDOS</th>
                            <th style="width: 34%; padding: 5px; border: 1px solid #FFF;">NOMBRES</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['DocumentoAsignado'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['ApellidosAsignado'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['NombresAsignado'].'</td>
                        </tr>
                    </tbody>
                </table>
                
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse; margin-top: 10px;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">DEPARTAMENTO</th>
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">ÁREA</th>
                            <th style="width: 34%; padding: 5px; border: 1px solid #FFF;">CARGO</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['DireccionAsignado'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['AreaAsignado'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['CargoAsignado'].'</td>
                        </tr>
                    </tbody>
                </table>

                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse; margin-top: 10px;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 100%; padding: 5px; border: 1px solid #FFF;">TIPO ASIGNACIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['TipoAsignado'].'</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div>
                <h3>Detalle o características del equipo(s):</h3>
                <div class="table-responsive">
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse; font-size: 9px;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="padding: 5px; border: 1px solid #FFF;">TIPO-EQUIPO</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">MARCA</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">MODELO</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">SERIE</th>';
                            
                        if(in_array("Ordenador", array_column($array['detalle'], 'CategoriaHardware'))) {
                            $html .= '<th style="padding: 5px; border: 1px solid #FFF;">CPU</th>
                                      <th style="padding: 5px; border: 1px solid #FFF;">MEMORIA</th>
                                      <th style="padding: 5px; border: 1px solid #FFF;">DISCO DURO</th>';
                        }
        
                        $html .= '<th style="padding: 5px; border: 1px solid #FFF;">OBSERVACIÓN</th>
                                  <th style="padding: 5px; border: 1px solid #FFF;">CANTIDAD</th>
                                  <th style="padding: 5px; border: 1px solid #FFF;">REPOSICIÓN<br>(UNIDAD)</th>
                              </tr>
                          </thead>
                          <tbody>';
                          
                          foreach($array['detalle'] as $items) {
                              $html .= '<tr style="text-align: center;">
                                          <td style="padding: 5px; border: 1px solid #FFF;">'.$items['TipoEquipo'].'</td>
                                          <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Marca'].'</td>
                                          <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Modelo'].'</td>
                                          <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Serie'].'</td>';
        
                              if(in_array("Ordenador", array_column($array['detalle'], 'CategoriaHardware'))) 
                              {
                                  $hdd = ($items['HDD'] == "--" || $items['HDD'] == "0" ? "" : $items['HDD'].' GB');
                                  $sdd = ($items['SSD'] == "--" || $items['SSD'] == "0" ? "" : $items['SSD'].' GB');
                                  
                                  $discoDuro = ($hdd != '' && $sdd != '' ? $hdd.' + '.$sdd : ($hdd != '' && $sdd == '' ? $hdd : $sdd ));
                                  
                                  $html .= '<td style="padding: 5px; border: 1px solid #FFF;">'.$items['Procesador'].'</td>
                                            <td style="padding: 5px; border: 1px solid #FFF;">'.($items['RAM'] == "--" ? $items['RAM'] : $items['RAM'].' GB' ).'</td>
                                            <td style="padding: 5px; border: 1px solid #FFF;">'.$discoDuro.'</td>';
                              }
        
                              $html .= '<td style="padding: 5px; border: 1px solid #FFF;">'.$items['Observacion'].' | '.$items['IDElemento'].'</td>
                                        <td style="padding: 5px; border: 1px solid #FFF;">'.$items['CantidadElementos'].'</td>
                                        <td style="padding: 5px; border: 1px solid #FFF;">'.$array['monedas'][$items['Moneda_Asignacion']].' '.$items['Monto_Asignacion'].'</td>
                                      </tr>';
                          }
        
                          $html .= '</tbody>
                      </table>
                      </div>
                  </div>
                  
                  <div style="margin-top: 20px;">
                      <h5>Observaciones:</h5>
                      <p style="text-decoration: underline;">'.$array['asignacion']['Observacion'].'</p>
                      <p>Yo, <strong>'.ucwords(mb_strtolower($array['asignacion']['NombresAsignado'])).' '.ucwords(mb_strtolower($array['asignacion']['ApellidosAsignado'])).'</strong>, con Matrícula <strong>'.$array['asignacion']['MatriculaAsignado'].'</strong>, 
                          identificado con DNI/CE/PAS N° <strong>'.$array['asignacion']['DocumentoAsignado'].'</strong> declaro bajo juramento que mi firma digital puesta al final del presente documento 
                          corroboran mi aceptación y compromiso ineludible de tener bajo mi responsabilidad el material asignado por <strong>VERISURE PERÚ S.A.C</strong> para el desempeño de mis 
                          funciones de <strong>'.ucwords(mb_strtolower($array['asignacion']['CargoAsignado'])).'</strong> que han sido detallados en el cuadro previo.</p>
                      <div>'.$array['asignacion']['Legales'].'</div>
                      <p>ENTREGADO POR: '.$array['asignacion']['NombreRemitente'].'</p>
                      <p>Lima, '.date('d', strtotime($array['asignacion']['FechaAsignado'])).' de '.$this->complementos->parseoMes(date('m', strtotime($array['asignacion']['FechaAsignado']))).' de '.date('Y', strtotime($array['asignacion']['FechaAsignado'])).'</p>
                  </div>
                  
                  <table style="width: 100%; margin-top: 20px; border: 0; text-align: center;">
                    <tr>
                        <td style="text-align: center; vertical-align: middle;">
                            <table style="width: 50%; margin: 0 auto; text-align: center; border: 0;">
                                <tr>
                                    <td>';
                                        
                                        if(empty($array['firma'])) {
                                            $html .= '<br><br><br>';
                                        } else {
                                            $html .= '<img src="'.$array['asignacion']['baseURL'].'/'.$array['baseDinamic'].'/docs/ActaAsignacion/'.date("Y",strtotime($array['firma']['FechaCrea'])).'/'.date("m",strtotime($array['firma']['FechaCrea'])).'/'.$array['firma']['IDAsignacion'].'-'.$array['firma']['IDAdjuntoAsignacion'].'.'.$array['firma']['Extension'].'" alt="" style="max-width: 150px; height: auto;">';
                                        }
                                        
                                        $html .= '</td>
                                </tr>
                                <tr>
                                    <td style="border-top: 1px solid black; padding-top: 10px;">
                                        <h4>RECIBÍ CONFORME</h4>
                                        <h5>DNI: '.$array['asignacion']['DocumentoAsignado'].'</h5>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
              </div>';
        
        return $html;
    }
    
    public function formatoActaAsignacion_V2($array)
    {
        $html = '';
        
        $html = '<div id="ctnActaAsignacion" style="font-size: 11px; '.$array['asignacion']['widthActa'].'">
            <table cellspacing="1" style="width: 100%;">
				<tr>
					<td rowspan="2" style="width:23%; text-align:center">
					    <img src="'.$array['asignacion']['baseURL'].'/'.$array['basePublic'].'/images/LOGO-VERISURE-FULL.png" alt="" style="max-width: 100%; height: auto;">
					    <br>
					</td>
					<td rowspan="2" style="width:54%; text-align: center; border-left-width: thin; border-bottom-width: thin; border-right-width: thin; border-top-width: thin; border-left-style: none; border-bottom-style: none; border-right-style: none; border-top-style: none; font-size: 10px;">
					    <p>&nbsp;</p>
						<h2>ACTA DE ASIGNACIÓN DE EQUIPOS</h2>
                        <h3 style="font-weigth: normal;">'.$array['asignacion']['nombreAreaActaAsignacion'].'</h3>
						<p>&nbsp;</p>
					</td>
					<td rowspan="2" style="width:23%; border: 1px solid #000; border-radius: 20px:">
					    <h2 style="font-weigth: normal; text-align: center;">'.$array['asignacion']['nombreAreaActaAsignacion'].'</h2>
					</td>
				</tr>
			</table>
            <div style="">
                <h3 >Datos del Colaborador:</h3>
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">DNI</th>
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">APELLIDOS</th>
                            <th style="width: 34%; padding: 5px; border: 1px solid #FFF;">NOMBRES</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['DocumentoAsignado'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['ApellidosAsignado'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['NombresAsignado'].'</td>
                        </tr>
                    </tbody>
                </table>
                
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse; margin-top: 10px;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">DEPARTAMENTO</th>
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">ÁREA</th>
                            <th style="width: 34%; padding: 5px; border: 1px solid #FFF;">CARGO</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['DireccionAsignado'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['AreaAsignado'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['CargoAsignado'].'</td>
                        </tr>
                    </tbody>
                </table>

                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse; margin-top: 10px;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 100%; padding: 5px; border: 1px solid #FFF;">TIPO ASIGNACIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['asignacion']['TipoAsignado'].'</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div>
                <h3>Detalle o características del equipo(s):</h3>
                <div class="table-responsive">
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse; font-size: 9px;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="padding: 5px; border: 1px solid #FFF;">TIPO-EQUIPO</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">MARCA</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">MODELO</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">SERIE</th>';
                            
                        if(in_array("Ordenador", array_column($array['detalle'], 'CategoriaHardware'))) {
                            $html .= '<th style="padding: 5px; border: 1px solid #FFF;">CPU</th>
                                      <th style="padding: 5px; border: 1px solid #FFF;">MEMORIA</th>
                                      <th style="padding: 5px; border: 1px solid #FFF;">DISCO DURO</th>';
                        }
        
                        $html .= '<th style="padding: 5px; border: 1px solid #FFF;">OBSERVACIÓN</th>
                                  <th style="padding: 5px; border: 1px solid #FFF;">CANTIDAD</th>
                                  <th style="padding: 5px; border: 1px solid #FFF;">REPOSICIÓN<br>(UNIDAD)</th>
                              </tr>
                          </thead>
                          <tbody>';
                          
                          foreach($array['detalle'] as $items) {
                              $html .= '<tr style="text-align: center;">
                                          <td style="padding: 5px; border: 1px solid #FFF;">'.$items['TipoEquipo'].'</td>
                                          <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Marca'].'</td>
                                          <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Modelo'].'</td>
                                          <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Serie'].'</td>';
        
                              if(in_array("Ordenador", array_column($array['detalle'], 'CategoriaHardware'))) 
                              {
                                  $hdd = ($items['HDD'] == "--" || $items['HDD'] == "0" ? "" : $items['HDD'].' GB');
                                  $sdd = ($items['SSD'] == "--" || $items['SSD'] == "0" ? "" : $items['SSD'].' GB');
                                  
                                  $discoDuro = ($hdd != '' && $sdd != '' ? $hdd.' + '.$sdd : ($hdd != '' && $sdd == '' ? $hdd : $sdd ));
                                  
                                  $html .= '<td style="padding: 5px; border: 1px solid #FFF;">'.$items['Procesador'].'</td>
                                            <td style="padding: 5px; border: 1px solid #FFF;">'.($items['RAM'] == "--" ? $items['RAM'] : $items['RAM'].' GB' ).'</td>
                                            <td style="padding: 5px; border: 1px solid #FFF;">'.$discoDuro.'</td>';
                              }
        
                              $html .= '<td style="padding: 5px; border: 1px solid #FFF;">'.$items['Observacion'].'</td>
                                        <td style="padding: 5px; border: 1px solid #FFF;">'.$items['CantidadElementos'].'</td>
                                        <td style="padding: 5px; border: 1px solid #FFF;">'.$array['monedas'][$items['Moneda_Asignacion']].' '.$items['Monto_Asignacion'].'</td>
                                      </tr>';
                          }
        
                          $html .= '</tbody>
                      </table>
                      </div>
                  </div>
                  
                  <div style="margin-top: 20px;">
                      <h5>Observaciones:</h5>
                      <p style="text-decoration: underline;">'.$array['asignacion']['Observacion'].'</p>
                      <p>Yo, <strong>'.ucwords(mb_strtolower($array['asignacion']['NombresAsignado'])).' '.ucwords(mb_strtolower($array['asignacion']['ApellidosAsignado'])).'</strong>, con Matrícula <strong>'.$array['asignacion']['MatriculaAsignado'].'</strong>, 
                          identificado con DNI/CE/PAS N° <strong>'.$array['asignacion']['DocumentoAsignado'].'</strong> declaro bajo juramento lo siguiente:</p>
                      <div>'.$array['asignacion']['Legales'].'</div>
                      <p>ENTREGADO POR: '.$array['asignacion']['NombreRemitente'].'</p>
                      <p>Lima, '.date('d', strtotime($array['asignacion']['FechaAsignado'])).' de '.$this->complementos->parseoMes(date('m', strtotime($array['asignacion']['FechaAsignado']))).' de '.date('Y', strtotime($array['asignacion']['FechaAsignado'])).'</p>
                  </div>
                  
                  <table style="width: 100%; margin-top: 20px; border: 0; text-align: center;">
                    <tr>
                        <td style="text-align: center; vertical-align: middle;">
                            <table style="width: 50%; margin: 0 auto; text-align: center; border: 0;">
                                <tr>
                                    <td>';
                                        
                                        if(empty($array['firma'])) {
                                            $html .= '<br><br><br>';
                                        } else {
                                            $html .= '<img src="'.$array['asignacion']['baseURL'].'/'.$array['baseDinamic'].'/docs/ActaAsignacion/'.date("Y",strtotime($array['firma']['FechaCrea'])).'/'.date("m",strtotime($array['firma']['FechaCrea'])).'/'.$array['firma']['IDAsignacion'].'-'.$array['firma']['IDAdjuntoAsignacion'].'.'.$array['firma']['Extension'].'" alt="" style="max-width: 150px; height: auto;">';
                                        }
                                        
                                        $html .= '</td>
                                </tr>
                                <tr>
                                    <td style="border-top: 1px solid black; padding-top: 10px;">
                                        <h4>RECIBÍ CONFORME</h4>
                                        <h5>DNI: '.$array['asignacion']['DocumentoAsignado'].'</h5>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
              </div>';
        
        return $html;
    }
    
    public function formatoActaReposicion_V1($array)
    {
        $html = '';
        
        $html = '<div id="ctnActaReposicion" style="font-size: 11px; '.$array['reposicion']['widthActa'].'">
            <table cellspacing="1" style="width: 100%;">
				<tr style="">
					<td rowspan="2" style="width:23%; text-align:center">
					    <img src="'.$array['reposicion']['baseURL'].'/'.$array['basePublic'].'/images/LOGO-VERISURE-FULL.png" alt="" style="max-width: 100%; height: auto;">
					    <br>
					</td>
					<td rowspan="2" style="width:54%; text-align: center; border-left-width: thin; border-bottom-width: thin; border-right-width: thin; border-top-width: thin; border-left-style: none; border-bottom-style: none; border-right-style: none; border-top-style: none; font-size: 10px;">
					    <p>&nbsp;</p>
						<h2>ACTA DE REPOSICIÓN</h2>
                        <h2 style="font-weigth: normal;">AUTORIZACIÓN DE DESCUENTO</h2>
						<p>&nbsp;</p>
					</td>
					<td rowspan="2" style="width:23%; border: 1px solid #000; border-radius: 20px:">
					    <h2 style="font-weigth: normal; text-align: center;">'.$array['reposicion']['nombreAreaActaReposicion'].'</h2>
					</td>
				</tr>
			</table>
            <div class="col-12 row m-0 p-0">
				<p>Yo, <strong>'.ucwords(mb_strtolower($array['reposicion']['NombreAdjudicado'])).'</strong>, con Matrícula <strong>'.$array['reposicion']['MatriculaAdjudicado'].'</strong>, identificado
				con DNI/CE/PAS <strong>'.$array['reposicion']['DocumentoAdjudicado'].'</strong>, declaro bajo juramento que mi firma digital puesta al final del presente documento corroboran mi aceptación y compromiso ineludible de autorizar el descuento del monto
				total descrito líneas abajo en la planilla de mis haberes o de mis beneficios de liquidación, de acuerdo a las políticas establecidas por <strong>VERISURE PERÚ S.A.C.</strong>.</p>
            </div>';
            
            foreach($array['detalle'] as $items)
            {
                $html .= '<div class="col-12 row m-0 p-0">
					<h3 class="col-12">Detalle o características del equipo:</h3>
					<div class="col-12 mb-3">
						<table id="tblElementosReposicion" style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
							<thead>
								<tr style="background-color: #333; color: white; text-align: center;">
									<th style="padding: 5px; border: 1px solid #FFF;">TIPO-EQUIPO</th>
									<th style="padding: 5px; border: 1px solid #FFF;">ELEMENTO</th>
									<th style="padding: 5px; border: 1px solid #FFF;">DESCUENTO TOTAL</th>
									<th style="padding: 5px; border: 1px solid #FFF;">% VERISURE</th>
									<th style="padding: 5px; border: 1px solid #FFF;">% TRABAJADOR</th>
									<th style="padding: 5px; border: 1px solid #FFF;">OBSERVACIÓN</th>
								</tr>
							</thead>
							<tbody>
								<tr style="text-align: center;">
									<td style="padding: 5px; border: 1px solid #FFF;">'.$items['TipoEquipo'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">'.$items['Marca'].' '.$items['Modelo'].' '.$items['Serie'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">S/ '.$items['TotalDescuento'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">S/ '.$items['TotalVerisure'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">S/ '.$items['TotalTrabajador'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">'.$items['Observacion'].'</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<div class="col-12 row m-0 p-0">
					<p>El monto total de descuento (<strong>S/ '.$items['TotalTrabajador'].'</strong>) será descontado mensualmente de mi remuneración en <strong>'.$items['TotalCuotas'].'</strong> 
					cuota(s), bajo el siguiente esquema:</p>
                </div>
                <div class="col-12 row m-0 p-0">
					<h3 class="col-12">Detalle de cuota(s):</h3>
					<div class="col-12 mb-3">
						<table id="tblCuotasDescuento" style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
							<thead>
								<tr style="background-color: #333; color: white; text-align: center;">';
								foreach($array['cronograma'] as $cabecera )
								{
								    if($cabecera['IDDetalleReposicion'] == $items['IDDetalleReposicion'])
								    {
									    $html .= '<th style="padding: 5px; border: 1px solid #FFF;">'.$cabecera['NroCuota'].' CUOTA<br>'.$this->complementos->parseoMes($cabecera['MesCuota'], FALSE).' '.$cabecera['AnioCuota'].'</th>';
								    }
								}
								$html .= '</tr>
							</thead>
							<tbody>
								<tr style="text-align: center;">';
								foreach($array['cronograma'] as $descuentos )
								{
								    if($descuentos['IDDetalleReposicion'] == $items['IDDetalleReposicion'])
								    {
									    $html .= '<td style="padding: 5px; border: 1px solid #FFF;">S/ '.$descuentos['MontoCuota'].'</td>';
								    }
								}
								$html .= '</tr>
							</tbody>
						</table>
					</div>
				</div>';				
            }
            
            $html .= '<div class="col-12 row m-0 p-0">
                <p>Declaro expresamente que estoy de acuerdo con todo el contenido del presente documento, por lo que manifiesto que estoy en pleno uso de mis facultades al momento de firmar la presente 
                autorización, y que reconozco las consecuencias y efectos que se derivan del presente documento que son los que están expresamente contenidos en este.</p>
				<p>ENTREGADO POR: '.$array['reposicion']['NombreReceptor'].'</p>
                <p>Lima, '.date('d', strtotime($array['reposicion']['FechaCrea'])).' de '.$this->complementos->parseoMes(date('m', strtotime($array['reposicion']['FechaCrea']))).' de '.date('Y', strtotime($array['reposicion']['FechaCrea'])).'</p>
            </div>
            <table style="width: 100%; margin-top: 20px; border: 0; text-align: center;">
                <tr>
                    <td style="text-align: center; vertical-align: middle;">
                        <table style="width: 50%; margin: 0 auto; text-align: center; border: 0;">
                            <tr>
                                <td>';
                                    if(empty($array['firma'])) 
                                    {
                                        $html .= '<br><br><br>';
                                    } 
                                    else 
                                    {
                                        $html .= '<img src="'.$array['reposicion']['baseURL'].'/'.$array['baseDinamic'].'/docs/ActaReposicion/'.date("Y", strtotime($array['firma']['FechaCrea'])).'/'.date("m", strtotime($array['firma']['FechaCrea'])).'/'.$array['firma']['IDReposicion'].'-'.$array['firma']['IDAdjuntoReposicion'].'.'.$array['firma']['Extension'].'" alt="" style="max-width: 150px; height: auto;">';
                                    }
                                $html .= '</td>
                            </tr>
                            <tr>
                                <td style="border-top: 1px solid black; padding-top: 10px;">
                                    <h4>RECIBÍ CONFORME</h4>
                                    <h5>DNI: '.$array['reposicion']['DocumentoAdjudicado'].'</h5>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>';
        
        return $html;
    }
    
    public function formatoActaReposicion_V2($array)
    {
        $html = '';
        
        $html = '<div id="ctnActaReposicion" style="font-size: 11px; '.$array['reposicion']['widthActa'].'">
            <table cellspacing="1" style="width: 100%;">
				<tr style="">
					<td rowspan="2" style="width:23%; text-align:center">
					    <img src="'.$array['reposicion']['baseURL'].'/'.$array['basePublic'].'/images/LOGO-VERISURE-FULL.png" alt="" style="max-width: 100%; height: auto;">
					    <br>
					</td>
					<td rowspan="2" style="width:54%; text-align: center; border-left-width: thin; border-bottom-width: thin; border-right-width: thin; border-top-width: thin; border-left-style: none; border-bottom-style: none; border-right-style: none; border-top-style: none; font-size: 10px;">
					    <p>&nbsp;</p>
                        <h2 style="font-weigth: normal;">AUTORIZACIÓN DE DESCUENTO</h2>
						<p>&nbsp;</p>
					</td>
					<td rowspan="2" style="width:23%; border: 1px solid #000; border-radius: 20px:">
					    <h2 style="font-weigth: normal; text-align: center;">'.$array['reposicion']['nombreAreaActaReposicion'].'</h2>
					</td>
				</tr>
			</table>
            <div class="col-12 row m-0 p-0">
				<p>Yo, <strong>'.ucwords(mb_strtolower($array['reposicion']['NombreAdjudicado'])).'</strong>, con Matrícula <strong>'.$array['reposicion']['MatriculaAdjudicado'].'</strong>, identificado
				con DNI/CE/PAS <strong>'.$array['reposicion']['DocumentoAdjudicado'].'</strong>, declaro bajo juramento que los siguientes descuentos sean aplicados en mi remuneración mensual o en mi 
				liquidación de beneficios sociales, de acuerdo a las políticas establecidas por <strong>VERISURE PERÚ S.A.C.</strong>.</p>
            </div>';
            
            foreach($array['detalle'] as $items)
            {
                $html .= '<div class="col-12 row m-0 p-0">
					<h3 class="col-12">Detalle o características del equipo:</h3>
					<div class="col-12 mb-3">
						<table id="tblElementosReposicion" style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
							<thead>
								<tr style="background-color: #333; color: white; text-align: center;">
									<th style="padding: 5px; border: 1px solid #FFF;">TIPO-EQUIPO</th>
									<th style="padding: 5px; border: 1px solid #FFF;">ELEMENTO</th>
									<th style="padding: 5px; border: 1px solid #FFF;">DESCUENTO TOTAL</th>
									<th style="padding: 5px; border: 1px solid #FFF;">% VERISURE</th>
									<th style="padding: 5px; border: 1px solid #FFF;">% TRABAJADOR</th>
									<th style="padding: 5px; border: 1px solid #FFF;">OBSERVACIÓN</th>
								</tr>
							</thead>
							<tbody>
								<tr style="text-align: center;">
									<td style="padding: 5px; border: 1px solid #FFF;">'.$items['TipoEquipo'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">'.$items['Marca'].' '.$items['Modelo'].' '.$items['Serie'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">S/ '.$items['TotalDescuento'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">S/ '.$items['TotalVerisure'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">S/ '.$items['TotalTrabajador'].'</td>
									<td style="padding: 5px; border: 1px solid #FFF;">'.$items['Observacion'].'</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<div class="col-12 row m-0 p-0">
					<p>El monto asumido (<strong>S/ '.$items['TotalTrabajador'].'</strong>) será descontado mensualmente de mi remuneración en <strong>'.$items['TotalCuotas'].'</strong> 
					cuota(s), bajo el siguiente esquema:</p>
                </div>
                <div class="col-12 row m-0 p-0">
					<h3 class="col-12">Detalle de cuota(s):</h3>
					<div class="col-12 mb-3">
						<table id="tblCuotasDescuento" style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
							<thead>
								<tr style="background-color: #333; color: white; text-align: center;">';
								foreach($array['cronograma'] as $cabecera )
								{
								    if($cabecera['IDDetalleReposicion'] == $items['IDDetalleReposicion'])
								    {
									    $html .= '<th style="padding: 5px; border: 1px solid #FFF;">'.$cabecera['NroCuota'].' CUOTA<br>'.$this->complementos->parseoMes($cabecera['MesCuota'], FALSE).' '.$cabecera['AnioCuota'].'</th>';
								    }
								}
								$html .= '</tr>
							</thead>
							<tbody>
								<tr style="text-align: center;">';
								foreach($array['cronograma'] as $descuentos )
								{
								    if($descuentos['IDDetalleReposicion'] == $items['IDDetalleReposicion'])
								    {
									    $html .= '<td style="padding: 5px; border: 1px solid #FFF;">S/ '.$descuentos['MontoCuota'].'</td>';
								    }
								}
								$html .= '</tr>
							</tbody>
						</table>
					</div>
				</div>';				
            }
            
            $html .= '<div class="col-12 row m-0 p-0">
                <p>Acepto que, en caso de darse por terminada la relación laboral antes del cumplimiento del total de cuotas señaladas, autorizo a que se descuente el saldo pendiente de mi 
                liquidación de beneficios sociales o cualquier otro beneficio que tenga pendiente por cobrar y que me corresponda a la fecha del cese de la relación laboral.</p>
                <p>Declaro expresamente que estoy de acuerdo con todo el contenido del presente documento, por lo que manifiesto que estoy en pleno uso de mis facultades al momento de firmar la presente 
                autorización, y reconozco los efectos que se derivan del presente documento.</p>
				<p>ENTREGADO POR: '.$array['reposicion']['NombreReceptor'].'</p>
                <p>Lima, '.date('d', strtotime($array['reposicion']['FechaCrea'])).' de '.$this->complementos->parseoMes(date('m', strtotime($array['reposicion']['FechaCrea']))).' de '.date('Y', strtotime($array['reposicion']['FechaCrea'])).'</p>
            </div>
            <table style="width: 100%; margin-top: 20px; border: 0; text-align: center;">
                <tr>
                    <td style="text-align: center; vertical-align: middle;">
                        <table style="width: 50%; margin: 0 auto; text-align: center; border: 0;">
                            <tr>
                                <td>';
                                    if(empty($array['firma'])) 
                                    {
                                        $html .= '<br><br><br>';
                                    } 
                                    else 
                                    {
                                        $html .= '<img src="'.$array['reposicion']['baseURL'].'/'.$array['baseDinamic'].'/docs/ActaReposicion/'.date("Y", strtotime($array['firma']['FechaCrea'])).'/'.date("m", strtotime($array['firma']['FechaCrea'])).'/'.$array['firma']['IDReposicion'].'-'.$array['firma']['IDAdjuntoReposicion'].'.'.$array['firma']['Extension'].'" alt="" style="max-width: 150px; height: auto;">';
                                    }
                                $html .= '</td>
                            </tr>
                            <tr>
                                <td style="border-top: 1px solid black; padding-top: 10px;">
                                    <h4>RECIBÍ CONFORME</h4>
                                    <h5>DNI: '.$array['reposicion']['DocumentoAdjudicado'].'</h5>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>';
        
        return $html;
        
    }
    
    public function formatoActaDevolucion_V1($array)
    {
        $html = '';
        
        $html = '<div id="ctnActaDevolucion" style="font-size: 11px; '.$array['devolucion']['widthActa'].'">
            <table cellspacing="1" style="width: 100%; ">
				<tr>
					<td rowspan="2" style="width:23%; text-align:center">
					    <img src="'.$array['devolucion']['baseURL'].'/'.$array['basePublic'].'/images/LOGO-VERISURE-FULL.png" alt="" style="max-width: 100%; height: auto;">
					    <br>
					</td>
					<td rowspan="2" style="width:54%; text-align: center; border-left-width: thin; border-bottom-width: thin; border-right-width: thin; border-top-width: thin; border-left-style: none; border-bottom-style: none; border-right-style: none; border-top-style: none; font-size: 10px;">
					    <p>&nbsp;</p>
						<h2>ACTA DE DEVOLUCIÓN</h2>
                        <h2 style="font-weigth: normal;">HOJA DE DESVINCULACIÓN</h2>
						<p>&nbsp;</p>
					</td>
					<td rowspan="2" style="width:23%; border: 1px solid #000; border-radius: 20px:">
					    <h2 style="font-weigth: normal; text-align: center;">'.$array['devolucion']['nombreAreaActaDevolucion'].'</h2>
					</td>
				</tr>
			</table>
            <div style="">
                <h3 >Datos del Colaborador:</h3>
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">DNI</th>
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">APELLIDOS</th>
                            <th style="width: 34%; padding: 5px; border: 1px solid #FFF;">NOMBRES</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['DocumentoUsuarioDevolucion'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['ApellidosUsuarioDevolucion'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['NombresUsuarioDevolucion'].'</td>
                        </tr>
                    </tbody>
                </table>
                
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse; margin-top: 10px;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">DEPARTAMENTO</th>
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">ÁREA</th>
                            <th style="width: 34%; padding: 5px; border: 1px solid #FFF;">CARGO</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['DireccionUsuarioDevolucion'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['AreaUsuarioDevolucion'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['CargoDevolucion'].'</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div>
                <h3>Detalle o características del equipo(s):</h3>
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="padding: 5px; border: 1px solid #FFF;">TIPO-EQUIPO</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">ELEMENTO</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">MOTIVO DEVOLUCIÓN</th>¿
                            <th style="padding: 5px; border: 1px solid #FFF;">OBSERVACIÓN</th>
                        </tr>
                    </thead>
                    <tbody>';
                    
                    foreach($array['detalle'] as $items) 
                    {
                        $html .= '<tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$items['TipoEquipo'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Marca'].' '.$items['Modelo'].' '.$items['Serie'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['estadosDispositivo'][$items['MotivoDevolucion']].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Observacion'].'</td>
                        </tr>';
                    }
                    
                    $html .= '</tbody>
                </table>
            </div>
            <div style="margin-top: 20px;">
                <h5>Observaciones:</h5>
                <p style="text-decoration: underline;">'.$array['devolucion']['Observacion'].'</p>
                <p>Por medio del presente documento declaro que he entregado los elementos descritos anteriormente, que su estado fue verificado por el personal que recibe y 
    				que estoy de acuerdo a lo anteriormente señalado. También con mi firma declaro que:</p>
    			<ul class="mx-3">
    				<li>La revisión fue realizada con honestidad, con el mejor uso de mis capacidades y se describe el estado en que fue entregado el dispositivo.</li>
    				<li>He puesto el mayor esfuerzo en el cuidado del material entregado y que su deterioro corresponde a su desgaste natural por uso.</li>
    				<li>Únicamente le he dado uso al elemento para los fines encomendado por la empresa.</li>
    				<li>No he mantenido en mi posesión ningún elemento adicional relacionado a los descritos, incluyendo información si corresponde.</li>
    				<li>Toda información otorgada por la empresa fue devuelta, a menos que se detalle lo contrario en las observaciones.</li>
    				<li>Si algún dispositivo no fue devuelto o se encuentra en mal estado, se generará automáticamente un ACTA DE REPOSICIÓN que autoriza el descuento respectivo de acuerdo al proceso de telefonía.</li>
    			</ul>
    			<p>Con esta firma reconozco que de no cumplir lo anterior estaría en violación de los términos aceptados al momento de recibir los elementos de 
                    						trabajo, los cuales están expuestos en la(s) respectiva(s) acta(s) de asignación.</p>
                <p>ENTREGADO POR: '.$array['devolucion']['NombreReceptor'].'</p>
                <p>'.$array['devolucion']['FechaDevolucion'].'</p>
            </div>
            <table style="width: 100%; margin-top: 20px; border: 0; text-align: center;">
                <tr>
                    <td style="text-align: center; vertical-align: middle;">
                        <table style="width: 50%; margin: 0 auto; text-align: center; border: 0;">
                            <tr>
                                <td>';
                                    if(empty($array['firma'])) 
                                    {
                                        $html .= '<br><br><br>';
                                    } 
                                    else 
                                    {
                                        $html .= '<img src="'.$array['devolucion']['baseURL'].'/'.$array['baseDinamic'].'/docs/ActaDevolucion/'.date("Y", strtotime($array['firma']['FechaCrea'])).'/'.date("Y", strtotime($array['firma']['FechaCrea'])).'/'.$array['firma']['IDDevolucion'].'-'.$array['firma']['IDAdjuntoDevolucion'].'.'.$array['firma']['Extension'].'" alt="" style="max-width: 150px; height: auto;">';
                                    }
                                $html .= '</td>
                            </tr>
                            <tr>
                                <td style="border-top: 1px solid black; padding-top: 10px;">
                                    <h4>RECIBÍ CONFORME</h4>
                                    <h5>DNI: '.$array['devolucion']['DocumentoUsuarioDevolucion'].'</h5>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>';
        
        return $html;
    }
    
    public function formatoActaDevolucion_V2($array)
    {
        $html = '';
        
        $html = '<div id="ctnActaDevolucion" style="font-size: 11px; '.$array['devolucion']['widthActa'].'">
            <table cellspacing="1" style="width: 100%; ">
				<tr>
					<td rowspan="2" style="width:23%; text-align:center">
					    <img src="'.$array['devolucion']['baseURL'].'/'.$array['basePublic'].'/images/LOGO-VERISURE-FULL.png" alt="" style="max-width: 100%; height: auto;">
					    <br>
					</td>
					<td rowspan="2" style="width:54%; text-align: center; border-left-width: thin; border-bottom-width: thin; border-right-width: thin; border-top-width: thin; border-left-style: none; border-bottom-style: none; border-right-style: none; border-top-style: none; font-size: 10px;">
					    <p>&nbsp;</p>
						<h2>ACTA DE DEVOLUCIÓN</h2>
                        <h2 style="font-weigth: normal;">HOJA DE DESVINCULACIÓN</h2>
						<p>&nbsp;</p>
					</td>
					<td rowspan="2" style="width:23%; border: 1px solid #000; border-radius: 20px:">
					    <h2 style="font-weigth: normal; text-align: center;">'.$array['devolucion']['nombreAreaActaDevolucion'].'</h2>
					</td>
				</tr>
			</table>
            <div style="">
                <h3 >Datos del Colaborador:</h3>
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">DNI</th>
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">APELLIDOS</th>
                            <th style="width: 34%; padding: 5px; border: 1px solid #FFF;">NOMBRES</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['DocumentoUsuarioDevolucion'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['ApellidosUsuarioDevolucion'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['NombresUsuarioDevolucion'].'</td>
                        </tr>
                    </tbody>
                </table>
                
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse; margin-top: 10px;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">DEPARTAMENTO</th>
                            <th style="width: 33%; padding: 5px; border: 1px solid #FFF;">ÁREA</th>
                            <th style="width: 34%; padding: 5px; border: 1px solid #FFF;">CARGO</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['DireccionUsuarioDevolucion'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['AreaUsuarioDevolucion'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['devolucion']['CargoDevolucion'].'</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div>
                <h3>Detalle o características del equipo(s):</h3>
                <table style="width: 100%; border: 1px solid #000; border-collapse: collapse;">
                    <thead>
                        <tr style="background-color: #333; color: white; text-align: center;">
                            <th style="padding: 5px; border: 1px solid #FFF;">TIPO-EQUIPO</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">ELEMENTO</th>
                            <th style="padding: 5px; border: 1px solid #FFF;">MOTIVO DEVOLUCIÓN</th>¿
                            <th style="padding: 5px; border: 1px solid #FFF;">OBSERVACIÓN</th>
                        </tr>
                    </thead>
                    <tbody>';
                    
                    foreach($array['detalle'] as $items) 
                    {
                        $html .= '<tr style="text-align: center;">
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$items['TipoEquipo'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Marca'].' '.$items['Modelo'].' '.$items['Serie'].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$array['estadosDispositivo'][$items['MotivoDevolucion']].'</td>
                            <td style="padding: 5px; border: 1px solid #FFF;">'.$items['Observacion'].'</td>
                        </tr>';
                    }
                    
                    $html .= '</tbody>
                </table>
            </div>
            <div style="margin-top: 20px;">
                <h5>Observaciones:</h5>
                <p style="text-decoration: underline;">'.$array['devolucion']['Observacion'].'</p>
                
                <p>Por medio del presente documento declaro bajo juramento lo siguiente:</p>
    			<ol class="mx-3">
					<li>He devuelto los equipos informáticos que me fueron asignados, los cuales pasarán por una revisión técnica 
					    por parte del área de IT, en un plazo de veinticuatro (24) horas después de su recepción, con el fin de corroborar si presentan daños.</li>';
					    
					if( ($array['devolucion']['CorreoDevolucion'] != '' && $array['devolucion']['CorreoDevolucion'] != null) || ($array['devolucion']['TelefonoDevolucion'] != '' && $array['devolucion']['TelefonoDevolucion'] != null) )
					{
					    $texto = '';
					    
					    if( ($array['devolucion']['CorreoDevolucion'] != '' && $array['devolucion']['CorreoDevolucion'] != null) && ($array['devolucion']['TelefonoDevolucion'] != '' && $array['devolucion']['TelefonoDevolucion'] != null) )
					    {
					        $texto = 'correo electrónico '.$array['devolucion']['CorreoDevolucion'].' y al número '.$array['devolucion']['TelefonoDevolucion'];
					    }
					    else if( ($array['devolucion']['CorreoDevolucion'] != '' && $array['devolucion']['CorreoDevolucion'] != null) && ($array['devolucion']['TelefonoDevolucion'] == '' && $array['devolucion']['TelefonoDevolucion'] == null) )
					    {
					        $texto = 'correo electrónico '.$array['devolucion']['CorreoDevolucion'];
					    }
					    else if( ($array['devolucion']['CorreoDevolucion'] == '' && $array['devolucion']['CorreoDevolucion'] == null) && ($array['devolucion']['TelefonoDevolucion'] != '' && $array['devolucion']['TelefonoDevolucion'] != null) )
					    {
					        $texto = 'número '.$array['devolucion']['TelefonoDevolucion'];
					    }
					    
					$html .= '<li>En caso se detecten daños en los equipos informáticos, IT procederá a comunicarme tal situación al '.$texto.', 
					    detallando los daños advertidos y el monto que deberé asumir por estos.</li>';
					    
					}
					
					$html .= '<li>Autorizo por anticipado el descuento correspondiente del monto que se determine por los daños detectados, el cual ha sido comunicado por el área de IT.</li>
				</ol>
    			<p>Declaro expresamente que estoy de acuerdo con todo el contenido del presente documento, por lo que manifiesto que estoy en pleno uso de mis facultades al momento de firmarlo, 
									    y reconozco los efectos que se derivan del presente documento.</p>
                <p>ENTREGADO POR: '.$array['devolucion']['NombreReceptor'].'</p>
                <p>'.$array['devolucion']['FechaDevolucion'].'</p>
            </div>
            <table style="width: 100%; margin-top: 20px; border: 0; text-align: center;">
                <tr>
                    <td style="text-align: center; vertical-align: middle;">
                        <table style="width: 50%; margin: 0 auto; text-align: center; border: 0;">
                            <tr>
                                <td>';
                                    if(empty($array['firma'])) 
                                    {
                                        $html .= '<br><br><br>';
                                    } 
                                    else 
                                    {
                                        $html .= '<img src="'.$array['devolucion']['baseURL'].'/'.$array['baseDinamic'].'/docs/ActaDevolucion/'.date("Y", strtotime($array['firma']['FechaCrea'])).'/'.date("Y", strtotime($array['firma']['FechaCrea'])).'/'.$array['firma']['IDDevolucion'].'-'.$array['firma']['IDAdjuntoDevolucion'].'.'.$array['firma']['Extension'].'" alt="" style="max-width: 150px; height: auto;">';
                                    }
                                $html .= '</td>
                            </tr>
                            <tr>
                                <td style="border-top: 1px solid black; padding-top: 10px;">
                                    <h4>RECIBÍ CONFORME</h4>
                                    <h5>DNI: '.$array['devolucion']['DocumentoUsuarioDevolucion'].'</h5>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>';
        
        return $html;
    }
    
}
