<?php

if (!function_exists('valor_valido')) {
    /**
     * Verifica si el valor recibido (string o array) es válido, es decir,
     * no está vacío ni es un array con sólo valores vacíos.
     *
     * @param mixed $valor
     * @return bool
     */
    function valor_valido($valor): bool
    {
        // Si es null o no está definido
        if (!isset($valor)) {
            return false;
        }
    
        // Si es array, verificamos que al menos uno de sus elementos tenga un valor no vacío
        if (is_array($valor)) {
            foreach ($valor as $item) {
                if (is_string($item) && trim($item) !== '') {
                    return true;
                }
                if (is_numeric($item)) { // También considerar números
                    return true;
                }
                // Puedes agregar más chequeos aquí si esperas otros tipos
            }
            return false; // Si ningún elemento es válido, devolvemos false
        }
    
        // Si es string, chequeamos que no sea vacío ni solo espacios
        if (is_string($valor)) {
            return trim($valor) !== '';
        }
    
        // Si es numérico (int, float), lo consideramos válido
        if (is_numeric($valor)) {
            return true;
        }
    
        // Por defecto, falso para otros tipos o vacíos
        return false;
    }
}