<?php

namespace App\Controllers;

class Dashboard extends BaseController
{
	public function __construct()
	{
	    $this->usuariosDelegaciones             = new \App\Models\UsuarioDelegacionModel();
	    
		$this->estructuraSubareaDelegaciones    = new \App\Models\EstructuraSubareaDelegacionesModel();
		
		/* CARGOS */
        $this->asignaciones                 = new \App\Models\Cargos\AsignacionesModel();
        $this->devolucionesDetalle          = new \App\Models\Cargos\DevolucionesDetalleModel();
	}
	
	/**************************************************************************/
	
    /******************************** GENERAL *********************************/
    
	public function dashboardGeneral()
	{
	    if(isset($this->items['id']))
	    {
	        switch ($this->items['idPerfil']) {
                case '1':
                    echo $this->dashboardAdministrador();
                    break;
                case '2':
                    echo $this->dashboardGestorIT();
                    break;
                case '3':
                    echo $this->dashboardCoordinador();
                    break;
                default:
                    echo "No se encontró";
            }
	    } 
	    else 
	    {
			return view('errors/500');
		}
	}

	/**************************************************************************/
	
    /***************************** ADMINISTRADOR ******************************/
    
    public function dashboardAdministrador()
    {
        $data = array (
			'session'               => 'on',
			'titulo'                => 'Dashboard Administrador | Verisure',
			'breadcrumb'            => $this->items['modulo'],
			'breadcrumb_alias'          => 'Dashboard',
            // 'previo'                => 'listar-proveedores',
			'elementoSeleccionadoModulo'=> "Dashboard",
			'subtitulo'                 => 'Dashboard'
		);
		
		$data = array_merge($data, $this->items);
		
		return view('dashboard/administrador',$data);		
    }
    
	/**************************************************************************/
	
    /******************************* GESTOR IT ********************************/
    
    public function dashboardGestorIT()
    {
        $data = array (
			'session'               => 'on',
			'titulo'                => 'Dashboard IT | Verisure',
			'breadcrumb'            => $this->items['modulo'],
			'breadcrumb_alias'          => 'Dashboard',
            // 'previo'                => 'listar-proveedores',
			'elementoSeleccionadoModulo'=> "Dashboard",
			'subtitulo'                 => 'Dashboard'
		);
		
		$data = array_merge($data, $this->items);
		
		return view('dashboard/gestorIT',$data);		
    }
    
	/**************************************************************************/
	
    /****************************** COORDINADOR *******************************/
    
    public function dashboardCoordinador()
    {
        $data = array (
			'session'               => 'on',
			'titulo'                => 'Dashboard Coordinadores | Verisure',
			'breadcrumb'            => $this->items['modulo'],
			'breadcrumb_alias'          => 'Dashboard',
            // 'previo'                => 'listar-proveedores',
			'elementoSeleccionadoModulo'=> "Dashboard",
			'subtitulo'                 => 'Dashboard'
		);
		
		$data = array_merge($data, $this->items);
		
		return view('dashboard/coordinadores',$data);		
    }
    
	/**************************************************************************/
	
    /*************************** GRÁFICAS - TABLAS ****************************/
    
    public function graficaActaAsignacionPendienteFirmaFechaCreacion()
    {
        $inicio     = $this->request->getPost('inicioGrafico');
        $final      = $this->request->getPost('finalGrafico');
        $activos    = $this->request->getPost('activosGrafico');
        
        $arrayGrafica = array(
            'InicioBusqueda'    => $inicio,
            'FinalBusqueda'     => $final,
            'ActivosBusqueda'   => $activos,
            'GroupBy'           => 'FechaCrea'
        );
        
        if($this->items['idPerfil'] == 3)
        {
            //Listar delegaciones asociadas a la subarea "Fuerza de Ventas"
            $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
            
            //Listar delegaciones asociadas al usuario logueado
            // $listadoDelegaciones = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
            
            $delegaciones = array_column($listadoDelegaciones, 'IDDelegacion');
            
            $arrayGrafica['arrayIDDelegacionActa'] =  $delegaciones;
        }
        
        $valores = $this->asignaciones->cantidadAsignacionesPendientesFirmaCreacion($arrayGrafica);
        
        echo json_encode($valores, JSON_PRETTY_PRINT);
    }
    
    public function recargarTablaDetalleActaAsignacionPendienteFirmaFechaCreacion()
    {
        $resultado['data'] = array();
            
        if(isset($this->items['id']))
        {
            $fechaSeleccionada = $this->request->getPost('fechaSeleccionada');
            $activos = $this->request->getPost('activosGrafico');
            
            $whereDetalle = array(
    		    'FechaBusqueda' => $fechaSeleccionada,
    		    'Activos'       => $activos,
    		    'FechaFirma'    => null
    		);
    		
            if($this->items['idPerfil'] == 3)
            {
                //Listar delegaciones asociadas a la subarea "Fuerza de Ventas"
                $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
                
                //Listar delegaciones asociadas al usuario logueado
                // $listadoDelegaciones = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
                
                $delegaciones = array_column($listadoDelegaciones, 'IDDelegacion');
                
                $whereDetalle['arrayIDDelegacionActa'] =  $delegaciones;
            }
        
    		$listaDetalle = $this->asignaciones->listarActasAsignacion($whereDetalle);
    		
            foreach($listaDetalle as $key=>$detalle)
            {
                $acciones = '';
                
                $resultado['data'][$key] = array(
                    'id_asignacion'     => (string) $detalle['IDAsignacion'],
    				'fecha_asignacion'  => (string) date("d-m-Y", strtotime($detalle['FechaCrea'])),
    				'asignado'          => (string) ucwords(mb_strtolower($detalle['NombresAsignado'].' '.$detalle['ApellidosAsignado'])),
                    'matricula'         => (string) $detalle['MatriculaAsignado'],
    				'CC'                => (string) $detalle['CCAsignado'],
    				'dispositivos'      => (string) $detalle['TIPOS_ELEMENTO'],
    				'acciones'          => (string) $acciones
    			);
            }
            
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
        else 
		{
            $resultado['sesion'] = 0;
            
		    echo json_encode($resultado);
		}
    }
    
    public function graficaDetalleActaAsignacionPendienteFirmaFechaCreacion()
    {
        $fecha     = $this->request->getPost('fechaGrafico');
        $activos    = $this->request->getPost('activosGrafico');
        
        $arrayGrafica = array(
            'FechaBusqueda'     => $fecha,
            'ActivosBusqueda'   => $activos,
            'GroupBy'           => 'CC'
        );
        
        if($this->items['idPerfil'] == 3)
        {
            //Listar delegaciones asociadas a la subarea "Fuerza de Ventas"
            $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
            
            //Listar delegaciones asociadas al usuario logueado
            // $listadoDelegaciones = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
            
            $delegaciones = array_column($listadoDelegaciones, 'IDDelegacion');
            
            $arrayGrafica['arrayIDDelegacionActa'] =  $delegaciones;
        }
    
        $valores = $this->asignaciones->cantidadAsignacionesPendientesFirmaCreacion($arrayGrafica);
        
        echo json_encode($valores, JSON_PRETTY_PRINT);
    }
    
    public function graficaDetalleActaAsignacionPendienteFirmaActivo()
    {
        $inicio     = $this->request->getPost('inicioGrafico');
        $final      = $this->request->getPost('finalGrafico');
        $activos    = $this->request->getPost('activosGrafico');
        
        $valores = array();
        
        $arrayGrafica = array(
            'InicioBusqueda'    => $inicio,
            'FinalBusqueda'     => $final,
            'ActivosBusqueda'   => $activos,
            'GroupBy'           => 'Activos'
        );
        
        if($this->items['idPerfil'] == 3)
        {
            //Listar delegaciones asociadas a la subarea "Fuerza de Ventas"
            $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
            
            //Listar delegaciones asociadas al usuario logueado
            // $listadoDelegaciones = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
            
            $delegaciones = array_column($listadoDelegaciones, 'IDDelegacion');
            
            $arrayGrafica['arrayIDDelegacionActa'] =  $delegaciones;
        }
    
        $data = $this->asignaciones->cantidadAsignacionesPendientesFirmaCreacion($arrayGrafica);
        
        foreach($data[0] as $activo => $valor)
        {
            $valores[] = array(
                'TotalPendiente'=> $valor,
                'TipoElemento'  => str_replace(" ", "", $activo),
                'Activo'        => $activo
            );
        }
        
        echo json_encode($valores, JSON_PRETTY_PRINT);
    }
    
    public function recargarTablaDetalleActaAsignacionPendienteFirmaFechaActivo()
    {
        $resultado['data'] = array();
            
        if(isset($this->items['id']))
        {
            $inicioBusqueda = $this->request->getPost('inicioGrafico');
            $finalBusqueda  = $this->request->getPost('finalGrafico');
            $tipoElemento = $this->request->getPost('tipoElemento');
            
            $whereDetalle = array(
    		    'InicioBusqueda'=> $inicioBusqueda,
    		    'FinalBusqueda' => $finalBusqueda,
    		    'TipoElemento'  => $tipoElemento,
    		    'FechaFirma'    => null
    		);
    		
            if($this->items['idPerfil'] == 3)
            {
                //Listar delegaciones asociadas a la subarea "Fuerza de Ventas"
                $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
                
                //Listar delegaciones asociadas al usuario logueado
                // $listadoDelegaciones = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
                
                $delegaciones = array_column($listadoDelegaciones, 'IDDelegacion');
                
                $whereDetalle['arrayIDDelegacionActa'] =  $delegaciones;
            }
        
    		$listaDetalle = $this->asignaciones->listarActasAsignacion($whereDetalle);
    		
            foreach($listaDetalle as $key=>$detalle)
            {
                $acciones = '';
                
                $resultado['data'][$key] = array(
                    'id_asignacion'     => (string) $detalle['IDAsignacion'],
    				'fecha_asignacion'  => (string) date("d-m-Y", strtotime($detalle['FechaCrea'])),
    				'asignado'          => (string) ucwords(mb_strtolower($detalle['NombresAsignado'].' '.$detalle['ApellidosAsignado'])),
                    'matricula'         => (string) $detalle['MatriculaAsignado'],
    				'CC'                => (string) $detalle['CCAsignado'],
    				'dispositivos'      => (string) $detalle['TIPOS_ELEMENTO'],
    				'acciones'          => (string) $acciones
    			);
            }
            
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
        else 
		{
            $resultado['sesion'] = 0;
            
		    echo json_encode($resultado);
		}
    }
    
    public function graficaDetalleActaAsignacionPendienteFirmaFechaActivo()
    {
        $inicioBusqueda = $this->request->getPost('inicioGrafico');
        $finalBusqueda  = $this->request->getPost('finalGrafico');
        $tipoElemento   = $this->request->getPost('tipoElemento');
            
        $arrayGrafica = array(
            'InicioBusqueda'=> $inicioBusqueda,
		    'FinalBusqueda' => $finalBusqueda,
		    'TipoElemento'  => $tipoElemento,
            'GroupBy'       => 'CC'
        );
        
        if($this->items['idPerfil'] == 3)
        {
            //Listar delegaciones asociadas a la subarea "Fuerza de Ventas"
            $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
            
            //Listar delegaciones asociadas al usuario logueado
            // $listadoDelegaciones = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
            
            $delegaciones = array_column($listadoDelegaciones, 'IDDelegacion');
            
            $arrayGrafica['arrayIDDelegacionActa'] =  $delegaciones;
        }
    
        $valores = $this->asignaciones->cantidadAsignacionesPendientesFirmaCreacion($arrayGrafica);
        
        echo json_encode($valores, JSON_PRETTY_PRINT);
    }
    
    public function graficaPendientesValidar()
    {
        $inicio     = $this->request->getPost('inicioGrafico');
        $final      = $this->request->getPost('finalGrafico');
        $activos    = $this->request->getPost('activosGrafico');
        
        $arrayGrafica = array(
            'InicioBusqueda'    => $inicio,
            'FinalBusqueda'     => $final
        );
        
        if($this->items['idPerfil'] == 3)
        {
            //Listar delegaciones asociadas a la subarea "Fuerza de Ventas"
            $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
            
            //Listar delegaciones asociadas al usuario logueado
            // $listadoDelegaciones = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
            
            $delegaciones = array_column($listadoDelegaciones, 'IDDelegacion');
            
            $arrayGrafica['arrayIDDelegacionActa'] =  $delegaciones;
        }
    
        $valores = $this->devolucionesDetalle->cantidadPendientesValidacion($arrayGrafica);
        
        echo json_encode($valores, JSON_PRETTY_PRINT);
    }
    
    public function recargarTablaDetallePendientesValidacion()
    {
        $resultado['data'] = array();
            
        if(isset($this->items['id']))
        {
            $inicioGrafico = $this->request->getPost('inicioGrafico');
            $finalGrafico = $this->request->getPost('finalGrafico');
            $tipoElemento = $this->request->getPost('tipoElemento');
            $rangoValidacion = $this->request->getPost('rangoValidacion');
            
            $whereDetalle = array(
    		    'InicioGrafico'     => $inicioGrafico,
    		    'FinalGrafico'      => $finalGrafico,
    		    'TipoElemento'      => $tipoElemento,
    		    'RangoValidacion'   => $rangoValidacion,
    		    'Estado'            => "REGIS",
    		    'MotivoDevolucion'  => "DEV"
    		);
    		
            if($this->items['idPerfil'] == 3)
            {
                //Listar delegaciones asociadas a la subarea "Fuerza de Ventas"
                $listadoDelegaciones = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
                
                //Listar delegaciones asociadas al usuario logueado
                // $listadoDelegaciones = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
                
                $delegaciones = array_column($listadoDelegaciones, 'IDDelegacion');
                
                $whereDetalle['arrayIDDelegacionActa'] =  $delegaciones;
            }
        
    		$listaDetalle = $this->devolucionesDetalle->listadoDetalleActaDevolucion($whereDetalle);
    		
            foreach($listaDetalle as $key=>$detalle)
            {
                //CONFIGURACIÓN DE LAS ACCIONES DEL ELEMENTO
                $acciones = "";
                $acciones .= "<div class='dropdown d-inline-block'>";
                
                $acciones .= "<a href='".$this->items['baseUrl']."/detalle-acta-devolucion/".$detalle['IDDevolucion']."/".$detalle['TokenFirmaDevolucion']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Detalle de Devolución' aria-label='Ver Detalle de Devolución'>
                    <i class='mdi mdi-file-sign align-bottom' style='font-size: 20px; color: #FFF;'></i>
                </a>";
                    
    			$acciones .= "</div>";
                
                $resultado['data'][$key] = array(
                    'id_devolucion'     => (string) $detalle['IDDevolucion'],
    				'fecha_devolucion'  => (string) date("d-m-Y", strtotime($detalle['FechaRegistroDevolucion'])),
    				'activo'            => (string) $detalle['TipoEquipo'],
                    'marca'             => (string) $detalle['Marca'],
    				'modelo'            => (string) $detalle['Modelo'],
    				'serie'             => (string) $detalle['Serie'],
    				'acciones'          => (string) $acciones
    			);
            }
            
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
        else 
		{
            $resultado['sesion'] = 0;
            
		    echo json_encode($resultado);
		}
    }
    
    
    
	public function dashboardMovil()
	{
    	if(isset($this->items['id'])){

			/* ACCIONES */
// 			$listaKitsDemo = $this->kitsDemo->listarKitsDemo('');
			
//             foreach($listaKitsDemo as $key=>$item)
//             {
//                 $asignado = $this->usuarios->where("IdUsuario ", $item['UsuarioAsignado'])->first();
//                 if(!empty($asignado))
//                 {
//                     $listaKitsDemo[$key]['NombreAsignado'] = strtoupper($asignado['Nombres'].' '.$asignado['Apellidos']);
//                     $listaKitsDemo[$key]['MatriculaAsignado'] = $asignado['Matricula'];
//                     $listaKitsDemo[$key]['EstadoAsignado'] = $asignado['Estado'] ;
//                 }
//                 else
//                 {
//                     $listaKitsDemo[$key]['UsuarioAsignado'] = "--";
//                     $listaKitsDemo[$key]['NombreAsignado'] = "--";
//                     $listaKitsDemo[$key]['MatriculaAsignado'] = "--";
//                     $listaKitsDemo[$key]['EstadoAsignado'] = "--";
//                 }
//             }

            $totalMoviles = $this->moviles->countAll();
            $bajaMovil = $this->moviles->where("Estado", "BAJ")->findAll();
            
            $cantidadesGenerales = array(
                "totalMovil"    => $totalMoviles,
                "bajaMovil"     => empty($bajaMovil) ? 0 : count($bajaMovil),
                "Pendientes"    => 0,
                "NoIniciados"   => 0
            );
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Dashboard Móviles | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Dashboard',
				'cantidadesGenerales'   => $cantidadesGenerales
			);
			$data = array_merge($data, $this->items);
			return view('dashboard/moviles',$data);			
		} else {
			return view('errors/500');
		}	
	}
	
	public function graficaMovilesDireccion()
	{
	    $listaMoviles = $this->moviles->listadoMoviles('');
	    $dataGrafica = array();

        foreach($listaMoviles as $key=>$value)
        {
            if($value['UsuarioAsignado'] != '' && $value['UsuarioAsignado'] != null)
            {
                $asignado = $this->usuarios->where("IdUsuario ", $value['UsuarioAsignado'])->first();
                $subarea = $this->estructuraSubareas->obtenerSubarea($asignado['IDSubarea']);
                
                if(isset($dataGrafica[$subarea['Direccion']]))
                {
                    $dataGrafica[$subarea['Direccion']] = $dataGrafica[$subarea['Direccion']] + 1;
                }
                else
                {
                    $dataGrafica[$subarea['Direccion']] = 1;
                }
            }
            
            // $listaMoviles[$key]['IDDireccion'] = $subarea['IDDireccion'];
            // $listaMoviles[$key]['Direccion'] = $subarea['Direccion'];
        }
        
        // Convertir a formato JSON e Imprimir el JSON
        
        echo json_encode($dataGrafica, JSON_PRETTY_PRINT);

        // var_dump($dataGrafica); exit;
	}
	
	public function graficaModeloMovilesDireccion()
	{
	    $listaMoviles = $this->moviles->listadoMoviles('');
	    $dataGrafica = array();
        $modelos = array(); // Para almacenar modelos únicos
        $direcciones = array(); // Para almacenar direcciones únicas

        foreach($listaMoviles as $key=>$value)
        {
            if($value['UsuarioAsignado'] != '' && $value['UsuarioAsignado'] != null)
            {
                $asignado = $this->usuarios->where("IdUsuario ", $value['UsuarioAsignado'])->first();
                $subarea = $this->estructuraSubareas->obtenerSubarea($asignado['IDSubarea']);
                $direccion = $subarea['Direccion'];
                $modelo = $value['Marca'].' '.$value['Modelo'];

                if (!isset($dataGrafica[$direccion]))
                {
                    $dataGrafica[$direccion] = array();
                    $direcciones[] = $direccion;
                }
                
                if (!isset($dataGrafica[$direccion][$modelo]))
                {
                    $dataGrafica[$direccion][$modelo] = 0;
                    $modelos[] = $modelo;
                }
    
                $dataGrafica[$direccion][$modelo]++;
            }
        }
        
        // Eliminar duplicados de modelos
        $modelos = array_unique($modelos);
        
        // Preparar datos para Chart.js
        $datasets = array();
        foreach ($modelos as $modelo) {
            $dataset = array(
                'label' => $modelo,
                'data' => array(),
                'borderWidth' => 1
            );
            foreach ($direcciones as $direccion) {
                $dataset['data'][] = isset($dataGrafica[$direccion][$modelo]) ? $dataGrafica[$direccion][$modelo] : 0;
            }
            $datasets[] = $dataset;
        }

        // Convertir a formato JSON
        $response = array(
            'labels' => $direcciones,
            'datasets' => $datasets
        );
        
        echo json_encode($response, JSON_PRETTY_PRINT);
	}
	
	public function graficaModeloMoviles()
	{
	    $listaMoviles = $this->moviles->listadoMoviles('');
        $dataGrafica = array();
        $modelos = array(); // Para almacenar modelos únicos
    
        foreach ($listaMoviles as $value)
        {
            if ($value['UsuarioAsignado'] != '' && $value['UsuarioAsignado'] != null)
            {
                $asignado = $this->usuarios->where("IdUsuario", $value['UsuarioAsignado'])->first();
                $subarea = $this->estructuraSubareas->obtenerSubarea($asignado['IDSubarea']);
                $modelo = $value['Marca'].' '.$value['Modelo'];
    
                if (!isset($dataGrafica[$modelo]))
                {
                    $dataGrafica[$modelo] = 0;
                    $modelos[] = $modelo;
                }
    
                $dataGrafica[$modelo]++;
            }
        }
    
        // Preparar datos para Chart.js
        $datasets = array(
            array(
                'label' => 'Cantidad de Móviles',
                'data' => array_values($dataGrafica),
                'borderWidth' => 1
            )
        );
    
        // Convertir a formato JSON
        $response = array(
            'labels' => array_keys($dataGrafica), // Modelos
            'datasets' => $datasets
        );
    // var_dump($response);
        echo json_encode($response, JSON_PRETTY_PRINT);
	}

}