<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Cargos extends BaseController
{
	public function __construct()
	{
	    $this->db = \Config\Database::connect();
	    
	    $this->estructuraSubareaDelegaciones    = new \App\Models\EstructuraSubareaDelegacionesModel();
	    
		$this->usuarios             = new \App\Models\UsuarioModel();
		$this->usuariosDelegaciones = new \App\Models\UsuarioDelegacionModel();
		
        $this->divisas              = new \App\Models\DivisasModel();
        
		$this->estructuraDirecciones    = new \App\Models\EstructuraDireccionModel();
		$this->estructuraAreas          = new \App\Models\EstructuraAreaModel();
		
        $this->legales                  = new \App\Models\LegalesModel();
        
		/* CONFIGURACIÓN */
		$this->elementosTrabajo             = new \App\Models\Configuracion\ElementosTrabajoModel();
		
		/* IT */
		$this->moviles                      = new \App\Models\IT\MovilesModel();
        $this->lineas                       = new \App\Models\IT\LineasModel();
        $this->contratos                    = new \App\Models\IT\LineasContratoModel();
        $this->hardware                     = new \App\Models\IT\HardwareModel();
        $this->tarjetasAcceso               = new \App\Models\IT\TarjetasAccesoModel();
        $this->accesorios                   = new \App\Models\IT\AccesoriosITModel();
        $this->accesoriosKardex             = new \App\Models\IT\AccesoriosITKardexModel();
        $this->accesoriosKardexDescargas    = new \App\Models\IT\AccesoriosITKardexDescargasModel();
		
		/* URES */
		$this->kitsDemo                     = new \App\Models\URES\KitsDemoModel();
		$this->kitsTrabajo                  = new \App\Models\URES\KitsTrabajoModel();
		$this->kitsTrabajoElementos         = new \App\Models\URES\KitsTrabajoElementosModel();
		
		/* CARGOS */
        $this->asignaciones                 = new \App\Models\Cargos\AsignacionesModel();
        $this->asignacionesDetalle          = new \App\Models\Cargos\AsignacionesDetalleModel();
        $this->asignacionesAdjuntos         = new \App\Models\Cargos\AsignacionesAdjuntosModel();
        $this->devoluciones                 = new \App\Models\Cargos\DevolucionesModel();
        $this->devolucionesDetalle          = new \App\Models\Cargos\DevolucionesDetalleModel();
        $this->devolucionesAdjuntos         = new \App\Models\Cargos\DevolucionesAdjuntosModel();
        $this->reposiciones                 = new \App\Models\Cargos\ReposicionesModel();
        $this->reposicionesDetalle          = new \App\Models\Cargos\ReposicionesDetalleModel();
        $this->reposicionesAdjuntos         = new \App\Models\Cargos\ReposicionesAdjuntosModel();
        $this->reposicionesCronogramaPago   = new \App\Models\Cargos\ReposicionesCronogramaPagoModel();
        
        $this->informeDevolucion            = new \App\Models\Cargos\InformeDevolucionModel();
        $this->informeDevolucionDetalle     = new \App\Models\Cargos\InformeDevolucionDetalleModel();
        $this->informeDevolucionDetalleEvaluacion   = new \App\Models\Cargos\InformeDevolucionDetalleEvaluacionModel();
        $this->informeDevolucionDetalleAdjuntos     = new \App\Models\Cargos\InformeDevolucionDetalleAdjuntosModel();
        
		/* CORREOS STATUS */
        $this->correoStatusAsignacion = new \App\Models\Cargos\CorreoStatusAsignacionModel();
        $this->correoStatusDevolucion = new \App\Models\Cargos\CorreoStatusDevolucionModel();
        $this->correoStatusReposicion = new \App\Models\Cargos\CorreoStatusReposicionModel();
	}

	/**************************************************************************/
	
    /****************************** ASIGNACIONES ******************************/
    
    public function listarAsignaciones()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Actas de Asignación | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Actas de asignación',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Actas de Asignación",
				'subtitulo'                 => 'Listado de Actas de Asignación'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('cargos/listar_asignaciones',$data);
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function actasAsignacionServerside()
	{
    	if (isset($this->items['id'])) 
    	{
            $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            if($this->items['idPerfil'] == 3)
    		{
    		  //  $userXdeleg = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
    		    $userXdeleg = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
    		    $idDelegaciones = array_column($userXdeleg, 'IDDelegacion');
    		    
    		    $adicionales['Delegaciones'] = $idDelegaciones;
    		}
            
    	    $dataServerside =  $this->asignaciones->listarAsignacionesServerside($this->request->getPost(), $adicionales);
    	    
    	    foreach($dataServerside["data"] as $key=>$value)
            {
                //CONFIGURACIÓN DE LA INFORMACIÓN "FECHA ASIGNADO"
                
                $fechaAsignado = date("d-m-Y", strtotime($value['FechaAsignado']));
                
                $dataServerside["data"][$key]['FechaAsignado'] = $fechaAsignado;
                
                //CONFIGURACIÓN DE LA INFORMACIÓN "FIRMA"
                $firma = "";
                
                if($value['FechaRegistroFirma']!='' && $value['FechaRegistroFirma']!=null)
                {
                    $firma .= "<span class='badge bg-success border-0'>".date("d-m-Y H:i:s", strtotime($value['FechaRegistroFirma']))."</span>";
                }
                else
                {
                    $firma .= "<span class='badge bg-danger border-0'>NO</span>";
                }
                
                $dataServerside["data"][$key]['Firma'] = $firma;
                
                //CONFIGURACIÓN DE LAS ACCIONES DEL ELEMENTO
                $acciones = "";
                $acciones .= "<div class='dropdown d-inline-block'>";
                
    			if (in_array("DETASI", $this->items['permisos'])) 
    			{
                    $acciones .= "<a href='".$this->items['baseUrl']."/detalle-acta-asignacion/".$value['IDAsignacion']."/".$value['TokenLinkFirma']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Detalle de Asignación' aria-label='Ver Detalle de Asignación'>
                        <i class='mdi mdi-file-sign align-bottom' style='font-size: 20px; color: #FFF;'></i>
                    </a>";
    			}
    			
    			$acciones .= "</div>";
                
                $dataServerside["data"][$key]['Acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'descripcion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
	}
	
    public function obtenerElementosAsignacion()
    {
        if (isset($this->items['id'])) 
        {
            /*
            * ----------------------
            * OBTIENE Y VALIDA DATOS
            * ----------------------
            */
            
            $post = $this->request->getPost('term');
            
            $elementos=array();
    
            if($post['elemento'] == 'MOVIL')
            {
                $listado = $this->moviles->listarMovilesDisponibles($post['term']);
    
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
                        'id' => (string) $items['IDMovil'],
                        'text' => (string) $items['IMEI']." | ".$items['Marca']." ".$items['Modelo']
                    );
                }
                
            }
            else if($post['elemento'] == 'LINEA')
            {
                $listado = $this->lineas->listarLineasDisponibles($post['term']);
    
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
                        'id' => (string) $items['IDLinea'],
                        'text' => (string) $items['Numero']." | ".$items['Operador']." ".$items['Plan']
                    );
                }
            }
            else if($post['elemento'] == 'TARJETA')
            {
                $listado = $this->tarjetasAcceso->listarTarjetasAccesoDisponibles($post['term']);
    
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
                        'id' => (string) $items['IDTarjetaAcceso'],
                        'text' => (string) $items['Serie']
                    );
                }
            }
            else if($post['elemento'] == 'HARDWARE')
            {
                $infoUsuario = $this->usuarios->buscarUsuario($post['usuario']);
                
                $listado = $this->hardware->listarHardwareDisponibles($post['term'], $infoUsuario['IDSubarea']);
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
                        'id' => (string) $items['IDHardware'],
                        'text' => (string) $items['Modelo'].' | '.$items['Serie'].' '.$items['nombre_subtipo'].' '.$items['nombre_tipo'].' '.$items['nombre_categoria']
                    );
                }
            }
            else if($post['elemento'] == 'ACCESORIOIT')
            {
                $listado = $this->accesorios->listarAccesorios("A");
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
                        'id' => (string) $items['IDAccesorio'],
                        'text' => (string) $items['Accesorio'].' | '.$items['Marca'].' '.$items['Modelo'].' '.$items['nombre_categoria'].' '.$items['nombre_tipo'].' '.$items['nombre_subtipo']
                    );
                }
            }
            else if($post['elemento'] == 'KITDEMO')
            {
                $demoAsignado = $this->kitsDemo->obtenerKitDemoAsignadoUsuario($post['usuario']);
                
                if(!empty($demoAsignado))
                {
                    foreach ($demoAsignado as $items) 
                    {
                        $elementos[] = array(
                            'id' => (string) $items['CodigoKitDemo'],
                            'text' => (string) $items['CodigoKitDemo']
                        );
                    }
                }
                else
                {
                    $listado = $this->kitsDemo->listarKitDemoDisponibles($post['term']);
                    foreach ($listado as $items) 
                    {
                        $elementos[] = array(
                            'id' => (string) $items['CodigoKitDemo'],
                            'text' => (string) $items['CodigoKitDemo']
                        );
                    }
                }
            }
            else if($post['elemento'] == 'ELEMENTOTRABAJO')
            {
                $where = array(
                    "like" => $post['term']
                );
                $listado = $this->elementosTrabajo->listarElementosTrabajo($where);
                
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
                        'id' => (string) $items['IDElementoTrabajo'],
                        'text' => (string) $items['Clasificacion'].' | '.$items['Nombre'].' '.$items['SKU']
                    );
                }
            }
            else if($post['elemento'] == 'KITTRABAJO')
            {
                $where = array(
                    "like" => $post['term']
                );
                $listado = $this->kitsTrabajo->listarkitsTrabajo($where);
                
                foreach ($listado as $items) 
                {
                    $elementos[] = array(
                        'id' => (string) $items['IDKitTrabajo'],
                        'text' => (string) $items['CategoriaKitTrabajo']
                    );
                }
            }
            
            
            /*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
            echo json_encode($elementos);
        }
        else 
    	{
            return "no hay sesión iniciada";
        }
    }
	
    public function obtenerElementoAsignar()
    {
        $idItem         = $this->request->getPost('itemElemento');
        $elemento       = $this->request->getPost('tipoElemento');
        $seleccionados  = json_decode($this->request->getPost('seleccionados'));
        
        $dataReposicion = array();
        
        if($elemento == "LINEA")
        {
            $informacionLinea = $this->lineas->obtenerLinea($idItem);
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionLinea['Operador']." - ".$informacionLinea['Numero'].' | '.$informacionLinea['ICCID'],
                "TOTAL"     => 1,
                "MONEDA"    => "PEN",
                "SIMBOLO"   => "S/",
                "PRECIOEDITABLE"    => false,
                "CANTIDADEDITABLE"  => false,
                "INFORMACION"   => $informacionLinea
            );
        }
        else if($elemento == "MOVIL")
        {
            $informacionMovil = $this->moviles->obtenerMovil($idItem);
            
            if($informacionMovil['EquipoStock'] == "N")
            {
                $contrato = $this->contratos->obtenerContratosXEquipo($idItem);
                $montoTotal = $this->veriactivos->calculoPenalidadMovil($contrato);
            }
            else
            {
                $montoTotal = $informacionMovil['PrecioLista'];
            }
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionMovil['Marca']." - ".$informacionMovil['Modelo'].' | '.$informacionMovil['IMEI'],
                "TOTAL"     => $montoTotal,
                "MONEDA"    => "PEN",
                "SIMBOLO"   => "S/",
                "PRECIOEDITABLE"    => false,
                "CANTIDADEDITABLE"  => false,
                "INFORMACION"   => $informacionMovil
            );
        }
        else if($elemento == "HARDWARE")
        {
            $informacionHardware = $this->hardware->obtenerHardware($idItem);
            
            if(!in_array($informacionHardware['FechaCompra'], array('', null, "0000-00-00")))
            {
                $listadoMonedas = $this->divisas->findAll();
                $montoTotal = $this->veriactivos->calculoReposicionHardware($informacionHardware, $listadoMonedas);
            }
            else
            {
                $montoTotal = $informacionHardware['PrecioCompra'];
            }
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionHardware['nombre_categoria']." - ".$informacionHardware['Modelo'].' | '.$informacionHardware['Serie'],
                "TOTAL"     => $montoTotal,
                "MONEDA"    => $informacionHardware['MonedaCompra'],
                "SIMBOLO"   => ($informacionHardware['MonedaCompra'] == 'USD' ? '$' : ($informacionHardware['MonedaCompra'] == 'EUR' ? '€' : 'S/')),
                "PRECIOEDITABLE"    => false,
                "CANTIDADEDITABLE"  => false,
                "INFORMACION"   => $informacionHardware
            );
        }
        else if($elemento == "ACCESORIOIT")
        {
            $informacionAccesorio = $this->accesorios->obtenerAccesorio($idItem);
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionAccesorio['Accesorio']." | ".$informacionAccesorio['Marca'].' - '.$informacionAccesorio['Modelo'].' | '.$informacionAccesorio['nombre_categoria'].' - '.$informacionAccesorio['nombre_tipo'].' - '.$informacionAccesorio['nombre_subtipo'],
                "TOTAL"     => isset($informacionAccesorio['ReposicionNuevo']) && !empty($informacionAccesorio['ReposicionNuevo']) && $informacionAccesorio['ReposicionNuevo'] != "0.00" ? $informacionAccesorio['ReposicionNuevo'] : "1",
                "MONEDA"    => "PEN",
                "SIMBOLO"   => "S/",
                "PRECIOEDITABLE"    => true,
                "CANTIDADEDITABLE"  => false,
                "INFORMACION"   => $informacionAccesorio
            );
        }
        else if($elemento == "TARJETA")
        {
            $informacionTarjeta = $this->tarjetasAcceso->where("IDTarjetaAcceso", $idItem)->first();
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionTarjeta['Serie'],
                "TOTAL"     => $informacionTarjeta['PrecioCompra'],
                "MONEDA"    => "PEN",
                "SIMBOLO"   => "S/",
                "PRECIOEDITABLE"    => false,
                "CANTIDADEDITABLE"  => false,
                "INFORMACION"   => $informacionTarjeta
            );
        }
        else if($elemento == "KITDEMO")
        {
            $informacionKit = $this->kitsDemo->listarKitDemoXCodigoKitXNoAsignado($idItem);
            
            if(!empty($informacionKit))
            {
                foreach($informacionKit as $item)
                {
                    $dataReposicion[] = array(
                        "ELEMENTO"  => $elemento,
                        "IDITEM"    => $item['IDItemKitDemo'],
                        "ITEM"      => $item['CodigoKitDemo'].' - '.$item['Nombre'].' | '.$item['SKU'],
                        "TOTAL"     => $item['PrecioReposicion'],
                        "MONEDA"    => $item['MonedaReposicion'] == '' || $item['MonedaReposicion'] == null ? 'PEN' : $item['MonedaReposicion'],
                        "SIMBOLO"   => ($item['MonedaReposicion'] == 'USD' ? '$' : ($item['MonedaReposicion'] == 'EUR' ? '€' : 'S/')),
                        "PRECIOEDITABLE"    => false,
                        "CANTIDADEDITABLE"  => false,
                        "INFORMACION"   => $item
                    );
                }
            }
        }
        else if($elemento == "ELEMENTOTRABAJO")
        {
            $informacionElemento = $this->elementosTrabajo->where("IDElementoTrabajo", $idItem)->first();
            
            $dataReposicion[] = array(
                "ELEMENTO"  => $elemento,
                "IDITEM"    => $idItem,
                "ITEM"      => $informacionElemento['Clasificacion']." | ".$informacionElemento['Nombre'].' '.$informacionElemento['SKU'],
                "TOTAL"     => $informacionElemento['PrecioReposicion'],
                "MONEDA"    => $informacionElemento['MonedaReposicion'] == '' || $informacionElemento['MonedaReposicion'] == null ? 'PEN' : $informacionElemento['MonedaReposicion'],
                "SIMBOLO"   => ($informacionElemento['MonedaReposicion'] == 'USD' ? '$' : ($informacionElemento['MonedaReposicion'] == 'EUR' ? '€' : 'S/')),
                "PRECIOEDITABLE"    => false,
                "CANTIDADEDITABLE"  => true,
                "INFORMACION"   => $informacionElemento
            );
        }
        else if($elemento == "KITTRABAJO")
        {
            $informacionKit = $this->kitsTrabajoElementos->listarElementosKitTrabajo($idItem);
            
            if(!empty($informacionKit))
            {
                foreach($informacionKit as $item)
                {
                    $dataReposicion[] = array(
                        "ELEMENTO"  => "ELEMENTOTRABAJO",
                        "IDITEM"    => $item['IDElementoTrabajo'],
                        "ITEM"      => $item['SKU']." | ".$item['Nombre'],
                        "TOTAL"     => $item['PrecioReposicion'],
                        "MONEDA"    => $item['MonedaReposicion'] == '' || $item['MonedaReposicion'] == null ? 'PEN' : $item['MonedaReposicion'],
                        "SIMBOLO"   => ($item['MonedaReposicion'] == 'USD' ? '$' : ($item['MonedaReposicion'] == 'EUR' ? '€' : 'S/')),
                        "PRECIOEDITABLE"    => false,
                        "CANTIDADEDITABLE"  => true,
                        "INFORMACION"   => $item
                    );
                }
            }
        }
        
	    $html = '';
	    
	    if(empty($dataReposicion))
	    {
            $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
	        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemasignar'.$aleatorio.'" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No se encontró información sobre el item seleccionado.
                    </div>
                </div>
        		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
        			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemasignar'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Asignar">
                        <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                    </button>
        		</div>
        	</div>';
	    }
	    else
	    {
    	    foreach($dataReposicion as $item)
    	    {
    	        if(!in_array($item['ELEMENTO'].'-'.$item['IDITEM'] , $seleccionados))
    	        {
                    $aleatorio = $this->complementos->generar_string_aleatorio(5);
                    
        	        if($item['ELEMENTO'] != "HARDWARE" || ($item['ELEMENTO'] == "HARDWARE" && !in_array($item['INFORMACION']['FechaCompra'], array('', null, "0000-00-00"))))
        	        {
            	        $html.='<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemasignar'.$aleatorio.'" style="border-radius: 10px;">
            	            <input type="hidden" name="item['.$aleatorio.']" value="'.$item['IDITEM'].'">
            	            <input type="hidden" name="itemAsignacion[]" value="'.$item['ELEMENTO'].'-'.$item['IDITEM'].'">
                    		<div class="col-xxl-6 col-md-12 col-12 mb-2">
                    			<div>
                    				<label class="form-label">Elemento:</label>
                    			    <input type="hidden" name="elemento['.$aleatorio.']" value="'.$item['ELEMENTO'].'">
                    				<input type="text" class="form-control" value="'.$item['ELEMENTO'].'" disabled>
                    			</div>
                    		</div>
                    		<div class="col-xxl-6 col-md-12 col-12 mb-2">
                    			<div>
                    				<label class="form-label">ITEM:</label>
                    				<input type="text" class="form-control" value="'.$item['ITEM'].'" disabled>
                    			</div>
                    		</div>';
                    		if($item['ELEMENTO'] == "HARDWARE")
                    		{
                    		    $html.='<div class="col-xxl-3 col-md-12 col-12 mb-2">
                        		    <label class="form-label">Fecha Compra</label>
                        			<div class="input-group">
                                        <span class="input-group-text mdi mdi-calendar-text-outline" style="font-size: 15px;"></span>
                                        <input type="date" class="form-control" value="'.(date("Y-m-d", strtotime($item['INFORMACION']['FechaCompra']))).'" style="pointer-events: none; background:#AAA; color:#F5F5F5;">
                                    </div>
                        		</div>
                        		<div class="col-xxl-3 col-md-12 col-12 mb-2">
                        		    <label class="form-label">Precio Compra</label>
                        			<div class="input-group">
                                        <span class="input-group-text">'.$item['SIMBOLO'].'</span>
                                        <input type="number" class="form-control" value="'.$item['INFORMACION']['PrecioCompra'].'" style="pointer-events: none; background:#AAA; color:#F5F5F5;">
                                    </div>
                        		</div>
                        		<div class="col-xxl-3 col-md-12 col-12 mb-2">
                        		    <label class="form-label">Costo Reposición</label>
                        			<div class="input-group">
                        			    <input type="hidden" name="moneda['.$aleatorio.']" value="PEN">
                                        <span class="input-group-text">S/</span>
                                        <input type="number" class="form-control" id="txtCostoReposicion'.$aleatorio.'" name="reposicion['.$aleatorio.']" step="0.01" min="1" value="'.$item['TOTAL'].'" '.($item['PRECIOEDITABLE'] === true ? '' : 'style="pointer-events: none; background:#AAA; color:#F5F5F5;"').'>
                                    </div>
                        		</div>
                        		
                        		<div class="col-xxl-3 col-md-12 col-12 mb-2">
                        		    <label class="form-label">Cantidad</label>
                        			<div class="input-group">
                                        <input type="number" class="form-control" id="txtCantidadEntregado'.$aleatorio.'" name="cantidad['.$aleatorio.']" step="1" min="1" max="5" value="1" '.($item['CANTIDADEDITABLE'] === true ? '' : 'style="pointer-events: none; background:#AAA; color:#F5F5F5;"').'>
                                    </div>
                        		</div>';
                    		}
                    		else
                    		{
                    		    $html.='<div class="col-xxl-6 col-md-12 col-12 mb-2">
                        		    <label class="form-label">Reposición</label>
                        			<div class="input-group">
                        			    <input type="hidden" name="moneda['.$aleatorio.']" value="'.$item['MONEDA'].'">
                                        <span class="input-group-text">'.$item['SIMBOLO'].'</span>
                                        <input type="number" class="form-control" id="txtCostoReposicion'.$aleatorio.'" name="reposicion['.$aleatorio.']" step="0.01" min="1" value="'.(($item['ELEMENTO'] == "ACCESORIOIT" && $item['INFORMACION']['CantidadTotal'] > 0) || $item['ELEMENTO'] != "ACCESORIOIT" ? $item['TOTAL'] : $item['INFORMACION']['ReposicionReutilizado'] ).'" '.($item['PRECIOEDITABLE'] === true ? '' : 'style="pointer-events: none; background:#AAA; color:#F5F5F5;"').'>
                                    </div>
                        		</div>
                        		<div class="col-xxl-6 col-md-12 col-12 mb-2">
                        		    <label class="form-label">Cantidad</label>
                        			<div class="input-group">
                                        <input type="number" class="form-control" id="txtCantidadEntregado'.$aleatorio.'" name="cantidad['.$aleatorio.']" step="1" min="1" max="5" value="1" '.($item['CANTIDADEDITABLE'] === true ? '' : 'style="pointer-events: none; background:#AAA; color:#F5F5F5;"').'>
                                    </div>
                        		</div>';
                    		}
                    		
                    		if($item['ELEMENTO'] == "ACCESORIOIT")
                    		{
                    		    $bloqueoNuevo = $item['INFORMACION']['CantidadTotal'] > 0 ? false : true;
                    		    
                        		$html.='<div class="col-xxl-12 col-md-12 col-12 ">
                        		    <div class="form-floating">
                                        <textarea class="form-control" id="detalle'.$aleatorio.'" name="obselemento['.$aleatorio.']" rows="3"></textarea>
                                        <label for="detalle'.$aleatorio.'">Detalle</label>
                                    </div>
                        		</div>
                        		<div class="col-5 py-2 d-flex justify-content-start align-items-center">
        							<div class="form-check form-switch form-switch-lg">
        								<input class="form-check-input form-check-input-orange precio-tipo-accesorio-asignacion" type="radio" role="switch" name="rdEstadoAccesorio['.$aleatorio.']" value="NUEVO" id="rbNuevoAccesorioIT'.$aleatorio.'" data-precio="'.(!empty($item['INFORMACION']['ReposicionNuevo']) && $item['INFORMACION']['ReposicionNuevo'] != "0.00" ? $item['INFORMACION']['ReposicionNuevo'] : "1").'" data-aleatorio="'.$aleatorio.'" '.($bloqueoNuevo == true ? "disabled" : "checked").'>
        								<label class="form-check-label" for="rbNuevoAccesorioIT'.$aleatorio.'">Nuevo</label>
        							</div>
        						</div>
                        		<div class="col-5 py-2 d-flex justify-content-start align-items-center">
        							<div class="form-check form-switch form-switch-lg">
        								<input class="form-check-input form-check-input-orange precio-tipo-accesorio-asignacion" type="radio" role="switch" name="rdEstadoAccesorio['.$aleatorio.']" value="REUTILIZADO" id="rbReutilizadoAccesorioIT'.$aleatorio.'" data-precio="'.(!empty($item['INFORMACION']['ReposicionReutilizado']) && $item['INFORMACION']['ReposicionReutilizado'] != "0.00" ? $item['INFORMACION']['ReposicionReutilizado'] : "1").'" data-aleatorio="'.$aleatorio.'" '.($bloqueoNuevo == true ? "checked" : "").'>
        								<label class="form-check-label" for="rbReutilizadoAccesorioIT'.$aleatorio.'">Reutilizado</label>
        							</div>
        						</div>';
                    		}
                    		else
                    		{
                    		    $html.='<div class="col-xxl-10 col-md-12 col-12 ">
                        		    <div class="form-floating">
                                        <textarea class="form-control" id="detalle'.$aleatorio.'" name="obselemento['.$aleatorio.']" rows="3"></textarea>
                                        <label for="detalle'.$aleatorio.'">Detalle</label>
                                    </div>
                        		</div>';
                    		}
                    		$html.='<div class="col-xxl-2 col-md-2 col-2 py-2 d-flex justify-content-end align-items-center">
                    			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemasignar'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Asignar">
                                    <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                                </button>
                    		</div>
                    	</div>';
        	        }
        	        else
        	        {
        	            $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemasignar'.$aleatorio.'" style="border-radius: 10px;">
            	            <div class="col-xxl-10 col-md-10 col-10 ">
                    	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                                    <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>HARDWARE SIN FECHA DE COMPRA</strong> - El hardware no tiene fecha de compra registrado. No se puede calcular el costo de reposición.
                                </div>
                            </div>
                    		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
                    			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemasignar'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Asignar">
                                    <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                                </button>
                    		</div>
                    	</div>';
        	        }
    	        }
    	    }
	    }
	    
	    echo $html;
    }

    public function guardarAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualKardex = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        // $asignado = $this->request->getPost('txtAsignado');
        $asignado = $this->request->getPost('txtUsuarioAsignacion');
        $fechaasignado = $this->request->getPost('txtFechaAsignado');
        $tipoasignado = $this->request->getPost('txtTipoAsignado');
        // $remitente = $this->request->getPost('txtRemitenteAsignacion');
        $remitente = $this->items['id'];
        $observacion = $this->request->getPost('txtObservacionAsignacion');
        
        $elementoDetalle = $this->request->getPost('elemento');
        $itemDetalle = $this->request->getPost('item');
        $observacionDetalle = $this->request->getPost('obselemento');
        $reposicionDetalle = $this->request->getPost('reposicion');
        $cantidadDetalle = $this->request->getPost('cantidad');
        $monedaDetalle = $this->request->getPost('moneda');
        $caracteristicaDetalle = $this->request->getPost('rdEstadoAccesorio');
        
        $remitente = ($remitente == '' || $remitente == null ? $this->items['id'] : $remitente );
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($asignado, 'required|trim', 'Usuario asignado');
        $error .= $this->complementos->validaCampo($fechaasignado, 'required|dateDos', 'Fecha de asignación');
        $error .= $this->complementos->validaCampo($tipoasignado, 'required|alphabet|trim', 'Tipo de asignación');
        $error .= $this->complementos->validaCampo($remitente, 'required|trim', 'Usuario remitente');
        
        if(empty($elementoDetalle) || empty($itemDetalle))
        {
            $error .= "<li>Debe registrar un item en la asignación.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
    
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($elementoDetalle as $key=>$detalle)
        {
            if($detalle != "ACCESORIOIT")
            {
                $itemAsignado = $this->asignacionesDetalle->validarElementoAsignado($detalle, $itemDetalle[$key]);
            
                if(count($itemAsignado)>0)
                {
                    $msgExistencia .= "<li>El ".$etiquetaitem[$key]." ya fue asignado.</li>";
                }
            }
            else
            {
                $accesorioIT = $this->accesorios->where("IDAccesorio", $itemDetalle[$key])->first();
                
                if($accesorioIT['CantidadTotal'] <= 0 && $caracteristicaDetalle[$key] == "NUEVO" )
                {
                    $msgExistencia .= "<li>El ".$etiquetaitem[$key]." no cuenta con existencias NUEVAS disponibles para asignar.</li>";
                }
            }
        }
        
        if (count(array_filter($cantidadDetalle, function($value) { return $value > 5; })) === 0) 
        {} 
        else 
        {
            $msgExistencia .= "<li>Hay elementos con cantidades mayores a 5. Por favor, reconsiderar la cantidad o contáctese con soporte IT.</li>";
        }
        
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
       */
        $datosAsignado = $this->usuarios->buscarUsuario($asignado);
        $tokenAsignacion = $this->complementos->generar_string_aleatorio(15);
        
        $textoLegal = '';
        
        $infolegales = $this->legales->buscarLegalXactaXelementos("ASIGNACIÓN", array_unique($elementoDetalle));
        
        if(!empty($infolegales))
        {
            foreach($infolegales as $key=>$value)
            {
                $textoLegal.=$value['Titulo'];
                $textoLegal.="\n";
                $textoLegal.=$value['Texto'];
                $textoLegal.="\n";
            }
        }
        // echo $textoLegal;exit;
        
        $dataAsignacion = array (
            'UsuarioAsignado'       => $asignado, 
            'CargoAsignado'         => $datosAsignado['Cargo'], 
            'DireccionAsignado'     => $datosAsignado['IDDireccion'], 
            'AreaAsignado'          => $datosAsignado['IDArea'], 
            'SubareaAsignado'       => $datosAsignado['IDSubarea'], 
            'DelegacionAsignado'    => $datosAsignado['IDDelegacion'], 
            'FechaAsignado'         => $fechaasignado, 
            'TipoAsignado'          => $tipoasignado, 
            'Observacion'           => $observacion, 
            'UsuarioRemitente'      => $remitente, 
            'CargoRemitente'        => $this->items['cargo'], 
            'DireccionRemitente'    => $this->items['dpto'], 
            'AreaRemitente'         => $this->items['idArea'], 
            'SubareaRemitente'      => $this->items['idSubarea'], 
            'DelegacionRemitente'   => $this->items['idDelegacionLog'], 
            'Legales'               => $textoLegal,
            'TokenLinkFirma'        => $tokenAsignacion,
            'LiberadoFirma'         => 'Y',
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
        
        if($lastIdAsignacion !== FALSE){
            $idAsignacion = $lastIdAsignacion;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la asignación. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        $dataDetalle = array();
        $dataKardexAccesoriosIT = array();
        $dataUpdateHardware = array();

        foreach($elementoDetalle as $key=>$detalle)
        {
            if($cantidadDetalle[$key] > 1)
            {
                for($i=0; $i < $cantidadDetalle[$key]; $i++ )
                {
                    $dataDetalle[] = array (
                        'IDAsignacion'      => $idAsignacion, 
                        'TipoElemento'      => $detalle,  
                        'IDElemento'        => $itemDetalle[$key], 
                        'Observacion'       => ($observacionDetalle[$key] != '' && $observacionDetalle[$key] != NULL ? $observacionDetalle[$key]."<br>CANTIDAD[".$cantidadDetalle[$key]."]" : "CANTIDAD[".$cantidadDetalle[$key]."]"), 
                        'MonedaReposicion'  => $monedaDetalle[$key], 
                        'MontoReposicion'   => $reposicionDetalle[$key],
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
                }
            }
            else
            {
                $dataDetalle[] = array (
                    'IDAsignacion'      => $idAsignacion, 
                    'TipoElemento'      => $detalle,  
                    'IDElemento'        => $itemDetalle[$key], 
                    'Observacion'       => $observacionDetalle[$key], 
                    'MonedaReposicion'  => $monedaDetalle[$key], 
                    'MontoReposicion'   => $reposicionDetalle[$key],
                    'UsuarioCrea'       => $this->items['id'],
                    'FechaCrea'         => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );
            }
            
            
            if($detalle == "ACCESORIOIT" && $caracteristicaDetalle[$key] == "NUEVO")
            {
                $fechaActualKardex = date("Y-m-d H:i:s", strtotime($fechaActualKardex)+1);
                
                $dataKardexAccesoriosIT[] = array (
                    'IDAccesorio'       => $itemDetalle[$key], 
                    'Concepto'          => "Acta de Asignación",
                    'Movimiento'        => "SAL",
                    'Cantidad'          => "1",
                    'IDUsuario'         => $asignado,
                    'IDDelegacion'      => $datosAsignado['IDDelegacion'],
                    'IDSubarea'         => $datosAsignado['IDSubarea'],
                    'IDArea'            => $datosAsignado['IDArea'],
                    'IDDireccion'       => $datosAsignado['IDDireccion'],
                    'IDCargo'           => $datosAsignado['IDCargo'],
                    'IDAsignacion'      => $idAsignacion,
                    'Observacion'       => "Elemento asignado via Acta de Asignación.", 
                    'UsuarioRegistra'   => $this->items['id'],
                    'FechaRegistra'     => $fechaActualKardex,    
                    'Localhost'         => $this->request->getIPAddress()
                );
            }
            
            if($detalle == "HARDWARE")
            {
                $dataUpdateHardware[] = array(
                    'IDHardware'        => $itemDetalle[$key],
                    'IDSubarea'         => $datosAsignado['IDSubarea'],
                    'UsuarioModifica'   => $this->items['id'],
                    'FechaModifica'     => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );
            }
        }
        
        $this->hardware->updateBatch($dataUpdateHardware, 'IDHardware');
        
        $lastId = $this->asignacionesDetalle->insertBatch($dataDetalle);
        
        if(!empty($dataKardexAccesoriosIT))
        {
            $lastIdKardex = $this->accesoriosKardex->insertBatch($dataKardexAccesoriosIT);
        }
        
		if($lastId !== FALSE){
            
            /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO
            * ----------------------------
            */

            $arrayCuerpo = array(
                "TITULO" => "ACTA DE ASIGNACIÓN",
                "ACTA" => "ACTA DE ASIGNACIÓN",
                "USUARIO" => ucwords(mb_strtolower($datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'])),
                "URL_ACTA" => base_url()."/acta-asignacion/".$idAsignacion."/".$tokenAsignacion,
                'baseUrl'       => $this->items['baseUrl'],
                'basePublic'    => $this->items['basePublic'],
                'baseDinamic'   => $this->items['baseDinamic']
            );

            $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */

            $asunto='ACTA DE ASIGNACIÓN: '.$idAsignacion.' - '.$datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'];
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => $this->items['correoElectronico'],
                "CORREOS_DESTINOS" => array($datosAsignado['Correo']),
                "CORREOS_COPIA" => array("soporteit@verisure.pe", $this->items['correoElectronico']),
                "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                // "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
                // "CORREOS_COPIA" => array(),
                // "CORREOS_OCULTO" => array(),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );

            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

            $dataCorreo = array(
                "IDAsignacion"  => $idAsignacion,
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );

            $this->correoStatusAsignacion->insert($dataCorreo, TRUE);
            
			$message = sprintf($this->mensajeError->msg502, $idAsignacion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->reDireccion(base_url()."/documento-asignado/".$idAsignacion, 1);
		} 
    }
    
    public function importarCSVAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        $fechaActualKardex = date("Y-m-d H:i:s");
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("fileCSVAsignacion");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileCSVAsignacion' => [
                'mime_in[fileCSVAsignacion,text/csv,text/plain]',
                'ext_in[fileCSVAsignacion,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 9);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $arrayElementos = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        $arrayCantidadesNuevosAccesorios = array();

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $tipo           = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $referencia     = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $usuario        = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $situacion      = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                
                if($tipo == "ACCESORIOIT" && $situacion == '')
                {
                    $filasError[$fila]['SITUACION'] = "PARA LOS ACCESORIOS ES REQUERIDO COLOCAR SITUACIÓN ['NUEVO', 'REUTILIZADO']";
                    $ejecutarInsert = false;
                }
                else if($tipo == "ACCESORIOIT" && $situacion != '')
                {
                    if($situacion != "NUEVO" && $situacion != "REUTILIZADO")
                    {
                        $filasError[$fila]['SITUACION'] = "SITUACION SOLO ACEPTA LOS SIGUIENTES VALORES ['NUEVO', 'REUTILIZADO']";
                        $ejecutarInsert = false;
                    }
                }

                //Validamos usuario correcto:
                if($usuario != '' && $usuario != null)
                {
                    $datosUsuario = $this->usuarios->buscarUsuarioXusuario($usuario);

                    if(empty($datosUsuario))
                    {
                        $filasError[$fila]['USUARIO'] = "USUARIO NO VÁLIDO: ".$usuario;
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        if($datosUsuario['Cargo'] == '' || $datosUsuario['Cargo'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE EL CARGO/PUESTO ACTUALIZADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDArea'] == '' || $datosUsuario['IDArea'] == null)
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE EL ÁREA DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDireccion'] == '' || $datosUsuario['IDDireccion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE LA DIRECCIÓN DEPARTAMENTAL ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['IDDelegacion'] == '' || $datosUsuario['IDDelegacion'] == null )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO NO TIENE LA DELEGACIÓN ACTUALIZADA: ".$usuario;
                            $ejecutarInsert = false;
                        }
                        
                        if($datosUsuario['Estado'] == 'Cesado' )
                        {
                            $filasError[$fila]['USUARIO'] = "EL USUARIO SE ENCUENTRA CESADO: ".$usuario;
                            $ejecutarInsert = false;
                        }
                    }
                }
                else
                {
                        $filasError[$fila]['USUARIO'] = "CAMPO USUARIO NO PUEDE ESTAR VACIO";
                        $ejecutarInsert = false;
                        $datosUsuario=array();
                }
                
                if($tipo == 'LINEA')
                {
                    $disponible = $this->lineas->listarLineasDisponibles($referencia);
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                    //Validamos existencia de Linea:
                    $datosLinea = $this->lineas->where("Numero",trim($referencia))->first();
                    if(empty($datosLinea))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                else if($tipo == 'MOVIL')
                {
                    $disponible = $this->moviles->listarMovilesDisponibles($referencia);
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                    //Validamos existencia de IMEI:
                    $datosImei = $this->moviles->where('IMEI', trim($referencia))->first();
                    if(empty($datosImei))
                    {
                        $filasError[$fila]['REFERENCIA'] = "IMEI NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                else if($tipo == 'HARDWARE')
                {
                    $disponible = $this->hardware->listarHardwareDisponibles($referencia,(empty($datosUsuario)?'':$datosUsuario['IDSubarea']));
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO O RESERVADO";
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        $arrayHardware = array(
                            'Serie' => $referencia
                        );
                        
                        $dataHardware = $this->hardware->obtenerHardwareXValores($arrayHardware);
                        
                        if(empty($dataHardware))
                        {
                            $filasError[$fila]['REFERENCIA'] = "NO SE ENCONTRÓ INFORMACIÓN DEL HARDWARE SOLICITADO.";
                            $ejecutarInsert = false;
                        }
                        
                        if(in_array($dataHardware['FechaCompra'], array('', null, "0000-00-00")))
                        {
                            $filasError[$fila]['REFERENCIA'] = "EL HARDWARE NO TIENE FECHA DE COMPRA PARA CALCULAR EL MONTO DE REPOSICIÓN. NO SE PUEDE ASIGNAR.";
                            $ejecutarInsert = false;
                        }
                    }
                }
                else if($tipo == 'TARJETA')
                {
                    $disponible = $this->tarjetasAcceso->listarTarjetasAccesoDisponibles($referencia);
                    
                    if(empty($disponible))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ELEMENTO SE ENCUENTRA ASIGNADO";
                        $ejecutarInsert = false;
                    }
                }
                else if($tipo == 'ACCESORIOIT')
                {
                    $where = array(
                        'Accesorio' => $referencia
                    );
                    
                    $existe = $this->accesorios->where($where)->first();
                    
                    if(empty($existe))
                    {
                        $filasError[$fila]['REFERENCIA'] = "ACCESORIO IT NO EXISTE";
                        $ejecutarInsert = false;
                    }
                    
                    if($situacion == 'NUEVO' && $existe['CantidadTotal'] <= 0)
                    {
                        $filasError[$fila]['REFERENCIA'] = "ACCESORIO IT NO CUENTA CON EXISTENCIAS NUEVAS PARA SER ASIGNADO.";
                        $ejecutarInsert = false;
                    }
                    
                    if($situacion == 'NUEVO')
                    {
                        if(!isset($arrayCantidadesNuevosAccesorios[$referencia]))
                        {
                            $arrayCantidadesNuevosAccesorios[$referencia] = 1;
                        }
                        else
                        {
                            $arrayCantidadesNuevosAccesorios[$referencia] = $arrayCantidadesNuevosAccesorios[$referencia]++;
                        }
                    }
                    
                }
                else if($tipo == 'MALETÍN DE HERRAMIENTA' || $tipo == 'VESTIMENTA')
                {
                    $where = array(
                        'SKU' => $referencia
                    );
                    
                    $existe = $this->elementosTrabajo->where($where)->first();
                    
                    if(empty($existe))
                    {
                        $filasError[$fila]['REFERENCIA'] = $tipo." NO EXISTE";
                        $ejecutarInsert = false;
                    }
                }
                else if($tipo == 'KITDEMO')
                {
                    if($usuario != '' && $usuario != null)
                    {
                        $whereKitDemo = array(
                	        'CodigoKitDemo' => $referencia
                	    );
                	    
                	    $existenciaKitDemo = $this->kitsDemo->where($whereKitDemo)->countAllResults();
                	    
                	    if(!($existenciaKitDemo > 0))
                	    {
                	        $filasError[$fila]['REFERENCIA'] = "KIT DEMO ".$referencia." NO EXISTE";
                            $ejecutarInsert = false;
                	    }
                	    
                	    //Valido asociación de kit demo con el usuario
                	    //**USUARIO***/
                		$whereUsuario = array (
                			'Usuario' => $usuario,
                			'Estado'  => "Activo"
                		);
                		
                        $datosUsuario = $this->usuarios->where($whereUsuario)->first();
                
                        if(!empty($datosUsuario))
                        {
                            $demoAsignado = $this->kitsDemo->obtenerKitDemoAsignadoUsuario($datosUsuario['IdUsuario']);
                            
                            if(empty($demoAsignado))
                            {
                                //Valido si kit está libre para asignar
                                $disponible = $this->kitsDemo->listarKitDemoDisponibles($referencia);
                                
                                if(empty($disponible))
                                {
                                    $filasError[$fila]['REFERENCIA'] = "KIT DEMO YA ASIGNADO";
                                    $ejecutarInsert = false;
                                }
                            }
                            else
                            {
                                $filasError[$fila]['REFERENCIA'] = "KIT DEMO NO ESTÁ ASOCIADO AL USUARIO A ASIGNAR";
                                $ejecutarInsert = false;
                            }
                            
                        }
                        else
                        {
                            $filasError[$fila]['USUARIO'] = "USUARIO NO VÁLIDO PARA ASIGNAR KIT DEMO";
                            $ejecutarInsert = false;
                        }
                        
                    }
                    
                }
                else
                {
                    $filasError[$fila]['TIPO'] = "TIPO NO DECLARADO";
                    $ejecutarInsert = false;
                }
                
                if($tipo != "ACCESORIOIT" && $tipo != 'MALETÍN DE HERRAMIENTA' && $tipo != 'VESTIMENTA')
                {
                    //Validamos repetición de elementos
                    $filaRepetida = array_search($referencia, $arrayElementos);
                    if($filaRepetida !== FALSE)
                    {
                        $filasError[$fila]['REFERENCIA'] = "VALOR REPETIDO-FILA ".$filaRepetida;
                        $ejecutarInsert = false;
                    }
                }
                
                $arrayElementos[$fila] = $referencia;
                
            }
        }

        fclose($handle);
        
        foreach($arrayCantidadesNuevosAccesorios as $accesorio => $cantidad)
        {
            $where = array(
                'Accesorio' => $accesorio
            );
            
            $existe = $this->accesorios->where($where)->first();
            
            if($existe['CantidadTotal'] < $cantidad)
            {
                $filasError[$accesorio]['CANTIDAD-NUEVO'] = "NO HAY EXISTENCIAS SUFICIENTES PARA ASIGNAR DEL ACCESORIO SELECCIONADO.";
                $ejecutarInsert = false;
            }
            
        }
        
        if(!$ejecutarInsert)
        {
            $raiz = $this->items['basePublic'].'/';
            $nombre = 'error.txt';
            $file = $this->items['basePublic'].'/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayAsignacionInsert = array();
        $arrayAsignacionDetalleInsert = array();
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");
        $arrayAsig = array();
        $arrayDetalleAsig = array();
        
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                $a = trim($data[3]);
                //Asignamos valores de CSV a variables locales
                $tipo = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $referencia = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                $usuario = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                $tipoAsignado = trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                $obsAsignado = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
                $fechaAsignado = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
                $obsElemento = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
                $cantidadElemento = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
                $situacionElemento = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
                
                $detectaFormatoFA = strpos($fechaAsignado, "/");
                    
                if($detectaFormatoFA === false)
                {
                    $fechaAsignado = date("Y-m-d", strtotime($fechaAsignado));
                }
                else
                {
                    $fechaAsignado_e = $this->complementos->myUrlEncode($fechaAsignado);
                    $fechaAsignado = date('Y-m-d', strtotime(str_replace('/', '-', $fechaAsignado_e)));
                }
                    
                if(!array_key_exists($usuario, $arrayAsig)) 
                {
                    $arrayAsig[$usuario][$fechaAsignado] = array(
                        "TIPO"          => $tipoAsignado,
                        "OBSERVACION"   => $obsAsignado);
                }
                else
                {
                    if(!array_key_exists($fechaAsignado, $arrayAsig[$usuario])) 
                    {
                        $arrayAsig[$usuario][$fechaAsignado] = array(
                            "TIPO"          => $tipoAsignado,
                            "OBSERVACION"   => $obsAsignado);
                    }
                }
                
                $arrayDetalleAsig[$usuario][$fechaAsignado][] = array(
                    "TIPOELEMENTO"  => $tipo,
                    "ELEMENTO"      => $referencia,
                    "OBSERVACION"   => $obsElemento,
                    "CANTIDAD"      => $cantidadElemento,
                    "SITUACION"     => $situacionElemento);
            }
        }

        fclose($handleInsert);
        
        $arrayInsertAsign=array();
        
        foreach($arrayAsig as $usuario => $valor)
        {
            $dataKardexAccesoriosIT = array();
        
            foreach($valor as $fechaAsignacion => $value)
            {
        
                $textoLegal = '';
                
                $tiposElementoCSV = array_column($arrayDetalleAsig[$usuario][$fechaAsignacion], "TIPOELEMENTO");
                $tiposElementoCSV = str_replace("VESTIMENTA", "ELEMENTOTRABAJO", $tiposElementoCSV);
                $tiposElementoCSV = str_replace("MALETÍN DE HERRAMIENTA", "ELEMENTOTRABAJO", $tiposElementoCSV);
                
                // $infolegales = $this->legales->buscarLegalXactaXelementos("ASIGNACIÓN", array("TARJETA"));
                $infolegales = $this->legales->buscarLegalXactaXelementos("ASIGNACIÓN", array_unique($tiposElementoCSV));
                
                if(!empty($infolegales))
                {
                    foreach($infolegales as $key=>$legalesinfo)
                    {
                        $textoLegal.=$legalesinfo['Titulo'];
                        $textoLegal.="\n";
                        $textoLegal.=$legalesinfo['Texto'];
                        $textoLegal.="\n";
                    }
                }
                
                $datosAsignado = $this->usuarios->buscarUsuarioXusuario($usuario);
                $tokenAsignacion = $this->complementos->generar_string_aleatorio(15);
                
                $dataAsignacion = array (
                    'UsuarioAsignado'       => $datosAsignado['IdUsuario'], 
                    'CargoAsignado'         => $datosAsignado['Cargo'], 
                    'DireccionAsignado'     => $datosAsignado['IDDireccion'], 
                    'AreaAsignado'          => $datosAsignado['IDArea'], 
                    'SubareaAsignado'       => $datosAsignado['IDSubarea'], 
                    'DelegacionAsignado'    => $datosAsignado['IDDelegacion'],
                    'FechaAsignado'         => $fechaAsignacion, 
                    'TipoAsignado'          => $value['TIPO'], 
                    'Observacion'           => $value['OBSERVACION'], 
                    'UsuarioRemitente'      => $this->items['id'], 
                    'CargoRemitente'        => $this->items['cargo'],  
                    'DireccionRemitente'    => $this->items['dpto'], 
                    'AreaRemitente'         => $this->items['idArea'], 
                    'SubareaRemitente'      => $this->items['idSubarea'], 
                    'DelegacionRemitente'   => $this->items['idDelegacionLog'], 
                    'Legales'               => $textoLegal,
                    'TokenLinkFirma'        => $tokenAsignacion,
                    'LiberadoFirma'         => 'Y',
                    'UsuarioCrea'           => $this->items['id'],
                    'FechaCrea'             => $fechaActual,    
                    'Localhost'             => $this->request->getIPAddress()
                );
                
                $lastIdAsignacion = $this->asignaciones->insert($dataAsignacion, TRUE);
                // $lastIdAsignacion = "999999999999999999999999";
                if($lastIdAsignacion !== FALSE){
                    $arrayInsertAsign[] = $lastIdAsignacion;
                    $dataDetalle = array();
                    
                    foreach($arrayDetalleAsig[$usuario][$fechaAsignacion] as $detalle)
                    {
                        $totalReposicion = 0;
            
                        if($detalle['TIPOELEMENTO'] == "LINEA")
                        {
                            $infolinea = $this->lineas->where("Numero", trim($detalle['ELEMENTO']))->first();
                            $elemento = $infolinea['IDLinea'];
                            $monedaReposicion = "PEN";
                            $totalReposicion = 1;
                            
                            $dataDetalle[] = array (
                                'IDAsignacion'      => $lastIdAsignacion, 
                                'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                                'IDElemento'        => $elemento, 
                                'Observacion'       => $detalle['OBSERVACION'],  
                                'MonedaReposicion'  => $monedaReposicion,
                                'MontoReposicion'   => $totalReposicion, 
                                'UsuarioCrea'       => $this->items['id'],
                                'FechaCrea'         => $fechaActual,    
                                'Localhost'         => $this->request->getIPAddress()
                            );
                        }
                        else if($detalle['TIPOELEMENTO'] == "MOVIL")
                        {
                            $infomovil = $this->moviles->where('IMEI', trim($detalle['ELEMENTO']))->first();
                            $elemento = $infomovil['IDMovil'];
                            $contrato = $this->contratos->obtenerContratosXEquipo($infomovil['IDMovil']);
                            $monedaReposicion = "PEN"; //NO EXISTIA, AGREGADO IDTarjetaAcceso SERIE 18.08.2024 11:44
                            $montoTotal = $this->veriactivos->calculoPenalidadMovil($contrato);
                
                            $totalReposicion = $montoTotal;
                            
                            $dataDetalle[] = array (
                                'IDAsignacion'      => $lastIdAsignacion, 
                                'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                                'IDElemento'        => $elemento, 
                                'Observacion'       => $detalle['OBSERVACION'],  
                                'MonedaReposicion'  => $monedaReposicion,
                                'MontoReposicion'   => $totalReposicion, 
                                'UsuarioCrea'       => $this->items['id'],
                                'FechaCrea'         => $fechaActual,    
                                'Localhost'         => $this->request->getIPAddress()
                            );
                        }
                        else if($detalle['TIPOELEMENTO'] == "HARDWARE")
                        {
                            $listadoMonedas = $this->divisas->findAll();
                            
                            // $infohardware = $this->hardware->where("Hostname", trim($detalle['ELEMENTO']))->first(); //CODIGO ENCONTRADO PASO A CORREGIR HOSTNAME A SERIE 18.08.2024 11:41
                            $infohardware = $this->hardware->where("Serie", trim($detalle['ELEMENTO']))->first();
                            $elemento = $infohardware['IDHardware'];  //NO EXISTIA, AGREGADO IDHardware SERIE 18.08.2024 11:44
                            
                            // $monedaReposicion = $infohardware['MonedaCompra']; //NO EXISTIA, AGREGADO IDTarjetaAcceso SERIE 18.08.2024 11:44
                            // $totalReposicion = $infohardware['PrecioCompra'];
                            
                            $monedaReposicion   = "PEN";
                            $totalReposicion    = $this->veriactivos->calculoReposicionHardware($infohardware, $listadoMonedas);
                            
                            $dataDetalle[] = array (
                                'IDAsignacion'      => $lastIdAsignacion, 
                                'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                                'IDElemento'        => $elemento, 
                                'Observacion'       => $detalle['OBSERVACION'],  
                                'MonedaReposicion'  => $monedaReposicion,
                                'MontoReposicion'   => $totalReposicion, 
                                'UsuarioCrea'       => $this->items['id'],
                                'FechaCrea'         => $fechaActual,    
                                'Localhost'         => $this->request->getIPAddress()
                            );
                        }
                        else if($detalle['TIPOELEMENTO'] == "TARJETA")
                        {
                            $infotarjeta = $this->tarjetasAcceso->where("Serie", trim($detalle['ELEMENTO']))->first();
                            $elemento = $infotarjeta['IDTarjetaAcceso'];  //NO EXISTIA, AGREGADO IDTarjetaAcceso SERIE 18.08.2024 11:44
                            $monedaReposicion = "PEN"; //NO EXISTIA, AGREGADO IDTarjetaAcceso SERIE 18.08.2024 11:44
                            $totalReposicion = $infotarjeta['PrecioCompra'];
                            
                            $dataDetalle[] = array (
                                'IDAsignacion'      => $lastIdAsignacion, 
                                'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                                'IDElemento'        => $elemento, 
                                'Observacion'       => $detalle['OBSERVACION'],  
                                'MonedaReposicion'  => $monedaReposicion,
                                'MontoReposicion'   => $totalReposicion, 
                                'UsuarioCrea'       => $this->items['id'],
                                'FechaCrea'         => $fechaActual,    
                                'Localhost'         => $this->request->getIPAddress()
                            );
                        }
                        else if($detalle['TIPOELEMENTO'] == "ACCESORIOIT")
                        {
                            $infoaccesorio = $this->accesorios->where("Accesorio", $detalle['ELEMENTO'])->first();
                            $elemento = $infoaccesorio['IDAccesorio'];  //NO EXISTIA, AGREGADO IDTarjetaAcceso SERIE 18.08.2024 11:44
                            $monedaReposicion = "PEN"; //NO EXISTIA, AGREGADO IDTarjetaAcceso SERIE 18.08.2024 11:44
                            
                            if($detalle['SITUACION'] === "NUEVO")
                            {
                                $totalReposicion = $infoaccesorio['ReposicionNuevo'];
                                
                                $fechaActualKardex = date("Y-m-d H:i:s", strtotime($fechaActualKardex)+1);
                
                                $dataKardexAccesoriosIT[] = array (
                                    'IDAccesorio'       => $infoaccesorio['IDAccesorio'], 
                                    'Concepto'          => "Acta de Asignación",
                                    'Movimiento'        => "SAL",
                                    'Cantidad'          => "1",
                                    'IDUsuario'         => $datosAsignado['IdUsuario'],
                                    'IDDelegacion'      => $datosAsignado['IDDelegacion'],
                                    'IDSubarea'         => $datosAsignado['IDSubarea'],
                                    'IDArea'            => $datosAsignado['IDArea'],
                                    'IDDireccion'       => $datosAsignado['IDDireccion'],
                                    'IDCargo'           => $datosAsignado['IDCargo'],
                                    'IDAsignacion'      => $lastIdAsignacion,
                                    'Observacion'       => "Elemento asignado via Acta de Asignación Masiva.", 
                                    'UsuarioRegistra'   => $this->items['id'],
                                    'FechaRegistra'     => $fechaActualKardex,    
                                    'Localhost'         => $this->request->getIPAddress()
                                );
                            }
                            else
                            {
                                $totalReposicion = $infoaccesorio['ReposicionReutilizado'];
                            }
                            
                            $dataDetalle[] = array (
                                'IDAsignacion'      => $lastIdAsignacion, 
                                'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                                'IDElemento'        => $elemento, 
                                'Observacion'       => $detalle['OBSERVACION'],  
                                'MonedaReposicion'  => $monedaReposicion,
                                'MontoReposicion'   => $totalReposicion, 
                                'UsuarioCrea'       => $this->items['id'],
                                'FechaCrea'         => $fechaActual,    
                                'Localhost'         => $this->request->getIPAddress()
                            );
                        }
                        else if($detalle['TIPOELEMENTO'] == 'MALETÍN DE HERRAMIENTA' || $detalle['TIPOELEMENTO'] == 'VESTIMENTA')
                        {
                            $where = array(
                                'SKU' => $detalle['ELEMENTO']
                            );
                            
                            $infoelemento = $this->elementosTrabajo->where($where)->first();
                            $elemento = $infoelemento['IDElementoTrabajo'];
                            $monedaReposicion = $infoelemento["MonedaReposicion"];
                            $totalReposicion = $infoelemento['PrecioReposicion'];
                            
                            for($i=0; $i < $detalle['CANTIDAD']; $i++ )
                            {
                                $dataDetalle[] = array (
                                    'IDAsignacion'      => $lastIdAsignacion, 
                                    'TipoElemento'      => "ELEMENTOTRABAJO",  
                                    'IDElemento'        => $elemento, 
                                    'Observacion'       => ($detalle['OBSERVACION'] != '' && $detalle['OBSERVACION'] != NULL ?  $detalle['OBSERVACION']."<br>CANTIDAD[".$detalle['CANTIDAD']."]" : "CANTIDAD[".$detalle['CANTIDAD']."]"),  
                                    'MonedaReposicion'  => $monedaReposicion,
                                    'MontoReposicion'   => $totalReposicion, 
                                    'UsuarioCrea'       => $this->items['id'],
                                    'FechaCrea'         => $fechaActual,    
                                    'Localhost'         => $this->request->getIPAddress()
                                );
                            }
                            
                        }
                        else if($detalle['TIPOELEMENTO'] == "KITDEMO")
                        {
                            $informacionKit = $this->kitsDemo->listarKitDemoXCodigoKitXNoAsignado($detalle['ELEMENTO']);
            
                            if(!empty($informacionKit))
                            {
                                foreach($informacionKit as $item)
                                {
                                    $dataDetalle[] = array (
                                        'IDAsignacion'      => $lastIdAsignacion, 
                                        'TipoElemento'      => $detalle['TIPOELEMENTO'],  
                                        'IDElemento'        => $item['IDItemKitDemo'], 
                                        'Observacion'       => $detalle['OBSERVACION'],  
                                        'MonedaReposicion'  => $item['MonedaReposicion'], 
                                        'MontoReposicion'   => $item['PrecioReposicion'], 
                                        'UsuarioCrea'       => $this->items['id'],
                                        'FechaCrea'         => $fechaActual,    
                                        'Localhost'         => $this->request->getIPAddress()
                                    );
                                }
                            }
                        }
                    }
                    
                    $lastId = $this->asignacionesDetalle->insertBatch($dataDetalle);
                    
            		if($lastId !== FALSE){
                        
                        if(!empty($dataKardexAccesoriosIT))
                        {
                            $lastIdKardex = $this->accesoriosKardex->insertBatch($dataKardexAccesoriosIT);
                        }
                        
                        /*
                        * ----------------------------
                        * PREPARACIÓN DE CUERPO DE CORREO
                        * ----------------------------
                        */
            
                        $arrayCuerpo = array(
                            "TITULO" => "ACTA DE ASIGNACIÓN",
                            "ACTA" => "ACTA DE ASIGNACIÓN",
                            "USUARIO" => ucwords(mb_strtolower($datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'])),
                            "URL_ACTA" => base_url()."/acta-asignacion/".$lastIdAsignacion."/".$tokenAsignacion,
                            'baseUrl'       => $this->items['baseUrl'],
                            'basePublic'    => $this->items['basePublic'],
                            'baseDinamic'   => $this->items['baseDinamic']
                        );
            
                        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
                        
                        /*
                        * ----------------------------
                        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                        * ----------------------------
                        */
                        
                        $asunto='ACTA DE ASIGNACIÓN: '.$lastIdAsignacion.' - '.$datosAsignado['Nombres'].' '.$datosAsignado['Apellidos'];
                        //$correoDestino = array($asignado['Correo']);
                        $configCorreo = array(
                            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                            "CORREO_ORIGEN" => $this->items['correoElectronico'],
                            // "CORREOS_DESTINOS" => array("soporteit@verisure.pe"),
                            // "CORREOS_COPIA" => array(),
                            // "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                            "CORREOS_DESTINOS" => array($datosAsignado['Correo']),
                            "CORREOS_COPIA" => array("soporteit@verisure.pe", $this->items['correoElectronico']),
                            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                            "ASUNTO" => $asunto,
                            "MENSAJE" => $cuerpo
                        );
            
                        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
            
                        $dataCorreo = array(
                            "IDAsignacion"  => $lastIdAsignacion,
                            "Response"      => $estadoCorreo['RESPUESTA'],
                            "Error"         => $estadoCorreo['ERROR'],
                            'UsuarioCrea'   => $this->items['id'],
                            'FechaCrea'     => $fechaActual,    
                            'Localhost'     => $this->request->getIPAddress()
                        );
            
                        $this->correoStatusAsignacion->insert($dataCorreo, TRUE);
                        
            		}
            		else
                    {
                        $this->asignacionesDetalle->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                        $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                        $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la asignación. Inténtelo luego.</li>");
                        echo $this->alertas->alertaError($message);
                        EXIT;
                    }
                }
                else
                {
                    $this->asignacionesDetalle->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $this->asignaciones->whereIn('IDAsignacion', $arrayInsertAsign)->delete();
                    $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la asignación. Inténtelo luego.</li>");
                    echo $this->alertas->alertaError($message);
                    EXIT;
                }
            }    
        }

        $message = sprintf($this->mensajeError->msg201, "Se insertaron el total de ".count($arrayAsig)." asignaciones.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
	/***/
    
    public function detalleActaAsignacion($idAsignacion, $token)
    {
        if(isset($this->items['id']))
        {
			// ACCIONES
			$whereAsignacion = array(
			    'IDAsignacion'  => $idAsignacion
			);
			
            $asignacion = $this->asignaciones->obtenerInformacionActaAsignacion($whereAsignacion);
            
            if($token == $asignacion['TokenLinkFirma'] )
            {
                $listaAdjunto = $this->asignacionesAdjuntos->where("IDAsignacion", $idAsignacion)->findAll();
                $pdfActaAsignacion = $this->PDFActaAsignacion($idAsignacion, $asignacion['TokenLinkFirma'], 'html');
                
    			$data = array (
    				'session'               => 'on',
    				'titulo'                => 'Detalle de Asignación | Verisure',
    				'breadcrumb'            => $this->items['modulo'],
    				'breadcrumb_alias'      => 'Detalle de asignación | '.$asignacion['IDAsignacion'],
                    'previo'                => 'listar-asignaciones',
                    'actaAsignacion'        => $pdfActaAsignacion,
                    'informacionAsignacion' => $asignacion,
                    'listaAdjunto'          => $listaAdjunto,
                    'idAsignacion'          => $idAsignacion
    			);
    			
    			$data = array_merge($data, $this->items);
    			
    			return view('cargos/listar_detalle_asignacion',$data);
            }
            else
            {
                return view('errors/404');
            }
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function PDFActaAsignacion($idAsignacion, $token, $salida)
    {
        $whereAsignacion = array(
		    'IDAsignacion'  => $idAsignacion
		);
		
		$whereFirma = array(
            "IDAsignacion"  => $idAsignacion,
            "Firma"         => "Y"
        );
			
        $asignacion = $this->asignaciones->obtenerInformacionActaAsignacion($whereAsignacion);
        
        if($token != $asignacion['TokenLinkFirma'] )
        {
            return view('errors/token');
        }
        else
        {
            $detalle = $this->asignacionesDetalle->listadoDetalleActaAsignacion($whereAsignacion);
            $firmaAsignacion = $this->asignacionesAdjuntos->where($whereFirma)->first();
            
            $area1 = in_array("MOVIL", array_column($detalle, 'TipoElemento')) || in_array("LINEA", array_column($detalle, 'TipoElemento')) || in_array("HARDWARE", array_column($detalle, 'TipoElemento')) || in_array("TARJETA", array_column($detalle, 'TipoElemento')) || in_array("ACCESORIOIT", array_column($detalle, 'TipoElemento')) ? "IT" : "";
            $area2 = in_array("KITDEMO", array_column($detalle, 'TipoElemento')) || in_array("ELEMENTOTRABAJO", array_column($detalle, 'TipoElemento')) ? "URES" : "";
            
            if($area1 != '' && $area2 != '')
            {
                $nombreArea = $area1.' - '.$area2;
            }
            else if($area1 == '' && $area2 != '')
            {
                $nombreArea = $area2;
            }
            else if($area1 != '' && $area2 == '')
            {
                $nombreArea = $area1;
            }
            else
            {
                $nombreArea = '';
            }
            
            /* OBTENER MONEDAS ACTUALES */
            
            $listadoMonedas = $this->divisas->findAll();
            // Crear un array asociativo para acceder fácilmente a cada MONEDA por su nomenclatura
            $monedasMapeadas = [];
            foreach ($listadoMonedas as $moneda) {
                $monedasMapeadas[$moneda['CodigoInternacional']] = $moneda['Simbolo'] ;
            }
            
            $widthActa = "";
            
            if($salida != "download")
            {
                $widthActa = 'width: 21cm; ';
            }
            
            
            
            $asignacion['widthActa'] = $widthActa;
            $asignacion['baseURL'] = $this->items['baseUrl'];
            $asignacion['nombreAreaActaAsignacion'] = $nombreArea;
            
            $arrayInformacionActa = array(
                'asignacion'    => $asignacion,
                'detalle'       => $detalle,
                'monedas'       => $monedasMapeadas,
                'firma'         => $firmaAsignacion,
                'basePublic'    => $this->items['basePublic'],
                'baseDinamic'   => $this->items['baseDinamic']
            );
            
            $html = '';
            
            if(strtotime($asignacion['FechaCrea']) < strtotime("2025-05-29 00:00:00") )
            {
                $html = $this->plantillasPDF->formatoActaAsignacion_V1($arrayInformacionActa);
            }
            else
            {
                $html = $this->plantillasPDF->formatoActaAsignacion_V2($arrayInformacionActa);
            }
            
            
            
    		$filename = 'Acta de Asignación #' . $idAsignacion;
    		
    		if($salida == "view")
    		{
    		    $html = $this->pdf->generar($html, $filename, $stream = TRUE, $paper = 'A4', $orientation = "portrait");
    		    exit();
    		}
    		else if($salida == "html")
    		{
    		    return $html;
    		}
    		else if($salida == "download")
    		{
    		    $html = $this->pdf->generar($html, $filename, $salida, $paper = 'A4', $orientation = "portrait");
    		    exit();
    		}
    		else
    		{
    		    return $html;
    		}
        }
    }

    public function adjuntarDocumentoAsignacion($idAsignacion)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $nombre         = $this->request->getPost('txtNombreAdjunto_i');
        $observacion    = $this->request->getPost('txtObservacionAdjunto_i');
        $reemplazafirma = $this->request->getPost('chkAdjuntoFirma');
        $adjunto        = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|minlength[9]|maxlength[15]', 'Nombre');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[itemsFile,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->getClientExtension() != null)
        {
            $extensionDoc = strtolower($adjunto->getClientExtension());
        }
        else if($adjunto->guessExtension() != null)
        {
            $extensionDoc = strtolower($adjunto->guessExtension());
        }
        else
        {
            $extensionDoc = strtolower(pathinfo($adjunto->getClientName(), PATHINFO_EXTENSION));
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDAsignacion'      => $idAsignacion, 
            'Nombre'            => $nombre, 
            'Extension'         => $extensionDoc,
            'Observacion'       => $observacion,
            'ReemplazoFirma'    => ((isset($reemplazafirma) && $reemplazafirma != null) ? 'Y' : 'N'),  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->asignacionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = $this->items['baseDinamic']."/docs/ActaAsignacion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
        $nombreArchivo = $idAsignacion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        $message = sprintf($this->mensajeError->msg201, "El archivo adjunto fue registrado exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
    public function enviarCorreoAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idAsignacion   = $this->request->getPost('idAsignacion');
        $asignacion     = $this->asignaciones->where("IDAsignacion", $idAsignacion)->first();
        $detalle        = $this->asignacionesDetalle->where("IDAsignacion", $idAsignacion)->first();
        $asignado       = $this->usuarios->buscarUsuario($asignacion['UsuarioAsignado']);
        
        $correoCopia = array();
		/*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
		*/

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE ASIGNACIÓN",
            "ACTA" => "ACTA DE ASIGNACIÓN",
            "USUARIO" => ucwords(mb_strtolower($asignado['Nombres'].' '.$asignado['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-asignacion/".$idAsignacion."/".$asignacion['TokenLinkFirma'],
            'baseUrl'       => $this->items['baseUrl'],
            'basePublic'    => $this->items['basePublic'],
            'baseDinamic'   => $this->items['baseDinamic']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
		*/
		
		$elementosDetalle = array_column($detalle, 'TipoElemento');
		
		$correoCopia[] = $this->items['correoElectronico'];
		
		if(in_array("KITDEMO", $elementosDetalle) || in_array("ELEMENTOTRABAJO", $elementosDetalle))
		{
		    $correoCopia[] = "ag.alcantaraodar@verisure.pe";
		}
		
		if(in_array("MOVIL", $elementosDetalle) || in_array("LINEA", $elementosDetalle) || in_array("HARDWARE", $elementosDetalle) || in_array("TARJETA", $elementosDetalle) || in_array("ACCESORIOIT", $elementosDetalle) )
		{
		    $correoCopia[] = "soporteit@verisure.pe";
		}

        $asunto='ACTA DE ASIGNACIÓN: '.$idAsignacion.' - '.$asignado['Nombres'].' '.$asignado['Apellidos'];
        
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($asignado['Correo']),
            "CORREOS_COPIA" => $correoCopia,
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDAsignacion"  => $idAsignacion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusAsignacion->insert($dataCorreo, TRUE);

        if($estadoCorreo['ERROR'] != '')
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
            echo $this->alertas->alertaExito($message);
        }
        
    }
    
    /***/
    
    public function actaAsignacion($idAsignacion, $token)
    {
        $whereAsignacion = array(
		    'IDAsignacion'  => $idAsignacion
		);
		
        $asignacion = $this->asignaciones->obtenerInformacionActaAsignacion($whereAsignacion);

        $whereFirma = array(
            "IDAsignacion"  => $idAsignacion,
            "Firma"         => "Y"
        );
        $firmaAsignacion = $this->asignacionesAdjuntos->where($whereFirma)->first();

        if($token == $asignacion['TokenLinkFirma'])
        {
            $pdfActaAsignacion = $this->PDFActaAsignacion($idAsignacion, $asignacion['TokenLinkFirma'], 'html');
			/* ACCIONES */

			$data = array (
				'titulo'                => 'Asignaciones | Verisure',
				'asignacion'            => $asignacion,
				'actaAsignacion'        => $pdfActaAsignacion,
                'firmaAsignacion'       => $firmaAsignacion,
                'idAsignacion'          => $idAsignacion
                
			);
			$data = array_merge($data, $this->items);
			return view('cargos/acta_asignacion',$data);	
        }
        else
        {
            return view('errors/500');
        }
    }

    public function subirFirmaActaAsignacion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idAsignacion = $this->request->getPost("txtIDAsignacion");
        $canvasFirma = $this->request->getPost("firmaActaAsignacion");
        
        $adjunto = $this->request->getFile("fileFotoDNI");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            if($adjunto->getError() == 4)
            {
                $mensajeError = "No ha sido subido ningún archivo.";
            }
            else
            {
                $mensajeError = $adjunto->getErrorString();
            }
            
            $message = sprintf($this->mensajeError->msg201, $mensajeError.'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileFotoDNI' => [
                'mime_in[fileFotoDNI,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileFotoDNI,png,jpg,jpeg,gif,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }
        
        /*
        * ----------------------------
        * VALIDAR EXISTENCIA DE DATOS
        * ----------------------------
        */
        
        $arrayWhere = array(
            "IDAsignacion"  => $idAsignacion,
            "Firma"         => "Y"
        );
        
        $lastIdFirma = $this->asignacionesAdjuntos->where($arrayWhere)->findAll();
        
        if (!empty($lastIdFirma)) {
            $message = sprintf($this->mensajeError->msg201, "<li>Acta ya se encuentra firmada.</li>");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $asignacion = $this->asignaciones->where("IDAsignacion", $idAsignacion)->first();

        $data = array (
            'IDAsignacion'      => $idAsignacion, 
            'Nombre'            => "COMPROBANTE DE RECEPCIÓN", 
            'Extension'         => $extensionDoc,
            'Observacion'       => "COMPROBANTE DE RECEPCIÓN ADJUNTADO EN LA FIRMA.",
            'ReemplazoFirma'    => 'N',  
            'UsuarioCrea'       => $asignacion['UsuarioAsignado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->asignacionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = $this->items['baseDinamic']."/docs/ActaAsignacion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
        $nombreArchivo = $idAsignacion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $dataFirma = array (
            'IDAsignacion'      => $idAsignacion, 
            'Nombre'            => "FIRMA", 
            'Extension'         => "png",
            'Observacion'       => "FIRMA DEL ASIGNADO.",
            'ReemplazoFirma'    => 'N',  
            'Firma'             => 'Y',  
            'UsuarioCrea'       => $asignacion['UsuarioAsignado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdFirma = $this->asignacionesAdjuntos->insert($dataFirma, TRUE);

		if($lastIdFirma === FALSE){
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR FIRMA
        * ----------------------------
        */

        $ruta = $this->items['baseDinamic']."/docs/ActaAsignacion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
        $nombreArchivoFirma = $idAsignacion."-".$lastIdFirma;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombreFirma = $nombreArchivoFirma.'.png';
            
            $datos = base64_decode(
                preg_replace('/^[^,]*,/', '', $canvasFirma)
            );

            $estadoFirma = file_put_contents($ruta.$nuevonombreFirma, $datos);
            
            if ($estadoFirma===FALSE) {
                unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
                $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastIdFirma]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastId]);
            $this->asignacionesAdjuntos->delete(["IDAdjuntoAsignacion", $lastIdFirma]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }

        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
        */
        
        $usuarioRemitente = $this->usuarios->where("IdUsuario", $asignacion['UsuarioRemitente'])->first();
        
        $usuarioAsignado = $this->usuarios->where("IdUsuario", $asignacion['UsuarioAsignado'])->first();
        
        $arrayCuerpo = array(
            "TITULO" => "FIRMA DE ACTA DE ASIGNACIÓN",
            "ACTA" => "ACTA DE ASIGNACIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioRemitente['Nombres'].' '.$usuarioRemitente['Apellidos'])),
            "CODIGO" => $idAsignacion,
            'baseUrl'       => $this->items['baseUrl'],
            'basePublic'    => $this->items['basePublic'],
            'baseDinamic'   => $this->items['baseDinamic']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActasConfirmacion($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='FIRMA DE ACTA DE ASIGNACIÓN: '.$idAsignacion.' - '.$usuarioAsignado['Nombres'].' '.$usuarioAsignado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $usuarioAsignado['Nombres'].' '.$usuarioAsignado['Apellidos'],
            "CORREO_ORIGEN" => $usuarioAsignado['Correo'],
            "CORREOS_DESTINOS" => array($usuarioRemitente['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDAsignacion"  => $idAsignacion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $asignacion['UsuarioAsignado'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusAsignacion->insert($dataCorreo, TRUE);

        $message = sprintf($this->mensajeError->msg201, "La firma fue registrada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
	/**************************************************************************/
	
    /****************************** DEVOLUCIONES ******************************/
    
    public function listarDevoluciones()
    {
        if(isset($this->items['id']))
        {
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Actas de Devolución | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Actas de Devolución',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Actas de Devolución",
				'subtitulo'                 => 'Listado de Actas de Devolución'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('cargos/listar_devoluciones',$data);
			
		} 
		else 
		{
			return view('errors/500');
		}
    }

	public function actasDevolucionServerside()
	{
    	if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            if($this->items['idPerfil'] == 3)
    		{
    		    $userXdeleg = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
    		  
    		  //  $userXdeleg = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
    		    $idDelegaciones = array_column($userXdeleg, 'IDDelegacion');
    		    
    		    $adicionales['Delegaciones'] = $idDelegaciones;
    		}
            
    	    $dataServerside =  $this->devoluciones->listarDevolucionesServerside($this->request->getPost(), $adicionales);
    	    
    	    foreach($dataServerside["data"] as $key=>$value)
            {
                //CONFIGURACIÓN DE LA INFORMACIÓN "FECHA ASIGNADO"
                
                $fechaDevolucion = date("d-m-Y", strtotime($value['FechaCrea']));
                
                $dataServerside["data"][$key]['FechaDevolucion'] = $fechaDevolucion;
                
                //CONFIGURACIÓN DE LA INFORMACIÓN "FIRMA"
                $firma = "";
                
                if($value['FechaRegistroFirma']!='' && $value['FechaRegistroFirma']!=null)
                {
                    $firma .= "<span class='badge bg-success border-0'>".date("d-m-Y H:i:s", strtotime($value['FechaRegistroFirma']))."</span>";
                }
                else
                {
                    $firma .= "<span class='badge bg-danger border-0'>NO</span>";
                }
                
                $dataServerside["data"][$key]['Firma'] = $firma;
                
                //CONFIGURACIÓN DE LAS ACCIONES DEL ELEMENTO
                $acciones = "";
                $acciones .= "<div class='dropdown d-inline-block'>";
                
    			if (in_array("DETDEV", $this->items['permisos'])) 
    			{
                    $acciones .= "<a href='".$this->items['baseUrl']."/detalle-acta-devolucion/".$value['IDDevolucion']."/".$value['TokenLinkFirma']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Detalle de Devolución' aria-label='Ver Detalle de Devolución'>
                        <i class='mdi mdi-file-sign align-bottom' style='font-size: 20px; color: #FFF;'></i>
                    </a>";
    			}
    			
    			$acciones .= "</div>";
                
                $dataServerside["data"][$key]['Acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'descripcion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
	}
	
    public function elementosDevolucion()
    {
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
        $idUsuario          = $this->request->getPost('idUsuario');
        $motivoDevolucion   = $this->request->getPost('motivoDevolucion');
        
		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idUsuario, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * OBTENER ELEMENTOS ASIGNADOS
        * -------------
        */
        
        $whereDetalle = array(
            'IDDevolucion'      => '',
            'UsuarioAsignado'   => $idUsuario
        );
		
		$listadoItems = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalle);
		
        $items = array();

        if (!empty($listadoItems)) 
        {
            foreach($listadoItems as $value)
            {
                $items[] = array(
					'idDetalleAsignacion'   => (string) $value['IDDetalleAsignacion'],
         	        'item'                  => (string) $value['TipoEquipo'].' | '.$value['Marca'].' '.$value['Modelo'].' '.$value['Serie'],
         	        'motivo'                => (string) $motivoDevolucion,
         	        'tipoElemento'          => (string) $value['TipoElemento'],
         	        'tipoCategoria'         => (string) $value['TipoCategoria']
                );
            }
        }
        
		/*
        * -------------
        * ARMAR ESTRUCTURA HTML A DEVOLVER
        * -------------
        */
		
		$html = '';
		
		if (!empty($items)) 
		{
    		if($motivoDevolucion == "CESE" || $motivoDevolucion == "USUARIO NO INGRESÓ")
    		{
    		    foreach($items as $elementos)
    		    {
    		        $html .= $this->estructuraHTMLElementoDevolucion($elementos);
    		    }
    		    
    		    $html .= '<script>
                	$(".select2-situacionelementodevolucion").select2({
                        dropdownParent: $("#registrarDevolucion .modal-body")
                    });
                </script>';
    		}
    		else
    		{
    		    $html .= '<div class="row col-12 m-0 p-0 mb-3 d-flex">
			        <div class="col-xxl-10 col-md-12 col-12 px-3">
						<div>
                            <label for="txtItemDevolucion" class="form-label">Item</label>
                            <select class="form-select" aria-label="Item" id="txtItemDevolucion" name="txtItemDevolucion">
                                <option selected="" value="">Seleccione una opción</option>';
                                foreach($items as $elementos)
                    		    {
                    		        $html .= '<option value="'.$elementos['idDetalleAsignacion'].'">'.$elementos['item'].'</option>';
                    		    }
                            $html .= '</select>
                        </div>
					</div>
					<div class="col-xxl-2 col-md-12 col-12 px-3 d-flex justify-content-end align-items-center">
					    <button type="button" class="btn bg-success px-2 py-1 ms-3" onclick="return agregarItemDevolucion();" data-tooltip="tooltip" aria-label="Agregar Item a la devolución">
                            <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i>
                        </button>
					</div>
			    </div>
			    <hr class="m-0 p-0 pb-3">
			    <div class="row col-12 m-0 p-0 mb-3 d-flex" id="ctnListadoElementosDevolucion">
			    </div>
			    <script>
                	$("#txtItemDevolucion").select2({
                        dropdownParent: $("#registrarDevolucion .modal-body")
                    });
                </script>';
    		}
		}
		else
		{
		    $html .= '<div class="alert alert-warning" role="alert">
            <h4 class="alert-heading">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16" role="img" aria-label="Warning:">
                <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
            </svg>
            No hay dispositivos asignados!
            </h4>
            <p>No se encontraron dispositivos asignados.</p>
            <hr>
            <p class="mb-0">Por favor, validar los dispositivos entregados y reportarlo con SOPORTE IT.</p>
          </div>';
		}
        
        $resultado = array(
            'html' => $html,
		);
		
		echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }
    
    public function obtenerElementoDevolver()
    {
        $idItem     = $this->request->getPost('idItem');
        $idUsuario  = $this->request->getPost('idUsuario');
        $motivo     = $this->request->getPost('motivo');
        
        $dataDevolucion = array();
        
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $whereDetalle = array(
            'IDDetalleAsignacion'   => $idItem,
            'return'                => "row"
        );
		
		$detalle = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalle);
		
        $elemento = $detalle['TipoEquipo'].' | '.$detalle['Marca'].' '.$detalle['Modelo'].' '.$detalle['Serie'];
                
        $dataDevolucion = array(
			'idDetalleAsignacion'   => (string) $idItem,
 	        'item'                  => (string) $elemento,
 	        'motivo'                => (string) $motivo,
 	        'tipoElemento'          => (string) $detalle['TipoElemento'],
 	        'tipoCategoria'         => (string) $detalle['TipoCategoria']
        );
        
        echo $this->estructuraHTMLElementoDevolucion($dataDevolucion);
    }
    
    function estructuraHTMLElementoDevolucion($elementos)
    {
        $random = $this->complementos->generar_string_aleatorio(8);
        
        $valorValidacion = in_array($elementos['tipoElemento'], array("MOVIL", "HARDWARE", "TARJETA")) ? "REGIS" : "NREQV";
        
        $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="ctnDevolucion'.$random.'" style="border-radius: 10px;">
            <div class="col-xxl-6 col-md-12 col-12 mb-2">
                <label class="form-label">Elemento</label>
                <div class="input-group">
                    <input type="hidden" name="etiqueta['.$elementos['idDetalleAsignacion'].'][ETIQUETA]" value="'.$elementos['item'].'">
                    <input type="hidden" name="itemDevolucion[]" value="'.$elementos['idDetalleAsignacion'].'">
                    <input type="hidden" name="validacionDevolucion['.$elementos['idDetalleAsignacion'].'][ESTADOVALIDACION]" value="'.$valorValidacion.'">
                    <input type="text" class="form-control" value="'.$elementos['item'].'" disabled>
                </div>
            </div>
            <div class="col-xxl-6 col-md-12 col-12 mb-2">
                <div>
                    <label for="txtSituacionElemento'.$elementos['idDetalleAsignacion'].'" class="form-label">Situación</label>
                    <select class="form-select select2-situacionelementodevolucion" aria-label="Situación" id="txtSituacionElemento'.$elementos['idDetalleAsignacion'].'" name="txtSituacionElemento['.$elementos['idDetalleAsignacion'].'][SITUACION]" required>';
                        
                        if($elementos['motivo'] == "USUARIO NO INGRESÓ")
                        {
                            $html .= '<option value="DEV">DEVOLUCIÓN OK</option>';
                        }
                        else
                        {
                            $html .= '<option selected="" value="">Seleccione una opción</option>
                            <option value="INO">INOPERATIVO</option>
                            <option value="ROB">ROBO</option>
                            <option value="PER">PÉRDIDA</option>
                            <option value="NOD">NO DEVOLUCIÓN</option>
                            <option value="FAL">FALLA</option>
                            <option value="FVU">FIN DE VIDA ÚTIL</option>
                            <option value="DEV">DEVOLUCIÓN OK</option>';
                            
                            if($elementos['tipoCategoria'] == "KITS")
                            {
                                $html .= '<option value="INC">KIT INCOMPLETO</option>';
                            }
                        }
                    $html .= '</select>
                </div>
            </div>';
            
            if($elementos['motivo'] == "CESE" || $elementos['motivo'] == "USUARIO NO INGRESÓ")
            {
                $html .= '<div class="col-xxl-12 col-md-12 col-12">
                    <div class="form-floating">
                        <textarea class="form-control" id="txtObservacionElemento'.$elementos['idDetalleAsignacion'].'" name="txtObservacionElemento['.$elementos['idDetalleAsignacion'].'][OBSERVACION]" rows="3" required></textarea>
                        <label for="txtObservacionElemento'.$elementos['idDetalleAsignacion'].'">Observación</label>
                    </div>
                </div>';
            }
            else
            {
                $html .= '<div class="col-xxl-10 col-md-10 col-10">
                    <div class="form-floating">
                        <textarea class="form-control" id="txtObservacionElemento'.$elementos['idDetalleAsignacion'].'" name="txtObservacionElemento['.$elementos['idDetalleAsignacion'].'][OBSERVACION]" rows="3" required></textarea>
                        <label for="txtObservacionElemento'.$elementos['idDetalleAsignacion'].'">Observación</label>
                    </div>
                </div>
        		<div class="col-xxl-2 col-md-2 col-2 py-2 d-flex justify-content-end align-items-center">
        			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'ctnDevolucion'.$random.'\');" data-tooltip="tooltip" aria-label="Eliminar Elemento">
                        <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                    </button>
        		</div>
        		<script>
                	$("#txtSituacionElemento'.$elementos['idDetalleAsignacion'].'").select2({
                        dropdownParent: $("#registrarDevolucion .modal-body")
                    });
                </script>';
            }
            
        $html .= '</div>';
        return $html;
    }

    public function registrarDevolucion()
    {
        /*REVISAR*/
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $usuarioDevolucion  = $this->request->getPost('txtUsuarioDevolucion');
        $observacion        = $this->request->getPost('txtObservacion');
        $motivo             = $this->request->getPost('txtMotivoDevolucion');
        
        $preguntaEmail      = $this->request->getPost('txtPreguntaEmailDevolucion');
        $motivoNegativa     = $this->request->getPost('txtMotivoNegativa');
        $emailDevolucion    = $this->request->getPost('txtCorreoPersonalDevolucion');
        $celularDevolucion  = $this->request->getPost('txtNroCelularPersonalDevolucion');
        
        // $elemento = $this->request->getPost('elemento');
        $elemento           = $this->request->getPost('itemDevolucion');
        $etiqueta           = $this->request->getPost('etiqueta');
        $situacion          = $this->request->getPost('txtSituacionElemento');
        $validacion         = $this->request->getPost('validacionDevolucion');
        $obsElemento        = $this->request->getPost('txtObservacionElemento');
        
        $adjunto            = $this->request->getFile("itemsFile");
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($usuarioDevolucion, 'required|trim', 'Usuario');
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo de devolución');
        $error .= $this->complementos->validaCampo($celularDevolucion, 'trim|numeric', 'Celular Personal');
        
        // if($motivo == "USUARIO NO INGRESÓ")
        // {
        //     $error .= $this->complementos->validaCampo($emailDevolucion, 'trim|email|minlength[1]|maxlength[200]', 'Email Personal');
        // }
        // else
        // {
        //     $error .= $this->complementos->validaCampo($emailDevolucion, 'required|trim|email|minlength[1]|maxlength[200]', 'Email Personal');
        // }
        
        if($motivo == "CESE")
        {
            if(empty($preguntaEmail))
            {
                $error .= "<li>Debe responder a la pregunta sobre el email del usuario a devolver.</li>";
            }
            else
            {
                if($preguntaEmail == "Y")
                {
                    $error .= $this->complementos->validaCampo($emailDevolucion, 'required|trim|email|minlength[1]|maxlength[200]', 'Email Personal');
                }
                else
                {
                    if(empty($motivoNegativa))
                    {
                        $error .= "<li>Debe seleccionar el motivo de la negativa a brindar el email personal.</li>";
                    }
                }
            }
            $error .= $this->complementos->validaCampo($emailDevolucion, 'trim|email|minlength[1]|maxlength[200]', 'Email Personal');
        }
        
        
        if(empty($situacion))
        {
            $error .= "<li>Debe seleccionar la situación del item mostrado.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        $arraySituacion = array_column($situacion, 'SITUACION');
        
        if(in_array("ROB", $arraySituacion) || in_array("PER", $arraySituacion))
        {
            /*
            * ----------------------------
            * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
            * ----------------------------
            */
            
            if (! $adjunto->isValid()) {
                $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
                echo $this->alertas->alertaError($message);
                exit;
            }
            
            /*
            * ----------------------------
            * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
            * ----------------------------
            */
            
            $validationRule = [
                'itemsFile' => [
                    'mime_in[itemsFile,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                    'ext_in[itemsFile,pdf]'
                ],
            ];

            if (! $this->validate($validationRule)) {
                $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($elemento as $detalle)
        {
            $elementoDevuelto = $this->devolucionesDetalle->where("IDDetalleAsignacion", $detalle)->findAll();

            if(!empty($elementoDevuelto))
            {
                $msgExistencia .= "<li>El ".$etiquetaitem[$detalle]['ETIQUETA']." ya fue devuelto.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS DEVOLUCIÓN
        * ----------------------------
        */
        
        $datosUsuario = $this->usuarios->buscarUsuario($usuarioDevolucion);
        $tokenDevolucion = $this->complementos->generar_string_aleatorio(15);

        $dataDevolucion = array (
            'UsuarioDevolucion'         => $usuarioDevolucion, 
            'CargoDevolucion'           => $datosUsuario['Cargo'], 
            'DireccionDevolucion'       => $datosUsuario['IDDireccion'], 
            'AreaDevolucion'            => $datosUsuario['IDArea'], 
            'SubareaDevolucion'         => $datosUsuario['IDSubarea'], 
            'DelegacionDevolucion'      => $datosUsuario['IDDelegacion'], 
            'InformaCorreoPersonal'     => $preguntaEmail,
            'MotivoNegativaCorreo'      => $motivoNegativa,
            'CorreoDevolucion'          => $emailDevolucion,
            'TelefonoDevolucion'        => $celularDevolucion,
            'Motivo'                    => $motivo, 
            'Observacion'               => $observacion, 
            'TokenLinkFirma'            => $tokenDevolucion, 
            'UsuarioCrea'               => $this->items['id'],
            'CargoCrea'                 => $this->items['cargo'], 
            'DireccionCrea'             => $this->items['dpto'], 
            'AreaCrea'                  => $this->items['idArea'], 
            'SubareaCrea'               => $this->items['idSubarea'],
            'DelegacionCrea'            => $this->items['idDelegacionLog'],
            'FechaCrea'                 => $fechaActual,
            'Localhost'                 => $this->request->getIPAddress()
        );

        if($motivo == "USUARIO NO INGRESÓ")
        {
            $dataDevolucion['FechaRegistroFirma'] = $fechaActual;
            $dataDevolucion['ConceptoRegistroFirma'] = "Firma no registrada - Usuario no ingresó - Registro de firma automático";
        }

        $lastIdDevolucion = $this->devoluciones->insert($dataDevolucion, TRUE);
        
        if($lastIdDevolucion !== FALSE){
            $idDevolucion = $lastIdDevolucion;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la devolución. Inténtelo luego.[AD]</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $dataDetalleDevolucion = array();

        foreach($elemento as $detalle)
        {
            $dataDetalleDevolucion[] = array (
                'IDDevolucion'          => $idDevolucion, 
                'IDDetalleAsignacion'   => $detalle,  
                'MotivoDevolucion'      => $situacion[$detalle]['SITUACION'],
                'Observacion'           => $obsElemento[$detalle]['OBSERVACION'],
                'Estado'                => $validacion[$detalle]['ESTADOVALIDACION'],
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActual,    
                'Localhost'             => $this->request->getIPAddress()
            );
            
            $whereDetalleAsignacion = array(
                'IDDetalleAsignacion'   => $detalle,
                'return'                => "row"
            );
    		
    		$detalleAsignacion = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalleAsignacion);
    		
    		if($detalleAsignacion['GeneraCobroReposicion'] == "N")
    		{
    		    if(isset($situacion[$detalle])) 
    		    {
    		        unset($situacion[$detalle]);
    		    }
    		}
        }
        $lastIdDetalleDevolucion = $this->devolucionesDetalle->insertBatch($dataDetalleDevolucion);
        
		if($lastIdDetalleDevolucion === FALSE){
            $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la devolución. Inténtelo luego.[ADD]");
			echo $this->alertas->alertaError($message);
			exit;
		} 

        $arraySituacionEvaluado = array_column($situacion, 'SITUACION');
        
        //Situaciones que no generan reposición
        $situacionesReposicion = array_diff($arraySituacionEvaluado, array("DEV", "FVU", "REN", "UNI"));

        if(!empty($situacionesReposicion))
        {
            /*
            * ----------------------------
            * INSERCIÓN DE DATOS REPOSICIÓN
            * ----------------------------
            */

            $datosAdjudicado = $this->usuarios->buscarUsuario($usuarioDevolucion);
            $tokenReposicion = $this->complementos->generar_string_aleatorio(15);

            $dataReposicion = array (
                'UsuarioAdjudicado'         => $usuarioDevolucion, 
                'CargoAdjudicado'           => $datosAdjudicado['Cargo'], 
                'DireccionAdjudicado'       => $datosAdjudicado['IDDireccion'], 
                'AreaAdjudicado'            => $datosAdjudicado['IDArea'], 
                'SubareaAdjudicado'         => $datosAdjudicado['IDSubarea'], 
                'DelegacionAdjudicado'      => $datosAdjudicado['IDDelegacion'], 
                'TokenLinkFirma'            => $tokenReposicion, 
                'LiberadoFirma'             => "Y", 
                'Motivo'                    => "REPOSICIÓN POR ACTA DE DEVOLUCIÓN", 
                'Observacion'               => $observacion, 
                'Cuotas'                    => 'N', 
                'UsuarioCrea'               => $this->items['id'],
                'CargoCrea'                 => $this->items['cargo'], 
                'DireccionCrea'             => $this->items['dpto'],
                'AreaCrea'                  => $this->items['idArea'],
                'SubareaCrea'               => $this->items['idSubarea'],
                'DelegacionCrea'            => $this->items['idDelegacionLog'],
                'FechaCrea'                 => $fechaActualAdd,    
                'Localhost'                 => $this->request->getIPAddress()
            );

            $lastIdReposicion = $this->reposiciones->insert($dataReposicion, TRUE);
            
            if($lastIdReposicion !== FALSE){
                $idReposicion = $lastIdReposicion;
            }
            else
            {
                $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la devolución. Inténtelo luego[AR].</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }

            $dataDetalle = array();
            // $totalSumaTrabajador = 0;

            foreach($elemento as $detalle)
            {
                if($situacion[$detalle]['SITUACION'] != 'DEV' && $situacion[$detalle]['SITUACION'] != 'FVU' && $situacion[$detalle]['SITUACION'] != 'REN')
                {
                    $diaPlanilla = $this->globales->diaCortePlanilla();
        
                    $fechaPlanillaActual = date("Y-m-".$diaPlanilla);
                    $fechaEvaluarActual= date("Y-m-d");
        
                    $timePlanilla = strtotime($fechaPlanillaActual);
                    $timeActual = strtotime($fechaEvaluarActual);
        
                    $mesInicioCuotas=0;
                    $anioInicioCuotas=0;
        
                    $mesActual = date("m");
                    $anioActual = date("Y");
    
                    if($timePlanilla >= $timeActual)
                    {
                        $mesInicioCuotas = date("m");
                        $anioInicioCuotas = date("Y");
                    }
                    else
                    {
                        if($mesActual == 12)
                        {
                            $mesInicioCuotas = 1;
                            $anioInicioCuotas = $anioActual +1 ;
                        }
                        else
                        {
                            $mesInicioCuotas = $mesActual + 1;
                            $anioInicioCuotas = $anioActual;
                        }
                    }
                    
                    
                    $whereDetalle = array(
                        'IDDetalleAsignacion'   => $detalle,
                        'return'                => "row"
                    );
                    
                    $detalleAsignacion = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalle);
                    $dataReposicion = $this->informacionReposicionElemento($detalleAsignacion, $usuarioDevolucion, $situacion[$detalle]['SITUACION'], $motivoDevolucion);
                    
                    $totalDescuento     = !empty($dataReposicion) ? $dataReposicion['TOTALCAMBIO'] : 0 ;
                    $totalVerisure      = !empty($dataReposicion) ? $dataReposicion['VERISURE'] : 0 ;
                    $totalTrabajador    = !empty($dataReposicion) ? $dataReposicion['TRABAJADOR'] : 0 ;
                    
                    $cuotasTrabajador   = !empty($dataReposicion) ? $dataReposicion['TOTALCUOTAS'] : 1 ;
                    $bolsa              = !empty($dataReposicion) ? $dataReposicion['BOLSA'] : 'IT' ;

                    $dataDetalle = array (
                        'IDReposicion'          => $idReposicion, 
                        'IDDetalleAsignacion'   => $detalle,  
                        'TotalDescuento'        => $totalDescuento, 
                        'TotalVerisure'         => $totalVerisure, 
                        'TotalTrabajador'       => $totalTrabajador, 
                        'Observacion'           => $obsElemento[$detalle]['OBSERVACION'], 
                        'TotalCuotas'           => $cuotasTrabajador,
                        'MesFacturacion'        => $mesInicioCuotas,
                        'AnioFacturacion'       => $anioInicioCuotas,
                        'Bolsa'                 => $bolsa,
                        'Cobrado'               => 'N',
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActualAdd,    
                        'Localhost'             => $this->request->getIPAddress()
                    );
                    
                    $lastIdDetalleReposicion = $this->reposicionesDetalle->insert($dataDetalle, TRUE);
                    
                    if($lastIdDetalleReposicion === FALSE){
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición de un item. Inténtelo luego.[ARD]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    } 
                    
                    /*
                    * ----------------------------
                    * INSERCIÓN DE DATOS REPOSICIÓN - CRONOGRAMA DE PAGOS
                    * ----------------------------
                    */
                    
                    $dataCronogramaPago = array();
                    
                    $descuentoMensual = number_format(round($totalTrabajador / $cuotasTrabajador, 2), 2, '.', '');
        
                    for($i=1; $i<=$cuotasTrabajador;$i++)
                    {
                        if($i == ($cuotasTrabajador))
                        {
                            $montoCuota = ($totalTrabajador - (($cuotasTrabajador - 1)*$descuentoMensual));
                        }
                        else
                        {
                            $montoCuota = $descuentoMensual;
                        }
        
                        $dataCronogramaPago[] = array (
                            'IDDetalleReposicion'   => $lastIdDetalleReposicion, 
                            'NroCuota'              => $i, 
                            'MesCuota'              => $mesInicioCuotas, 
                            'AnioCuota'             => $anioInicioCuotas, 
                            'MontoCuota'            => $montoCuota, 
                            'Observacion'           => 'Cuota generada automáticamente', 
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,    
                            'Estado'                => 'A',
                            'UsuarioEstado'         => $this->items['id'],
                            'FechaEstado'           => $fechaActual,    
                            'Localhost'             => $this->request->getIPAddress()
                        );
        
                        $mesInicioCuotas++;
        
                        if($mesInicioCuotas > 12)
                        {
                            $mesInicioCuotas = 1;
                            $anioInicioCuotas = $anioInicioCuotas + 1;
                        }
                    }
        
                    $lastIdCronograma = $this->reposicionesCronogramaPago->insertBatch($dataCronogramaPago);
                    
                    if($lastIdCronograma === FALSE){
                        // $this->devolucionesDetalle->where('IDDetalleReposicion', $lastIdDetalleReposicion)->delete();
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición. Inténtelo luego.[INSERTCRP]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    } 

                }
            }

            /*
            * ----------------------------
            * GUARDAR ARCHIVO ADJUNTO
            * ----------------------------
            */
            
            
            if(in_array("ROB", $arraySituacion) || in_array("PER", $arraySituacion))
            {
                if($adjunto->guessExtension() != null)
                {
                    $extensionDoc = $adjunto->guessExtension();
                }
                else
                {
                    $nombre_original = $adjunto->getBasename();
                    $fileNameCmps = explode(".", $nombre_original);
                    $extensionDoc = strtolower(end($fileNameCmps));
                }

                /*
                * ----------------------------
                * INSERCIÓN DE DATOS ADJUNTOS
                * ----------------------------
                */

                $dataAdjuntoReposicion = array (
                    'IDReposicion'      => $idReposicion, 
                    'Nombre'            => "Denuncia Reposición", 
                    'Extension'         => $extensionDoc,
                    'Observacion'       => "Reporte de denuncia de equipos.",
                    'ReemplazoFirma'    => "N",  
                    'UsuarioCrea'       => $this->items['id'],
                    'FechaCrea'         => $fechaActualAdd,    
                    'Localhost'         => $this->request->getIPAddress()
                );

                $lastIdAdjuntosReposiciones = $this->reposicionesAdjuntos->insert($dataAdjuntoReposicion, TRUE);

                if($lastIdAdjuntosReposiciones === FALSE){
                    $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                    $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                    $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                    $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                    $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                    $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el acta de devolución. Inténtelo luego.[ARA]");
                    echo $this->alertas->alertaError($message);
                    exit;
                }

                /*
                * ----------------------------
                * GUARDAR ARCHIVO ADJUNTO REPOSICIÓN
                * ----------------------------
                */
                $ruta = $this->items['baseDinamic']."/docs/ActaReposicion/".date("Y", strtotime($fechaActualAdd))."/".date("m", strtotime($fechaActualAdd))."/";
                $nombreArchivo = $idReposicion."-".$lastIdAdjuntosReposiciones;

                if(!file_exists($ruta))
                {
                    @mkdir($ruta, 0777, true);
                }

                # si exsite la carpeta o se ha creado
                if (file_exists($ruta) || @mkdir($ruta)) 
                {
                    $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
                    
                    $estadoMove = $adjunto->move($ruta, $nuevonombre);
                    
                    if (!$estadoMove) {
                        $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                        $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                        $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                        $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                        $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                        $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el acta de devolución. Inténtelo luego.[SAVEDOC]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    }
                }
                else
                {
                    $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                    $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                    $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                    $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                    $this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                    $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();
                    $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
                    echo $this->alertas->alertaError($message);
                    exit;
                }
            }

            
            /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO DE REPOSICIÓN
            * ----------------------------
            */

            $arrayCuerpo = array(
                "TITULO" => "ACTA DE REPOSICIÓN",
                "ACTA" => "ACTA DE REPOSICIÓN",
                "USUARIO" => ucwords(mb_strtolower($datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'])),
                "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$tokenReposicion,
                'baseUrl'       => $this->items['baseUrl'],
                'basePublic'    => $this->items['basePublic'],
                'baseDinamic'   => $this->items['baseDinamic']
            );

            $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */

            $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'];
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => $this->items['correoElectronico'],
                "CORREOS_DESTINOS" => array($datosUsuario['Correo']),
                "CORREOS_COPIA" => array("soporteit@verisure.pe", $this->items['correoElectronico']),
                "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );

            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

            $dataCorreo = array(
                "IDReposicion"  => $idReposicion,
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );

            $this->correoStatusReposicion->insert($dataCorreo, TRUE);
            
        }
        
        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO DE DEVOLUCIÓN
        * ----------------------------
        */
        
        // if($motivo != "USUARIO NO INGRESÓ")
        // {
        //     $arrayCuerpo = array(
        //         "TITULO" => "ACTA DE DEVOLUCIÓN",
        //         "ACTA" => "ACTA DE DEVOLUCIÓN",
        //         "USUARIO" => ucwords(mb_strtolower($datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'])),
        //         "URL_ACTA" => base_url()."/acta-devolucion/".$idDevolucion."/".$tokenDevolucion,
        //         'baseUrl'       => $this->items['baseUrl'],
        //         'basePublic'    => $this->items['basePublic'],
        //         'baseDinamic'   => $this->items['baseDinamic']
        //     );
    
        //     $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
            
        //     /*
        //     * ----------------------------
        //     * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        //     * ----------------------------
        //     */

        //     $asunto='ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'];
        //     //$correoDestino = array($asignado['Correo']);
        //     $configCorreo = array(
        //         "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
        //         "CORREO_ORIGEN" => $this->items['correoElectronico'],
        //         "CORREOS_DESTINOS" => array($datosUsuario['Correo']),
        //         "CORREOS_COPIA" => array("soporteit@verisure.pe", $this->items['correoElectronico']),
        //         "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
        //         "ASUNTO" => $asunto,
        //         "MENSAJE" => $cuerpo
        //     );
    
        //     $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
    
        //     $dataCorreo = array(
        //         "IDDevolucion"  => $idDevolucion,
        //         "Response"      => $estadoCorreo['RESPUESTA'],
        //         "Error"         => $estadoCorreo['ERROR'],
        //         'UsuarioCrea'   => $this->items['id'],
        //         'FechaCrea'     => $fechaActual,    
        //         'Localhost'     => $this->request->getIPAddress()
        //     );
    
        //     $this->correoStatusDevolucion->insert($dataCorreo, TRUE);
        // }
        // else
        // {
        //     $arrayAsig = $this->detalleasignaciones->select('asignaciones.IDAsignacion, asignaciones.FechaRegistroFirma, asignaciones.Estado')->distinct()->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion', 'left')->whereIn('asignaciones_detalle.IDDetalleAsignacion', $elemento)->findAll();
            
        //     if(!empty($arrayAsig))
        //     {
        //         $firmaPendienteAsig = array();
                
        //         foreach($arrayAsig as $asignacion)
        //         {
        //             if($asignacion['FechaRegistroFirma'] == null || $asignacion['Estado'] == "REG")
        //             {
        //                 $firmaPendienteAsig[] = array(
        //                     'IDAsignacion'          => $asignacion['IDAsignacion'],
        //                     'FechaRegistroFirma'    => $fechaActual,
        //                     'ConceptoRegistroFirma' => "Firma no registrada - Usuario no ingresó - Registro de firma automático",
        //                     'UsuarioModifica'       => $this->items['id'],
        //                     'FechaModifica'         => $fechaActual,
        //                     'Localhost'             => $this->request->getIPAddress(),
        //                     'Estado'                => 'FIR'
        //                 );
        //             }
        //         }
                
        //         if(!empty($firmaPendienteAsig))
        //         {
        //             $this->asignaciones->updateBatch($firmaPendienteAsig, 'IDAsignacion');
        //         }
        //     }
        // }
        
        $message = sprintf($this->mensajeError->msg201, "La devolución fue solicitada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->reDireccion(base_url()."/detalle-acta-devolucion/".$idDevolucion."/".$tokenDevolucion, 1);
        
    }

	/***/
    
    public function detalleActaDevolucion($idDevolucion, $token)
    {
        if(isset($this->items['id']))
        {
			// ACCIONES
			$whereDevolucion = array(
			    'IDDevolucion'  => $idDevolucion
			);
			
            $devolucion = $this->devoluciones->obtenerInformacionActaDevolucion($whereDevolucion);
            
            if($token == $devolucion['TokenLinkFirma'] )
            {
                $listaAdjunto = $this->devolucionesAdjuntos->where("IDDevolucion", $idDevolucion)->findAll();
                $pdfActaDevolucion = $this->PDFActaDevolucion($idDevolucion, $token, 'html');
                
    			$data = array (
    				'session'               => 'on',
    				'titulo'                => 'Detalle de Devolución | Verisure',
    				'breadcrumb'            => $this->items['modulo'],
    				'breadcrumb_alias'      => 'Detalle de devolución | '.$idDevolucion,
                    'previo'                => 'listar-devoluciones',
                    'actaDevolucion'        => $pdfActaDevolucion,
                    'informacionDevolucion' => $devolucion,
                    'listaAdjunto'          => $listaAdjunto,
                    'idDevolucion'          => $idDevolucion
    			);
    			
    			$data = array_merge($data, $this->items);
    			
    			return view('cargos/listar_detalle_devolucion',$data);	
            }
            else
            {
                return view('errors/404');
            }
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function PDFActaDevolucion($idDevolucion, $token, $salida)
    {
        $whereDevolucion = array(
		    'IDDevolucion'  => $idDevolucion
		);
		
		$whereFirma = array(
            "IDDevolucion"  => $idDevolucion,
            "Firma"         => "Y"
        );
        
        $devolucion         = $this->devoluciones->obtenerInformacionActaDevolucion($whereDevolucion);
        
        if($token != $devolucion['TokenLinkFirma'] )
        {
            return view('errors/token');
        }
        else
        {
            $detalle            = $this->devolucionesDetalle->listadoDetalleActaDevolucion($whereDevolucion);
            $firmaDevolucion    = $this->devolucionesAdjuntos->where($whereFirma)->first();
            
            $area1 = in_array("MOVIL", array_column($detalle, 'TipoElemento')) || in_array("LINEA", array_column($detalle, 'TipoElemento')) || in_array("HARDWARE", array_column($detalle, 'TipoElemento')) || in_array("TARJETA", array_column($detalle, 'TipoElemento')) || in_array("ACCESORIOIT", array_column($detalle, 'TipoElemento')) ? "IT" : "";
            $area2 = in_array("KITDEMO", array_column($detalle, 'TipoElemento')) || in_array("ELEMENTOTRABAJO", array_column($detalle, 'TipoElemento')) ? "URES" : "";
            
            if($area1 != '' && $area2 != '')
            {
                $nombreArea = $area1.' - '.$area2;
            }
            else if($area1 == '' && $area2 != '')
            {
                $nombreArea = $area2;
            }
            else if($area1 != '' && $area2 == '')
            {
                $nombreArea = $area1;
            }
            else
            {
                $nombreArea = '';
            }
            
            $widthActa = "";
            
            if($salida != "download")
            {
                $widthActa = 'width: 21cm; ';
            }
            
            $devolucion['widthActa']                = $widthActa;
            $devolucion['baseURL']                  = $this->items['baseUrl'];
            $devolucion['nombreAreaActaDevolucion'] = $nombreArea;
            $devolucion['FechaDevolucion']          = "Lima, ".date('d', strtotime($devolucion['FechaCrea']))." de ".$this->complementos->parseoMes(date('m', strtotime($devolucion['FechaCrea'])))." de ".date('Y', strtotime($devolucion['FechaCrea']));
            
            $arrayInformacionActa = array(
                'devolucion'    => $devolucion,
                'detalle'       => $detalle,
                'firma'         => $firmaDevolucion,
                'estadosDispositivo'    => $this->globales->motivoEstadoDispositivos(''),
                'basePublic'    => $this->items['basePublic'],
                'baseDinamic'   => $this->items['baseDinamic']
            );
            
            $html = '';
            
            if(strtotime($devolucion['FechaCrea']) < strtotime("2025-06-14 00:00:00") )
            {
                $html = $this->plantillasPDF->formatoActaDevolucion_V1($arrayInformacionActa);
            }
            else
            {
                $html = $this->plantillasPDF->formatoActaDevolucion_V2($arrayInformacionActa);
            }
            
            
    		$filename = 'Acta de Devolución #' . $idDevolucion;
    		
    		if($salida == "view")
    		{
    		    $html = $this->pdf->generar($html, $filename, $stream = TRUE, $paper = 'A4', $orientation = "portrait");
    		    exit();
    		}
    		else if($salida == "html")
    		{
    		    return $html;
    		}
    		else if($salida == "download")
    		{
    		    $html = $this->pdf->generar($html, $filename, $salida, $paper = 'A4', $orientation = "portrait");
    		    exit();
    		}
    		else
    		{
    		    return $html;
    		}
    		
        }
    }

    public function adjuntarDocumentoDevolucion($idDevolucion)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $nombre         = $this->request->getPost('txtNombreAdjunto_i');
        $observacion    = $this->request->getPost('txtObservacionAdjunto_i');
        $reemplazafirma = $this->request->getPost('chkAdjuntoFirma');
        $adjunto        = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|minlength[9]|maxlength[50]', 'Nombre');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[itemsFile,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->getClientExtension() != null)
        {
            $extensionDoc = strtolower($adjunto->getClientExtension());
        }
        else if($adjunto->guessExtension() != null)
        {
            $extensionDoc = strtolower($adjunto->guessExtension());
        }
        else
        {
            $extensionDoc = strtolower(pathinfo($adjunto->getClientName(), PATHINFO_EXTENSION));
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDDevolucion'      => $idDevolucion, 
            'Nombre'            => $nombre, 
            'Extension'         => $extensionDoc,
            'Observacion'       => $observacion,
            'ReemplazoFirma'    => ((isset($reemplazafirma) && $reemplazafirma != null) ? 'Y' : 'N'),  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->devolucionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = $this->items['baseDinamic']."/docs/ActaDevolucion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
        $nombreArchivo = $idDevolucion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        $message = sprintf($this->mensajeError->msg201, "El archivo adjunto fue registrado exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
    public function enviarCorreoDevolucion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idDevolucion       = $this->request->getPost('idDevolucion');
        $devolucion         = $this->devoluciones->where("IDDevolucion", $idDevolucion)->first();
        $usuarioDevolucion  = $this->usuarios->buscarUsuario($devolucion['UsuarioDevolucion']);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
		*/

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-devolucion/".$idDevolucion."/".$devolucion['TokenLinkFirma'],
            'baseUrl'       => $this->items['baseUrl'],
            'basePublic'    => $this->items['basePublic'],
            'baseDinamic'   => $this->items['baseDinamic']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
		/*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
		*/

        $asunto='ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($usuarioDevolucion['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe", $this->items['correoElectronico']),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);

        if($estadoCorreo['ERROR'] != '')
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
            echo $this->alertas->alertaExito($message);
        }
        
    }
    
    public function recargarTablaDetalleElementosDevolucion()
    {
        $resultado['data'] = array();
            
        if(isset($this->items['id']))
        {
            $idDevolucion = $this->request->getPost('idDevolucion');
            
            $whereDevolucion = array(
    		    'IDDevolucion'  => $idDevolucion
    		);
    		
    		$listaDetalle = $this->devolucionesDetalle->listadoDetalleActaDevolucion($whereDevolucion);
    		
            foreach($listaDetalle as $key=>$detalle)
            {
                $validacion = '';
                $reposicion = '';
                
                if($detalle['Estado'] == "VALID")
                {
                    $validacion = '<span class="badge bg-success border-0">VALIDADO</span>';
                }
                else if($detalle['Estado'] == "NREQV")
                {
                    $validacion = '<span class="badge bg-dark border-0">NO REQUIERE</span>';
                }
                else
                {
                    $validacion = '<span class="badge bg-danger border-0">NO VALIDADO</span>';
                }
                
                if($detalle['IDDevolucion'] != "" || $detalle['IDDevolucion'] != NULL)
                {
                    $reposicion = '<span class="badge bg-success border-0">SI</span>';
                }
                else
                {
                    $reposicion = '<span class="badge bg-danger border-0">NO</span>';
                }
                
                $motivo = $this->globales->motivoEstadoMovil('')[$detalle['MotivoDevolucion']];
                
                $resultado['data'][$key] = array(
                    'codigo'        => (string) $detalle['IDDetalleDevolucion'],
    				'tipo_elemento' => (string) $detalle['TipoEquipo'],
    				'elemento'      => (string) $detalle['Marca'].' '.$detalle['Modelo'].' '.$detalle['Serie'],
                    'motivo'        => (string) $motivo,
    				'observacion'   => (string) $detalle['Observacion'],
    				'validacion'    => (string) $validacion,
    				'reposicion'    => (string) $reposicion
    			);
            }
            
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
        else 
		{
            $resultado['sesion'] = 0;
            
		    echo json_encode($resultado);
		}
    }
    
    public function validacionDetalleDevolucion($idDetalleDevolucion)
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $observacion    = $this->request->getPost('observacionValidacion');
        $recibido       = $this->request->getPost('elementoRecibido');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($observacion, 'required|trim', 'Observación');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $mensaje = $this->alertas->alertaError($message);
            
            
            $resultado = array(
    			'result'    => (string) 0,
    			'mensaje'   => (string) $mensaje
    		);
    		
    		echo json_encode($resultado);
    		
            EXIT;
        }

        /*
        * ----------------------------
        * REGISTRO DE VALIDACIÓN DETALLE DEVOLUCIÓN
        * ----------------------------
        */
        
        $dataDetalleDevolucion = array (
            'Estado'                => "VALID", 
            'UsuarioValidacion'     => $this->items['id'],
            'FechaValidado'         => $fechaActual,
            'ElementoRecibido'      => $recibido != "" ? "Y" : "N",
            'ObservacionValidado'   => $observacion
        );

        $lastId = $this->devolucionesDetalle->update([$idDetalleDevolucion], $dataDetalleDevolucion);
        
        if($lastId !== FALSE)
        {
            $message = sprintf($this->mensajeError->msg201, "Se validó el elemento exitosamente.");
            $mensaje = $this->alertas->alertaExito($message);
            $result = 1;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al validar el elemento. Inténtelo luego.[AD]</li>");
            $mensaje = $this->alertas->alertaError($message);
            $result = 0;
        }

        $resultado = array(
			'result'    => (string) $result,
			'mensaje'   => (string) $mensaje
		);
		
		echo json_encode($resultado);
    }
    
    public function validacionActivosDevolucion()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            /*
            * ----------------------------
            * DATOS DE AJAX PRE PROCESADOS
            * ----------------------------
            */
    
            $msjError       = TRUE;
            $idDevolucion  = $this->request->getPost('idDevolucion');
            
            $motivosDevolucion = $this->veriactivos->motivosDevolucion();
            /*
            * ----------------------------
            * CONSULTAS SQL
            * ----------------------------
            */
            
            $whereDevolucion = array(
    		    'IDDevolucion'  => $idDevolucion,
    		    'Estado'        => 'REGIS'
    		);
    		
    		$listaDetalle = $this->devolucionesDetalle->listadoDetalleActaDevolucion($whereDevolucion);

            /*
            * ----------------------------
            * ARMAR HTML
            * ----------------------------
            */
            
            $html .= '<div class="row col-12 m-0 p-0">';
            
            if(!empty($listaDetalle))
            {
                if(count($listaDetalle) == 1)
                {
                    $tamañoDiv = "col-xl-12";
                }
                else if(count($listaDetalle) == 2)
                {
                    $tamañoDiv = "col-xl-6";
                }
                else
                {
                    $tamañoDiv = "col-xl-4";
                }
                
                foreach($listaDetalle as $detalle)
                {
                    $border = !empty($detalle['FechaValidado']) ? "border-success-2px" : "border-gris-claro-2px";
                    $situacion = $detalle['MotivoDevolucion'] == "DEV" ? "ACT" : "BAJ";
                    
                    $html .= '<div class="'.$tamañoDiv.' col-lg-12">
                        <div class="card '.$border.'">
                            <div class="card-header">
                                <div class="d-flex">
                                    <h6 class="card-title flex-grow-1 mb-0">
                                        '.$detalle['TipoEquipo'].' - '.$detalle['Marca'].' '.$detalle['Modelo'].'
                                        <br>
                                        <small class="text-muted">'.$detalle['Serie'].'</small>
                                    </h6>
                                    <div class="flex-shrink-0 d-flex align-items-center justify-content-center">
                                        <a class="badge bg-primary-subtle text-primary fs-11">'.$motivosDevolucion[$detalle['MotivoDevolucion']].'</a>
                                        <input type="hidden" name="txtMotivoDevolucionValidacion['.$detalle['IDDetalleAsignacion'].']" value="'.$detalle['MotivoDevolucion'].'">
                                        <input type="hidden" name="txtIDDetalleDevolucion['.$detalle['IDDetalleAsignacion'].']" value="'.$detalle['IDDetalleDevolucion'].'">
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">';
                                if($detalle['Estado']==="REGIS")
                                {
                                    $html .= '<div class="row col-12 m-0 p-0 mb-2 d-flex">
                                        <div class="col-12">
                                            <h5 class="mb-1">Recepción de elemento</h5>
                                            <p class="color-red m-0">¿Recepcionó el activo indicado arriba?:</p>
                                        </div>
                                        <div class="row col-12 g-4 m-0 p-0">
                                            <div class="col-6 px-3 m-0 my-2">
                                                <div>
                                                    <div class="form-check card-radio">
                                                        <input id="rdbtnActivoRecibido_vda'.$detalle['IDDetalleAsignacion'].'" name="txtRecepcionElemento_vda['.$detalle['IDDetalleAsignacion'].']" type="radio" class="form-check-input rdbtnActivoRecibidoDevolucion" data-detalle-asignacion="'.$detalle['IDDetalleAsignacion'].'" value="Y">
                                                        <label class="form-check-label" for="rdbtnActivoRecibido_vda'.$detalle['IDDetalleAsignacion'].'">
                                                            <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-up align-bottom"></i></span>
                                                            <span class="fs-14 text-wrap">Si</span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-6 px-3 m-0 my-2">
                                                <div>
                                                    <div class="form-check card-radio">
                                                        <input id="rdbtnActivoNoRecibido_vda'.$detalle['IDDetalleAsignacion'].'" name="txtRecepcionElemento_vda['.$detalle['IDDetalleAsignacion'].']" type="radio" class="form-check-input rdbtnActivoRecibidoDevolucion" data-detalle-asignacion="'.$detalle['IDDetalleAsignacion'].'" value="N">
                                                        <label class="form-check-label" for="rdbtnActivoNoRecibido_vda'.$detalle['IDDetalleAsignacion'].'">
                                                            <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-down align-bottom"></i></span>
                                                            <span class="fs-14 text-wrap">No</span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse m-0 p-0" id="ctnEstadoRealDevolucion'.$detalle['IDDetalleAsignacion'].'" style="">
                                        <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                            <div class="col-12">
                                                <h5 class="mb-1">Estado Real de recepción</h5>
                                                <p class="color-red m-0">¿El estado real es el indicado arriba?:</p>
                                            </div>
                                            <div class="row col-12 g-4 m-0 p-0">
                                                <div class="col-6 px-3 m-0 my-2">
                                                    <div>
                                                        <div class="form-check card-radio">
                                                            <input id="rdbtnEstadoRealActivo_vda'.$detalle['IDDetalleAsignacion'].'" name="txtEstadoRealDevolucionActivo_vda['.$detalle['IDDetalleAsignacion'].']" type="radio" class="form-check-input rdbtnEstadoRealDevolucion" data-detalle-asignacion="'.$detalle['IDDetalleAsignacion'].'" data-situacion="'.$situacion.'" value="Y">
                                                            <label class="form-check-label" for="rdbtnEstadoRealActivo_vda'.$detalle['IDDetalleAsignacion'].'">
                                                                <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-up align-bottom"></i></span>
                                                                <span class="fs-14 text-wrap">Si</span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-6 px-3 m-0 my-2">
                                                    <div>
                                                        <div class="form-check card-radio">
                                                            <input id="rdbtnEstadoNoRealActivo_vda'.$detalle['IDDetalleAsignacion'].'" name="txtEstadoRealDevolucionActivo_vda['.$detalle['IDDetalleAsignacion'].']" type="radio" class="form-check-input rdbtnEstadoRealDevolucion" data-detalle-asignacion="'.$detalle['IDDetalleAsignacion'].'" data-situacion="'.$situacion.'" value="N">
                                                            <label class="form-check-label" for="rdbtnEstadoNoRealActivo_vda'.$detalle['IDDetalleAsignacion'].'">
                                                                <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-down align-bottom"></i></span>
                                                                <span class="fs-14 text-wrap">No</span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse m-0 p-0" id="ctnSelectEstadoRealDevolucion'.$detalle['IDDetalleAsignacion'].'" style="">
                                        <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                            <div class="col-12">
                                                <h5 class="mb-2">Seleccione el estado real</h5>
                                            </div>
                                            <div class="col-12 m-0 p-0 px-3">
                                                <div class="row col-12 card border shadow-none m-0 p-2">
                                                    <div class="col-12 mb-2">
                                                        <div>
                                                            <label for="txtSituacionRealDevuelto'.$detalle['IDDetalleAsignacion'].'" class="form-label">Estado real del activo devuelto</label>
                                                            <select class="form-select cboSituacionRealActivoDevuelto" aria-label="Estado real Activo" id="txtSituacionRealDevuelto'.$detalle['IDDetalleAsignacion'].'" name="txtSituacionRealDevuelto['.$detalle['IDDetalleAsignacion'].']" data-detalle-asignacion="'.$detalle['IDDetalleAsignacion'].'">
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse m-0 p-0" id="ctnObservacionValidacionDevolucion'.$detalle['IDDetalleAsignacion'].'" style="">
                                        <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                            <div class="col-12 m-0 p-0 px-3">
                                                <div class="row col-12 card border shadow-none m-0 p-2">
                                                    <div class="col-12 mb-2">
                                                        <div>
                                                            <label for="txtSituacionRealDevuelto'.$detalle['IDDetalleAsignacion'].'" class="form-label">Observación de Validación</label>
                                                            <textarea class="form-control validarNextTab" id="txtObservacionValidacionActivoDevolucion'.$detalle['IDDetalleAsignacion'].'" name="txtObservacionValidacionActivoDevolucion['.$detalle['IDDetalleAsignacion'].']" rows="4"></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="collapse m-0 p-0" id="ctnInformeRecepcionActivo'.$detalle['IDDetalleAsignacion'].'" style="">
                                        <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                            <div class="col-12">
                                                <h5 class="mb-2">Información para generar Informe de Recepción</h5>
                                            </div>
                                            <div class="col-12 m-0 p-0 px-3">
                                                <div class="row col-12 card border shadow-none m-0 p-2">
                                                    <div class="col-xl-12 col-md-12 col-12 mb-2">
                            							<div>
                            								<label class="form-label" >Tipo de Informe</label>
                            								<input type="hidden" name="txtTipoInforme['.$detalle['IDDetalleAsignacion'].']" value="DEVACT" >
                            								<input type="hidden" id="informe'.$detalle['IDDetalleAsignacion'].'" name="informe['.$detalle['IDDetalleAsignacion'].']" class="statusInforme" data-id="'.$detalle['IDDetalleAsignacion'].'">
                            								<input type="text" class="form-control" style="color: #0000FF" value="Devolución de Activo" disabled >
                            							</div>
                            						</div>
                            						<div class="col-12 m-0 p-0 my-2 p-3 border-sistema-2px" style="border-radius: 10px;">
                            							<div class="form-group row">
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label for="txtEtapaEvaluacion'.$detalle['IDDetalleAsignacion'].'0">Etapa</label>
                                                                    <input type="text" class="form-control" id="txtEtapaEvaluacion'.$detalle['IDDetalleAsignacion'].'0" name="txtEtapaEvaluacion['.$detalle['IDDetalleAsignacion'].'][]" placeholder="Recepción del Equipo IT" value="Recepción del Equipo IT">
                                                                </div>
                                                            </div>
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label for="txtFechaEvaluacion'.$detalle['IDDetalleAsignacion'].'0" class="form-label">Fecha</label>
                                                                    <div class="input-group mb-2">
                                                                        <div class="input-group-prepend">
                                                                            <div class="input-group-text"><span class="mdi mdi-calendar-month"></span></div>
                                                                        </div>
                                                                        <input type="date" class="form-control pull-right" id="txtFechaEvaluacion'.$detalle['IDDetalleAsignacion'].'0" name="txtFechaEvaluacion['.$detalle['IDDetalleAsignacion'].'][]" value="'.date('Y-m-d').'">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label for="txtDescripcionEvaluacion'.$detalle['IDDetalleAsignacion'].'0" class="form-label">Descripción</label>
                                                                    <textarea class="form-control" id="txtDescripcionEvaluacion'.$detalle['IDDetalleAsignacion'].'0" name="txtDescripcionEvaluacion['.$detalle['IDDetalleAsignacion'].'][]" rows="4" placeholder="Descripción de la evaluación"></textarea>
                                                                </div>
                                                            </div>
                            							</div>
                                                    </div>
                            						<div class="col-12 m-0 p-0 my-2 p-3 border-sistema-2px" style="border-radius: 10px;">
                            							<div class="form-group row">
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label for="txtEtapaEvaluacion'.$detalle['IDDetalleAsignacion'].'1">Etapa</label>
                                                                    <input type="text" class="form-control" id="txtEtapaEvaluacion'.$detalle['IDDetalleAsignacion'].'1" name="txtEtapaEvaluacion['.$detalle['IDDetalleAsignacion'].'][]" placeholder="Revisión del equipo devuelto - IT" value="Revisión del equipo devuelto - IT">
                                                                </div>
                                                            </div>
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label for="txtFechaEvaluacion'.$detalle['IDDetalleAsignacion'].'1" class="form-label">Fecha</label>
                                                                    <div class="input-group mb-2">
                                                                        <div class="input-group-prepend">
                                                                            <div class="input-group-text"><span class="mdi mdi-calendar-month"></span></div>
                                                                        </div>
                                                                        <input type="date" class="form-control pull-right" id="txtFechaEvaluacion'.$detalle['IDDetalleAsignacion'].'1" name="txtFechaEvaluacion['.$detalle['IDDetalleAsignacion'].'][]" value="'.date('Y-m-d').'">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label for="txtDescripcionEvaluacion'.$detalle['IDDetalleAsignacion'].'1" class="form-label">Descripción</label>
                                                                    <textarea class="form-control" id="txtDescripcionEvaluacion'.$detalle['IDDetalleAsignacion'].'1" name="txtDescripcionEvaluacion['.$detalle['IDDetalleAsignacion'].'][]" rows="4" placeholder="Descripción de la evaluación"></textarea>
                                                                </div>
                                                            </div>
                            							</div>
                                                    </div>
                            						<div class="col-12 m-0 p-0 my-2 p-3 border-sistema-2px" style="border-radius: 10px;">
                            							<div class="form-group row">
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label for="txtEtapaEvaluacion'.$detalle['IDDetalleAsignacion'].'2">Etapa</label>
                                                                    <input type="text" class="form-control" id="txtEtapaEvaluacion'.$detalle['IDDetalleAsignacion'].'2" name="txtEtapaEvaluacion['.$detalle['IDDetalleAsignacion'].'][]" placeholder="Resultado de la evaluación - IT" value="Resultado de la evaluación - IT">
                                                                </div>
                                                            </div>
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label for="txtFechaEvaluacion'.$detalle['IDDetalleAsignacion'].'2" class="form-label">Fecha</label>
                                                                    <div class="input-group mb-2">
                                                                        <div class="input-group-prepend">
                                                                            <div class="input-group-text"><span class="mdi mdi-calendar-month"></span></div>
                                                                        </div>
                                                                        <input type="date" class="form-control pull-right" id="txtFechaEvaluacion'.$detalle['IDDetalleAsignacion'].'2" name="txtFechaEvaluacion['.$detalle['IDDetalleAsignacion'].'][]" value="'.date('Y-m-d').'">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label for="txtDescripcionEvaluacion'.$detalle['IDDetalleAsignacion'].'2" class="form-label">Descripción</label>
                                                                    <textarea class="form-control" id="txtDescripcionEvaluacion'.$detalle['IDDetalleAsignacion'].'2" name="txtDescripcionEvaluacion['.$detalle['IDDetalleAsignacion'].'][]" rows="4" placeholder="Descripción de la evaluación"></textarea>
                                                                </div>
                                                            </div>
                            							</div>
                                                    </div>
                                                    <div class="col-12 m-0 p-0 my-2 p-3 border-sistema-2px" style="border-radius: 10px;">
                                                        <div class="col-12">
                                                            <div class="form-group">
                                                                <label>Importar Imágenes</label>
                                                                <input type="file" id="fileImgEvaluacion'.$detalle['IDDetalleAsignacion'].'" class="filepond" data-max-file-size="100MB" data-max-files="6" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 m-0 p-0 my-2 p-3 border-sistema-2px" style="border-radius: 10px;">
                                                        <div class="col-12">
                                                            <div class="form-group">
                                                                <label>Importar Adjuntos</label>
                                                                <input type="file" id="fileDocEvaluacion'.$detalle['IDDetalleAsignacion'].'" class="filepond" data-max-file-size="100MB" data-max-files="6" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <script>
                                                        $(function () {
                                                            pondImgEvaluacion'.$detalle['IDDetalleAsignacion'].' = FilePond.create(
                                                                document.querySelector("#fileImgEvaluacion'.$detalle['IDDetalleAsignacion'].'"), {
                                                                    labelIdle: \'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>\',
                                                                    allowMultiple: true,
                                                                    maxFiles: 6,
                                                                    instantUpload: false,
                                                                    allowProcess: false,
                                                                    acceptedFileTypes: ["image/*"],
                                                                    onaddfile: (error, file) => 
                                                                    {
                                                                        if (error) 
                                                                        {
                                                                            Swal.fire({
                                                                                text: "Solo se permiten archivos de imagen (jpg, jpeg, png, gif, bmp).",
                                                                                icon: "warning",
                                                                                confirmButtonColor: "#282e38",
                                                                                confirmButtonText: "OK"
                                                                            });
                                                                            // Remover archivo
                                                                            pondImgEvaluacion'.$detalle['IDDetalleAsignacion'].'.removeFile(file.id);
                                                                            return;
                                                                            
                                                                        }
                                                                        const allowedExtensions = /(\.jpg|\.jpeg|\.png|\.gif|\.bmp)$/i;
                                                                        if (!allowedExtensions.exec(file.filename)) 
                                                                        {
                                                                            Swal.fire({
                                                                                text: "Solo se permiten archivos de imagen (jpg, jpeg, png, gif, bmp).",
                                                                                icon: "warning",
                                                                                confirmButtonColor: "#282e38",
                                                                                confirmButtonText: "OK"
                                                                            });
                                                                            // Remover archivo
                                                                            pondImgEvaluacion'.$detalle['IDDetalleAsignacion'].'.removeFile(file.id);
                                                                        }
                                                                    }
                                                                }
                                                            );
                                                            
                                                            pondDocEvaluacion'.$detalle['IDDetalleAsignacion'].' = FilePond.create(
                                                                document.querySelector("#fileDocEvaluacion'.$detalle['IDDetalleAsignacion'].'"), {
                                                                    labelIdle: \'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>\',
                                                                    allowMultiple: true,
                                                                    maxFiles: 6,
                                                                    instantUpload: false,
                                                                    allowProcess: false,
                                                                    acceptedFileTypes: ["application/pdf"],
                                                                    onaddfile: (error, file) => 
                                                                    {
                                                                        if (error) 
                                                                        {
                                                                            Swal.fire({
                                                                                text: "Solo se permiten archivos PDF.",
                                                                                icon: "warning",
                                                                                confirmButtonColor: "#282e38",
                                                                                confirmButtonText: "OK"
                                                                            });
                                                                            // Remover archivo
                                                                            pondDocEvaluacion'.$detalle['IDDetalleAsignacion'].'.removeFile(file.id);
                                                                            return;
                                                                            
                                                                        }
                                                                        const allowedExtensions = /(\.pdf)$/i;
                                                                        if (!allowedExtensions.exec(file.filename)) 
                                                                        {
                                                                            Swal.fire({
                                                                                text: "Solo se permiten archivos PDF.",
                                                                                icon: "warning",
                                                                                confirmButtonColor: "#282e38",
                                                                                confirmButtonText: "OK"
                                                                            });
                                                                            // Remover archivo
                                                                            pondDocEvaluacion'.$detalle['IDDetalleAsignacion'].'.removeFile(file.id);
                                                                        }
                                                                    }
                                                                }
                                                            );
                                                        });
                                                    </script>
                                                </div>
                                            </div>
                                        </div>
                                    </div>';
                                }
                                else if($detalle['Estado']==="NREQV")
                                {
                                    $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                                        <div class="col-xxl-10 col-md-12 col-12 ">
                                            <div class="alert alert-dark alert-border-left fade show mb-xl-0 text-center" role="alert">
                                                <strong>NO REQUIERE VALIDACIÓN</strong><br>Activo no requiere validación.
                                            </div>
                                        </div>
                                    </div>';
                                }
                                else
                                {
                                    $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                                        <div class="col-xxl-10 col-md-12 col-12 ">
                                            <div class="alert alert-success alert-border-left fade show mb-xl-0 text-center" role="alert">
                                                <i class="ri-error-success-line me-3 align-middle fs-16"></i><strong>VALIDADO</strong> - Activo Validado.
                                            </div>
                                        </div>
                                    </div>';
                                }
                            $html .= '</div>
                        </div>
                    </div>';
                }
                
            }
            else
            {
                $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 justify-content-center align-items-center" style="border-radius: 10px;">
                    <div class="col-xxl-10 col-md-12 col-12 ">
                        <div class="alert alert-dark alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>NO SE ENCONTRARON ACTIVOS</strong> - Comunicarse con desarrollo para validar la información.
                        </div>
                    </div>
                </div>';
            }
            
            $html .= '</div>';
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function registroValidacionActivosDevolucion()
    {
        //FALTA VALIDACIÓN DE CESE 24 HORAS SINO GENERAR REPOSICIÓN Y ENVIAR A CORREO DE USUARIO
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        // var_dump($this->request->getPost());exit;
        
        $msjError = TRUE;
        $idDevolucion           = $this->request->getPost('txtIDDevolucion_vda');
        $idDetalleDevolucion    = $this->request->getPost('txtIDDetalleDevolucion');
        $recepcionElemento      = $this->request->getPost('txtRecepcionElemento_vda'); //Decisión Si-No de recepción de activo (checkbox)
        $estadoRealElemento     = $this->request->getPost('txtEstadoRealDevolucionActivo_vda'); //Decisión Si-No de estado real (checkbox)
        $situacionReal          = $this->request->getPost('txtSituacionRealDevuelto'); //Estado real en el que ha llegado el activo (combobox)
        $motivoDevolucion       = $this->request->getPost('txtMotivoDevolucionValidacion'); //Estado colocado al momento de generar el acta de devolución
        $observacionValidacion  = $this->request->getPost('txtObservacionValidacionActivoDevolucion');
        $tipoInforme            = $this->request->getPost('txtTipoInforme');
        $generaInforme          = $this->request->getPost('informe');
        
        $etapaEvaluacion        = $this->request->getPost('txtEtapaEvaluacion');
        $fechaEvaluacion        = $this->request->getPost('txtFechaEvaluacion');
        $descripcionEvaluacion  = $this->request->getPost('txtDescripcionEvaluacion');
        
        $adjuntosTotales        = $this->request->getFiles();
        
        $imagenesEvaluacion     = isset($adjuntosTotales["imagenesEvaluacion"]) ? $adjuntosTotales["imagenesEvaluacion"] : "";
        $adjuntoEvaluacion      = isset($adjuntosTotales["pdfEvaluacion"]) ? $adjuntosTotales["pdfEvaluacion"] : "";
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        
        if(empty($recepcionElemento))
        {
            $error .= "<li>Debe seleccionar la recepción de un activo como mínimo.</li>";
        }
        else
        {
            foreach($recepcionElemento as $idDetalle => $valor)
            {
                if($valor === "N")
                {
                    if(!(array_key_exists($idDetalle, $situacionReal)))
                    {
                        $error .= "<li>Debe seleccionar el estado real de la no recepción del activo.</li>";
                    }
                    
                    if($etapaEvaluacion[$idDetalle][0]=='' || $etapaEvaluacion[$idDetalle][1]=='' || $etapaEvaluacion[$idDetalle][2]=='')
                    {
                        $error .= "<li>Debe ingresar la etapa de evaluación de la no recepción del activo.</li>";
                    }
                    
                    if($fechaEvaluacion[$idDetalle][0]=='' || $fechaEvaluacion[$idDetalle][1]=='' || $fechaEvaluacion[$idDetalle][2]=='')
                    {
                        $error .= "<li>Debe ingresar la fecha de evaluación de la no recepción del activo.</li>";
                    }
                    
                    if($descripcionEvaluacion[$idDetalle][0]=='' || $descripcionEvaluacion[$idDetalle][1]=='' || $descripcionEvaluacion[$idDetalle][2]=='')
                    {
                        $error .= "<li>Debe ingresar la descripción de evaluación de la no recepción del activo.</li>";
                    }
                }
                else
                {
                    if(empty($estadoRealElemento))
                    {
                        $error .= "<li>Debe responder si es el estado real del activo recibido.</li>";
                    }
                    else if(!(array_key_exists($idDetalle, $estadoRealElemento)))
                    {
                        $error .= "<li>Debe responder si es el estado real del activo recibido.</li>";
                    }
                    else
                    {
                        if($estadoRealElemento[$idDetalle] === "Y")
                        {
                            if($generaInforme[$idDetalle] !== "GENERA")
                            {
                                if($observacionValidacion[$idDetalle] == '')
                                {
                                    $error .= "<li>Debe colocar una observación del activo recibido con estado correcto.</li>";
                                }
                            }
                            else
                            {
                                if($etapaEvaluacion[$idDetalle][0]=='' || $etapaEvaluacion[$idDetalle][1]=='' || $etapaEvaluacion[$idDetalle][2]=='')
                                {
                                    $error .= "<li>Debe ingresar la etapa de evaluación de recepción del activo.</li>";
                                }
                                
                                if($fechaEvaluacion[$idDetalle][0]=='' || $fechaEvaluacion[$idDetalle][1]=='' || $fechaEvaluacion[$idDetalle][2]=='')
                                {
                                    $error .= "<li>Debe ingresar la fecha de evaluación de recepción del activo.</li>";
                                }
                                
                                if($descripcionEvaluacion[$idDetalle][0]=='' || $descripcionEvaluacion[$idDetalle][1]=='' || $descripcionEvaluacion[$idDetalle][2]=='')
                                {
                                    $error .= "<li>Debe ingresar la descripción de evaluación de recepción del activo.</li>";
                                }
                            }
                        }
                        else
                        {
                            if(!(array_key_exists($idDetalle, $situacionReal)))
                            {
                                $error .= "<li>Debe seleccionar el estado real del activo recibido.</li>";
                            }
                            else if($situacionReal[$idDetalle] == "")
                            {
                                $error .= "<li>Debe seleccionar el estado real del activo recibido.</li>";
                            }
                            else
                            {
                                if($situacionReal[$idDetalle] == $motivoDevolucion[$idDetalle])
                                {
                                    $error .= "<li>El estado real del activo recibido no puede ser el mismo que el seleccionado en el acta de devolución.</li>";
                                }
                                
                                if($situacionReal[$idDetalle] == "DEV")
                                {
                                    if($observacionValidacion[$idDetalle] == '')
                                    {
                                        $error .= "<li>Debe colocar una observación del activo devuelto en óptimas condiciones.</li>";
                                    }
                                }
                                else
                                {
                                    
                                    if($etapaEvaluacion[$idDetalle][0]=='' || $etapaEvaluacion[$idDetalle][1]=='' || $etapaEvaluacion[$idDetalle][2]=='')
                                    {
                                        $error .= "<li>Debe ingresar la etapa de evaluación de recepción del activo.</li>";
                                    }
                                    
                                    if($fechaEvaluacion[$idDetalle][0]=='' || $fechaEvaluacion[$idDetalle][1]=='' || $fechaEvaluacion[$idDetalle][2]=='')
                                    {
                                        $error .= "<li>Debe ingresar la fecha de evaluación de recepción del activo.</li>";
                                    }
                                    
                                    if($descripcionEvaluacion[$idDetalle][0]=='' || $descripcionEvaluacion[$idDetalle][1]=='' || $descripcionEvaluacion[$idDetalle][2]=='')
                                    {
                                        $error .= "<li>Debe ingresar la descripción de evaluación de recepción del activo.</li>";
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * EJECUCIÓN DE TRANSACCIÓN
        * ----------------------------
        */
        
        // $dataDetalleInforme = array();
        $dataDetalleEvaluacionInforme = array();
        $dataUpdateDetalleDevolucion = array();
        $nombresAdjuntos = array();
        
        try 
        {
            //INICIO DE TRANSACCIÓN
            $this->db->transBegin();
            
            if(in_array('GENERA', $generaInforme))
            {
                //VALIDAR EXISTENCIA DE INFORME
                $informeDevolucion = $this->informeDevolucion->where('IDDevolucion', $idDevolucion)->first();
                
                if(empty($informeDevolucion))
                {
                    //ARMADO DE VALORES DE INFORME DE DEVOLUCIÓN
                    $dataInforme = array (
                        'TipoInforme'       => 'DEVACT',
                        'IDDevolucion'      => $idDevolucion,
                        'UsuarioCrea'       => $this->items['id'],
                        'IDDireccionCrea'   => $this->items['dpto'],
                        'IDAreaCrea'        => $this->items['idArea'],
                        'IDSubareaCrea'     => $this->items['idSubarea'],
                        'IDDelegacionCrea'  => $this->items['idDelegacionLog'],
                        'IDCargoCrea'       => $this->items['idCargoLog'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress(),
                        'Estado'            => 'REGI'
                    );
                    
                    $idInforme = $this->informeDevolucion->insert($dataInforme, TRUE);
                }
                else
                {
                    $idInforme = $informeDevolucion['IDInforme'];
                }
            }
            
            //ARMAR VALORES DE DETALLE DE INFORME DE DEVOLUCIÓN

            foreach($recepcionElemento as $idDetalle => $valor)
            {
                if($valor === "N")
                {
                    /*
                    * ----------------------------
                    * SI NO RECEPCIONA EL ELEMENTO, SE ACTUALIZA EL ESTADO DE VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN
                    * SE GENERA INFORME CON EL NUEVO ESTADO COMO NO RECIBIDO Y SE DA DE BAJA EL ACTIVO POR NO RECIBIDO
                    * ----------------------------
                    */
                    
                    //ARMAR VALORES PARA ACTUALIZAR VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN (UPDATE MASIVO)
                    $dataUpdateDetalleDevolucion[] = array(
                        'IDDetalleDevolucion'   => $idDetalleDevolucion[$idDetalle],
                        'Estado'                => "VALID", 
                        'UsuarioValidacion'     => $this->items['id'],
                        'FechaValidado'         => $fechaActual,
                        'ElementoRecibido'      => "N",
                        'ObservacionValidado'   => "Validación generada vía informe de devolución."
                    );
                    
                    //ARMAR VALORES PARA DETALLE DE INFORME DE NO RECEPCIÓN DE ELEMENTO
                    $insertDetalleInforme = array (
                        'IDInforme'             => $idInforme,
                        'IDDetalleAsignacion'   => $idDetalle,
                        'MotivoRealDevolucion'  => $situacionReal[$idDetalle],
                        'UsuarioCrea'           => $this->items['id'],
                        'IDDireccionCrea'       => $this->items['dpto'],
                        'IDAreaCrea'            => $this->items['idArea'],
                        'IDSubareaCrea'         => $this->items['idSubarea'],
                        'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                        'IDCargoCrea'           => $this->items['idCargoLog'],
                        'FechaCrea'             => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress(),
                        'Estado'                => 'REGI'
                    );
                    
                    //INSERTAR DETALLE DE INFORME PARA OBTENER EL ID RESPECTIVO
                    $idDetalleInforme = $this->informeDevolucionDetalle->insert($insertDetalleInforme, TRUE);
                    
                    //ARMAR VALORES PARA EVALUACION DETALLE INFORME DEVOLUCIÓN (INSERT MASIVO)
                    $dataDetalleEvaluacionInforme[] = array (
                        'IDDetalleInforme'      => $idDetalleInforme,
                        'EtapaEvaluacion'       => $etapaEvaluacion[$idDetalle][0],
                        'FechaEvaluacion'       => $fechaEvaluacion[$idDetalle][0],
                        'DescripcionEvaluacion' => $descripcionEvaluacion[$idDetalle][0],
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress(),
                        'Estado'                => 'CREA'
                    );
                    $dataDetalleEvaluacionInforme[] = array (
                        'IDDetalleInforme'      => $idDetalleInforme,
                        'EtapaEvaluacion'       => $etapaEvaluacion[$idDetalle][1],
                        'FechaEvaluacion'       => $fechaEvaluacion[$idDetalle][1],
                        'DescripcionEvaluacion' => $descripcionEvaluacion[$idDetalle][1],
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress(),
                        'Estado'                => 'CREA'
                    );
                    $dataDetalleEvaluacionInforme[] = array (
                        'IDDetalleInforme'      => $idDetalleInforme,
                        'EtapaEvaluacion'       => $etapaEvaluacion[$idDetalle][2],
                        'FechaEvaluacion'       => $fechaEvaluacion[$idDetalle][2],
                        'DescripcionEvaluacion' => $descripcionEvaluacion[$idDetalle][2],
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress(),
                        'Estado'                => 'CREA'
                    );
                    
                    //EVALUAMOS SI HAY IMÁGENES O ARCHIVOS ADJUNTOS PARA INSERTAR...
                    if(!empty($imagenesEvaluacion) && isset($imagenesEvaluacion[$idDetalle]))
                    {
                        foreach ($imagenesEvaluacion[$idDetalle] as $key => $value) 
            	        {
                            if ($value->isValid() && ! $value->hasMoved()) 
                            {
                                //OBTENGO LA EXTENSIÓN DEL ADJUNTO A REGISTRAR
                                if($value->getClientExtension() != null)
                                {
                                    $extAdjunto = strtolower($value->getClientExtension());
                                }
                                else if($value->guessExtension() != null)
                                {
                                    $extAdjunto = strtolower($value->guessExtension());
                                }
                                else
                                {
                                    $extAdjunto = strtolower(pathinfo($value->getClientName(), PATHINFO_EXTENSION));
                                }
                                
                                //OBTENGO EL NOMBRE DEL ADJUNTO A REGISTRAR
                                $nombreAdjunto = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                                
                                //ARMADO DE VALORES DEL ADJUNTO A REGISTRAR
                                $dataAdjunto = array (
                                    'IDDetalleInforme'      => $idDetalleInforme, 
                                    'Nombre'                => $nombreAdjunto,
                                    'Extension'             => $extAdjunto,
                                    'Token'                 => $this->complementos->generar_string_aleatorio(5),
                                    'UsuarioCrea'           => $this->items['id'],
                                    'FechaCrea'             => $fechaActual,
                                    'Localhost'             => $this->request->getIPAddress()
                                );
                                
                                $lastIdAdjunto = $this->informeDevolucionDetalleAdjuntos->insert($dataAdjunto, TRUE);
                                
                                //ASIGNAMOS LA NUEVA RUTA DONDE SE VA A GUARDAR EL ADJUNTO A REGISTRAR
                                $ruta = $this->items['baseDinamic']."/docs/InformeDevolucion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                                
                                //VALIDAR Y CREAR CARPETA SI NO EXISTE
                                if (!is_dir($ruta)) 
                                {
                                    if (!mkdir($ruta, 0777, true)) 
                                    {
                                        // Si no se puede crear la carpeta, cancelar
                                        $this->db->transRollback();
                                        
                                        if(!empty($nombresAdjuntos))
                                        {
                                            // Eliminar archivos guardados
                                            foreach ($nombresAdjuntos as $archivoGuardado) 
                                            {
                                                if (file_exists($ruta.$archivoGuardado)) 
                                                {
                                                    unlink($archivoGuardado);
                                                }
                                            }
                                        }
                                        
                                        $message = sprintf($this->mensajeError->msg201, "<li>No se pudo crear el directorio de almacenamiento. Inténtelo luego[ERRALMC]</li>");
                                        echo $this->alertas->alertaError($message);
                                        EXIT;
                                    }
                                }
                                
                                //ASIGNAR EL NUEVO NOMBRE
                                $nuevonombre =  $idInforme.'-'.$idDetalleInforme.'-'.$lastIdAdjunto.'.'.$extAdjunto;
                                $nombresAdjuntos[] = $nuevonombre;
                                
                                //INTENTAR MOVER EL ARCHIVO
                                try 
                                {
                                    $value->move($ruta, $nuevonombre);
                                } 
                                catch (\Exception $e) 
                                {
                                    $this->db->transRollback();
                                    
                                    if(!empty($nombresAdjuntos))
                                    {
                                        // Eliminar archivos guardados
                                        foreach ($nombresAdjuntos as $archivoGuardado) 
                                        {
                                            if (file_exists($ruta.$archivoGuardado)) 
                                            {
                                                unlink($archivoGuardado);
                                            }
                                        }
                                    }
                                    
                                    $message = sprintf($this->mensajeError->msg201, "<li>Error al guardar el archivo: ".$e->getMessage().". Inténtelo luego[ERRALMC]</li>");
                                    echo $this->alertas->alertaError($message);
                                    EXIT;
                                }
                                
                            }
            	        }
                    }
                    
                    if(!empty($adjuntoEvaluacion) && isset($adjuntoEvaluacion[$idDetalle]))
                    {
                        foreach ($adjuntoEvaluacion[$idDetalle] as $key => $value) 
            	        {
                            if ($value->isValid() && ! $value->hasMoved()) 
                            {
                                //OBTENGO LA EXTENSIÓN DEL ADJUNTO A REGISTRAR
                                if($value->getClientExtension() != null)
                                {
                                    $extAdjunto = strtolower($value->getClientExtension());
                                }
                                else if($value->guessExtension() != null)
                                {
                                    $extAdjunto = strtolower($value->guessExtension());
                                }
                                else
                                {
                                    $extAdjunto = strtolower(pathinfo($value->getClientName(), PATHINFO_EXTENSION));
                                }
                                
                                //OBTENGO EL NOMBRE DEL ADJUNTO A REGISTRAR
                                $nombreAdjunto = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                                
                                //ARMADO DE VALORES DEL ADJUNTO A REGISTRAR
                                $dataAdjunto = array (
                                    'IDDetalleInforme'      => $idDetalleInforme, 
                                    'Nombre'                => $nombreAdjunto,
                                    'Extension'             => $extAdjunto,
                                    'Token'                 => $this->complementos->generar_string_aleatorio(5),
                                    'UsuarioCrea'           => $this->items['id'],
                                    'FechaCrea'             => $fechaActual,
                                    'Localhost'             => $this->request->getIPAddress()
                                );
                                
                                $lastIdAdjunto = $this->informeDevolucionDetalleAdjuntos->insert($dataAdjunto, TRUE);
                                
                                //ASIGNAMOS LA NUEVA RUTA DONDE SE VA A GUARDAR EL ADJUNTO A REGISTRAR
                                $ruta = $this->items['baseDinamic']."/docs/InformeDevolucion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                                
                                //VALIDAR Y CREAR CARPETA SI NO EXISTE
                                if (!is_dir($ruta)) 
                                {
                                    if (!mkdir($ruta, 0777, true)) 
                                    {
                                        // Si no se puede crear la carpeta, cancelar
                                        $this->db->transRollback();
                                        
                                        if(!empty($nombresAdjuntos))
                                        {
                                            // Eliminar archivos guardados
                                            foreach ($nombresAdjuntos as $archivoGuardado) 
                                            {
                                                if (file_exists($ruta.$archivoGuardado)) 
                                                {
                                                    unlink($archivoGuardado);
                                                }
                                            }
                                        }
                                        
                                        $message = sprintf($this->mensajeError->msg201, "<li>No se pudo crear el directorio de almacenamiento. Inténtelo luego[ERRALMC]</li>");
                                        echo $this->alertas->alertaError($message);
                                        EXIT;
                                    }
                                }
                                
                                //ASIGNAR EL NUEVO NOMBRE
                                $nuevonombre =  $idInforme.'-'.$idDetalleInforme.'-'.$lastIdAdjunto.'.'.$extAdjunto;
                                $nombresAdjuntos[] = $nuevonombre;
                                
                                //INTENTAR MOVER EL ARCHIVO
                                try 
                                {
                                    $value->move($ruta, $nuevonombre);
                                } 
                                catch (\Exception $e) 
                                {
                                    $this->db->transRollback();
                                    
                                    if(!empty($nombresAdjuntos))
                                    {
                                        // Eliminar archivos guardados
                                        foreach ($nombresAdjuntos as $archivoGuardado) 
                                        {
                                            if (file_exists($ruta.$archivoGuardado)) 
                                            {
                                                unlink($archivoGuardado);
                                            }
                                        }
                                    }
                                    
                                    $message = sprintf($this->mensajeError->msg201, "<li>Error al guardar el archivo: ".$e->getMessage().". Inténtelo luego[ERRALMC]</li>");
                                    echo $this->alertas->alertaError($message);
                                    EXIT;
                                }
                                
                            }
            	        }
                    }
                }
                else
                {
                    if($estadoRealElemento[$idDetalle] === "Y")
                    {
                        if($generaInforme[$idDetalle] !== "GENERA")
                        {
                            /*
                            * ----------------------------
                            * SI RECEPCIONA EL ELEMENTO, EL ESTADO REAL DE RECEPCIÓN ES EL MISMO DEL ESTADO DE DEVOLUCIÓN Y NO GENERA INFORME (EL ELEMENTO SIGUE ACTIVO) 
                            * SE ACTUALIZA EL ESTADO DE VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN SIN GENERAR INFORME DE DEVOLUCIÓN
                            * ----------------------------
                            */
                            
                            //ARMAR VALORES PARA ACTUALIZAR VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN (UPDATE MASIVO)
                            $dataUpdateDetalleDevolucion[] = array(
                                'IDDetalleDevolucion'   => $idDetalleDevolucion[$idDetalle],
                                'Estado'                => "VALID", 
                                'UsuarioValidacion'     => $this->items['id'],
                                'FechaValidado'         => $fechaActual,
                                'ElementoRecibido'      => "Y",
                                'ObservacionValidado'   => $observacionValidacion[$idDetalle]
                            );
                        }
                        else
                        {
                            /*
                            * ----------------------------
                            * SI RECEPCIONA EL ELEMENTO, EL ESTADO REAL DE RECEPCIÓN ES EL MISMO DEL ESTADO DE DEVOLUCIÓN Y GENERA INFORME
                            * (EL ELEMENTO SE DIO DE BAJA EN EL ACTA DE DEVOLUCIÓN) 
                            * SE ACTUALIZA EL ESTADO DE VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN GENERANDO INFORME DE DEVOLUCIÓN
                            * ----------------------------
                            */
                            
                            //ARMAR VALORES PARA ACTUALIZAR VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN (UPDATE MASIVO)
                            $dataUpdateDetalleDevolucion[] = array(
                                'IDDetalleDevolucion'   => $idDetalleDevolucion[$idDetalle],
                                'Estado'                => "VALID", 
                                'UsuarioValidacion'     => $this->items['id'],
                                'FechaValidado'         => $fechaActual,
                                'ElementoRecibido'      => "Y",
                                'ObservacionValidado'   => "Validación generada vía informe de devolución."
                            );
                            
                            //ARMAR VALORES PARA DETALLE DE INFORME DE NO RECEPCIÓN DE ELEMENTO
                            $insertDetalleInforme = array (
                                'IDInforme'             => $idInforme,
                                'IDDetalleAsignacion'   => $idDetalle,
                                'UsuarioCrea'           => $this->items['id'],
                                'IDDireccionCrea'       => $this->items['dpto'],
                                'IDAreaCrea'            => $this->items['idArea'],
                                'IDSubareaCrea'         => $this->items['idSubarea'],
                                'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                                'IDCargoCrea'           => $this->items['idCargoLog'],
                                'FechaCrea'             => $fechaActual,    
                                'Localhost'             => $this->request->getIPAddress(),
                                'Estado'                => 'REGI'
                            );
                            
                            //INSERTAR DETALLE DE INFORME PARA OBTENER EL ID RESPECTIVO
                            $idDetalleInforme = $this->informeDevolucionDetalle->insert($insertDetalleInforme, TRUE);
                            
                            //ARMAR VALORES PARA EVALUACION DETALLE INFORME DEVOLUCIÓN (INSERT MASIVO)
                            $dataDetalleEvaluacionInforme[] = array (
                                'IDDetalleInforme'      => $idDetalleInforme,
                                'EtapaEvaluacion'       => $etapaEvaluacion[$idDetalle][0],
                                'FechaEvaluacion'       => $fechaEvaluacion[$idDetalle][0],
                                'DescripcionEvaluacion' => $descripcionEvaluacion[$idDetalle][0],
                                'UsuarioCrea'           => $this->items['id'],
                                'FechaCrea'             => $fechaActual,    
                                'Localhost'             => $this->request->getIPAddress(),
                                'Estado'                => 'CREA'
                            );
                            $dataDetalleEvaluacionInforme[] = array (
                                'IDDetalleInforme'      => $idDetalleInforme,
                                'EtapaEvaluacion'       => $etapaEvaluacion[$idDetalle][1],
                                'FechaEvaluacion'       => $fechaEvaluacion[$idDetalle][1],
                                'DescripcionEvaluacion' => $descripcionEvaluacion[$idDetalle][1],
                                'UsuarioCrea'           => $this->items['id'],
                                'FechaCrea'             => $fechaActual,    
                                'Localhost'             => $this->request->getIPAddress(),
                                'Estado'                => 'CREA'
                            );
                            $dataDetalleEvaluacionInforme[] = array (
                                'IDDetalleInforme'      => $idDetalleInforme,
                                'EtapaEvaluacion'       => $etapaEvaluacion[$idDetalle][2],
                                'FechaEvaluacion'       => $fechaEvaluacion[$idDetalle][2],
                                'DescripcionEvaluacion' => $descripcionEvaluacion[$idDetalle][2],
                                'UsuarioCrea'           => $this->items['id'],
                                'FechaCrea'             => $fechaActual,    
                                'Localhost'             => $this->request->getIPAddress(),
                                'Estado'                => 'CREA'
                            );
                            
                            
                            //EVALUAMOS SI HAY IMÁGENES O ARCHIVOS ADJUNTOS PARA INSERTAR...
                            if(!empty($imagenesEvaluacion) && isset($imagenesEvaluacion[$idDetalle]))
                            {
                                foreach ($imagenesEvaluacion[$idDetalle] as $key => $value) 
                    	        {
                                    if ($value->isValid() && ! $value->hasMoved()) 
                                    {
                                        //OBTENGO LA EXTENSIÓN DEL ADJUNTO A REGISTRAR
                                        if($value->getClientExtension() != null)
                                        {
                                            $extAdjunto = strtolower($value->getClientExtension());
                                        }
                                        else if($value->guessExtension() != null)
                                        {
                                            $extAdjunto = strtolower($value->guessExtension());
                                        }
                                        else
                                        {
                                            $extAdjunto = strtolower(pathinfo($value->getClientName(), PATHINFO_EXTENSION));
                                        }
                                        
                                        //OBTENGO EL NOMBRE DEL ADJUNTO A REGISTRAR
                                        $nombreAdjunto = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                                        
                                        //ARMADO DE VALORES DEL ADJUNTO A REGISTRAR
                                        $dataAdjunto = array (
                                            'IDDetalleInforme'      => $idDetalleInforme, 
                                            'Nombre'                => $nombreAdjunto,
                                            'Extension'             => $extAdjunto,
                                            'Token'                 => $this->complementos->generar_string_aleatorio(5),
                                            'UsuarioCrea'           => $this->items['id'],
                                            'FechaCrea'             => $fechaActual,
                                            'Localhost'             => $this->request->getIPAddress()
                                        );
                                        
                                        $lastIdAdjunto = $this->informeDevolucionDetalleAdjuntos->insert($dataAdjunto, TRUE);
                                        
                                        //ASIGNAMOS LA NUEVA RUTA DONDE SE VA A GUARDAR EL ADJUNTO A REGISTRAR
                                        $ruta = $this->items['baseDinamic']."/docs/InformeDevolucion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                                        
                                        //VALIDAR Y CREAR CARPETA SI NO EXISTE
                                        if (!is_dir($ruta)) 
                                        {
                                            if (!mkdir($ruta, 0777, true)) 
                                            {
                                                // Si no se puede crear la carpeta, cancelar
                                                $this->db->transRollback();
                                                
                                                if(!empty($nombresAdjuntos))
                                                {
                                                    // Eliminar archivos guardados
                                                    foreach ($nombresAdjuntos as $archivoGuardado) 
                                                    {
                                                        if (file_exists($ruta.$archivoGuardado)) 
                                                        {
                                                            unlink($archivoGuardado);
                                                        }
                                                    }
                                                }
                                                
                                                $message = sprintf($this->mensajeError->msg201, "<li>No se pudo crear el directorio de almacenamiento. Inténtelo luego[ERRALMC]</li>");
                                                echo $this->alertas->alertaError($message);
                                                EXIT;
                                            }
                                        }
                                        
                                        //ASIGNAR EL NUEVO NOMBRE
                                        $nuevonombre =  $idInforme.'-'.$idDetalleInforme.'-'.$lastIdAdjunto.'.'.$extAdjunto;
                                        $nombresAdjuntos[] = $nuevonombre;
                                        
                                        //INTENTAR MOVER EL ARCHIVO
                                        try 
                                        {
                                            $value->move($ruta, $nuevonombre);
                                        } 
                                        catch (\Exception $e) 
                                        {
                                            $this->db->transRollback();
                                            
                                            if(!empty($nombresAdjuntos))
                                            {
                                                // Eliminar archivos guardados
                                                foreach ($nombresAdjuntos as $archivoGuardado) 
                                                {
                                                    if (file_exists($ruta.$archivoGuardado)) 
                                                    {
                                                        unlink($archivoGuardado);
                                                    }
                                                }
                                            }
                                            
                                            $message = sprintf($this->mensajeError->msg201, "<li>Error al guardar el archivo: ".$e->getMessage().". Inténtelo luego[ERRALMC]</li>");
                                            echo $this->alertas->alertaError($message);
                                            EXIT;
                                        }
                                        
                                    }
                    	        }
                            }
                            
                            if(!empty($adjuntoEvaluacion) && isset($adjuntoEvaluacion[$idDetalle]))
                            {
                                foreach ($adjuntoEvaluacion[$idDetalle] as $key => $value) 
                    	        {
                                    if ($value->isValid() && ! $value->hasMoved()) 
                                    {
                                        //OBTENGO LA EXTENSIÓN DEL ADJUNTO A REGISTRAR
                                        if($value->getClientExtension() != null)
                                        {
                                            $extAdjunto = strtolower($value->getClientExtension());
                                        }
                                        else if($value->guessExtension() != null)
                                        {
                                            $extAdjunto = strtolower($value->guessExtension());
                                        }
                                        else
                                        {
                                            $extAdjunto = strtolower(pathinfo($value->getClientName(), PATHINFO_EXTENSION));
                                        }
                                        
                                        //OBTENGO EL NOMBRE DEL ADJUNTO A REGISTRAR
                                        $nombreAdjunto = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                                        
                                        //ARMADO DE VALORES DEL ADJUNTO A REGISTRAR
                                        $dataAdjunto = array (
                                            'IDDetalleInforme'      => $idDetalleInforme, 
                                            'Nombre'                => $nombreAdjunto,
                                            'Extension'             => $extAdjunto,
                                            'Token'                 => $this->complementos->generar_string_aleatorio(5),
                                            'UsuarioCrea'           => $this->items['id'],
                                            'FechaCrea'             => $fechaActual,
                                            'Localhost'             => $this->request->getIPAddress()
                                        );
                                        
                                        $lastIdAdjunto = $this->informeDevolucionDetalleAdjuntos->insert($dataAdjunto, TRUE);
                                        
                                        //ASIGNAMOS LA NUEVA RUTA DONDE SE VA A GUARDAR EL ADJUNTO A REGISTRAR
                                        $ruta = $this->items['baseDinamic']."/docs/InformeDevolucion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                                        
                                        //VALIDAR Y CREAR CARPETA SI NO EXISTE
                                        if (!is_dir($ruta)) 
                                        {
                                            if (!mkdir($ruta, 0777, true)) 
                                            {
                                                // Si no se puede crear la carpeta, cancelar
                                                $this->db->transRollback();
                                                
                                                if(!empty($nombresAdjuntos))
                                                {
                                                    // Eliminar archivos guardados
                                                    foreach ($nombresAdjuntos as $archivoGuardado) 
                                                    {
                                                        if (file_exists($ruta.$archivoGuardado)) 
                                                        {
                                                            unlink($archivoGuardado);
                                                        }
                                                    }
                                                }
                                                
                                                $message = sprintf($this->mensajeError->msg201, "<li>No se pudo crear el directorio de almacenamiento. Inténtelo luego[ERRALMC]</li>");
                                                echo $this->alertas->alertaError($message);
                                                EXIT;
                                            }
                                        }
                                        
                                        //ASIGNAR EL NUEVO NOMBRE
                                        $nuevonombre =  $idInforme.'-'.$idDetalleInforme.'-'.$lastIdAdjunto.'.'.$extAdjunto;
                                        $nombresAdjuntos[] = $nuevonombre;
                                        
                                        //INTENTAR MOVER EL ARCHIVO
                                        try 
                                        {
                                            $value->move($ruta, $nuevonombre);
                                        } 
                                        catch (\Exception $e) 
                                        {
                                            $this->db->transRollback();
                                            
                                            if(!empty($nombresAdjuntos))
                                            {
                                                // Eliminar archivos guardados
                                                foreach ($nombresAdjuntos as $archivoGuardado) 
                                                {
                                                    if (file_exists($ruta.$archivoGuardado)) 
                                                    {
                                                        unlink($archivoGuardado);
                                                    }
                                                }
                                            }
                                            
                                            $message = sprintf($this->mensajeError->msg201, "<li>Error al guardar el archivo: ".$e->getMessage().". Inténtelo luego[ERRALMC]</li>");
                                            echo $this->alertas->alertaError($message);
                                            EXIT;
                                        }
                                        
                                    }
                    	        }
                            }
                        }
                    }
                    else
                    {
                        if($situacionReal[$idDetalle] == "DEV")
                        {
                            /*
                            * ----------------------------
                            * SI RECEPCIONA EL ELEMENTO, EL ESTADO REAL DE RECEPCIÓN NO ES EL MISMO DEL ESTADO DE DEVOLUCIÓN Y EL ESTADO REAL ES "DEVOLUCIÓN OK"
                            * SE ACTUALIZA EL ESTADO DE VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN SIN GENERAR INFORME DE DEVOLUCIÓN Y SE REACTIVA EL ACTIVO DADO DE BAJA POR ACTA DE DEVOLUCIÓN
                            * ----------------------------
                            */
                            
                            //ARMAR VALORES PARA ACTUALIZAR VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN
                            $dataUpdateDetalleDevolucion[] = array(
                                'IDDetalleDevolucion'   => $idDetalleDevolucion[$idDetalle],
                                'Estado'                => "VALID", 
                                'UsuarioValidacion'     => $this->items['id'],
                                'FechaValidado'         => $fechaActual,
                                'ElementoRecibido'      => "Y",
                                'ObservacionValidado'   => $observacionValidacion[$idDetalle]
                            );
                            
                            //BUSCAR EL ACTIVO ASOCIADO AL DETALLE ASIGNACIÓN Y REACTIVARLO.
                            $whereDetalleAsignacion = array(
                                'IDDetalleAsignacion'   => $idDetalle,
                                'return'                => "row"
                            );
                    		
                    		$detalleAsignacion = $this->asignacionesDetalle->listarDetalleElementosAsignados($whereDetalleAsignacion);
                    		
                    		if($detalleAsignacion['EstadoActivoActual'] == "BAJ")
                    		{
                    		    if($detalleAsignacion['TipoElemento'] == "MOVIL")
                        		{
                        		    $dataMovilUpdate = array (
                                        'FechaEstado'       => $fechaActual,
                                        'UsuarioEstado'     => $this->items['id'],
                                        'Estado'            => 'ACT',
                                        'Situacion'         => $situacionReal[$idDetalle],
                                        'MotivoEstado'      => 'Móvil activo por validación de devolución de activo.',
                                        'UsuarioModifica'   => $this->items['id'],
                                        'FechaModifica'     => $fechaActual,
                                        'Localhost'         => $this->request->getIPAddress()
                                    );
                                    
                                    $this->moviles->update([$detalleAsignacion['IDElemento']], $dataMovilUpdate);
                        		}
                        		else if($detalleAsignacion['TipoElemento'] == "HARDWARE")
                        		{
                        		    $dataHardwareUpdate = array (
                                        'FechaEstado'       => $fechaActual,
                                        'UsuarioEstado'     => $this->items['id'],
                                        'Estado'            => 'ACT',
                                        'Situacion'         => $situacionReal[$idDetalle],
                                        'MotivoEstado'      => 'Hardware activo por validación de devolución de activo.',
                                        'UsuarioModifica'   => $this->items['id'],
                                        'FechaModifica'     => $fechaActual,
                                        'Localhost'         => $this->request->getIPAddress()
                                    );
                                    
                                    $this->hardware->update([$detalleAsignacion['IDElemento']], $dataHardwareUpdate);
                        		}
                        		else if($detalleAsignacion['TipoElemento'] == "TARJETA")
                        		{
                        		    $dataTarjetaUpdate = array (
                                        'FechaEstado'       => $fechaActual,
                                        'UsuarioEstado'     => $this->items['id'],
                                        'Estado'            => 'ACT',
                                        'Situacion'         => $situacionReal[$idDetalle],
                                        'MotivoEstado'      => 'Tarjeta de acceso activo por validación de devolución de activo.',
                                        'UsuarioModifica'   => $this->items['id'],
                                        'FechaModifica'     => $fechaActual,
                                        'Localhost'         => $this->request->getIPAddress()
                                    );
                                    
                                    $this->tarjetasAcceso->update([$detalleAsignacion['IDElemento']], $dataTarjetaUpdate);
                        		}
                    		}
                        }
                        else
                        {
                            /*
                            * ----------------------------
                            * SI RECEPCIONA EL ELEMENTO, EL ESTADO REAL DE RECEPCIÓN NO ES EL MISMO DEL ESTADO DE DEVOLUCIÓN Y EL ESTADO REAL ES DISTINTO A "DEVOLUCIÓN OK"
                            * SE ACTUALIZA EL ESTADO DE VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN GENERANDO INFORME DE DEVOLUCIÓN
                            * ----------------------------
                            */
                            
                            //ARMAR VALORES PARA ACTUALIZAR VALIDACIÓN DEL DETALLE DE DEVOLUCIÓN
                            $dataUpdateDetalleDevolucion[] = array(
                                'IDDetalleDevolucion'   => $idDetalleDevolucion[$idDetalle],
                                'Estado'                => "VALID", 
                                'UsuarioValidacion'     => $this->items['id'],
                                'FechaValidado'         => $fechaActual,
                                'ElementoRecibido'      => "Y",
                                'ObservacionValidado'   => $observacionValidacion[$idDetalle]
                            );
                                    
                            //ARMAR VALORES PARA DETALLE DE INFORME DE NO RECEPCIÓN DE ELEMENTO
                            $insertDetalleInforme = array (
                                'IDInforme'             => $idInforme,
                                'IDDetalleAsignacion'   => $idDetalle,
                                'MotivoRealDevolucion'  => $situacionReal[$idDetalle],
                                'UsuarioCrea'           => $this->items['id'],
                                'IDDireccionCrea'       => $this->items['dpto'],
                                'IDAreaCrea'            => $this->items['idArea'],
                                'IDSubareaCrea'         => $this->items['idSubarea'],
                                'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                                'IDCargoCrea'           => $this->items['idCargoLog'],
                                'FechaCrea'             => $fechaActual,    
                                'Localhost'             => $this->request->getIPAddress(),
                                'Estado'                => 'REGI'
                            );
                            
                            //INSERTAR DETALLE DE INFORME PARA OBTENER EL ID RESPECTIVO
                            $idDetalleInforme = $this->informeDevolucionDetalle->insert($insertDetalleInforme, TRUE);
                            
                            //ARMAR VALORES PARA EVALUACION DETALLE INFORME DEVOLUCIÓN (INSERT MASIVO)
                            $dataDetalleEvaluacionInforme[] = array (
                                'IDDetalleInforme'      => $idDetalleInforme,
                                'EtapaEvaluacion'       => $etapaEvaluacion[$idDetalle][0],
                                'FechaEvaluacion'       => $fechaEvaluacion[$idDetalle][0],
                                'DescripcionEvaluacion' => $descripcionEvaluacion[$idDetalle][0],
                                'UsuarioCrea'           => $this->items['id'],
                                'FechaCrea'             => $fechaActual,    
                                'Localhost'             => $this->request->getIPAddress(),
                                'Estado'                => 'CREA'
                            );
                            $dataDetalleEvaluacionInforme[] = array (
                                'IDDetalleInforme'      => $idDetalleInforme,
                                'EtapaEvaluacion'       => $etapaEvaluacion[$idDetalle][1],
                                'FechaEvaluacion'       => $fechaEvaluacion[$idDetalle][1],
                                'DescripcionEvaluacion' => $descripcionEvaluacion[$idDetalle][1],
                                'UsuarioCrea'           => $this->items['id'],
                                'FechaCrea'             => $fechaActual,    
                                'Localhost'             => $this->request->getIPAddress(),
                                'Estado'                => 'CREA'
                            );
                            $dataDetalleEvaluacionInforme[] = array (
                                'IDDetalleInforme'      => $idDetalleInforme,
                                'EtapaEvaluacion'       => $etapaEvaluacion[$idDetalle][2],
                                'FechaEvaluacion'       => $fechaEvaluacion[$idDetalle][2],
                                'DescripcionEvaluacion' => $descripcionEvaluacion[$idDetalle][2],
                                'UsuarioCrea'           => $this->items['id'],
                                'FechaCrea'             => $fechaActual,    
                                'Localhost'             => $this->request->getIPAddress(),
                                'Estado'                => 'CREA'
                            );
                            
                            //EVALUAMOS SI HAY IMÁGENES O ARCHIVOS ADJUNTOS PARA INSERTAR...
                            if(!empty($imagenesEvaluacion) && isset($imagenesEvaluacion[$idDetalle]))
                            {
                                foreach ($imagenesEvaluacion[$idDetalle] as $key => $value) 
                    	        {
                                    if ($value->isValid() && ! $value->hasMoved()) 
                                    {
                                        //OBTENGO LA EXTENSIÓN DEL ADJUNTO A REGISTRAR
                                        if($value->getClientExtension() != null)
                                        {
                                            $extAdjunto = strtolower($value->getClientExtension());
                                        }
                                        else if($value->guessExtension() != null)
                                        {
                                            $extAdjunto = strtolower($value->guessExtension());
                                        }
                                        else
                                        {
                                            $extAdjunto = strtolower(pathinfo($value->getClientName(), PATHINFO_EXTENSION));
                                        }
                                        
                                        //OBTENGO EL NOMBRE DEL ADJUNTO A REGISTRAR
                                        $nombreAdjunto = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                                        
                                        //ARMADO DE VALORES DEL ADJUNTO A REGISTRAR
                                        $dataAdjunto = array (
                                            'IDDetalleInforme'      => $idDetalleInforme, 
                                            'Nombre'                => $nombreAdjunto,
                                            'Extension'             => $extAdjunto,
                                            'Token'                 => $this->complementos->generar_string_aleatorio(5),
                                            'UsuarioCrea'           => $this->items['id'],
                                            'FechaCrea'             => $fechaActual,
                                            'Localhost'             => $this->request->getIPAddress()
                                        );
                                        
                                        $lastIdAdjunto = $this->informeDevolucionDetalleAdjuntos->insert($dataAdjunto, TRUE);
                                        
                                        //ASIGNAMOS LA NUEVA RUTA DONDE SE VA A GUARDAR EL ADJUNTO A REGISTRAR
                                        $ruta = $this->items['baseDinamic']."/docs/InformeDevolucion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                                        
                                        //VALIDAR Y CREAR CARPETA SI NO EXISTE
                                        if (!is_dir($ruta)) 
                                        {
                                            if (!mkdir($ruta, 0777, true)) 
                                            {
                                                // Si no se puede crear la carpeta, cancelar
                                                $this->db->transRollback();
                                                
                                                if(!empty($nombresAdjuntos))
                                                {
                                                    // Eliminar archivos guardados
                                                    foreach ($nombresAdjuntos as $archivoGuardado) 
                                                    {
                                                        if (file_exists($ruta.$archivoGuardado)) 
                                                        {
                                                            unlink($archivoGuardado);
                                                        }
                                                    }
                                                }
                                                
                                                $message = sprintf($this->mensajeError->msg201, "<li>No se pudo crear el directorio de almacenamiento. Inténtelo luego[ERRALMC]</li>");
                                                echo $this->alertas->alertaError($message);
                                                EXIT;
                                            }
                                        }
                                        
                                        //ASIGNAR EL NUEVO NOMBRE
                                        $nuevonombre =  $idInforme.'-'.$idDetalleInforme.'-'.$lastIdAdjunto.'.'.$extAdjunto;
                                        $nombresAdjuntos[] = $nuevonombre;
                                        
                                        //INTENTAR MOVER EL ARCHIVO
                                        try 
                                        {
                                            $value->move($ruta, $nuevonombre);
                                        } 
                                        catch (\Exception $e) 
                                        {
                                            $this->db->transRollback();
                                            
                                            if(!empty($nombresAdjuntos))
                                            {
                                                // Eliminar archivos guardados
                                                foreach ($nombresAdjuntos as $archivoGuardado) 
                                                {
                                                    if (file_exists($ruta.$archivoGuardado)) 
                                                    {
                                                        unlink($archivoGuardado);
                                                    }
                                                }
                                            }
                                            
                                            $message = sprintf($this->mensajeError->msg201, "<li>Error al guardar el archivo: ".$e->getMessage().". Inténtelo luego[ERRALMC]</li>");
                                            echo $this->alertas->alertaError($message);
                                            EXIT;
                                        }
                                        
                                    }
                    	        }
                            }
                            
                            if(!empty($adjuntoEvaluacion) && isset($adjuntoEvaluacion[$idDetalle]))
                            {
                                foreach ($adjuntoEvaluacion[$idDetalle] as $key => $value) 
                    	        {
                                    if ($value->isValid() && ! $value->hasMoved()) 
                                    {
                                        //OBTENGO LA EXTENSIÓN DEL ADJUNTO A REGISTRAR
                                        if($value->getClientExtension() != null)
                                        {
                                            $extAdjunto = strtolower($value->getClientExtension());
                                        }
                                        else if($value->guessExtension() != null)
                                        {
                                            $extAdjunto = strtolower($value->guessExtension());
                                        }
                                        else
                                        {
                                            $extAdjunto = strtolower(pathinfo($value->getClientName(), PATHINFO_EXTENSION));
                                        }
                                        
                                        //OBTENGO EL NOMBRE DEL ADJUNTO A REGISTRAR
                                        $nombreAdjunto = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                                        
                                        //ARMADO DE VALORES DEL ADJUNTO A REGISTRAR
                                        $dataAdjunto = array (
                                            'IDDetalleInforme'      => $idDetalleInforme, 
                                            'Nombre'                => $nombreAdjunto,
                                            'Extension'             => $extAdjunto,
                                            'Token'                 => $this->complementos->generar_string_aleatorio(5),
                                            'UsuarioCrea'           => $this->items['id'],
                                            'FechaCrea'             => $fechaActual,
                                            'Localhost'             => $this->request->getIPAddress()
                                        );
                                        
                                        $lastIdAdjunto = $this->informeDevolucionDetalleAdjuntos->insert($dataAdjunto, TRUE);
                                        
                                        //ASIGNAMOS LA NUEVA RUTA DONDE SE VA A GUARDAR EL ADJUNTO A REGISTRAR
                                        $ruta = $this->items['baseDinamic']."/docs/InformeDevolucion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                                        
                                        //VALIDAR Y CREAR CARPETA SI NO EXISTE
                                        if (!is_dir($ruta)) 
                                        {
                                            if (!mkdir($ruta, 0777, true)) 
                                            {
                                                // Si no se puede crear la carpeta, cancelar
                                                $this->db->transRollback();
                                                
                                                if(!empty($nombresAdjuntos))
                                                {
                                                    // Eliminar archivos guardados
                                                    foreach ($nombresAdjuntos as $archivoGuardado) 
                                                    {
                                                        if (file_exists($ruta.$archivoGuardado)) 
                                                        {
                                                            unlink($archivoGuardado);
                                                        }
                                                    }
                                                }
                                                
                                                $message = sprintf($this->mensajeError->msg201, "<li>No se pudo crear el directorio de almacenamiento. Inténtelo luego[ERRALMC]</li>");
                                                echo $this->alertas->alertaError($message);
                                                EXIT;
                                            }
                                        }
                                        
                                        //ASIGNAR EL NUEVO NOMBRE
                                        $nuevonombre =  $idInforme.'-'.$idDetalleInforme.'-'.$lastIdAdjunto.'.'.$extAdjunto;
                                        $nombresAdjuntos[] = $nuevonombre;
                                        
                                        //INTENTAR MOVER EL ARCHIVO
                                        try 
                                        {
                                            $value->move($ruta, $nuevonombre);
                                        } 
                                        catch (\Exception $e) 
                                        {
                                            $this->db->transRollback();
                                            
                                            if(!empty($nombresAdjuntos))
                                            {
                                                // Eliminar archivos guardados
                                                foreach ($nombresAdjuntos as $archivoGuardado) 
                                                {
                                                    if (file_exists($ruta.$archivoGuardado)) 
                                                    {
                                                        unlink($archivoGuardado);
                                                    }
                                                }
                                            }
                                            
                                            $message = sprintf($this->mensajeError->msg201, "<li>Error al guardar el archivo: ".$e->getMessage().". Inténtelo luego[ERRALMC]</li>");
                                            echo $this->alertas->alertaError($message);
                                            EXIT;
                                        }
                                        
                                    }
                    	        }
                            }
                        }
                        
                    }
                }
            }
            
            //INSERTAR Y ACTUALIZAR REGISTROS MASIVOS
            $this->devolucionesDetalle->updateBatch($dataUpdateDetalleDevolucion, 'IDDetalleDevolucion');
            $this->informeDevolucionDetalleEvaluacion->insertBatch($dataDetalleEvaluacionInforme);
            // var_dump($dataDetalleEvaluacionInforme);
            // var_dump($dataUpdateDetalleDevolucion);
            // var_dump($nombresAdjuntos);
            // exit;
            //VALIDACIÓN DE QUERYS
            if ($this->db->transStatus() === false) 
            {
                // Algo falló en los queries, pero no se lanzó excepción automáticamente
                // Asigna el error en "Throw" para que sea detectado por el catch y dispare el error
                throw new DatabaseException('Error en la transacción');
            }

            $this->db->transCommit();
            
            $message = sprintf($this->mensajeError->msg201, "La solicitud fue registrada con éxito");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        } 
        catch (\Throwable $e) 
        {
            $this->db->transRollback();
            
            if(!empty($nombresAdjuntos))
            {
                // Eliminar archivos guardados
                foreach ($nombresAdjuntos as $archivoGuardado) 
                {
                    if (file_exists($ruta.$archivoGuardado)) 
                    {
                        unlink($archivoGuardado);
                    }
                }
            }
                                                
            $message = sprintf($this->mensajeError->msg201, "<li>Error en la transacción. No se pudo registrar la solicitud. Inténtelo luego[ERRTRANS]</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
    }
    
	/***/
    
    public function actaDevolucion($idDevolucion, $token)
    {
        $whereDevolucion = array(
		    'IDDevolucion'  => $idDevolucion
		);
		
        $devolucion = $this->devoluciones->obtenerInformacionActaDevolucion($whereDevolucion);
        
        $whereFirma = array(
            "IDDevolucion"  => $idDevolucion,
            "Firma"         => "Y"
        );
        
        $firmaDevolucion = $this->devolucionesAdjuntos->where($whereFirma)->first();

        if($token == $devolucion['TokenLinkFirma'])
        {
            $pdfActaDevolucion = $this->PDFActaDevolucion($idDevolucion, $token, 'html');
			/* ACCIONES */

			$data = array (
				'titulo'                => 'Devoluciones | Verisure',
				'devolucion'            => $devolucion,
				'actaDevolucion'        => $pdfActaDevolucion,
                'firmaDevolucion'       => $firmaDevolucion,
                'idDevolucion'          => $idDevolucion
			);
            
			$data = array_merge($data, $this->items);
			
			return view('cargos/acta_devolucion',$data);	
        }
        else
        {
            return view('errors/500');
        }
    }

    public function subirFirmaActaDevolucion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idDevolucion   = $this->request->getPost("txtIDDevolucion");
        $canvasFirma    = $this->request->getPost("firmaActaDevolucion");
        
        $adjunto    = $this->request->getFile("fileFotoDNI");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXISTENCIA DE DATOS
        * ----------------------------
        */
        
        $arrayWhere = array(
            "IDDevolucion"  => $idDevolucion,
            "Firma"         => "Y"
        );
        
        $lastIdFirma = $this->devolucionesAdjuntos->where($arrayWhere)->findAll();
        
        if (!empty($lastIdFirma)) {
            $message = sprintf($this->mensajeError->msg201, "<li>Acta ya se encuentra firmada.</li>");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileFotoDNI' => [
                'mime_in[fileFotoDNI,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileFotoDNI,png,jpg,jpeg,gif,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $devolucion = $this->devoluciones->where("IDDevolucion", $idDevolucion)->first();

        $data = array (
            'IDDevolucion'      => $idDevolucion, 
            'Nombre'            => "DOCUMENTO DE IDENTIDAD", 
            'Extension'         => $extensionDoc,
            'Observacion'       => "DOCUMENTO DE IDENTIDAD ADJUNTADO EN LA FIRMA.",
            'ReemplazoFirma'    => 'N',  
            'UsuarioCrea'       => $devolucion['UsuarioDevolucion'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->devolucionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = $this->items['baseDinamic']."/docs/ActaDevolucion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
        $nombreArchivo = $idDevolucion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $dataFirma = array (
            'IDDevolucion'      => $idDevolucion, 
            'Nombre'            => "FIRMA", 
            'Extension'         => "png",
            'Observacion'       => "FIRMA DE USUARIO QUE DEVUELVE DISPOSITIVOS.",
            'ReemplazoFirma'    => 'N',  
            'Firma'             => 'Y',  
            'UsuarioCrea'       => $devolucion['UsuarioDevolucion'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdFirma = $this->devolucionesAdjuntos->insert($dataFirma, TRUE);

		if($lastIdFirma === FALSE){
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[INSERT]-".$lastIdFirma."-");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR FIRMA
        * ----------------------------
        */

        $nombreArchivoFirma = $idDevolucion."-".$lastIdFirma;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombreFirma = $nombreArchivoFirma.'.png';
            
            $datos = base64_decode(
                preg_replace('/^[^,]*,/', '', $canvasFirma)
            );

            $estadoFirma = file_put_contents($ruta.$nuevonombreFirma, $datos);
            
            if ($estadoFirma===FALSE) {
                unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
                $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastIdFirma]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[SAVEDOC]-");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastId]);
            $this->devolucionesAdjuntos->delete(["IDAdjuntoDevolucion", $lastIdFirma]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }

        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
        */
        
        $usuarioRemitente = $this->usuarios->where("IdUsuario", $devolucion['UsuarioCrea'])->first();
        
        $usuarioDevolucion = $this->usuarios->where("IdUsuario", $devolucion['UsuarioDevolucion'])->first();
        
        $arrayCuerpo = array(
            "TITULO" => "FIRMA DE ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioRemitente['Nombres'].' '.$usuarioRemitente['Apellidos'])),
            "CODIGO" => $idDevolucion,
            'baseUrl'       => $this->items['baseUrl'],
            'basePublic'    => $this->items['basePublic'],
            'baseDinamic'   => $this->items['baseDinamic']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActasConfirmacion($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='FIRMA DE ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $usuarioDevolucion['Nombres'].' '.$usuarioDevolucion['Apellidos'],
            "CORREO_ORIGEN" => $usuarioDevolucion['Correo'],
            "CORREOS_DESTINOS" => array($usuarioRemitente['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $devolucion['UsuarioDevolucion'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);

        $message = sprintf($this->mensajeError->msg201, "La firma fue registrada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }

	/**************************************************************************/
	
    /*************************** INFORME DEVOLUCIÓN ***************************/
    
    public function listarInformesDevolucion()
    {
        if(isset($this->items['id']))
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Informes de Devolución | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Informes de Devolución',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Informes de Devolución",
				'subtitulo'                 => 'Listado de Informes de Devolución'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('cargos/listar_informes_devolucion',$data);
			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
	public function informesDevolucionServerside()
	{
    	if (isset($this->items['id'])) 
    	{
    	    $adicionales = array();
    	    
    	    $dataServerside =  $this->informeDevolucion->listarInformesDevolucionServerside($this->request->getPost(), $adicionales);
    	    
    	    foreach($dataServerside["data"] as $key=>$value)
            {
                $dataServerside["data"][$key]['EncargadoInforme'] = ucwords(mb_strtolower($value['NombresUsuarioInforme'].' '.$value['ApellidosUsuarioInforme']));
                
                //CONFIGURACIÓN DE LAS ACCIONES DEL ELEMENTO
                $acciones = "";
                $acciones .= "<div class='dropdown d-inline-block'>";
                
    			if (in_array("DTINDV", $this->items['permisos'])) 
    			{
                    $acciones .= "<a href='".$this->items['baseUrl']."/detalle-informe-devolucion/".$value['IDInforme']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Informe de Devolución' aria-label='Ver Informe de Devolución'>
                        <i class='mdi mdi-file-sign align-bottom' style='font-size: 20px; color: #FFF;'></i>
                    </a>";
    			}
    			
    			$acciones .= "</div>";
                
                $dataServerside["data"][$key]['Acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'descripcion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
	}
	
	public function detalleInformeDevolucion($idInforme)
	{
	    if(isset($this->items['id']))
        {
             $listadoTiposInforme = $this->veriactivos->listadoTiposInforme();

            $whereInforme = array(
    		    'IDInforme' => $idInforme,
    		    'return'    => 'row'
    		);
    		
            $informeDevolucion          = $this->informeDevolucion->obtenerInformacionInformesDevolucion($whereInforme);
            $pdfInformeDevolucion       = $this->PDFInformeDevolucion($idInforme, "", 'html');
            $detalleInformeDevolucion   = $this->informeDevolucionDetalle->obtenerInformacionDetalleInformeDevolucion(array('IDInforme' => $idInforme));
        
            $informeDevolucion['AsuntoInforme'] = count($detalleInformeDevolucion) > 1 ? $listadoTiposInforme[$informeDevolucion['TipoInforme']]['ASUNTO_PLURAL'] : $listadoTiposInforme[$informeDevolucion['TipoInforme']]['ASUNTO_SINGULAR'];

            // $pdfInformeDevolucion = "";
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Detalle de Informe de Devolución | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Detalle de Informe de Devolución | '.$idInforme,
                'previo'                => 'listar-informes-devolucion',
                'informeDevolucion'     => $pdfInformeDevolucion,
                'informacionInforme'    => $informeDevolucion,
                // 'listaAdjunto'          => $listaAdjunto,
                'idInforme'             => $idInforme
			);
			
			$data = array_merge($data, $this->items);
			
			return view('cargos/listar_detalle_informe_devolucion',$data);	

		} 
		else 
		{
			return view('errors/500');
		}
	}
	
    public function PDFInformeDevolucion($idInforme, $token, $salida)
    {
        $listadoTiposInforme = $this->veriactivos->listadoTiposInforme();
        $listadoMotivoDevolucion = $this->veriactivos->motivosDevolucion();
        $listadoExtensionesImagen = $this->globales->extensionesImagen();
        
        $whereInforme = array(
		    'IDInforme' => $idInforme,
		    'return'    => 'row'
		);
		
        $informeDevolucion              = $this->informeDevolucion->obtenerInformacionInformesDevolucion($whereInforme);

        $detalleInformeDevolucion       = $this->informeDevolucionDetalle->obtenerInformacionDetalleInformeDevolucion(array('IDInforme' => $idInforme));
        
        $whereImgInforme = array(
		    'arrayIDDetalleInforme' => array_column($detalleInformeDevolucion, 'IDDetalleInforme'),
		    'arrayExtension'        => $listadoExtensionesImagen
		);
		
        $evaluacionInformeDevolucion    = $this->informeDevolucionDetalleEvaluacion->whereIn('IDDetalleInforme',array_column($detalleInformeDevolucion, 'IDDetalleInforme'))->orderBy('FechaEvaluacion', 'ASC')->findAll();
        
        $imgInformeDevolucion           = $this->informeDevolucionDetalleAdjuntos->listarAdjuntosDetalleInformeDevolucion($whereImgInforme);
        
        $horizontales = [];
        $verticales = [];
        $imagenesReordenadas = [];
        $imagenesTemporales = array(); //Rutas de Imagenes temporales mostrabas correctamente.
        
        if(!empty($imgInformeDevolucion))
        {
            // 1. Clasificar
        
            foreach ($imgInformeDevolucion as $imagen) 
            {
                $ruta = $this->items['baseUrl']."/".$this->items['baseDinamic']."/docs/InformeDevolucion/".date("Y", strtotime($imagen['FechaCrea']))."/".date("m", strtotime($imagen['FechaCrea']))."/".$imagen['IDInforme'].'-'.$imagen['IDDetalleInforme'].'-'.$imagen['IDAdjuntoDetalle'].'.'.$imagen['Extension'];
                
                list($ancho, $alto) = getimagesize($ruta);
                
                
                if (in_array($imagen['Extension'], ['jpg', 'jpeg'])) 
                {
                    $exif = @exif_read_data($ruta);
                    
                    if (!empty($exif['Orientation'])) 
                    {
                        $orientacion = $exif['Orientation'];
                        
                        if (in_array($orientacion, [6, 8])) 
                        {
                            // Rotación 90 o 270 grados
                            $temp = $ancho;
                            $ancho = $alto;
                            $alto = $temp;
                        }
                    }
                }
                
                if ($ancho > $alto) 
                {
                    $horizontales[] = $imagen + ['colspan' => 1, 'maxWidth' => 250, 'maxHeight' => 175];
                } 
                else 
                {
                    $verticales[] = $imagen + ['colspan' => 2, 'maxWidth' => 175, 'maxHeight' => 250];
                }
            }
            
            // 2. Combinar: horizontales primero, luego verticales
            $imagenesReordenadas = array_merge($horizontales, $verticales);
        }
        
        $asuntoInforme = count($detalleInformeDevolucion) > 1 ? $listadoTiposInforme[$informeDevolucion['TipoInforme']]['ASUNTO_PLURAL'] : $listadoTiposInforme[$informeDevolucion['TipoInforme']]['ASUNTO_SINGULAR'];
        $textoInforme = count($detalleInformeDevolucion) > 1 ? $listadoTiposInforme[$informeDevolucion['TipoInforme']]['TEXTO_PLURAL'] : $listadoTiposInforme[$informeDevolucion['TipoInforme']]['TEXTO_SINGULAR'];
        
        $widthActa = "";
        
        if($salida != "download")
        {
            $widthActa = 'width: 21cm; ';
        }
        
        $html = '<div id="ctnInformeDevolucionFormato" style="font-size: 13px; '.$widthActa.'">
            <table cellspacing="1" style="width: 100%; ">
				<tr>
					<td rowspan="2" style="width:27%; text-align:center">
					    <img src="'.$this->items['baseUrl'].'/'.$this->items['basePublic'].'/images/LOGO-VERISURE-FULL.png" alt="" style="max-width: 100%; height: auto;">
					    <br>
					</td>
					<td rowspan="2" style="width:73%;border-left-width: thin; border-bottom-width: thin; border-right-width: thin; border-top-width: thin; border-left-style: none; border-bottom-style: none; border-right-style: none; border-top-style: none;">
					    <p>&nbsp;</p>
						<h4 style="font-weight: bold; margin: 0px; ">VERISURE PERÚ S.A.C</h4>
                        <h4 style="font-weight: normal; margin: 0px; ">Av. Primavera N° 1050, Of 501 Urb. Chacarilla del Estanque</h4>
                        <h4 style="font-weight: normal; margin: 0px; ">Santiago de Surco, Lima - Perú</h4>
						<p>&nbsp;</p>
					</td>
				</tr>
			</table>
            <div style="">
                <h3 style="text-align: center; text-decoration: underline;">INFORME</h3>
                <table style="width: 100%; border: none;">
                    <thead>
                        <tr style="background-color: white; color: #333;">
                            <th style="width: 20%; padding: 2px 5px; text-align: left;">De: </th>
                            <th style="width: 80%; padding: 2px 5px; font-weight: normal; text-align: left;">'.ucwords(mb_strtolower($informeDevolucion['NombresUsuarioInforme'].' '.$informeDevolucion['ApellidosUsuarioInforme'])).'</th>
                        </tr>
                        <tr style="background-color: white; color: #333; text-align: left;">
                            <th style="width: 20%; padding: 2px 5px; text-align: left;"></th>
                            <th style="width: 80%; padding: 2px 5px; font-weight: normal; text-align: left;">'.$informeDevolucion['CargoInforme'].'</th>
                        </tr>
                        <tr style="background-color: white; color: #333; text-align: left;">
                            <th style="width: 20%; padding: 2px 5px; text-align: left;">Asunto: </th>
                            <th style="width: 80%; padding: 2px 5px; font-weight: normal; text-align: left;">'.$asuntoInforme.'</th>
                        </tr>
                        <tr style="background-color: white; color: #333; text-align: left;">
                            <th style="width: 20%; padding: 2px 5px; text-align: left;">Fecha: </th>
                            <th style="width: 80%; padding: 2px 5px; font-weight: normal; text-align: left;">'.date('d-m-Y', strtotime($informeDevolucion['FechaInforme'])).'</th>
                        </tr>
                    </thead>
                </table>
                <hr>
                <p>'.$textoInforme.'</p>
            </div>';
            
            foreach($detalleInformeDevolucion as $activo)
            {
                $html .= '<div>
                    <h4 style="margin: 0px;">Activo: '.$activo['Marca'].' '.$activo['Modelo'].' '.$activo['Serie'].'</h4>
                    <h4 style="margin: 0px;">Colaborador: '.ucwords(mb_strtolower($activo['NombreAsignado'].' '.$activo['ApellidoAsignado'])).'</h4>
                    <ol type="I" style="font-size: 12px;">
                        <li>ANTECEDENTES</li>
                        <ol style="font-size: 12px; margin: 10px 0px;">
                            <li>Asignación:</li>
                            <ul>
                                <li>Fecha de Asignación: '.date('d-m-Y', strtotime($activo['FechaAsignado'])).'</li>
                                <li>Fecha de Firma: '.($activo['FechaRegistroFirmaAsignado'] != null ? date('d-m-Y', strtotime($activo['FechaRegistroFirmaAsignado'])) : "No registra firma.").'</li>
                            </ul>
                            <li>Devolución</li>
                            <ul>
                                <li>Fecha de Devolución: '.date('d-m-Y', strtotime($activo['FechaDevolucion'])).'</li>
                                <li>Fecha de Firma: '.($activo['FechaRegistroFirmaDevolucion'] != null ? date('d-m-Y', strtotime($activo['FechaRegistroFirmaDevolucion'])) : "No registra firma.").'</li>
                                <li>Estado de devolución: '.$listadoMotivoDevolucion[$activo['MotivoDevolucion']].'</li>
                            </ul>';
                            if($activo['IDReposicion'] != null)
                            {
                                $html .= '<li>Reposición/Descuento</li>
                                <ul>
                                    <li>Fecha de Reposición: '.date('d-m-Y', strtotime($activo['FechaReposicion'])).'</li>
                                    <li>Fecha de Firma: '.($activo['FechaRegistroFirmaReposicion'] != null ? date('d-m-Y', strtotime($activo['FechaRegistroFirmaReposicion'])) : "No registra firma.").'</li>
                                    <li>Monto de Descuento: S/ '.$activo['TotalTrabajador'].'</li>
                                    <li>Total de Cuotas: '.$activo['TotalCuotas'].'</li>
                                </ul>';
                            }
                            
                        $html .= '</ol>';
                        
                        if(!empty($evaluacionInformeDevolucion))
                        {
                            $html .= '<li>PROCESO DE EVALUACIÓN</li>
                            <table style="border-collapse: collapse; width: 100%; margin: 10px 0px; border: 1px solid #000;">
                                <thead>
                                    <tr style="background-color: white; color: #333; text-align: center;">
                                        <th style="width: 30%; padding: 5px; border: 1px solid #000;">ETAPA</th>
                                        <th style="width: 20%; padding: 5px; border: 1px solid #000;">FECHA</th>
                                        <th style="width: 50%; padding: 5px; border: 1px solid #000;">DESCRIPCIÓN</th>
                                    </tr>
                                </thead>
                                <tbody>';
                                
                                foreach($evaluacionInformeDevolucion as $evaluacion)
                                {
                                    if($evaluacion['IDDetalleInforme'] === $activo['IDDetalleInforme'])
                                    {
                                        $html .= '<tr style="background-color: white; color: #333; text-align: center;">
                                            <td style="width: 30%; padding: 5px; border: 1px solid #000;">'.$evaluacion['EtapaEvaluacion'].'</td>
                                            <td style="width: 20%; padding: 5px; border: 1px solid #000;">'.date("d/m/Y", strtotime($evaluacion['FechaEvaluacion'])).'</td>
                                            <td style="width: 50%; padding: 5px; border: 1px solid #000;">'.$evaluacion['DescripcionEvaluacion'].'</td>
                                        </tr>';
                                    }
                                }
                                
                                $html .= '</tbody>
                            </table>';
                        }
                    $html .= '</ol>
                </div>';
                
                if(!empty($imagenesReordenadas))
                {
                    $columnasUsadas = 0;
                    $maxColumnas = 3;
                    
                    $html .= '<div style="">
                        <h5 style="text-align: center; text-decoration: underline;">ANEXO</h5>
                        <h5 style="text-align: center; text-decoration: underline;">REVISIÓN DEL ACTIVO '.$activo['Marca'].' '.$activo['Modelo'].' '.$activo['Serie'].'</h5>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>';
                            foreach ($imagenesReordenadas as $imagen) 
                            {
                                $rutaOriginal = $this->items['baseUrl']."/".$this->items['baseDinamic']."/docs/InformeDevolucion/".date("Y", strtotime($imagen['FechaCrea']))."/".date("m", strtotime($imagen['FechaCrea']))."/".$imagen['IDInforme'].'-'.$imagen['IDDetalleInforme'].'-'.$imagen['IDAdjuntoDetalle'].'.'.$imagen['Extension'];
                                
                                if(in_array($salida, array('view','download')))
                                {
                                    $imgTemporal = $this->complementos->corregirRotacionImagen($rutaOriginal);
                                    $ruta = $imgTemporal['RUTA_WEB'];
                                    
                                    if($imgTemporal['RUTA_ESTATICA'] != '')
                                    {
                                        $imagenesTemporales[] = $imgTemporal['RUTA_ESTATICA'];
                                    }
                                    
                                }
                                else
                                {
                                    $ruta = $rutaOriginal;
                                }
                                
                                $colspan = $imagen['colspan'];
                                $maxWidth = $imagen['maxWidth'];
                                $maxHeight = $imagen['maxHeight'];

                                if ($columnasUsadas + $colspan > $maxColumnas) 
                                {
                                    for ($i = $columnasUsadas; $i < $maxColumnas; $i++) 
                                    {
                                        $html .= '<td></td>';
                                    }
                                    $html .= '</tr><tr>';
                                    $columnasUsadas = 0;
                                }
                            
                                $html .= '<td colspan="' . $colspan . '" style="padding: 5px; text-align: center;">
                                            <img src="' . $ruta . '" style="max-width: ' . $maxWidth . 'px; max-height: ' . $maxHeight . 'px;" />
                                          </td>';
                            
                                $columnasUsadas += $colspan;
                            }
                            
                            for ($i = $columnasUsadas; $i < $maxColumnas; $i++) {
                                $html .= '<td></td>';
                            }
                            $html .= '</tr>
                        </table>
                    </div>';
                }
                
            }
            
            
            
            $html .= '<table style="width: 100%; margin-top: 20px; border: 0; text-align: center;">
                <tr>
                    <td style="text-align: center; vertical-align: middle;">
                        <table style="width: 50%; margin: 0 auto; text-align: center; border: 0;">
                            <tr>
                                <td><br><br><br><br><br><br></td>
                            </tr>
                            <tr>
                                <td style="border-top: 1px solid black; padding-top: 5px;">
                                    <h4 style="margin: 0px;">'.ucwords(mb_strtolower($informeDevolucion['NombresUsuarioInforme'].' '.$informeDevolucion['ApellidosUsuarioInforme'])).'</h4>
                                    <h5 style="margin: 0px;">'.$informeDevolucion['CargoInforme'].'</h5>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        
        
        </div>';
        
		$filename = 'Informe de Devolución #' . $idInforme;
		
		if($salida == "view")
		{
		    $html = $this->pdf->generar($html, $filename, $stream = TRUE, $paper = 'A4', $orientation = "portrait");
		    
		    if(!empty($imagenesTemporales))
		    {
		        foreach ($imagenesTemporales as $tempFile) {
                    if (file_exists($tempFile)) {
                        unlink($tempFile);
                    }
                }
                
		    }
		    
		    exit();
		}
		else if($salida == "html")
		{
		    return $html;
		    
		}
		else if($salida == "download")
		{
		    $html = $this->pdf->generar($html, $filename, $salida, $paper = 'A4', $orientation = "portrait");
		    
		    if(!empty($imagenesTemporales))
		    {
		        foreach ($imagenesTemporales as $tempFile) {
                    if (file_exists($tempFile)) {
                        unlink($tempFile);
                    }
                }
                
		    }
		    
		    exit();
		}
		else
		{
		    return $html;
		}
    }

	/**************************************************************************/
	
    /****************************** REPOSICIONES ******************************/
    
    public function listarReposiciones()
    {
		if(isset($this->items['id']))
		{
			$data = array (
				'session'                       => 'on',
				'titulo'                        => 'Actas de Reposición | Verisure',
				'breadcrumb'                    => $this->items['modulo'],
				'breadcrumb_alias'              => 'Actas de Reposición',
                // 'previo'                 => 'listar-proveedores',
				'elementoSeleccionadoModulo'    => "Actas de Reposición",
				'subtitulo'                     => 'Listado de Actas de Reposición'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('cargos/listar_reposiciones',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
	}
	
	public function actasReposicionServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            if($this->items['idPerfil'] == 3)
    		{
    		  //  $userXdeleg = $this->usuariosDelegaciones->where("IDUsuario", $this->items['id'])->findAll();
    		    
    		    $userXdeleg = $this->estructuraSubareaDelegaciones->listarDelegacionesXSubarea(57);
    		    $idDelegaciones = array_column($userXdeleg, 'IDDelegacion');
    		    
    		    $adicionales['Delegaciones'] = $idDelegaciones;
    		}
    		
    	    $dataServerside =  $this->reposiciones->listarReposicionesServerside($this->request->getPost(), $adicionales);
    	    
    	    foreach($dataServerside["data"] as $key=>$value)
            {
                //CONFIGURACIÓN DE LA INFORMACIÓN "FECHA ASIGNADO"
                
                $fechaReposicion = date("d-m-Y", strtotime($value['FechaCrea']));
                
                $dataServerside["data"][$key]['FechaAdjudicado'] = $fechaReposicion;
                $dataServerside["data"][$key]['MontoAdjudicado'] = 'S/ '.$value['TotalDescuentoTrabajador'];
                
                //CONFIGURACIÓN DE LA INFORMACIÓN "CUOTAS"
                $cuotas = '';
                
                if($value['Cuotas'] == 'Y' )
                {
                    $cuotas .= '<span class="badge bg-success border-0">SI</span>';
                }
                else
                {
                    $cuotas .= '<span class="badge bg-danger border-0">NO</span>';
                }
                
                $dataServerside["data"][$key]['CuotasPago'] = $cuotas;
                
                //CONFIGURACIÓN DE LA INFORMACIÓN "FIRMA"
                $firma = "";
                
                if($value['FechaRegistroFirma']!='' && $value['FechaRegistroFirma']!=null)
                {
                    $firma .= "<span class='badge bg-success border-0'>".date("d-m-Y H:i:s", strtotime($value['FechaRegistroFirma']))."</span>";
                }
                else
                {
                    $firma .= "<span class='badge bg-danger border-0'>NO</span>";
                }
                
                $dataServerside["data"][$key]['Firma'] = $firma;
                
                //CONFIGURACIÓN DE LAS ACCIONES DEL ELEMENTO
                $acciones = "";
                $acciones .= "<div class='dropdown d-inline-block'>";
                
    			if (in_array("DETREP", $this->items['permisos'])) 
    			{
                    $acciones .= "<a href='".$this->items['baseUrl']."/detalle-acta-reposicion/".$value['IDReposicion']."/".$value['TokenLinkFirma']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Detalle de Reposición' aria-label='Ver Detalle de Reposición'>
                        <i class='mdi mdi-file-sign align-bottom' style='font-size: 20px; color: #FFF;'></i>
                    </a>";
    			}
    			
    			$acciones .= "</div>";
                
                $dataServerside["data"][$key]['Acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'descripcion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
	}

	/***/
    
    public function detalleActaReposicion($idReposicion, $token)
    {
        if(isset($this->items['id']))
        {
			// ACCIONES
			$whereReposicion = array(
			    'IDReposicion'  => $idReposicion
			);
			
            $reposicion = $this->reposiciones->obtenerInformacionActaReposicion($whereReposicion);
            
            if($token == $reposicion['TokenLinkFirma'] )
            {
                $listaAdjunto = $this->reposicionesAdjuntos->where("IDReposicion", $idReposicion)->findAll();
                $pdfActaReposicion = $this->PDFActaReposicion($idReposicion, $token, 'html');
                
    			$data = array (
    				'session'               => 'on',
    				'titulo'                => 'Detalle de Reposición | Verisure',
    				'breadcrumb'            => $this->items['modulo'],
    				'breadcrumb_alias'      => 'Detalle de Reposición | '.$idReposicion,
                    'previo'                => 'listar-reposiciones',
                    'actaReposicion'        => $pdfActaReposicion,
                    'informacionReposicion' => $reposicion,
                    'listaAdjunto'          => $listaAdjunto,
                    'idReposicion'          => $idReposicion
    			);
    			
    			$data = array_merge($data, $this->items);
    			
    			return view('cargos/listar_detalle_reposicion',$data);	
            }
            else
            {
                return view('errors/404');
            }		
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function PDFActaReposicion($idReposicion, $token, $salida)
    {
        $whereReposicion = array(
		    'IDReposicion'  => $idReposicion
		);
		
		$whereFirma = array(
            "IDReposicion"  => $idReposicion,
            "Firma"         => "Y"
        );
        
        $reposicion         = $this->reposiciones->obtenerInformacionActaReposicion($whereReposicion);
        
        if($token != $reposicion['TokenLinkFirma'] )
        {
            return view('errors/token');
        }
        else
        {
            $detalle            = $this->reposicionesDetalle->listadoDetalleActaReposicion($whereReposicion);
            $cronograma         = $this->reposicionesCronogramaPago->whereIn("IDDetalleReposicion", array_column($detalle, "IDDetalleReposicion"))->where("Estado", "A")->orderBy('IDDetalleReposicion ASC, NroCuota ASC, MesCuota ASC, AnioCuota ASC')->findAll();
            $firmaReposicion    = $this->reposicionesAdjuntos->where($whereFirma)->first();
            
            $area1 = in_array("MOVIL", array_column($detalle, 'TipoElemento')) || in_array("LINEA", array_column($detalle, 'TipoElemento')) || in_array("HARDWARE", array_column($detalle, 'TipoElemento')) || in_array("TARJETA", array_column($detalle, 'TipoElemento')) || in_array("ACCESORIOIT", array_column($detalle, 'TipoElemento')) ? "IT" : "";
            $area2 = in_array("KITDEMO", array_column($detalle, 'TipoElemento')) || in_array("ELEMENTOTRABAJO", array_column($detalle, 'TipoElemento')) ? "URES" : "";
            
            if($area1 != '' && $area2 != '')
            {
                $nombreArea = $area1.' - '.$area2;
            }
            else if($area1 == '' && $area2 != '')
            {
                $nombreArea = $area2;
            }
            else if($area1 != '' && $area2 == '')
            {
                $nombreArea = $area1;
            }
            else
            {
                $nombreArea = '';
            }
            
            $widthActa = "";
            
            if($salida != "download")
            {
                $widthActa = 'width: 21cm; ';
            }
            
            
            $reposicion['widthActa'] = $widthActa;
            $reposicion['baseURL'] = $this->items['baseUrl'];
            $reposicion['nombreAreaActaReposicion'] = $nombreArea;
            
            $arrayInformacionActa = array(
                'reposicion'    => $reposicion,
                'detalle'       => $detalle,
                'cronograma'    => $cronograma,
                'firma'         => $firmaReposicion,
                'basePublic'    => $this->items['basePublic'],
                'baseDinamic'   => $this->items['baseDinamic']
            );
            
            $html = '';
            
            if(strtotime($reposicion['FechaCrea']) < strtotime("2025-05-29 00:00:00") )
            {
                $html = $this->plantillasPDF->formatoActaReposicion_V1($arrayInformacionActa);
            }
            else
            {
                $html = $this->plantillasPDF->formatoActaReposicion_V2($arrayInformacionActa);
            }
            
            
    
    		$filename = 'Acta de Reposición #' . $idReposicion;
    		
    		if($salida == "view")
    		{
    		    $html = $this->pdf->generar($html, $filename, $stream = TRUE, $paper = 'A4', $orientation = "portrait");
    		    exit();
    		}
    		else if($salida == "html")
    		{
    		    return $html;
    		}
    		else if($salida == "download")
    		{
    		    $html = $this->pdf->generar($html, $filename, $salida, $paper = 'A4', $orientation = "portrait");
    		    exit();
    		}
    		else
    		{
    		    return $html;
    		}
        }
    }
    
    public function adjuntarDocumentoReposicion($idReposicion)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $nombre         = $this->request->getPost('txtNombreAdjunto_i');
        $observacion    = $this->request->getPost('txtObservacionAdjunto_i');
        $reemplazafirma = $this->request->getPost('chkAdjuntoFirma');
        $adjunto        = $this->request->getFile("itemsFile");

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($nombre, 'required|trim|minlength[9]|maxlength[15]', 'Nombre');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[itemsFile,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->getClientExtension() != null)
        {
            $extensionDoc = strtolower($adjunto->getClientExtension());
        }
        else if($adjunto->guessExtension() != null)
        {
            $extensionDoc = strtolower($adjunto->guessExtension());
        }
        else
        {
            $extensionDoc = strtolower(pathinfo($adjunto->getClientName(), PATHINFO_EXTENSION));
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDReposicion'      => $idReposicion,
            'Nombre'            => $nombre, 
            'Extension'         => $extensionDoc,
            'Observacion'       => $observacion,
            'ReemplazoFirma'    => ((isset($reemplazafirma) && $reemplazafirma != null) ? 'Y' : 'N'),  
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->reposicionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = $this->items['baseDinamic']."/docs/ActaReposicion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
        $nombreArchivo = $idReposicion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        $message = sprintf($this->mensajeError->msg201, "El archivo adjunto fue registrado exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
    public function enviarCorreoReposicion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idReposicion = $this->request->getPost('idReposicion');
        $reposicion = $this->reposiciones->where("IDReposicion", $idReposicion)->first();
        $adjudicado = $this->usuarios->buscarUsuario($reposicion['UsuarioAdjudicado']);
        
		/*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
		*/

        $arrayCuerpo = array(
            "TITULO"        => "ACTA DE REPOSICIÓN",
            "ACTA"          => "ACTA DE REPOSICIÓN",
            "USUARIO"       => ucwords(mb_strtolower($adjudicado['Nombres'].' '.$adjudicado['Apellidos'])),
            "URL_ACTA"      => base_url()."/acta-reposicion/".$idReposicion."/".$reposicion['TokenLinkFirma'],
            'baseUrl'       => $this->items['baseUrl'],
            'basePublic'    => $this->items['basePublic'],
            'baseDinamic'   => $this->items['baseDinamic']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
		/*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
		*/

        $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$adjudicado['Nombres'].' '.$adjudicado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            "CORREOS_DESTINOS" => array($adjudicado['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe", $this->items['correoElectronico']),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDReposicion"  => $idReposicion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusReposicion->insert($dataCorreo, TRUE);

        if($estadoCorreo['ERROR'] != '')
        {
            $message = sprintf($this->mensajeError->msg201, "No se pudo enviar el correo. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "Se envió el correo correctamente.");
            echo $this->alertas->alertaExito($message);
        }
        
    }
    
	/***/
    
    public function actaReposicion($idReposicion, $token)
    {
        $whereReposicion = array(
		    'IDReposicion'  => $idReposicion
		);
		
        $reposicion = $this->reposiciones->obtenerInformacionActaReposicion($whereReposicion);

        $whereFirma = array(
            "IDReposicion"  => $idReposicion,
            "Firma"         => "Y"
        );
        
        $firmaReposicion = $this->reposicionesAdjuntos->where($whereFirma)->first();
        
        if($token == $reposicion['TokenLinkFirma'])
        {
            $pdfActaReposicion = $this->PDFActaReposicion($idReposicion, $token, 'html');
			/* ACCIONES */
            
			$data = array (
				'titulo'                => 'Reposiciones | Verisure',
                'idReposicion'          => $idReposicion,
                'actaReposicion'        => $pdfActaReposicion,
				'reposicion'            => $reposicion,
                'firmaReposicion'       => $firmaReposicion
			);
			$data = array_merge($data, $this->items);
			return view('cargos/acta_reposicion',$data);	
        }
        else
        {
            return view('errors/token');
        }
    }

    public function subirFirmaActaReposicion()
    {
        $fechaActual = date("Y-m-d H:i:s");

        $idReposicion = $this->request->getPost("txtIDReposicion");
        $canvasFirma = $this->request->getPost("firmaActaReposicion");
        
        $adjunto = $this->request->getFile("fileFotoDNI");
        
        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $adjunto->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'fileFotoDNI' => [
                'mime_in[fileFotoDNI,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                'ext_in[fileFotoDNI,png,jpg,jpeg,gif,pdf]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        if($adjunto->guessExtension() != null)
        {
            $extensionDoc = $adjunto->guessExtension();
        }
        else
        {
            $nombre_original = $adjunto->getBasename();
            $fileNameCmps = explode(".", $nombre_original);
            $extensionDoc = strtolower(end($fileNameCmps));
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $reposicion = $this->reposiciones->where("IDReposicion", $idReposicion)->first();

        $data = array (
            'IDReposicion'      => $idReposicion, 
            'Nombre'            => "DOCUMENTO DE IDENTIDAD", 
            'Extension'         => $extensionDoc,
            'Observacion'       => "DOCUMENTO DE IDENTIDAD ADJUNTADO EN LA FIRMA.",
            'ReemplazoFirma'    => 'N',  
            'UsuarioCrea'       => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->reposicionesAdjuntos->insert($data, TRUE);

		if($lastId === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR ARCHIVO ADJUNTO
        * ----------------------------
        */
        $ruta = $this->items['baseDinamic']."/docs/ActaReposicion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
        $nombreArchivo = $idReposicion."-".$lastId;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
            
            $estadoMove = $adjunto->move($ruta, $nuevonombre);
            
            if (!$estadoMove) {
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */

        $dataFirma = array (
            'IDReposicion'      => $idReposicion, 
            'Nombre'            => "FIRMA", 
            'Extension'         => "png",
            'Observacion'       => "FIRMA DE USUARIO DE REPOSICIÓN.",
            'ReemplazoFirma'    => 'N',  
            'Firma'             => 'Y',  
            'UsuarioCrea'       => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastIdFirma = $this->reposicionesAdjuntos->insert($dataFirma, TRUE);

		if($lastIdFirma === FALSE){
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		}

        /*
        * ----------------------------
        * GUARDAR FIRMA
        * ----------------------------
        */

        $nombreArchivoFirma = $idReposicion."-".$lastIdFirma;

        if(!file_exists($ruta))
        {
            @mkdir($ruta, 0777, true);
        }

		# si exsite la carpeta o se ha creado
		if (file_exists($ruta) || @mkdir($ruta)) 
        {
            $nuevonombreFirma = $nombreArchivoFirma.'.png';
            
            $datos = base64_decode(
                preg_replace('/^[^,]*,/', '', $canvasFirma)
            );

            $estadoFirma = file_put_contents($ruta.$nuevonombreFirma, $datos);
            
            if ($estadoFirma===FALSE) {
                unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
                $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastIdFirma]);
                $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la firma. Inténtelo luego.[SAVEDOC]");
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        else
        {
            unlink($ruta.$nombreArchivo.'.'.$extensionDoc);
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastId]);
            $this->reposicionesAdjuntos->delete(["IDAdjuntoReposicion", $lastIdFirma]);
            $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
            echo $this->alertas->alertaError($message);
        }
        
        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO
        * ----------------------------
        */
        
        $usuarioRemitente = $this->usuarios->where("IdUsuario", $reposicion['UsuarioCrea'])->first();
        
        $usuarioAdjudicado = $this->usuarios->where("IdUsuario", $reposicion['UsuarioAdjudicado'])->first();
        
        $arrayCuerpo = array(
            "TITULO" => "FIRMA DE ACTA DE REPOSICIÓN",
            "ACTA" => "ACTA DE REPOSICIÓN",
            "USUARIO" => ucwords(mb_strtolower($usuarioRemitente['Nombres'].' '.$usuarioRemitente['Apellidos'])),
            "CODIGO" => $reposicion['IDReposicion'],
            'baseUrl'       => $this->items['baseUrl'],
            'basePublic'    => $this->items['basePublic'],
            'baseDinamic'   => $this->items['baseDinamic']
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActasConfirmacion($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='FIRMA DE ACTA DE REPOSICIÓN: '.$reposicion['IDReposicion'].' - '.$usuarioAdjudicado['Nombres'].' '.$usuarioAdjudicado['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $usuarioAdjudicado['Nombres'].' '.$usuarioAdjudicado['Apellidos'],
            "CORREO_ORIGEN" => $usuarioAdjudicado['Correo'],
            "CORREOS_DESTINOS" => array($usuarioRemitente['Correo']),
            "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDReposicion"  => $reposicion['IDReposicion'],
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $reposicion['UsuarioAdjudicado'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusReposicion->insert($dataCorreo, TRUE);

        $message = sprintf($this->mensajeError->msg201, "La firma fue registrada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
    }
    
    public function mostrarElementosExcepcionReposicion()
    {
        $html = '';
        
        if(isset($this->items['id']))
        {
            
            $msjError   = TRUE;
            $idReposicion   = $this->request->getPost('idReposicion');
            
            $motivosDevolucion = $this->veriactivos->motivosDevolucion();
                
            /* OBTENER MONEDAS ACTUALES */
            
            $listadoMonedas = $this->divisas->findAll();
            // Crear un array asociativo para acceder fácilmente a cada MONEDA por su nomenclatura
            $simbolosMonedas = [];
            $cambioMonedas = [];
            foreach ($listadoMonedas as $moneda) {
                $simbolosMonedas[$moneda['CodigoInternacional']] = $moneda['Simbolo'] ;
                $cambioMonedas[$moneda['CodigoInternacional']] = $moneda['ValorCambio'] ;
            }
            
            
            // ACCIONES
			$whereReposicion = array(
			    'IDReposicion'  => $idReposicion
			);
			
            $reposicion = $this->reposiciones->obtenerInformacionActaReposicion($whereReposicion);
            
            $listadoDetalle = $this->reposicionesDetalle->listadoDetalleActaReposicion($whereReposicion);
            
            $border = "border-sistema-2px";
            
            $existeExcepcion = false;
            
            if(!empty($listadoDetalle))
            {
                foreach($listadoDetalle as $detalle)
                {
                    if($detalle['CobradoReposicion'] != "Y")
                    {
                        if($detalle['MotivoDevolucion'] == "ROB" && ($detalle['TipoCategoria'] == "MOVIL" || $detalle['TipoCategoria'] == "LAPTOP"))
                        {
                            $tipoCategoria = $detalle['TipoCategoria'] == "MOVIL" ? '' : $detalle['TipoCategoria'];
                            
                            $registrosRobo = $this->asignacionesDetalle->obtenerDispositivosRobadosUsuario($reposicion['UsuarioAdjudicado'],$detalle['TipoElemento'], "", $tipoCategoria);
                            
                            $cantidadRobo   = empty($registrosRobo) ? 0 : count($registrosRobo)-1;
                            
                            if($cantidadRobo === 0)
                            {
                                $maximoExcepcion = $detalle['TotalTrabajador'];
                            
                                $html .= '<div class="col-xl-6 col-lg-12">
                                    <div class="card '.$border.'">
                                        <div class="card-header">
                                            <div class="d-flex">
                                                <h6 class="card-title flex-grow-1 mb-0">
                                                    '.$detalle['TipoEquipo'].' - '.$detalle['Marca'].' '.$detalle['Modelo'].'
                                                    <br>
                                                    <small class="text-muted">'.$detalle['Serie'].'</small>
                                                </h6>
                                                <div class="flex-shrink-0 d-flex align-items-center justify-content-center">
                                                    <a class="badge bg-primary-subtle text-primary fs-11">'.$motivosDevolucion[$detalle['MotivoDevolucion']].'</a>
                                                    <input type="hidden" name="txtMotivoDevolucionExcepcionReposicion['.$detalle['IDDetalleReposicion'].']" value="'.$detalle['MotivoDevolucion'].'">
                                                    <input type="hidden" name="txtIDDetalleReposicion[]" value="'.$detalle['IDDetalleReposicion'].'">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="row col-12 m-0 p-0 mb-2 d-flex">
                                                <div class="col-12 m-0 p-0">
                                                    <h5 class="mb-1">Generar Excepción</h5>
                                                    <p class="color-red m-0">¿Desea generar una excepción para este activo?:</p>
                                                </div>
                                                <div class="row col-12 m-0 p-0">
                                                    <div class="col-6 p-0 m-0 my-2">
                                                        <div class="pe-3">
                                                            <div class="form-check card-radio">
                                                                <input id="rdbtnGeneraExcepcion_exrep'.$detalle['IDDetalleReposicion'].'" name="generaExcepcion['.$detalle['IDDetalleReposicion'].']" type="radio" class="form-check-input rdbtnGenerarExcepcionReposicion" data-detalle-reposicion="'.$detalle['IDDetalleReposicion'].'" value="Y">
                                                                <label class="form-check-label" for="rdbtnGeneraExcepcion_exrep'.$detalle['IDDetalleReposicion'].'">
                                                                    <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-up align-bottom"></i></span>
                                                                    <span class="fs-14 text-wrap">Si</span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-6 p-0 m-0 my-2">
                                                        <div class="ps-3">
                                                            <div class="form-check card-radio">
                                                                <input id="rdbtnNoGeneraExcepcion_exrep'.$detalle['IDDetalleReposicion'].'" name="generaExcepcion['.$detalle['IDDetalleReposicion'].']" type="radio" class="form-check-input rdbtnGenerarExcepcionReposicion" data-detalle-reposicion="'.$detalle['IDDetalleReposicion'].'" value="N">
                                                                <label class="form-check-label" for="rdbtnNoGeneraExcepcion_exrep'.$detalle['IDDetalleReposicion'].'">
                                                                    <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-down align-bottom"></i></span>
                                                                    <span class="fs-14 text-wrap">No</span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="collapse m-0 p-0" id="ctnGeneraExcepcionReposicion'.$detalle['IDDetalleReposicion'].'" style="">
                                                <div class="row col-12 m-0 p-0 d-flex">
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                            		    <label class="form-label">Descuento total:</label>
                                            			<div class="input-group">
                                                            <span class="input-group-text">S/ </span>
                                                            <input type="number" class="form-control" id="txtDescuentoTotal_exrep'.$detalle['IDDetalleReposicion'].'" name="descuentoTotal['.$detalle['IDDetalleReposicion'].']" step="0.01" min="1" value="'.$detalle['TotalDescuento'].'" style="pointer-events: none; background:#AAA; color:#F5F5F5;" >
                                                            <input type="hidden" class="form-control" id="txtDescuentoTotalOrigen_exrep'.$detalle['IDDetalleReposicion'].'" value="'.$detalle['TotalDescuento'].'">
                                                        </div>
                                            		</div>
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                            		    <label class="form-label">% Verisure:</label>
                                            			<div class="input-group">
                                                            <span class="input-group-text">S/ </span>
                                                            <input type="number" class="form-control" id="txtPorcentajeVerisure_exrep'.$detalle['IDDetalleReposicion'].'" name="porcentajeVerisure['.$detalle['IDDetalleReposicion'].']" step="0.01" min="0" value="'.$detalle['TotalVerisure'].'" style="pointer-events: none; background:#AAA; color:#F5F5F5;" >
                                                            <input type="hidden" class="form-control" id="txtPorcentajeVerisureOrigen_exrep'.$detalle['IDDetalleReposicion'].'" value="'.$detalle['TotalVerisure'].'">
                                                        </div>
                                            		</div>
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                            		    <label class="form-label">% Trabajador:</label>
                                            			<div class="input-group">
                                                            <span class="input-group-text">S/ </span>
                                                            <input type="number" class="form-control" id="txtPorcentajeTrabajador_exrep'.$detalle['IDDetalleReposicion'].'" name="porcentajeTrabajador['.$detalle['IDDetalleReposicion'].']" step="0.01" min="0" value="'.$detalle['TotalTrabajador'].'" style="pointer-events: none; background:#AAA; color:#F5F5F5;" >
                                                            <input type="hidden" class="form-control" id="txtPorcentajeTrabajadorOrigen_exrep'.$detalle['IDDetalleReposicion'].'" value="'.$detalle['TotalTrabajador'].'" >
                                                        </div>
                                            		</div>
                                            		<div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-2">
                            						    <!-- Slider-->
                                                        <div id="ctnExcepcionReposicion'.$detalle['IDDetalleReposicion'].'">
                                                            <div class="row">
                                                                <div class="col-lg-12 my-2">
                                                                    <h5 class="fs-14">Monto Excepción</h5>
                                                                </div>
                                                                <div class="col-lg-12">
                                                                    <div id="slideExcepcionReposicion'.$detalle['IDDetalleReposicion'].'"></div>
                                                                    <div class="d-flex justify-content-between align-items-center mt-2">
                                                                        <div>
                                                                            <strong>Min:</strong> <span id="minimoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'"></span>
                                                                        </div>
                                                                        <div class="d-flex flex-wrap align-items-center gap-2">
                                                                            <strong class="me-1">Valor:</strong>
                                                                            <div class="input-group input-group-sm" style="min-width: 120px; max-width: 150px; flex: 1 1 auto;">
                                                                                <span class="input-group-text">S/</span>
                                                                                <input type="number" class="form-control valorExcepcionReposicion" id="valorExcepcionReposicion'.$detalle['IDDetalleReposicion'].'" step="0.01" data-detalle-reposicion="'.$detalle['IDDetalleReposicion'].'" >
                                                                            </div>
                                                                        </div>
                                                                        <div>
                                                                            <strong>Máx:</strong> <span id="maximoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'"></span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <input type="hidden" id="txtMontoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'" name="txtMontoExcepcionReposicion['.$detalle['IDDetalleReposicion'].']">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                                        <div class="col-12">
                                                            <div class="form-group">
                                                                <label>Importar Correo de Aprobación</label>
                                                                <input type="file" id="fileCorreoAutorizacionExcepcion'.$detalle['IDDetalleReposicion'].'" class="filepond" data-max-file-size="100MB" data-max-files="6" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <script>
                                                        $(function () {
                                                            pondCorreoAutorizacionExcepcionReposicion'.$detalle['IDDetalleReposicion'].' = FilePond.create(
                                                                document.querySelector("#fileCorreoAutorizacionExcepcion'.$detalle['IDDetalleReposicion'].'"), {
                                                                    labelIdle: \'Arrastre y suelte el correo (.msg o .eml) o <span class="filepond--label-action">explore</span>\',
                                                                    allowMultiple: true,
                                                                    maxFiles: 3,
                                                                    instantUpload: false,
                                                                    allowProcess: false,
                                                                    onaddfile: (error, file) => 
                                                                    {
                                                                        const allowedExtensions = /\.(msg|eml)$/i;
                                                                        if (!allowedExtensions.test(file.filename)) 
                                                                        {
                                                                            Swal.fire({
                                                                                text: "Solo se permiten archivos de correo (.msg o .eml)[2].",
                                                                                icon: "warning",
                                                                                confirmButtonColor: "#282e38",
                                                                                confirmButtonText: "OK"
                                                                            });
                                                                            // Remover archivo
                                                                            pondCorreoAutorizacionExcepcionReposicion'.$detalle['IDDetalleReposicion'].'.removeFile(file.id);
                                                                        }
                                                                    }
                                                                }
                                                            );
                                                            
                                                            
                                                            let minValor = 0;
                                                            let maxValor = '.$maximoExcepcion.';
                                                            let startValor = 0;
                                    
                                                            let slider'.$detalle['IDDetalleReposicion'].' = document.getElementById("slideExcepcionReposicion'.$detalle['IDDetalleReposicion'].'");
                                                            if (slider'.$detalle['IDDetalleReposicion'].'.noUiSlider) {
                                                                slider'.$detalle['IDDetalleReposicion'].'.noUiSlider.destroy();
                                                            }
                                    
                                                            noUiSlider.create(slider'.$detalle['IDDetalleReposicion'].', {
                                                                start: [startValor],
                                                                connect: [true, false],
                                                                range: {
                                                                    min: minValor,
                                                                    max: maxValor
                                                                },
                                                                step: 0.01,
                                                                tooltips: true,
                                                                format: {
                                                                    to: value => "S/ " + value.toFixed(2),
                                                                    from: value => Number(value.replace(/[^0-9.-]+/g, ""))
                                                                }
                                                            });
                                    
                                                            $("#minimoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").text("S/ " + minValor);
                                                            $("#maximoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").text("S/ " + maxValor);
                                                            $("#valorExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").val(startValor);
                                                            
                                                            
                                                            slider'.$detalle['IDDetalleReposicion'].'.noUiSlider.on("update", function (values, handle) {
                                                                let descuentoTexto = values[handle];
                                                                let descuento = parseFloat(descuentoTexto.replace(/[^0-9.]/g, ""));
                                                                
                                                                let valorVerisure = parseFloat($("#txtPorcentajeVerisureOrigen_exrep'.$detalle['IDDetalleReposicion'].'").val()) || 0;;
                                                                let valorTrabajador = parseFloat($("#txtPorcentajeTrabajadorOrigen_exrep'.$detalle['IDDetalleReposicion'].'").val()) || 0;;
                                    
                                                                $("#txtMontoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").val(descuento);
                                                                $("#valorExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").val(descuento.toFixed(2));
                                                                
                                                                $("#txtPorcentajeVerisure_exrep'.$detalle['IDDetalleReposicion'].'").val((valorVerisure + descuento).toFixed(2));
                                                                $("#txtPorcentajeTrabajador_exrep'.$detalle['IDDetalleReposicion'].'").val((valorTrabajador - descuento).toFixed(2));
                                                            });
                                                            
                                                            
                                                        });
                                                    </script>
                                                </div>
                                            </div>';
                                        $html .= '</div>
                                    </div>
                                </div>';
                                
                                $existeExcepcion = true;
                            }
                        }
                        else if($detalle['MotivoDevolucion'] == "FAL")
                        {
                            $tipoCategoria = $detalle['TipoElemento'] == "HARDWARE" ? $detalle['TipoCategoria'] : '';
                            
                            $arrayDevolucion = array(
                                'IDUsuarioAsignado' => $reposicion['UsuarioAdjudicado'],
                                'MotivoDevolucion'  => $detalle['MotivoDevolucion'],
                                'TipoElemento'      => $detalle['TipoElemento'],
                                'TipoCategoria'     => $tipoCategoria,
                                'SoloReposicion'    => "Y"
                            );
                            
                            $registrosFalla = $this->asignacionesDetalle->obtenerDispositivosMotivoDevolucionUsuario($arrayDevolucion);
                            
                            $cantidadFalla  = empty($registrosFalla) ? 0 : count($registrosFalla)-1;
                            
                            if($cantidadFalla === 0)
                            {
                                $valorReposicion = ($detalle['TipoElemento'] == "HARDWARE" ? $this->veriactivos->calculoReposicionHardware($detalle, $listadoMonedas) : (is_numeric($detalle['PrecioCompraElemento']) ? $detalle['PrecioCompraElemento'] : 0 ));
                                $maximoExcepcion = $valorReposicion > 0 ? number_format(round($valorReposicion*0.5, 2), 2, '.', '') : 0;
                                
                                
                                $html .= '<div class="col-xl-6 col-lg-12">
                                    <div class="card '.$border.'">
                                        <div class="card-header">
                                            <div class="d-flex">
                                                <h6 class="card-title flex-grow-1 mb-0">
                                                    '.$detalle['TipoEquipo'].' - '.$detalle['Marca'].' '.$detalle['Modelo'].'
                                                    <br>
                                                    <small class="text-muted">'.$detalle['Serie'].'</small>
                                                </h6>
                                                <div class="flex-shrink-0 d-flex align-items-center justify-content-center">
                                                    <a class="badge bg-primary-subtle text-primary fs-11">'.$motivosDevolucion[$detalle['MotivoDevolucion']].'</a>
                                                    <input type="hidden" name="txtMotivoDevolucionExcepcionReposicion['.$detalle['IDDetalleReposicion'].']" value="'.$detalle['MotivoDevolucion'].'">
                                                    <input type="hidden" name="txtIDDetalleReposicion[]" value="'.$detalle['IDDetalleReposicion'].'">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="row col-12 m-0 p-0 mb-2 d-flex">
                                                <div class="col-12 m-0 p-0">
                                                    <h5 class="mb-1">Generar Excepción</h5>
                                                    <p class="color-red m-0">¿Desea generar una excepción para este activo?:</p>
                                                </div>
                                                <div class="row col-12 m-0 p-0">
                                                    <div class="col-6 p-0 m-0 my-2">
                                                        <div class="pe-3">
                                                            <div class="form-check card-radio">
                                                                <input id="rdbtnGeneraExcepcion_exrep'.$detalle['IDDetalleReposicion'].'" name="generaExcepcion['.$detalle['IDDetalleReposicion'].']" type="radio" class="form-check-input rdbtnGenerarExcepcionReposicion" data-detalle-reposicion="'.$detalle['IDDetalleReposicion'].'" value="Y">
                                                                <label class="form-check-label" for="rdbtnGeneraExcepcion_exrep'.$detalle['IDDetalleReposicion'].'">
                                                                    <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-up align-bottom"></i></span>
                                                                    <span class="fs-14 text-wrap">Si</span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-6 p-0 m-0 my-2">
                                                        <div class="ps-3">
                                                            <div class="form-check card-radio">
                                                                <input id="rdbtnNoGeneraExcepcion_exrep'.$detalle['IDDetalleReposicion'].'" name="generaExcepcion['.$detalle['IDDetalleReposicion'].']" type="radio" class="form-check-input rdbtnGenerarExcepcionReposicion" data-detalle-reposicion="'.$detalle['IDDetalleReposicion'].'" value="N">
                                                                <label class="form-check-label" for="rdbtnNoGeneraExcepcion_exrep'.$detalle['IDDetalleReposicion'].'">
                                                                    <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-down align-bottom"></i></span>
                                                                    <span class="fs-14 text-wrap">No</span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="collapse m-0 p-0" id="ctnGeneraExcepcionReposicion'.$detalle['IDDetalleReposicion'].'" style="">
                                                <div class="row col-12 m-0 p-0 d-flex">
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                            		    <label class="form-label">Precio de Compra:</label>
                                            			<div class="input-group">
                                                            <span class="input-group-text">'.$simbolosMonedas[$detalle['MonedaElemento']].'</span>
                                                            <input type="number" class="form-control" value="'.$detalle['PrecioCompraElemento'].'" disabled>
                                                        </div>
                                            		</div>
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                            		    <label class="form-label">Monto máximo excepción:</label>
                                            			<div class="input-group">
                                                            <span class="input-group-text">S/ </span>
                                                            <input type="number" class="form-control" value="'.$maximoExcepcion.'" disabled>
                                                        </div>
                                            		</div>
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                            		    <label class="form-label">Descuento total:</label>
                                            			<div class="input-group">
                                                            <span class="input-group-text">S/ </span>
                                                            <input type="number" class="form-control" id="txtDescuentoTotal_exrep'.$detalle['IDDetalleReposicion'].'" name="descuentoTotal['.$detalle['IDDetalleReposicion'].']" step="0.01" min="1" value="'.$detalle['TotalDescuento'].'" style="pointer-events: none; background:#AAA; color:#F5F5F5;" >
                                                            <input type="hidden" class="form-control" id="txtDescuentoTotalOrigen_exrep'.$detalle['IDDetalleReposicion'].'" value="'.$detalle['TotalDescuento'].'">
                                                        </div>
                                            		</div>
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                            		    <label class="form-label">% Verisure:</label>
                                            			<div class="input-group">
                                                            <span class="input-group-text">S/ </span>
                                                            <input type="number" class="form-control" id="txtPorcentajeVerisure_exrep'.$detalle['IDDetalleReposicion'].'" name="porcentajeVerisure['.$detalle['IDDetalleReposicion'].']" step="0.01" min="0" value="'.$detalle['TotalVerisure'].'" style="pointer-events: none; background:#AAA; color:#F5F5F5;" >
                                                            <input type="hidden" class="form-control" id="txtPorcentajeVerisureOrigen_exrep'.$detalle['IDDetalleReposicion'].'" value="'.$detalle['TotalVerisure'].'">
                                                        </div>
                                            		</div>
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                            		    <label class="form-label">% Trabajador:</label>
                                            			<div class="input-group">
                                                            <span class="input-group-text">S/ </span>
                                                            <input type="number" class="form-control" id="txtPorcentajeTrabajador_exrep'.$detalle['IDDetalleReposicion'].'" name="porcentajeTrabajador['.$detalle['IDDetalleReposicion'].']" step="0.01" min="0" value="'.$detalle['TotalTrabajador'].'" style="pointer-events: none; background:#AAA; color:#F5F5F5;" >
                                                            <input type="hidden" class="form-control" id="txtPorcentajeTrabajadorOrigen_exrep'.$detalle['IDDetalleReposicion'].'" value="'.$detalle['TotalTrabajador'].'" >
                                                        </div>
                                            		</div>
                                            		<div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-2">
                            						    <!-- Slider-->
                                                        <div id="ctnExcepcionReposicion'.$detalle['IDDetalleReposicion'].'">
                                                            <div class="row">
                                                                <div class="col-lg-12 my-2">
                                                                    <h5 class="fs-14">Monto Excepción</h5>
                                                                </div>
                                                                <div class="col-lg-12">
                                                                    <div id="slideExcepcionReposicion'.$detalle['IDDetalleReposicion'].'"></div>
                                                                    <div class="d-flex justify-content-between align-items-center mt-2">
                                                                        <div>
                                                                            <strong>Min:</strong> <span id="minimoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'"></span>
                                                                        </div>
                                                                        <div>
                                                                            <strong>Valor:</strong> 
                                                                            <div class="input-group">
                                                                                <span class="input-group-text">S/ </span>
                                                                                <input type="number" class="form-control form-control-sm valorExcepcionReposicion" id="valorExcepcionReposicion'.$detalle['IDDetalleReposicion'].'" step="0.01" data-detalle-reposicion="'.$detalle['IDDetalleReposicion'].'">
                                                                            </div>
                                                                        </div>
                                                                        <div>
                                                                            <strong>Máx:</strong> <span id="maximoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'"></span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <input type="hidden" id="txtMontoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'" name="txtMontoExcepcionReposicion['.$detalle['IDDetalleReposicion'].']">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 my-1">
                                                        <div class="col-12">
                                                            <div class="form-group">
                                                                <label>Importar Correo de Aprobación</label>
                                                                <input type="file" id="fileCorreoAutorizacionExcepcion'.$detalle['IDDetalleReposicion'].'" class="filepond" data-max-file-size="100MB" data-max-files="6" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <script>
                                                        $(function () {
                                                            pondCorreoAutorizacionExcepcionReposicion'.$detalle['IDDetalleReposicion'].' = FilePond.create(
                                                                document.querySelector("#fileCorreoAutorizacionExcepcion'.$detalle['IDDetalleReposicion'].'"), {
                                                                    labelIdle: \'Arrastre y suelte el correo (.msg o .eml) o <span class="filepond--label-action">explore</span>\',
                                                                    allowMultiple: true,
                                                                    maxFiles: 3,
                                                                    instantUpload: false,
                                                                    allowProcess: false,
                                                                    onaddfile: (error, file) => 
                                                                    {
                                                                        const allowedExtensions = /\.(msg|eml)$/i;
                                                                        if (!allowedExtensions.test(file.filename)) 
                                                                        {
                                                                            Swal.fire({
                                                                                text: "Solo se permiten archivos de correo (.msg o .eml)[2].",
                                                                                icon: "warning",
                                                                                confirmButtonColor: "#282e38",
                                                                                confirmButtonText: "OK"
                                                                            });
                                                                            // Remover archivo
                                                                            pondCorreoAutorizacionExcepcionReposicion'.$detalle['IDDetalleReposicion'].'.removeFile(file.id);
                                                                        }
                                                                    }
                                                                }
                                                            );
                                                            
                                                            let minValor = 0;
                                                            let maxValor = '.$maximoExcepcion.';
                                                            let startValor = 0;
                                    
                                                            let slider'.$detalle['IDDetalleReposicion'].' = document.getElementById("slideExcepcionReposicion'.$detalle['IDDetalleReposicion'].'");
                                                            if (slider'.$detalle['IDDetalleReposicion'].'.noUiSlider) {
                                                                slider'.$detalle['IDDetalleReposicion'].'.noUiSlider.destroy();
                                                            }
                                    
                                                            noUiSlider.create(slider'.$detalle['IDDetalleReposicion'].', {
                                                                start: [startValor],
                                                                connect: [true, false],
                                                                range: {
                                                                    min: minValor,
                                                                    max: maxValor
                                                                },
                                                                step: 0.01,
                                                                tooltips: true,
                                                                format: {
                                                                    to: value => "S/ " + value.toFixed(2),
                                                                    from: value => Number(value.replace(/[^0-9.-]+/g, ""))
                                                                }
                                                            });
                                    
                                                            $("#minimoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").text("S/ " + minValor);
                                                            $("#maximoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").text("S/ " + maxValor);
                                                            $("#valorExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").val(startValor);
                                                            
                                                            
                                                            slider'.$detalle['IDDetalleReposicion'].'.noUiSlider.on("update", function (values, handle) {
                                                                let descuentoTexto = values[handle];
                                                                let descuento = parseFloat(descuentoTexto.replace(/[^0-9.]/g, ""));
                                                                
                                                                let valorVerisure = parseFloat($("#txtPorcentajeVerisureOrigen_exrep'.$detalle['IDDetalleReposicion'].'").val()) || 0;;
                                                                let valorTrabajador = parseFloat($("#txtPorcentajeTrabajadorOrigen_exrep'.$detalle['IDDetalleReposicion'].'").val()) || 0;;
                                    
                                                                $("#txtMontoExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").val(descuento);
                                                                $("#valorExcepcionReposicion'.$detalle['IDDetalleReposicion'].'").val(descuento.toFixed(2));
                                                                
                                                                $("#txtPorcentajeVerisure_exrep'.$detalle['IDDetalleReposicion'].'").val((valorVerisure + descuento).toFixed(2));
                                                                $("#txtPorcentajeTrabajador_exrep'.$detalle['IDDetalleReposicion'].'").val((valorTrabajador - descuento).toFixed(2));
                                                            });
                                                            
                                                        });
                                                    </script>
                                                </div>
                                            </div>';
                                        $html .= '</div>
                                    </div>
                                </div>';
                                
                                $existeExcepcion = true;
                            }
                        }
                    }
                }
                
                if(!$existeExcepcion)
                {
                    $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
        	            <div class="col-xxl-10 col-md-12 col-12 ">
                	        <div class="alert alert-info alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                                <i class="ri-error-info-line me-3 align-middle fs-16"></i><strong>SIN EXCEPCIONES</strong> - No hay items autorizados para generar excepción
                                <input type="hidden" id="txtNoItemsExcepcion">
                            </div>
                        </div>
                	</div>';
                }
            }
            else
            {
                $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
    	            <div class="col-xxl-10 col-md-12 col-12 ">
            	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                            <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN FACTURAS</strong> - No se encontró facturas para este aprobador
                        </div>
                    </div>
            	</div>';
            }
            
        }
        else 
		{
            $html = '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px justify-content-center align-items-center" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-12 col-12 ">
        	        <div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0 text-center" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN SESIÓN</strong> - No hay sesión iniciada. Inicie sesión nuevamente.
                    </div>
                </div>
        	</div>';
		}
		
		echo $html;
    }
    
    public function registroExcepcionReposicion()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idReposicion           = $this->request->getPost('txtIDReposicion_exrep'); //string
        $idDetalleReposicion    = $this->request->getPost('txtIDDetalleReposicion'); //array
        $excepcionElemento      = $this->request->getPost('generaExcepcion'); //Decisión Si-No de excepcion activo (checkbox)
        $motivoDevolucion       = $this->request->getPost('txtMotivoDevolucionExcepcionReposicion'); //Motivo de devolución
        
        $descuentoTotal         = $this->request->getPost('descuentoTotal'); //string
        $porcentajeVerisure     = $this->request->getPost('porcentajeVerisure'); //string
        $porcentajeTrabajador   = $this->request->getPost('porcentajeTrabajador'); //string
        $valorExcepcion         = $this->request->getPost('txtMontoExcepcionReposicion'); //string
        
        $adjuntosTotales        = $this->request->getFiles();
        
        $correoExcepcion        = isset($adjuntosTotales["correoExcepcion"]) ? $adjuntosTotales["correoExcepcion"] : "";
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        //Quitamos a los N de $excepcionElemento ya que esos no van a generar Excepcion
        
        $excepcionElemento = array_filter(
            $excepcionElemento, function($value) 
            {
                return $value !== 'N';
            }
        );
        
        // Evaluamos valores de excepción.
        
        $error = '';
        
        if(empty($excepcionElemento))
        {
            $error .= "<li>Debe seleccionar la generación de la excepción de un activo como mínimo.</li>";
        }
        else
        {
            foreach($excepcionElemento as $idDetalle => $valor)
            {
                if($valorExcepcion[$idDetalle] === "0")
                {
                    $error .= "<li>El monto de excepción no puede ser 0.</li>";
                }
                else
                {
                    if(empty($correoExcepcion) && !isset($correoExcepcion[$idDetalle]))
                    {
                        $error .= "<li>No se encuentra el correo de autorización adjunto en una excepción.</li>";
                    }
                }
            }
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * EJECUCIÓN DE TRANSACCIÓN
        * ----------------------------
        */
        
        // $dataDetalleInforme = array();
        $dataUpdateDetalleReposicion = array();
        $dataUpdateCronogramaReposicion = array();
        $dataInsertCronogramaReposicion = array();
        $nombresAdjuntos = array();
        
        try 
        {
            //INICIO DE TRANSACCIÓN
            $this->db->transBegin();
            
            //OBTENER INFORMACIÓN DE LA REPOSICIÓN (DETALLE Y CRONOGRAMA)

            foreach($excepcionElemento as $idDetalle => $valor)
            {
                //OBTENGO INFORMACIÓN DE DETALLE DE REPOSICIÓN:
                $detalleReposicion = $this->reposicionesDetalle->where("IDDetalleReposicion", $idDetalle)->first();
                
                //OBTENGO INFORMACIÓN DE CRONOGRAMA DE REPOSICIÓN
                $cronogramaReposicion = $this->reposicionesCronogramaPago->where("IDDetalleReposicion", $idDetalle)->orderBy('NroCuota', 'ASC')->findAll();
                
                if($porcentajeTrabajador[$idDetalle] > 0)
                {
                    //EVALUAR NUEVO MONTO DE TRABAJADOR Y RECALCULAR LAS CUOTAS 
                    $cuotasTrabajador = $this->veriactivos->cuotasDescuentoEquiposInformaticos($porcentajeTrabajador[$idDetalle]);
                }
                else
                {
                    $cuotasTrabajador = 1;
                }
                
                if($detalleReposicion['TotalCuotas'] !== $cuotasTrabajador)
                {
                    //ARMADO DE VALORES PARA ACTUALIZAR DETALLE DE REPOSICIÓN - MASIVO
                    
                    $dataUpdateDetalleReposicion[] = array(
                        'IDDetalleReposicion'   => (int) $idDetalle,
                        'TotalVerisure'         => $porcentajeVerisure[$idDetalle],
                        'TotalTrabajador'       => $porcentajeTrabajador[$idDetalle],
                        'TotalCuotas'           => $cuotasTrabajador,
                        'UsuarioExcepcion'      => $this->items['id'],
                        'FechaExcepcion'        => $fechaActual,
                        'MontoExcepcion'        => $valorExcepcion[$idDetalle],
                        'ObservacionExcepcion'  => "Excepción generada por: ".$motivoDevolucion[$idDetalle],
                        'UsuarioModifica'       => $this->items['id'],
                        'FechaModifica'         => $fechaActual,
                        'Localhost'             => $this->request->getIPAddress()
                    );
                }
                else
                {
                    //ARMADO DE VALORES PARA ACTUALIZAR DETALLE DE REPOSICIÓN - MASIVO
                    
                    $dataUpdateDetalleReposicion[] = array(
                        'IDDetalleReposicion'   => (int) $idDetalle,
                        'TotalVerisure'         => $porcentajeVerisure[$idDetalle],
                        'TotalTrabajador'       => $porcentajeTrabajador[$idDetalle],
                        'UsuarioExcepcion'      => $this->items['id'],
                        'FechaExcepcion'        => $fechaActual,
                        'MontoExcepcion'        => $valorExcepcion[$idDetalle],
                        'ObservacionExcepcion'  => "Excepción generada por: ".$motivoDevolucion[$idDetalle],
                        'UsuarioModifica'       => $this->items['id'],
                        'FechaModifica'         => $fechaActual,
                        'Localhost'             => $this->request->getIPAddress()
                    );
                }
                
                // OBTENER EL MONTO DE DESCUENTO MENSUAL DE ACUERDO A LAS NUEVAS CUOTAS DE TRABAJADOR
                
                $descuentoMensual = number_format(round($porcentajeTrabajador[$idDetalle] / $cuotasTrabajador, 2), 2, '.', '');
                
                $ultimoMesCuota = 0;
                $ultimoAnioCuota = 0;
                
                // Recorrer hasta el número de cuotas deseadas
                for ($i = 0; $i < $cuotasTrabajador; $i++) 
                {
                    $numeroCuota = $i + 1;
                    
                    if($numeroCuota == ($cuotasTrabajador))
                    {
                        $montoCuota = ($porcentajeTrabajador[$idDetalle] - (($cuotasTrabajador - 1)*$descuentoMensual));
                    }
                    else
                    {
                        $montoCuota = $descuentoMensual;
                    }
            
                
                    if (isset($cronogramaReposicion[$i])) 
                    {
                        // Si la cuota existe, actualizar monto y estado = 'A'
                        $dataUpdateCronogramaReposicion[] = array(
                            'IDCronogramaPago'  => (int) $cronogramaReposicion[$i]['IDCronogramaPago'],
                            'MontoCuota'        => $montoCuota,
                            'Observacion'       => "Monto modificado por excepción: ".$motivoDevolucion[$idDetalle],
                            'UsuarioModifica'   => $this->items['id'],
                            'FechaModifica'     => $fechaActual,
                            'Estado'            => "A",
                            'UsuarioEstado'     => $this->items['id'],
                            'FechaEstado'       => $fechaActual,
                            'Localhost'         => $this->request->getIPAddress()
                        );
                        
                        $ultimoMesCuota = $cronogramaReposicion[$i]['MesCuota'];
                        $ultimoAnioCuota = $cronogramaReposicion[$i]['AnioCuota'];
                    } 
                    else 
                    {
                        if($ultimoMesCuota == 12)
                        {
                            $ultimoMesCuota = 1;
                            $ultimoAnioCuota = $ultimoAnioCuota + 1;
                        }
                        else
                        {
                            $ultimoMesCuota++;
                        }
                        
                        // Si la cuota no existe, insertar nueva
                        $dataInsertCronogramaReposicion[] = array(
                            'IDDetalleReposicion'   => (int) $idDetalle,
                            'NroCuota'              => $numeroCuota,
                            'MesCuota'              => $ultimoMesCuota,
                            'AnioCuota'             => $ultimoAnioCuota,
                            'MontoCuota'            => $montoCuota,
                            'Observacion'           => "Cuota generada por excepción: ".$motivoDevolucion[$idDetalle],
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,
                            'Estado'                => "A",
                            'UsuarioEstado'         => $this->items['id'],
                            'FechaEstado'           => $fechaActual,
                            'Localhost'             => $this->request->getIPAddress()
                        );
                    }
                }
                
                // Si hay más cuotas existentes que las deseadas, inactivarlas
                if (count($cronogramaReposicion) > $cuotasTrabajador) 
                {
                    for ($j = $cuotasTrabajador; $j < count($cronogramaReposicion); $j++) 
                    {
                        $dataUpdateCronogramaReposicion[] = array(
                            'IDCronogramaPago'  => (int) $cronogramaReposicion[$j]['IDCronogramaPago'],
                            'MontoCuota'        => $cronogramaReposicion[$j]['MontoCuota'], // mantener sin cambios
                            'Observacion'       => "Cronograma desactivado por excepción: ".$motivoDevolucion[$idDetalle],
                            'UsuarioModifica'   => $this->items['id'],
                            'FechaModifica'     => $fechaActual,
                            'Estado'            => "I",
                            'UsuarioEstado'     => $this->items['id'],
                            'FechaEstado'       => $fechaActual,
                            'Localhost'         => $this->request->getIPAddress()
                        );
                        
                    }
                }
                
                //ASIGNAMOS LA NUEVA RUTA DONDE SE VA A GUARDAR EL ADJUNTO A REGISTRAR
                $ruta = $this->items['baseDinamic']."/docs/ActaReposicion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                
                //ADJUNTAR LOS CORREOS DE AUTORIZACIÓN
                if(!empty($correoExcepcion) && isset($correoExcepcion[$idDetalle]))
                {
                    foreach ($correoExcepcion[$idDetalle] as $key => $value) 
        	        {
                        if ($value->isValid() && ! $value->hasMoved()) 
                        {
                            //OBTENGO LA EXTENSIÓN DEL ADJUNTO A REGISTRAR
                            if($value->getClientExtension() != null)
                            {
                                $extAdjunto = strtolower($value->getClientExtension());
                            }
                            else if($value->guessExtension() != null)
                            {
                                $extAdjunto = strtolower($value->guessExtension());
                            }
                            else
                            {
                                $extAdjunto = strtolower(pathinfo($value->getClientName(), PATHINFO_EXTENSION));
                            }
                            
                            //OBTENGO EL NOMBRE DEL ADJUNTO A REGISTRAR
                            $nombreAdjunto = pathinfo($value->getClientName(), PATHINFO_FILENAME);
                            
                            //ARMADO DE VALORES DEL ADJUNTO A REGISTRAR
                            $dataAdjunto = array (
                                'IDReposicion'  => $idReposicion, 
                                'Nombre'        => $nombreAdjunto,
                                'Extension'     => $extAdjunto,
                                'Observacion'   => "Correo de autorización de excepción: ".$idDetalle,
                                'ReemplazoFirma'=> "N",
                                'Firma'         => "N",
                                'UsuarioCrea'   => $this->items['id'],
                                'FechaCrea'     => $fechaActual,
                                'Localhost'     => $this->request->getIPAddress()
                            );
                            
                            $lastIdAdjunto = $this->reposicionesAdjuntos->insert($dataAdjunto, TRUE);
                            
                            //VALIDAR Y CREAR CARPETA SI NO EXISTE
                            if (!is_dir($ruta)) 
                            {
                                if (!mkdir($ruta, 0777, true)) 
                                {
                                    // Si no se puede crear la carpeta, cancelar
                                    $this->db->transRollback();
                                    
                                    if(!empty($nombresAdjuntos))
                                    {
                                        // Eliminar archivos guardados
                                        foreach ($nombresAdjuntos as $archivoGuardado) 
                                        {
                                            if (file_exists($ruta.$archivoGuardado)) 
                                            {
                                                unlink($archivoGuardado);
                                            }
                                        }
                                    }
                                    
                                    $message = sprintf($this->mensajeError->msg201, "<li>No se pudo crear el directorio de almacenamiento. Inténtelo luego[ERRALMC]</li>");
                                    echo $this->alertas->alertaError($message);
                                    EXIT;
                                }
                            }
                            
                            //ASIGNAR EL NUEVO NOMBRE 
                            $nuevonombre =  $idReposicion.'-'.$lastIdAdjunto.'.'.$extAdjunto;
                            $nombresAdjuntos[] = $nuevonombre;
                            
                            //INTENTAR MOVER EL ARCHIVO
                            try 
                            {
                                $value->move($ruta, $nuevonombre);
                            } 
                            catch (\Exception $e) 
                            {
                                $this->db->transRollback();
                                
                                if(!empty($nombresAdjuntos))
                                {
                                    // Eliminar archivos guardados
                                    foreach ($nombresAdjuntos as $archivoGuardado) 
                                    {
                                        if (file_exists($ruta.$archivoGuardado)) 
                                        {
                                            unlink($archivoGuardado);
                                        }
                                    }
                                }
                                
                                $message = sprintf($this->mensajeError->msg201, "<li>Error al guardar el archivo: ".$e->getMessage().". Inténtelo luego[ERRALMC]</li>");
                                echo $this->alertas->alertaError($message);
                                EXIT;
                            }
                            
                        }
        	        }
                }
            }
            
            //INSERTAR Y ACTUALIZAR REGISTROS MASIVOS
            
            if (!empty($dataUpdateDetalleReposicion)) 
            {
                $this->reposicionesDetalle->updateBatch($dataUpdateDetalleReposicion, 'IDDetalleReposicion');
            }
            else
            {
                $this->db->transRollback();
                                
                if(!empty($nombresAdjuntos))
                {
                    // Eliminar archivos guardados
                    foreach ($nombresAdjuntos as $archivoGuardado) 
                    {
                        if (file_exists($ruta.$archivoGuardado)) 
                        {
                            unlink($archivoGuardado);
                        }
                    }
                }
                
                $message = sprintf($this->mensajeError->msg201, "<li>No hay información en el detalle a guardar. Inténtelo luego.</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }
            
            if (!empty($dataUpdateCronogramaReposicion)) 
            {
                $this->reposicionesCronogramaPago->updateBatch($dataUpdateCronogramaReposicion, 'IDCronogramaPago');
            }
            else
            {
                $this->db->transRollback();
                                
                if(!empty($nombresAdjuntos))
                {
                    // Eliminar archivos guardados
                    foreach ($nombresAdjuntos as $archivoGuardado) 
                    {
                        if (file_exists($ruta.$archivoGuardado)) 
                        {
                            unlink($archivoGuardado);
                        }
                    }
                }
                
                $message = sprintf($this->mensajeError->msg201, "<li>No hay información en el cronograma a guardar. Inténtelo luego.</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }
            
            if (!empty($dataInsertCronogramaReposicion)) 
            {
                $this->reposicionesCronogramaPago->insertBatch($dataInsertCronogramaReposicion);
            }
            
            
            //VALIDACIÓN DE QUERYS
            if ($this->db->transStatus() === false) 
            {
                // Algo falló en los queries, pero no se lanzó excepción automáticamente
                // Asigna el error en "Throw" para que sea detectado por el catch y dispare el error
                throw new DatabaseException('Error en la transacción');
            }

            $this->db->transCommit();
            
            $message = sprintf($this->mensajeError->msg201, "La solicitud fue registrada con éxito");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        } 
        catch (\Throwable $e) 
        {
            $this->db->transRollback();
            
            //ASIGNAMOS LA NUEVA RUTA DONDE SE VA A GUARDAR EL ADJUNTO A REGISTRAR
            $ruta = $this->items['baseDinamic']."/docs/ActaReposicion/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
            
            if(!empty($nombresAdjuntos))
            {
                // Eliminar archivos guardados
                foreach ($nombresAdjuntos as $archivoGuardado) 
                {
                    if (file_exists($ruta.$archivoGuardado)) 
                    {
                        unlink($archivoGuardado);
                    }
                }
            }
                                                
            $message = sprintf($this->mensajeError->msg201, "<li>Error en la transacción. No se pudo registrar la solicitud. Inténtelo luego[ERRTRANS]</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
    }

	/**************************************************************************/
	
    /******************************* DESCUENTOS *******************************/
    
    public function listarDescuentosMensual()
    {
        if(isset($this->items['id']))
		{
			$data = array (
				'session'                       => 'on',
				'titulo'                        => 'Descuentos por Reposición | Verisure',
				'breadcrumb'                    => $this->items['modulo'],
				'breadcrumb_alias'              => 'Descuentos del mes',
                // 'previo'                 => 'listar-proveedores',
				'elementoSeleccionadoModulo'    => "Descuentos del mes",
				'subtitulo'                     => 'Descuentos '.$this->complementos->parseoMes(date("m"), FALSE).' '.date("Y")
			);
			
			$data = array_merge($data, $this->items);
			
			return view('cargos/listar_descuentos_mensual',$data);			
		} 
		else 
		{
			return view('errors/500');
		}
    }
    
    public function descuentosReposicionServerside()
    {
        if (isset($this->items['id'])) 
    	{
            $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
    	    $dataServerside =  $this->reposicionesDetalle->listarDescuentosReposicionesServerside($this->request->getPost(), $adicionales);
    	    
    	    foreach($dataServerside["data"] as $key=>$value)
            {
                $dataServerside["data"][$key]['Usuario']                = $value['NombresAdjudicado'].' '.$value['ApellidosAdjudicado'];
                $dataServerside["data"][$key]['PeriodoDescuento']       = $this->complementos->parseoMes($value['MesFacturacion'], FALSE).' '.$value['AnioFacturacion'];
                $dataServerside["data"][$key]['ElementoDescuento']      = $value['TipoEquipo'].' '.$value['Marca'].' '.$value['Modelo'];
                $dataServerside["data"][$key]['MontoDescuentoTotal']    = 'S/ '.$value['TotalTrabajador'];
                $dataServerside["data"][$key]['MontoCobrado']           = (($value['MontoCobro'] != '' && $value['MontoCobro'] != null) || $value['MontoCobro'] === "0.00"  ? "S/ ".$value['MontoCobro'] : '<span class="badge bg-light border-0 text-dark">Sin información</span>');
                $dataServerside["data"][$key]['FechaCobrado']           = ($value['FechaCobro'] != '' && $value['FechaCobro'] != null ? date("d-m-Y", strtotime($value['FechaCobro'])) : '<span class="badge bg-light border-0 text-dark">Sin información</span>');
                $dataServerside["data"][$key]['ObservacionCobrado']     = ($value['ObservacionCobro'] != '' && $value['ObservacionCobro'] != null ? $value['ObservacionCobro'] : '<span class="badge bg-light border-0 text-dark">Sin información</span>');
                
                //CONFIGURACIÓN DE LA INFORMACIÓN "COBRADO"
                $cobrado = '';
                
                if($value['Cobrado'] == 'Y' )
                {
                    $cobrado .= '<span class="badge bg-success border-0">SI</span>';
                }
                else
                {
                    $cobrado .= '<span class="badge bg-danger border-0">NO</span>';
                }
                
                $dataServerside["data"][$key]['DescuentoCobrado'] = $cobrado;
                
                //CONFIGURACIÓN DE LOS BOTONES DE LAS ACTAS
                $acciones = "";
                $acciones .= "<div class='dropdown d-inline-block'>";
                
                $acciones .= "<a href='".$this->items['baseUrl']."/detalle-acta-asignacion/".$value['IDAsignacion']."/".$value['TokenAsignacion']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Detalle de Asignación' aria-label='Ver Detalle de Asignación'>
                    <i class='mdi mdi-file-sign align-bottom' style='font-size: 20px; color: #FFF;'></i>
                </a>";
                
                $acciones .= "<a href='".$this->items['baseUrl']."/detalle-acta-reposicion/".$value['IDReposicion']."/".$value['TokenReposicion']."' target='_blank' class='badge bg-sistema border-0 p-2 mx-1' data-tooltip='tooltip' data-toggle='tooltip' data-placement='top' title='Ver Detalle de Reposición' aria-label='Ver Detalle de Reposición'>
                    <i class='mdi mdi-file-sign align-bottom' style='font-size: 20px; color: #FFF;'></i>
                </a>";
                
    			$acciones .= "</div>";
                
                $dataServerside["data"][$key]['BotonesDocumento'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	} 
    	else 
    	{
            $resultado = array(
				'descripcion' => 0,
			);
			echo json_encode($resultado, JSON_NUMERIC_CHECK);
        }
    }
    
    public function exportarDescuentoMensual($mes, $anio)
    {
        $arrayDescuento = array(
            "MesFacturacion"    => $mes,
            "AnioFacturacion"   => $anio,
            "Cobrado"           => "N",
            "return"            => "array"
        );
        
        $listadoMensual = $this->reposicionesDetalle->obtenerInformacionDescuentoReposicion($arrayDescuento);
        
        $filename = "Descuentos por reposición ".$mes." - ".$anio.".csv";
        $writer = WriterEntityFactory::createCSVWriter();
        $writer->setFieldDelimiter(';');
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Código"),
            WriterEntityFactory::createCell("Matrícula"),
            WriterEntityFactory::createCell("Usuario"),
            WriterEntityFactory::createCell("Periodo"),
            WriterEntityFactory::createCell("Fecha Firma Asignación"),
            WriterEntityFactory::createCell("Fecha Firma Reposición"),
            WriterEntityFactory::createCell("Elemento"),
            WriterEntityFactory::createCell("Monto Descuento"),
            WriterEntityFactory::createCell("Cuotas"),
            WriterEntityFactory::createCell("Monto Cobrado"),
            WriterEntityFactory::createCell("Fecha Cobro"),
            WriterEntityFactory::createCell("Observación Cobro")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoMensual as $key=>$item)
        {
            $periodo = (string) $this->complementos->parseoMes($mes, FALSE).' | '.$anio;
            
            $fechaFirmaAsignacion = $item['FirmaAsignacion'] != "" && $item['FirmaAsignacion'] != null ? date("Y-m-d", strtotime($item['FirmaAsignacion'])) : "SIN FIRMA";
            $fechaFirmaReposicion = $item['FirmaReposicion'] != "" && $item['FirmaReposicion'] != null ? date("Y-m-d", strtotime($item['FirmaReposicion'])) : "SIN FIRMA";
            
			$cells = [
                WriterEntityFactory::createCell($item['IDDetalleReposicion']),
                WriterEntityFactory::createCell($item['MatriculaAdjudicado']),
                WriterEntityFactory::createCell($item['NombresAdjudicado'].' '.$item['ApellidosAdjudicado']),
                WriterEntityFactory::createCell($periodo),
                WriterEntityFactory::createCell($fechaFirmaAsignacion),
                WriterEntityFactory::createCell($fechaFirmaReposicion),
                WriterEntityFactory::createCell($item['TipoEquipo'].' '.$item['Marca'].' '.$item['Modelo']),
                WriterEntityFactory::createCell($item['TotalTrabajador']),
                WriterEntityFactory::createCell($item['TotalCuotas']),
                WriterEntityFactory::createCell(""),
                WriterEntityFactory::createCell(""),
                WriterEntityFactory::createCell("")
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }
    
    public function importarDescuentosMensual()
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("file");

        /*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'file' => [
                'mime_in[file,text/csv,text/plain]',
                'ext_in[file,csv]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
        
        $separadorCSV = $this->complementos->validarSeparadorCSV($csv, 12);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $arrayElementos = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales
                $id = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $montoCobrado = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCobro = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                
                if($id == '' || $id == null)
                {
                    $filasError[$fila]['CÓDIGO'] = "EL CÓDIGO SE ENCUENTRA VACÍO.";
                    $ejecutarInsert = false;
                }
                
                $detectaFormatoFC = strpos($fechaCobro, "/");
                    
                if($detectaFormatoFC === false)
                {
                    if(strtotime($fechaCobro)=='' || strtotime($fechaCobro)==0 || strtotime($fechaCobro) == false)
                    {
                        $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (YYYY-MM-DD).";
                        $ejecutarInsert = false;
                    }
                }
                else
                {
                    try {
                        $fechaCobro = date_create_from_format('j/m/Y', $fechaCobro);
                        $fechaCobro = date_format($fechaCobro, 'Y-m-d');
                    } catch (Exception $e) {
                        $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (DD/MM/YYYY).";
                        $ejecutarInsert = false;
                    }
                }
                
                if(!is_numeric($montoCobrado) && $montoCobrado != null && $montoCobrado != '')
                {
                    $filasError[$fila]['MONTO COBRADO'] = "EL MONTO INGRESADO NO ES UN NÚMERO.";
                    $ejecutarInsert = false;
                }
                else if($montoCobrado != null && $montoCobrado != '')
                {
                    if(strtotime($fechaCobro) == '')
                    {
                        $detectaFormatoFC = strpos($fechaCobro, "/");
                    
                        if($detectaFormatoFC === false)
                        {
                            if(strtotime($fechaCobro)=='' || strtotime($fechaCobro)==0 || strtotime($fechaCobro) == false)
                            {
                                $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (YYYY-MM-DD).";
                                $ejecutarInsert = false;
                            }
                        }
                        else
                        {
                            try {
                                $fechaCobro = date_create_from_format('j/m/Y', $fechaCobro);
                                $fechaCobro = date_format($fechaCobro, 'Y-m-d');
                            } catch (Exception $e) {
                                $filasError[$fila]['FECHA COBRO'] = "LA FECHA NO CUENTA CON EL FORMATO ADECUADO (DD/MM/YYYY).";
                                $ejecutarInsert = false;
                            }
                        }
                    }
                }
                
            }
        }

        fclose($handle);

        if(!$ejecutarInsert)
        {
            $raiz = $this->items['basePublic'].'/';
            $nombre = 'error.txt';
            $file = $this->items['basePublic'].'/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);
			echo $salida1.$salida2;
			//echo $salida1;
            
			exit;
        }
        
        /*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        //Declaramos variables
        $arrayUpdateDescuento = [];
        
        $filainsert = 0;
        //Abrimos el archivo
        $handleInsert = fopen($csv, "r");
        
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleInsert, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
                //Asignamos valores de CSV a variables locales
                $idDetalle = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
                $montoCobrado = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
                $fechaCobro = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
                $observacionCobro = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
                
                
                $detectaFormatoFC = strpos($fechaCobro, "/");
                    
                if($detectaFormatoFC === false)
                {
                    $fechaCobro = date("Y-m-d", strtotime($fechaCobro));
                }
                else
                {
                    $fechaCobro_e = $this->complementos->myUrlEncode($fechaCobro);
                    $fechaCobro = date('Y-m-d', strtotime(str_replace('/', '-', $fechaCobro_e)));
                }
                
                if($montoCobrado != ''  && $montoCobrado != null)
                {
                    $arrayUpdateDescuento[] = array(
                        "IDDetalleReposicion"   => $idDetalle,
                        "Cobrado"               => "Y",
                        "UsuarioCobro"          => $this->items['id'],
                        "FechaCobro"            => $fechaCobro,
                        "MontoCobro"            => $montoCobrado,
                        "ObservacionCobro"      => $observacionCobro,
                        "UsuarioModifica"       => $this->items['id'],
                        'FechaModifica'         => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress());
                }
                
            }
        }

        fclose($handleInsert);
        
        $lastId = $this->reposicionesDetalle->updateBatch($arrayUpdateDescuento, 'IDDetalleReposicion');

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg201, "Cobros registrados correctamente.");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
        
    }

    public function exportarDescuentoGlobal()
    {
        $arrayDescuento = array(
        );
        
        $listadoMensual = $this->reposicionesDetalle->obtenerInformacionDescuentoReposicion($arrayDescuento);
        
        $filename = "Descuentos por reposición global.csv";
        $writer = WriterEntityFactory::createCSVWriter();
        $writer->setFieldDelimiter(';');
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Código"),
            WriterEntityFactory::createCell("Matrícula"),
            WriterEntityFactory::createCell("Usuario"),
            WriterEntityFactory::createCell("Dirección"),
            WriterEntityFactory::createCell("Área"),
            WriterEntityFactory::createCell("Subárea"),
            WriterEntityFactory::createCell("Delegación"),
            WriterEntityFactory::createCell("CC"),
            WriterEntityFactory::createCell("LN"),
            WriterEntityFactory::createCell("Periodo"),
            WriterEntityFactory::createCell("Elemento"),
            WriterEntityFactory::createCell("Firma Reposición"),
            WriterEntityFactory::createCell("Firma Asignación"),
            WriterEntityFactory::createCell("Monto Descuento"),
            WriterEntityFactory::createCell("Cuotas"),
            WriterEntityFactory::createCell("Monto Cobrado"),
            WriterEntityFactory::createCell("Fecha Cobro"),
            WriterEntityFactory::createCell("Observación Cobro")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoMensual as $key=>$item)
        {
            $periodo = (string) $this->complementos->parseoMes($item['MesFacturacion'], FALSE).' | '.$item['AnioFacturacion'];
			$cells = [
                WriterEntityFactory::createCell($item['IDDetalleReposicion']),
                WriterEntityFactory::createCell($item['MatriculaAdjudicado']),
                WriterEntityFactory::createCell($item['NombresAdjudicado'].' '.$item['ApellidosAdjudicado']),
                WriterEntityFactory::createCell($item['DireccionAdjudicado']),
                WriterEntityFactory::createCell($item['AreaAdjudicado']),
                WriterEntityFactory::createCell($item['SubareaAdjudicado']),
                WriterEntityFactory::createCell($item['DelegacionAdjudicado']),
                WriterEntityFactory::createCell($item['CCAdjudicado']),
                WriterEntityFactory::createCell($item['LNAdjudicado']),
                WriterEntityFactory::createCell($periodo),
                WriterEntityFactory::createCell($item['TipoEquipo'].' '.$item['Marca'].' '.$item['Modelo']),
                WriterEntityFactory::createCell($item['FirmaReposicion']),
                WriterEntityFactory::createCell($item['FirmaAsignacion']),
                WriterEntityFactory::createCell($item['TotalTrabajador']),
                WriterEntityFactory::createCell($item['TotalCuotas']),
                WriterEntityFactory::createCell($item['MontoCobro']),
                WriterEntityFactory::createCell($item['FechaCobro']),
                WriterEntityFactory::createCell($item['ObservacionCobro'])
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
    }    
    
	/**************************************************************************/
	
    /*************************** CATEGORÍAS - TIPOS ***************************/
    
	/**************************************************************************/
	
    /********************* CATEGORÍAS - TIPOS - SUBTIPOS **********************/
    
	/**************************************************************************/
	
    /***************************** ELEMENTOS DEMO *****************************/
    
	/**************************************************************************/
	
    /******************* CUENTAS CONTABLES - SUBCATEGORÍAS ********************/
    
	/**************************************************************************/
	
    /************************** PROVEEDORES ***********************************/
    
	/**************************************************************************/
	
    /********************* MODALIDAD DE PAGO - PROVEEDOR **********************/
    
	/**************************************************************************/
	
	
}