<?php

use CodeIgniter\Router\RouteCollection;
$routes->get('test-controller', 'TestController::index');
// $routes->add('test', function() {
//     return 'Ruta de prueba funcionando';
// });
/**
 * @var RouteCollection $routes
 */
// $routes->get('/', 'Home::index');
$routes->set404Override(function()
{
    echo view('errors/404');
});
/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Acceso::login');

/* ACCESO */
$routes->add('entrar', 'Acceso::entrar');
$routes->add('salir','Acceso::salir');
$routes->add('iniciar-sesion','Acceso::login');
$routes->add('cambiar-password', 'Acceso::cambiarPasswordUsuario');

/* ADMINISTRACIÓN */
$routes->add('descargatxt/(:any)','Administracion::descargatxt/$1');/* NUEVO */

$routes->add('listar-usuarios','Administracion::listarUsuarios');/* NUEVO */

$routes->add('listar-perfiles','Administracion::listarPerfiles');/* NUEVO */
$routes->add('registrar-perfil','Administracion::registrarPerfil');/* NUEVO */
$routes->add('listado-perfil-select','Administracion::listadoPerfilesSelect');/* NUEVO */
$routes->add('obtener-datos-perfil','Administracion::obtenerDatosPerfil');/* NUEVO */
$routes->add('actualizar-perfil/(:any)','Administracion::actualizarPerfil/$1');/* NUEVO */
$routes->add('cambiar-estado-perfil','Administracion::modificarEstadoPerfil');/* NUEVO */

$routes->add('listar-permisos-perfil/(:any)','Administracion::listarPermisosPerfil/$1');/* NUEVO */
$routes->add('grabar-permisos-perfil/(:any)','Administracion::guardarPermisosPerfil/$1');/* NUEVO */
$routes->add('listar-rutas-perfil/(:any)','Administracion::listarRutasPerfil/$1');/* NUEVO */
$routes->add('grabar-rutas-perfil/(:any)','Administracion::guardarRutasPerfil/$1');/* NUEVO */

$routes->add('obtener-cabecera','Administracion::obtenerCabecera');/* NUEVO */
$routes->add('listar-modulos','Administracion::listarModulos');/* NUEVO */
$routes->add('registrar-modulo','Administracion::registrarModulo');/* NUEVO */
$routes->add('cambiar-estado-modulo','Administracion::modificarEstadoModulo');/* NUEVO */
$routes->add('obtener-datos-modulo','Administracion::obtenerDatosModulo');/* NUEVO */
$routes->add('actualizar-modulo/(:any)','Administracion::modificarModulo/$1');/* NUEVO */
$routes->add('listar-rutas-modulo/(:any)','Administracion::listarRutasModulo/$1');/* NUEVO */
$routes->add('grabar-ruta/(:any)','Administracion::guardarRutaModulo/$1');/* NUEVO */
$routes->add('obtener-datos-ruta-modulo','Administracion::obtenerDatosRutaModulo');/* NUEVO */
$routes->add('actualizar-ruta-modulo/(:any)','Administracion::modificarRutaModulo/$1');/* NUEVO */
$routes->add('cambiar-estado-ruta-modulo','Administracion::modificarEstadoRutaModulo');/* NUEVO */
$routes->add('listar-acciones-modulo/(:any)','Administracion::listarAccionesModulo/$1');/* NUEVO */
$routes->add('grabar-accion/(:any)','Administracion::guardarAccionModulo/$1');/* NUEVO */

$routes->add('listar-informacion-legal','Administracion::listarInformacionLegal');/* NUEVO */
$routes->add('legales-serverside','Administracion::legalesServerside');/* NUEVO */
$routes->add('registrar-informacion-legal','Administracion::registrarInformacionLegal');/* NUEVO */
$routes->add('obtener-datos-informacion-legal','Administracion::obtenerDatosInformacionLegal');/* NUEVO */
$routes->add('actualizar-informacion-legal/(:any)','Administracion::modificarInformacionLegal/$1');/* NUEVO */

/******************************************************************************/
	
/* USUARIOS */
$routes->add('usuariosServerside','Usuarios::listarUsuarioDataTable');/* NUEVO */
$routes->add('obtener-datos-usuario','Usuarios::obtenerDatosUsuario');
$routes->add('modificar-usuario/(:any)','Usuarios::modificarUsuario/$1');/* NUEVO */
$routes->add('listado-usuarios-select','Usuarios::listadoUsuariosSelect');
$routes->add('listado-usuarios-comprador','Usuarios::listadoUsuariosComprador');

$routes->add('listar-permisos-usuario/(:any)','Usuarios::listarPermisosUsuario/$1');/* NUEVO */
$routes->add('grabar-permisos-usuario/(:any)','Usuarios::guardarPermisosUsuario/$1');/* NUEVO */
$routes->add('listar-rutas-usuario/(:any)','Usuarios::listarRutasUsuario/$1');/* NUEVO */
$routes->add('grabar-rutas-usuario/(:any)','Usuarios::guardarRutasUsuario/$1');/* NUEVO */

$routes->add('mi-perfil','Usuarios::miPerfil');
/******************************************************************************/

/*************************** NOTIFICACIONES ***********************************/
$routes->add('cargar-notificaciones-header','Notificaciones::cargarNotificacionesHeader');/* NUEVO */
$routes->add('cantidad-notificaciones-header','Notificaciones::cantidadNotificacionesHeader');/* NUEVO */
$routes->add('registrar-vista-notificacion','Notificaciones::registrarVisualizacionNotificacion');/* NUEVO */

/******************************************************************************/
	
/********************************* DASHBOARD **********************************/

$routes->add('dashboard-general','Dashboard::dashboardGeneral');/* NUEVO */
$routes->add('grafica-asignacion-pendiente-firma-creacion','Dashboard::graficaActaAsignacionPendienteFirmaFechaCreacion');/* NUEVO */
$routes->add('recargar-detalle-asignacion-pendiente-firma-creacion','Dashboard::recargarTablaDetalleActaAsignacionPendienteFirmaFechaCreacion');/* NUEVO */
$routes->add('grafica-detalle-asignacion-pendiente-firma-creacion','Dashboard::graficaDetalleActaAsignacionPendienteFirmaFechaCreacion');/* NUEVO */
$routes->add('grafica-asignacion-pendiente-firma-activo','Dashboard::graficaDetalleActaAsignacionPendienteFirmaActivo');/* NUEVO */
$routes->add('recargar-detalle-asignacion-pendiente-firma-activo','Dashboard::recargarTablaDetalleActaAsignacionPendienteFirmaFechaActivo');/* NUEVO */
$routes->add('grafica-detalle-asignacion-pendiente-firma-activo','Dashboard::graficaDetalleActaAsignacionPendienteFirmaFechaActivo');/* NUEVO */
$routes->add('grafica-pendientes-validar','Dashboard::graficaPendientesValidar');/* NUEVO */
$routes->add('recargar-detalle-pendientes-validacion','Dashboard::recargarTablaDetallePendientesValidacion');/* NUEVO */

/******************************************************************************/
	
/********************************** REPORTES **********************************/

$routes->add('listar-reporte','Reportes::listarReporteActivosAsignados');/* NUEVO */
$routes->add('reporte-asignaciones-serverside','Reportes::reporteAsignacionesServerside');/* NUEVO */
$routes->add('exportar-asignados-cesados','Reportes::exportarAsignadosCesados');/* NUEVO */
$routes->add('informacion-activos-usuario','Reportes::informacionActivosUsuarios');/* NUEVO */
$routes->add('recargar-reporte-activos-total','Reportes::recargarReporteActivosTotal');/* NUEVO */
$routes->add('pruebas-query/(:any)/(:any)','Reportes::pruebasquery/$1/$2');/* NUEVO */
$routes->add('simulador-reposicion','Reportes::simuladorReposicion');/* NUEVO */

/******************************************************************************/
	
/******************************* CONFIGURACIÓN ********************************/

$routes->add('obtener-marcas','Configuracion::listadoMarcas');
$routes->add('listar-marcas','Configuracion::listarMarcas');
$routes->add('marcas-serverside','Configuracion::marcasServerside');
$routes->add('registrar-marca','Configuracion::insertarMarca');
$routes->add('obtener-datos-marca','Configuracion::obtenerDatosMarca');
$routes->add('actualizar-marca/(:any)','Configuracion::modificarMarca/$1');
$routes->add('cambiar-estado-marca','Configuracion::modificarEstadoMarca/$1');

$routes->add('obtener-dispositivos','Configuracion::listadoDispositivos');
$routes->add('listar-dispositivos/(:any)','Configuracion::listarDispositivos/$1');
$routes->add('dispositivos-serverside','Configuracion::dispositivosServerside');
$routes->add('registrar-dispositivo','Configuracion::insertarDispositivo');
$routes->add('obtener-datos-dispositivo','Configuracion::obtenerDatosDispositivos');
$routes->add('actualizar-dispositivo/(:any)','Configuracion::modificarDispositivo/$1');
$routes->add('cambiar-estado-dispositivo','Configuracion::modificarEstadoDispositivo/$1');

$routes->add('listar-operadores','Configuracion::listarOperadores');
$routes->add('operadores-serverside','Configuracion::operadoresServerside');
$routes->add('registrar-operador','Configuracion::insertarOperador');
$routes->add('obtener-datos-operador','Configuracion::obtenerDatosOperador');
$routes->add('actualizar-operador/(:any)','Configuracion::modificarOperador/$1');
$routes->add('cambiar-estado-operador','Configuracion::modificarEstadoOperador/$1');
$routes->add('obtener-operadores','Configuracion::listadoOperadores');

$routes->add('listar-planes/(:any)','Configuracion::listarPlanes/$1');
$routes->add('planes-serverside','Configuracion::planesServerside');
$routes->add('registrar-plan','Configuracion::insertarPlan');
$routes->add('obtener-datos-plan','Configuracion::obtenerDatosPlan');
$routes->add('actualizar-plan/(:any)','Configuracion::modificarPlan/$1');
$routes->add('cambiar-estado-plan','Configuracion::modificarEstadoPlan/$1');
$routes->add('obtener-planes','Configuracion::listadoPlanes');

$routes->add('listar-categorias','Configuracion::listarCategorias');
$routes->add('categorias-serverside','Configuracion::categoriasServerside');
$routes->add('registrar-categoria','Configuracion::registrarCategoria');/* NUEVO */
$routes->add('obtener-datos-categoria','Configuracion::obtenerDatosCategoria');/* NUEVO */
$routes->add('actualizar-categoria/(:any)','Configuracion::modificarCategoria/$1');/* NUEVO */
$routes->add('cambiar-estado-categoria','Configuracion::modificarEstadoCategoria');/* NUEVO */
$routes->add('obtener-categorias','Configuracion::obtenerCategorias');

$routes->add('listar-tipos-categoria/(:any)','Configuracion::listarTiposCategoria/$1');
$routes->add('tipos-categoria-serverside','Configuracion::tiposCategoriaServerside');
$routes->add('registrar-tipo-categoria','Configuracion::registrarTipoCategoria');/* NUEVO */
$routes->add('obtener-datos-tipo-categoria','Configuracion::obtenerDatosTipoCategoria');/* NUEVO */
$routes->add('actualizar-tipo-categoria/(:any)','Configuracion::modificarTipoCategoria/$1');/* NUEVO */
$routes->add('cambiar-estado-tipo-categoria','Configuracion::modificarEstadoTipoCategoria');/* NUEVO */
$routes->add('obtener-tipos','Configuracion::obtenerTipos');

$routes->add('listar-subtipos-tipo/(:any)','Configuracion::listarSubtiposTipoCategoria/$1');
$routes->add('subtipos-categoria-serverside','Configuracion::subtiposCategoriaServerside');
$routes->add('registrar-subtipo-tipo','Configuracion::registrarSubtipoTipoCategoria');/* NUEVO */
$routes->add('obtener-datos-subtipo-tipo','Configuracion::obtenerDatosSubtipoTipoCategoria');/* NUEVO */
$routes->add('actualizar-subtipo-tipo/(:any)','Configuracion::modificarSubtipoTipoCategoria/$1');/* NUEVO */
$routes->add('cambiar-estado-subtipo-tipo','Configuracion::modificarEstadoSubtipoTipoCategoria');/* NUEVO */
$routes->add('obtener-subtipos','Configuracion::obtenerSubtipos');


// $routes->add('registrar-categoria','Administracion::registrarCategoria');/* NUEVO */
// $routes->add('obtener-datos-categoria','Administracion::obtenerDatosCategoria');/* NUEVO */
// $routes->add('actualizar-categoria/(:any)','Administracion::modificarCategoria/$1');/* NUEVO */
// $routes->add('cambiar-estado-categoria','Administracion::modificarEstadoCategoria');/* NUEVO */

// $routes->add('registrar-tipo-categoria','Administracion::registrarTipoCategoria');/* NUEVO */
// $routes->add('obtener-datos-tipo-categoria','Administracion::obtenerDatosTipoCategoria');/* NUEVO */
// $routes->add('actualizar-tipo-categoria/(:any)','Administracion::modificarTipoCategoria/$1');/* NUEVO */
// $routes->add('cambiar-estado-tipo-categoria','Administracion::modificarEstadoTipoCategoria');/* NUEVO */





$routes->add('listar-elementos-demo','Configuracion::listarElementosDemo');
$routes->add('elementos-demo-serverside','Configuracion::elementosDemoServerside');
$routes->add('registrar-elemento-demo','Configuracion::insertarElementoDemo');
$routes->add('obtener-datos-elemento-demo','Configuracion::obtenerDatosElementoDemo');
$routes->add('actualizar-elemento-demo/(:any)','Configuracion::modificarElementoDemo');
$routes->add('cambiar-estado-elemento-demo','Configuracion::modificarEstadoElementoDemo');
$routes->add('listado-elementos-demo','Configuracion::listadoElementosDemo');

$routes->add('listar-elementos-trabajo','Configuracion::listarElementosTrabajo');
$routes->add('elementos-trabajo-serverside','Configuracion::elementosTrabajoServerside');
$routes->add('registrar-elemento-trabajo','Configuracion::insertarElementoTrabajo');
$routes->add('obtener-datos-elemento-trabajo','Configuracion::obtenerDatosElementoTrabajo');
$routes->add('actualizar-elemento-trabajo/(:any)','Configuracion::modificarElementoTrabajo/$1');
$routes->add('cambiar-estado-elemento-trabajo','Configuracion::modificarEstadoElementoTrabajo');
$routes->add('listado-elementos-trabajo','Configuracion::listadoElementosTrabajo');

/******************************************************************************/
	
/************************************* IT *************************************/

$routes->add('listar-moviles','IT::listarMoviles');
$routes->add('moviles-serverside','IT::movilesServerside');
$routes->add('grabar-movil','IT::insertarMovil');
$routes->add('obtener-datos-movil','IT::obtenerDatosMovil');
$routes->add('actualizar-movil/(:any)','IT::modificarMovil/$1');
$routes->add('obtener-estados-movil','IT::obtenerEstadosMovil');
$routes->add('obtener-motivos-estado-movil','IT::obtenerMotivoEstadoMovil');
$routes->add('exportar-movil/(:any)','IT::exportarMovil/$1');
$routes->add('historico-asignaciones-moviles','IT::historicoAsignacionesMoviles');

$routes->add('listar-lineas','IT::listarLineas');
$routes->add('lineas-serverside','IT::lineasServerside');
$routes->add('grabar-linea','IT::insertarLinea');
$routes->add('obtener-datos-linea','IT::obtenerDatosLinea');
$routes->add('actualizar-linea/(:any)','IT::modificarLinea/$1');
$routes->add('obtener-estados-linea','IT::obtenerEstadosLinea');
$routes->add('obtener-motivos-estado-linea','IT::obtenerMotivoEstadoLinea');
$routes->add('exportar-linea/(:any)','IT::exportarLinea/$1');
$routes->add('subir-csv-linea','IT::importarCSVLinea');
$routes->add('historico-asignaciones-lineas','IT::historicoAsignacionesLineas');

$routes->add('contrato-linea/(:any)','IT::listarContratosLinea/$1');
$routes->add('contratos-linea-serverside','IT::contratosLineaServerside');
$routes->add('validar-contrato-linea-actual','IT::validarContratoLineaActual');
$routes->add('grabar-contrato','IT::insertarContratoLinea');
$routes->add('obtener-datos-contrato','IT::obtenerDatosContratoLinea');
$routes->add('actualizar-contrato/(:any)','IT::modificarContrato/$1');

$routes->add('listar-hardware','IT::listarHardware');
$routes->add('hardware-serverside','IT::hardwareServerside');
$routes->add('registrar-hardware','IT::insertarHardware');
$routes->add('obtener-datos-hardware','IT::obtenerDatosHardware');
$routes->add('actualizar-hardware/(:any)','IT::modificarHardware/$1');
$routes->add('historico-asignaciones-hardware','IT::historicoAsignacionesHardware');
$routes->add('pendientes-mover-navision-hardware','IT::pendientesMoverNavisionHardware');
$routes->add('importar-movimiento-navision-hardware','IT::importarMovimientoNavisionHardware');
$routes->add('subir-csv-hardware','IT::subirCSVHardware');

$routes->add('listar-tarjetas-acceso','IT::listarTarjetasAcceso');
$routes->add('tarjetas-acceso-serverside','IT::tarjetasAccesoServerside');
$routes->add('registrar-tarjeta-acceso','IT::insertarTarjetaAcceso');
$routes->add('obtener-datos-tarjeta-acceso','IT::obtenerDatosTarjetaAcceso');
$routes->add('actualizar-tarjeta-acceso/(:any)','IT::modificarTarjetaAcceso/$1');
$routes->add('historico-asignaciones-tarjeta-acceso','IT::historicoAsignacionesTarjetaAcceso');
$routes->add('subir-csv-tarjeta-acceso','IT::subirCSVTarjetaAcceso');

$routes->add('listado-direcciones-tarjeta-acceso','IT::listadoDireccionesTarjetaAcceso');
$routes->add('grabar-direcciones-tarjeta-acceso/(:any)','IT::guardarDireccionesTarjetaAcceso/$1');

$routes->add('listar-ubicaciones-tarjeta-acceso/(:any)','IT::listarUbicacionesTarjetaAcceso/$1');
$routes->add('grabar-ubicaciones-tarjeta-acceso/(:any)','IT::guardarUbicacionesTarjetaAcceso/$1');

$routes->add('listar-accesorios-it','IT::listarAccesoriosIT');
$routes->add('accesorios-it-serverside','IT::accesoriosITServerside');
$routes->add('registrar-accesorio-it','IT::insertarAccesorioIT');
$routes->add('obtener-datos-accesorio-it','IT::obtenerDatosAccesorioIT');
$routes->add('actualizar-accesorio-it/(:any)','IT::modificarAccesorioIT/$1');
$routes->add('listado-accesorios-it','IT::listadoAccesoriosIT');

$routes->add('registrar-kardex-accesorio-it','IT::guardarKardexAccesorioIT');
$routes->add('mostrar-movimientos-kardex-accesorios-it','IT::mostrarMovimientosKardexAccesorioIT');
$routes->add('registros-descargas-kardex','IT::listarRegistrosDescargasKardexAccesoriosIT');
$routes->add('exportar-kardex-accesorio-it','IT::exportarKardexAccesorioIT');
$routes->add('exportar-traspaso-accesorios-it/(:any)/(:any)/(:any)/(:any)','IT::exportarTraspasosKardexAccesorioIT/$1/$2/$3/$4');
$routes->add('importar-validacion-kardex-accesorio-it','IT::importarValidacionKardexAccesorioIT');

/******************************************************************************/
	
/*********************************** CARGOS ***********************************/

$routes->add('listar-asignaciones','Cargos::listarAsignaciones');
$routes->add('asignaciones-serverside','Cargos::actasAsignacionServerside');
$routes->add('obtener-elementos-asignacion','Cargos::obtenerElementosAsignacion');
$routes->add('obtener-elemento-a-asignar','Cargos::obtenerElementoAsignar');
$routes->add('guardar-asignacion','Cargos::guardarAsignacion');
$routes->add('subir-csv-asignacion','Cargos::importarCSVAsignacion');
$routes->add('detalle-acta-asignacion/(:any)/(:any)','Cargos::detalleActaAsignacion/$1/$2');
$routes->add('verPDFActaAsignacion/(:any)/(:any)/(:any)','Cargos::PDFActaAsignacion/$1/$2/$3');
$routes->add('adjuntar-documento-asignacion/(:any)','Cargos::adjuntarDocumentoAsignacion/$1');
$routes->add('enviar-correo-asignacion','Cargos::enviarCorreoAsignacion');
$routes->add('acta-asignacion/(:any)/(:any)','Cargos::actaAsignacion/$1/$2');
$routes->add('subir-firma-acta-asignacion','Cargos::subirFirmaActaAsignacion');

$routes->add('listar-devoluciones','Cargos::listarDevoluciones');
$routes->add('devoluciones-serverside','Cargos::actasDevolucionServerside');
$routes->add('elementos-devolucion','Cargos::elementosDevolucion');
$routes->add('obtener-elemento-a-devolver','Cargos::obtenerElementoDevolver');
$routes->add('guardar-devolucion','Cargos::registrarDevolucion');
$routes->add('detalle-acta-devolucion/(:any)/(:any)','Cargos::detalleActaDevolucion/$1/$2');
$routes->add('verPDFActaDevolucion/(:any)/(:any)','Cargos::PDFActaDevolucion/$1/$2');
$routes->add('adjuntar-documento-devolucion/(:any)','Cargos::adjuntarDocumentoDevolucion/$1');
$routes->add('enviar-correo-devolucion','Cargos::enviarCorreoDevolucion');
$routes->add('acta-devolucion/(:any)/(:any)','Cargos::actaDevolucion/$1/$2');
$routes->add('subir-firma-acta-devolucion','Cargos::subirFirmaActaDevolucion');
$routes->add('recargar-detalle-elementos-devolucion','Cargos::recargarTablaDetalleElementosDevolucion');
$routes->add('validacion-detalle-devolucion/(:any)','Cargos::validacionDetalleDevolucion/$1');

$routes->add('validacion-activos-devolucion','Cargos::validacionActivosDevolucion');
$routes->add('registro-validacion-activos-devolucion','Cargos::registroValidacionActivosDevolucion');

$routes->add('listar-informes-devolucion','Cargos::listarInformesDevolucion');
$routes->add('informes-devolucion-serverside','Cargos::informesDevolucionServerside');
$routes->add('detalle-informe-devolucion/(:any)','Cargos::detalleInformeDevolucion/$1');
$routes->add('verPDFInformeDevolucion/(:any)/(:any)','Cargos::PDFInformeDevolucion/$1/$2');

$routes->add('listar-reposiciones','Cargos::listarReposiciones');
$routes->add('reposiciones-serverside','Cargos::actasReposicionServerside');
$routes->add('detalle-acta-reposicion/(:any)/(:any)','Cargos::detalleActaReposicion/$1/$2');
$routes->add('verPDFActaReposicion/(:any)/(:any)','Cargos::PDFActaReposicion/$1/$2');
$routes->add('adjuntar-documento-reposicion/(:any)','Cargos::adjuntarDocumentoReposicion/$1');
$routes->add('enviar-correo-reposicion','Cargos::enviarCorreoReposicion');
$routes->add('acta-reposicion/(:any)/(:any)','Cargos::actaReposicion/$1/$2');
$routes->add('subir-firma-acta-reposicion','Cargos::subirFirmaActaReposicion');
$routes->add('mostrar-elementos-excepcion-reposicion','Cargos::mostrarElementosExcepcionReposicion');
$routes->add('registro-excepcion-reposicion','Cargos::registroExcepcionReposicion');

$routes->add('listar-descuentos-mensual','Cargos::listarDescuentosMensual');
$routes->add('descuentos-serverside','Cargos::descuentosReposicionServerside');
$routes->add('exportar-descuento-mensual/(:any)/(:any)','Cargos::exportarDescuentoMensual/$1/$2');
$routes->add('importar-descuento-mensual','Cargos::importarDescuentosMensual');
$routes->add('exportar-descuento-global','Cargos::exportarDescuentoGlobal');

/******************************************************************************/
	
/************************************ URES ************************************/

$routes->add('listar-kits-demo','Ures::listarKitsDemo');
$routes->add('kit-demo-serverside','Ures::kitDemoServerside');
$routes->add('obtener-nuevo-item-kit-demo','Ures::obtenerNuevoItemKitDemo');
$routes->add('subir-csv-kits-demo','Ures::subirCSVKitsDemo');
$routes->add('registrar-kit-demo','Ures::insertarKitDemo');
$routes->add('obtener-datos-item-kit-demo','Ures::obtenerDatosItemKitDemo');
$routes->add('actualizar-item-kit-demo/(:any)','Ures::modificarItemKitDemo/$1');

$routes->add('listar-kits-trabajo','Ures::listarKitsTrabajo');
$routes->add('obtener-nuevo-item-kit-trabajo','Ures::obtenerNuevoItemKitTrabajo');
$routes->add('registrar-kit-trabajo','Ures::insertarKitTrabajo');
$routes->add('kit-trabajo-elementos/(:any)','Ures::kitTrabajoElementos/$1');
$routes->add('asociar-elemento-kit-trabajo','Ures::asociarElementoKitTrabajo');
$routes->add('eliminar-elemento-kit-trabajo','Ures::eliminarElementoKitTrabajo');

/******************************************************************************/
	
/********************************* SOLICITUDES ********************************/

$routes->add('solicitudes-reposicion','Solicitudes::listarSolicitudesReposicion');
$routes->add('solicitud-reposicion-serverside','Solicitudes::solicitudReposicionServerside');
$routes->add('listado-items-asignados','Solicitudes::listadoItemsAsignados');
$routes->add('obtener-elemento-a-reponer','Solicitudes::obtenerElementoReponer');
$routes->add('solicitar-reposicion-item','Solicitudes::solicitarReposicionItem');
$routes->add('solicitud-reposicion-informacion/(:any)','Solicitudes::informacionSolicitudReposicion/$1');
$routes->add('cambio-estado-solicitud-reposicion/(:any)','Solicitudes::modificarEstadoSolicitudReposicion/$1');


/******************************************************************************/
	
/****************************** REMOTOS **************************************/

$routes->add('listado-direccion-busqueda','Remotos::listadoDireccionBusqueda');/* NUEVO */
$routes->add('listado-direccion','Remotos::listadoDireccionSUNAT');/* NUEVO */

$routes->add('listado-region-pais','Remotos::listadoRegionPais');/* NUEVO */
$routes->add('listado-region-departamentos','Remotos::listadoRegionDepartamento');/* NUEVO */
$routes->add('listado-region-provincias','Remotos::listadoRegionProvincia');/* NUEVO */
$routes->add('listado-region-distritos','Remotos::listadoRegionDistrito');/* NUEVO */

$routes->add('listado-monedas','Remotos::listadoMonedas');/* NUEVO */
$routes->add('listado-tipos-documento','Remotos::listadoTiposDocumento');/* NUEVO */
$routes->add('listado-tipos-documento-sunat','Remotos::listadoTiposDocumentoSunat');/* NUEVO */

$routes->add('listado-direccion-estructura','Remotos::listadoDireccionesEstructura');/* NUEVO */
$routes->add('listado-area-estructura','Remotos::listadoAreasEstructura');/* NUEVO */
$routes->add('listado-subarea-estructura','Remotos::listadoSubareasEstructura');/* NUEVO */
$routes->add('listado-delegacion-estructura','Remotos::listadoDelegacionEstructura');/* NUEVO */
$routes->add('listado-cc-delegacion-estructura','Remotos::listadoCCDelegacionEstructura');/* NUEVO */
$routes->add('listado-estructura-delegacion','Remotos::listadoEstructuraDelegacion');/* NUEVO */
$routes->add('exportar-estructura-departamental','Remotos::exportarEstructuraDepartamental');/* NUEVO */

$routes->add('listado-responsables-direccion-estructura','Remotos::listadoResponsablesDireccionEstructura');/* NUEVO */
$routes->add('listado-responsables-area-estructura','Remotos::listadoResponsablesAreaEstructura');/* NUEVO */
$routes->add('listado-responsables-subarea-estructura','Remotos::listadoResponsablesSubareaEstructura');/* NUEVO */

$routes->add('listado-usuarios','Remotos::listadoUsuarios');/* NUEVO */
