<?php
namespace App\Models;
use CodeIgniter\Model;

class RegionProvinciaModel extends Model
{
    protected $DBGroup      = 'baseT';
    protected $table        = 'region_provincia';
    protected $primaryKey   = 'IDProvincia';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Provincia', 'IDDepartamento', 'CodigoINEI', 'CodUbigeoReniec', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerProvincia($idProvincia)
    {
        $this->select('region_provincia.IDProvincia,
            region_provincia.Provincia,
            region_departamento.IDDepartamento,
            region_departamento.Departamento,
            region_departamento.IDPais,
            region_pais.Pais');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->join('region_pais', 'region_departamento.IDPais = region_pais.IDPais', 'left');
        $this->where('region_provincia.IDProvincia', $idProvincia);

        $datos = $this->first();
        return $datos;
    }
    
}