<?php
namespace App\Models;
use CodeIgniter\Model;

class ProveedorPagoModel extends Model
{
    protected $table      = 'proveedor_pago';
    protected $primaryKey = 'IDProveedorPago';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDProveedor', 'ModalidadPago', 'Banco', 'CuentaBancaria', 'CuentaInterbancaria', 'Moneda', 'Prioridad','UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarModalidadPagoProveedor($idProveedor)
    {
        $this->select('proveedor_pago.IDProveedorPago,
            proveedor_pago.IDProveedor,
            proveedor_pago.ModalidadPago AS CodigoModalidadPago,
            modalidadpago.ModalidadPago,
            proveedor_pago.Banco AS CodigoBanco,
            bancos.Nombre AS NombreBanco,
            proveedor_pago.CuentaBancaria,
            proveedor_pago.CuentaInterbancaria,
            proveedor_pago.Moneda,
            proveedor_pago.Prioridad,
            proveedor_pago.Estado');
        $this->join('modalidadpago', 'proveedor_pago.ModalidadPago = modalidadpago.Codigo', 'left');
        $this->join('bancos', 'proveedor_pago.Banco = bancos.CodigoInterno', 'left');
        $this->where('proveedor_pago.IDProveedor', $idProveedor);

        $datos = $this->findAll();
        return $datos;
    }
}