<?php
namespace App\Models;
use CodeIgniter\Model;

class ComprobantesPagoModel extends Model
{
    protected $DBGroup    = 'baseCompras';
    protected $table      = 'comprobantes_pago';
    protected $primaryKey = 'IDComprobante';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['TipoComprobante', 'Origen', 'IDOrigen', 'Observacion', 'NroFactura', 'FechaEmisionFactura', 'MontoFactura', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'UsuarioCreaProveedor', 'FechaCreaProveedor', 'UsuarioModificaProveedor', 'FechaModificaProveedor', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listadoComprobantesPagoXOrigen($array)
    {
        $this->select('comprobantes_pago.IDComprobante,
        comprobantes_pago.TipoComprobante,
        tipo_comprobante_pago.CodigoSUNAT,
        tipo_comprobante_pago.ComprobantePago,
        comprobantes_pago.Origen,
        comprobantes_pago.IDOrigen,
        comprobantes_pago.UsuarioCrea,
        comprobantes_pago.FechaCrea,
        comprobantes_pago.UsuarioCreaProveedor,
        comprobantes_pago.FechaCreaProveedor
        ');
        
        $this->join('tipo_comprobante_pago', 'comprobantes_pago.TipoComprobante = tipo_comprobante_pago.IDTipoComprobantePago', 'left');
        
        if(!empty($array))
        {
            if(isset($array['Origen']) && $array['Origen'] != ""&& $array['Origen'] != null )
            {
                $this->where('comprobantes_pago.Origen', $array['Origen']);
            }
            
            if(isset($array['IDOrigen']) && $array['IDOrigen'] != "" && $array['IDOrigen'] != null )
            {
                $this->where('comprobantes_pago.IDOrigen', $array['IDOrigen']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
    // public function obtenerComprobanteOrdenCompra($idComprobanteOC)
    // {
    //     $this->select('ordencompra_comprobantes.IDComprobanteOC,
    //         ordencompra.IDOrdenCompra, 
    //         ordencompra.IDProveedor, 
    //         proveedor.Nombre AS "Proveedor", 
    //         ordencompra.Concepto, 
    //         ordencompra.Total, 
    //         ordencompra.TipoMoneda, 
    //         ordencompra.FechaCrea AS "FechaEmision", 
    //         ordencompra_comprobantes.Nombre AS "NombreComprobante", 
    //         ordencompra_comprobantes.Extension,
    //         ordencompra_comprobantes.FechaCrea, 
    //         ordencompra_comprobantes.FechaCreaProveedor');
        
    //     $this->join('ordencompra', 'ordencompra_comprobantes.IDOrdenCompra = ordencompra.IDOrdenCompra', 'left');
    //     $this->join('proveedor', 'ordencompra.IDProveedor = proveedor.IDProveedor', 'left');
        
    //     $this->where('ordencompra_comprobantes.IDComprobanteOC', $idComprobanteOC);
        
    //     $datos = $this->first();
    //     return $datos;
    // }
    

}