<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content" style="background-color: transparent;">

    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-lg-12">
                    <div class="card mt-n4 mx-n4 mb-n5">
                        <div class="<?= $estadosPeticion[$peticion['Estado']]['FONDO'] ?> color-white">
                            <div class="card-body pb-4 mb-5">
                                <div class="row">
                                    <div class="col-md">
                                        <div class="row align-items-center px-3">
                                            <div class="col-md">
                                                <h4 class="fw-semibold color-white" id="ticket-title">#<?= $peticion['IDPeticion'] ?> - <?= $peticion['Peticion'] ?></h4>
                                                <div class="hstack gap-3 flex-wrap">
                                                    <div class="text-muted color-white"><span id="ticket-client"><?= ucwords(mb_strtolower($peticion['UsuarioSolicitante'])) ?></span></div>
                                                    <div class="vr"></div>
                                                    <div class="text-muted color-white">Fecha de creación : <span class="fw-medium"><?= date("d-m-Y H:i:s", strtotime($peticion['FechaCrea'])) ?></span></div>
                                                    <div class="vr"></div>
                                                    <div class="text-muted color-white">Último cambio : <span class="fw-medium"><?= date("d-m-Y H:i:s", strtotime($peticion['FechaEstado'])) ?></span></div>
                                                    <!--<div class="text-muted">Due Date : <span class="fw-medium" id="due-date">29 Dec, 2021</span></div>-->
                                                    <!--<div class="vr"></div>-->
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                    <!--end col-->
                                    <div class="col-md-auto mt-md-0 mt-4 d-flex justify-content-end align-items-center">
                                        <div class="hstack gap-1 flex-wrap">
                                            <?php
                                            if($peticion['Estado'] != 'APRO' && $peticion['Estado'] != 'CANC' && in_array("ADCOPE", $permisos))
                                            {
                                            ?>
                                            <button type="button" class="btn bg-come px-2 py-1" data-bs-target="#agregarComentarioPeticion" data-tooltip="tooltip" title="Agregar Comentario" id="btnAgregarComentarioPeticion">
                                                <i class="mdi mdi-comment-plus" style="font-size: 24px; color: #FFF"></i>
                                            </button>
                                            <?php
                                            }
                                            ?>
                                            <span class="btn p-0" style="background-color: transparent; box-shadow: none; cursor: default;">
                                                <i class="mdi mdi-drag-vertical-variant" style="font-size: 34px; color: #FFF"></i>
                                            </span>
                                            <?php
                                            if (in_array("ESTPET", $permisos)) 
            								{
                                                if( in_array($idPerfil, array(1, 2)) )
                                                {
                                                    if(($peticion['Estado'] == "CREA" || $peticion['Estado'] == "COMP" || $peticion['Estado'] == "REEV" || $peticion['Estado'] == "ESPE"))
                                                    {
                                                    ?>
                                                    <button type="button" class="btn bg-asig px-2 py-1" data-bs-target="#peticionAsignarUsuario" data-tooltip="tooltip" title="Asignar a usuario" id="btnAsignarUsuarioPeticion">
                                                        <i class="<?= $estadosPeticion["ASIG"]['ICONO'] ?>" style="font-size: 24px; color: #FFF"></i>
                                                    </button>
                                                    <?php
                                                    }
                                                    
                                                    if(($peticion['UsuarioAsignado'] == $id) || $peticion['UsuarioAsignado'] == '' || $peticion['UsuarioAsignado'] == null )
                                                    {
                                                        if(($peticion['Estado'] == "CREA" || $peticion['Estado'] == "ASIG" || $peticion['Estado'] == "COMP" || $peticion['Estado'] == "ESPE" || $peticion['Estado'] == "REEV") )
                                                        {
                                                        ?>
                                                        <button type="button" class="btn bg-inic px-2 py-1" onclick="return confirmarEstadoGestionPeticion('<?= $peticion['IDPeticion'] ?>', 'INIC', '<?= $peticion['Categorizacion'] ?>');" data-tooltip="tooltip" title="Iniciar Gestión">
                                                            <i class="<?= $estadosPeticion["INIC"]['ICONO'] ?>" style="font-size: 24px; color: #FFF"></i>
                                                        </button>
                                                        <?php
                                                        }
                                                        
                                                        if($peticion['Estado'] == "INIC")
                                                        {
                                                        ?>
                                                        <button type="button" class="btn bg-espe px-2 py-1" onclick="return confirmarEstadoGestionPeticion('<?= $peticion['IDPeticion'] ?>', 'ESPE', '<?= $peticion['Categorizacion'] ?>');" data-tooltip="tooltip" title="Gestión en espera">
                                                            <i class="<?= $estadosPeticion["ESPE"]['ICONO'] ?>" style="font-size: 24px; color: #FFF"></i>
                                                        </button>
                                                        <?php
                                                        }
                                                        
                                                        if(($peticion['Estado'] == "INIC"))
                                                        {
                                                        ?>
                                                        <button type="button" class="btn bg-comp px-2 py-1" data-bs-target="#completarPeticion" data-tooltip="tooltip" title="Terminar Gestión" id="btnCompletarPeticion">
                                                            <i class="<?= $estadosPeticion["COMP"]['ICONO'] ?>" style="font-size: 24px; color: #FFF"></i>
                                                        </button>
                                                        <?php
                                                        }
                                                    }
                                                }
                                                
                                                if($peticion['Estado'] == "COMP" && $peticion['UsuarioCrea'] == $id)
                                                {
                                                ?>
                                                <!--<button type="button" class="btn bg-apro px-2 py-1" onclick="return confirmarEstadoGestionPeticion('<?= $peticion['IDPeticion'] ?>', 'APRO', '<?= $peticion['Categorizacion'] ?>');" data-tooltip="tooltip" title="Aprobar la Gestión de la Petición">-->
                                                <!--    <i class="<?= $estadosPeticion["APRO"]['ICONO'] ?>" style="font-size: 24px; color: #FFF"></i>-->
                                                <!--</button>-->
                                                
                                                <button type="button" class="btn bg-apro px-2 py-1" data-bs-target="#aprobarPeticion" data-tooltip="tooltip" title="Crear Requerimiento Aprobando Gestión" id="btnGnerarOCPeticion">
                                                    <i class="<?= $estadosPeticion["APRO"]['ICONO'] ?>" style="font-size: 24px; color: #FFF"></i>
                                                </button>
                                                <button type="button" class="btn bg-reev px-2 py-1" onclick="return confirmarEstadoGestionPeticion('<?= $peticion['IDPeticion'] ?>', 'REEV', '<?= $peticion['Categorizacion'] ?>');" data-tooltip="tooltip" title="Reevaluar la Gestión de la Petición">
                                                    <i class="<?= $estadosPeticion["REEV"]['ICONO'] ?>" style="font-size: 24px; color: #FFF"></i>
                                                </button>
                                                <?php
                                                }
                                                
                                                if(($peticion['UsuarioCrea'] == $id) && $peticion['Estado'] != "CANC" && $peticion['Estado'] != "APRO" )
                                                {
                                                ?>
                                                    <button type="button" class="btn bg-canc px-2 py-1" onclick="return confirmarEstadoGestionPeticion('<?= $peticion['IDPeticion'] ?>', 'CANC', '<?= $peticion['Categorizacion'] ?>');" data-tooltip="tooltip" title="Cancelar la Gestión de la Petición">
                                                        <i class="<?= $estadosPeticion["CANC"]['ICONO'] ?>" style="font-size: 24px; color: #FFF"></i>
                                                    </button>
                                                <?php
                                                }
            								}
                                            ?>
                                            
                                            
                                            
                                            <a href="<?= $baseUrl.'/'.$previo ?>" class="btn btn-danger px-2 py-1" data-tooltip="tooltip" title="Volver">
                                                <i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <!--end col-->
                                </div>
                                <!--end row-->
                            </div><!-- end card body -->
                        </div>
                    </div><!-- end card -->
                </div><!-- end col -->
            </div><!-- end row -->

            <div class="row">
                <div class="col-xxl-9">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">TimeLine</h5>
                        </div>
                        <div class="card-body">
                            <div class="col-lg-12">
                                <div class="timeline">
                                    <?php
                                    foreach($timelinePeticion as $key => $value)
                                    {
                                        $cantAdjuntos = $value['AdjuntosComentario'];
                                        $position = ($key % 2) == 0 ? "left" : "right";
                                        $icon = $estadosPeticion[$value['Estado']]['ICONO'];
                                        $colorIcon = $estadosPeticion[$value['Estado']]['COLOR'];
                                        $fondoeEstado = $estadosPeticion[$value['Estado']]['FONDO'];
                                    ?>
                                    <div class="timeline-item <?= $position ?>">
                                        <i class="icon <?= $icon ?> <?= $colorIcon ?>"></i>
                                        <!--<i class="icon ri-stack-line"></i>-->
                                        <div class="date <?= $colorIcon ?>"><?= date("d-m-Y", strtotime($value['Fecha'])) ?><br><?= date("H:i:s", strtotime($value['Fecha'])) ?></div>
                                        <div class="content fw-bold">
                                            <div class="d-flex">
                                                <div class="flex-grow-1 ms-2">
                                                    <h5 class="fs-17"><?= ucwords(mb_strtolower($value['NombreUsuarioModifica'])) ?><br><small class="fs-14 fw-normal <?= $colorIcon ?>"><?= $value['CargoModifica'] ?></small></h5>
                                                    <hr class="m-0 py-2">
                                                    <p class="mb-2"><?= $value['Comentario'] ?></p>
                                                    <?php
                                                    if(!empty($cantAdjuntos))
                                                    {
                                                    ?>
                                                    <div class="row g-2 mb-2">
                                                        <!--end col-->
                                                        <?php
                                                        foreach($cantAdjuntos as $adjuntoComentario)
                                                        {
                                                        ?>
                                                        <div class="col-sm-6">
                                                            <div class="d-flex border border-dashed py-2 px-1 rounded position-relative">
                                                                <div class="flex-shrink-0 avatar-xs">
                                                                    <div class="avatar-title text-danger fs-24 rounded" style="background-color: transparent">
                                                                        <i class="<?= isset($iconosExtension[$adjuntoComentario["Extension"]]) ? $iconosExtension[$adjuntoComentario["Extension"]] : "mdi mdi-file" ?> color-black"></i>
                                                                    </div>
                                                                </div>
                                                                <div class="flex-shrink-0">
        
                                                                </div>
                                                                <div class="flex-grow-1 overflow-hidden ms-2">
                                                                    <h6 class="text-truncate mb-0"><a href="<?= base_url().'/public/files/Peticiones/Comentarios/'.date("Y", strtotime($adjuntoComentario['FechaCrea'])).'/'.date("m", strtotime($adjuntoComentario['FechaCrea'])).'/'.$adjuntoComentario['IDAdjuntoComentario'].'-'.$adjuntoComentario['IDComentarioPeticion'].'.'.$adjuntoComentario['Extension'] ?>" download='<?= $adjuntoComentario['Nombre'].".".$adjuntoComentario["Extension"] ?>' class="stretched-link color-black"><?= $adjuntoComentario["Nombre"] ?></a></h6>
                                                                    <small><?= $adjuntoComentario["Extension"] ?></small>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!--end col-->
                             <!--                           <div class="col-sm-6">-->
                             <!--                               <div class="d-flex border border-dashed p-2 rounded position-relative">-->
                             <!--                                   <div class="flex-shrink-0 avatar-xs">-->
                             <!--                                       <div class="avatar-title bg-info-subtle text-info fs-15 rounded">-->
                             <!--                                           <i class="ri-file-zip-line"></i>-->
                             <!--                                       </div>-->
                             <!--                                   </div>-->
                             <!--                                   <div class="flex-grow-1 ms-2 overflow-hidden">-->
                             <!--                                       <h6 class="mb-0 text-truncate"><a href="javascript:void(0);" class="stretched-link">Bank Management System - PSD</a></h6>-->
                             <!--                                       <small>8.78 MB</small>-->
                             <!--                                   </div>-->
                             <!--                               </div>-->
                             <!--                           </div>-->
                             <!--                           <a class='btn bg-light btn-label waves-effect waves-light border-0 mx-1 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/files/Peticiones/Comentarios/'.date("Y", strtotime($adjuntoComentario['FechaCrea'])).'/'.date("m", strtotime($adjuntoComentario['FechaCrea'])).'/'.$adjuntoComentario['IDAdjuntoComentario'].'-'.$adjuntoComentario['IDComentarioPeticion'].'.'.$adjuntoComentario['Extension'] ?>' download='<?= $adjuntoComentario['Nombre'].".".$adjuntoComentario["Extension"] ?>'>-->
                									    <!--    <i class="mdi mdi-tray-arrow-down label-icon align-middle me-1" style="font-size: 14px;"></i><?= $adjuntoComentario["Nombre"] ?>-->
                									    <!--</a><br>-->
                                                        <?php
                                                        }
                                                        ?>
                                                    </div>
                                                    <?php
                                                    }
                                                    
                                                    if($value['Link'] != "")
                                                    {
                                                    ?>
                                                    <div class="row g-2 mb-2">
                                                        <a href="<?= $value['Link'] ?>" class="link-info text-decoration-underline" target="_blank">Ir al link asociado <i class="ri-arrow-right-line"></i></a>
                                                    </div>
                                                    <?php
                                                    }
                                                    ?>
                                                    <hr class="m-0 py-2">
                                                    <div class="hstack gap-2">
                                                        <small class="text-muted fs-14 fw-normal"><?= $value['DireccionModifica'].' | '.$value['AreaModifica'].' | '.$value['SubareaModifica'] ?></small> 
                                                        <span class="badge <?= $fondoeEstado ?> color-white border-0">
            												<?= $estadosPeticion[$value['Estado']]['PASADO'] ?>
            											</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Información de Petición</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive table-card">
                                <table class="table table-borderless align-middle mb-0">
                                    <tbody>
                                        <tr>
                                            <td class="fw-medium">Petición</td>
                                            <td>#<?= $peticion['IDPeticion'] ?></td>
                                        </tr>
                                        <?php
                                        if($peticion['IDOrdenCompra'] != '' && $peticion['IDOrdenCompra'] != null && $peticion['IDOrdenCompra'] !== "0")
                                        {
                                        ?>
                                        <tr>
                                            <td class="fw-medium">Requerimiento</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $peticion['IDOrdenCompra'] ?>
                                                <a class="btn bg-sistema px-2 py-1 ms-auto" href="<?= $baseUrl ?>/editar-orden-compra/<?= $peticion['IDOrdenCompra'] ?>" target="_blank">
                                                    <i class="mdi mdi-eye-outline" style="font-size: 15px; color: #FFF"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <?php
                                        }
                                        ?>
                                        
                                        <tr>
                                            <td class="fw-medium">Marca / Modelo</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $peticion['Producto'] ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Cantidad</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $peticion['Cantidad'] ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Moneda</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $peticion['TipoMonedaText'] ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Presupuesto Asignado</td>
                                            <td id="t-client">
                                                <?= $peticion['PresupuestoAsignado'] ?>
                                            </td>
                                        </tr>
                                        <?php
                                        if($peticion['Categorizacion'] != '' && $peticion['Categorizacion'] != null)
                                        {
                                        ?>
                                        <tr>
                                            <td class="fw-medium">Categorización</td>
                                            <td id="t-client">
                                                <?= $peticion['Categorizacion'] == "RR" ? "Recurrente" : ($peticion['Categorizacion'] == "NR" ? "No Recurrente" : ($peticion['Categorizacion'] == "CT" ? "Compra Técnica" : "Licitación")) ?>
                                            </td>
                                        </tr>
                                        <?php
                                        }
                                        ?>
                                        <!--<tr>-->
                                        <!--    <td class="fw-medium">Categorización</td>-->
                                        <!--    <td id="t-client" class="d-flex align-items-center">-->
                                        <!--        <select class="form-select" id="cboCategorizacion" name="cboCategorizacion">-->

                                        <!--            <option value="" disabled selected>Seleccionar</option>-->
                                        <!--            <option value="Recurrente - 2 Dias Habiles" <?php if($peticion['Categorizacion'] == "Recurrente - 2 Dias Habiles"){ echo "selected"; }  ?>>Recurrente - 2 Dias Habiles</option>-->
                                        <!--            <option value="No Recurrente - 4 Dias Habiles" <?php if($peticion['Categorizacion'] == "No Recurrente - 4 Dias Habiles"){ echo "selected"; }  ?>>No Recurrente - 4 Dias Habiles</option>-->
                                        <!--            <option value="Compra tecnica - 10 Dias Habiles" <?php if($peticion['Categorizacion'] == "Compra tecnica - 10 Dias Habiles"){ echo "selected"; }  ?>>Compra tecnica - 10 Dias Habiles</option>-->
                                        <!--            <option value="Licitacion - 45 Dias Habiles" <?php if($peticion['Categorizacion'] == "Licitacion - 45 Dias Habiles"){ echo "selected"; }  ?>>Licitacion - 45 Dias Habiles</option>-->
                                        <!--        </select>                                                -->
                                        <!--    </td>-->
                                        <!--</tr>-->
                                        <tr class="bg-sistema-50 color-white">
                                            <td class="fw-medium">Categorización</td>
                                            <td><?= $peticion['Requerimiento'] ?></td>
                                        </tr>
                                        <tr class="bg-sistema-50 color-white">
                                            <td class="fw-medium">Motivo</td>
                                            <td><?= $peticion['Motivo'] ?></td>
                                        </tr>
                                        <tr class="bg-sistema-50 color-white">
                                            <td class="fw-medium">Detalle</td>
                                            <td><?= htmlspecialchars($peticion['Detalle'], ENT_QUOTES, 'UTF-8') ?></td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Usuario Solicitante</td>
                                            <td id="t-client"><?= $peticion['MatriculaSolicitante'].' | '.ucwords(mb_strtolower($peticion['UsuarioSolicitante'])) ?></td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Dirección Solicitante</td>
                                            <td id="t-client"><?= $peticion['DireccionSolicitante'] ?></td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Área Solicitante</td>
                                            <td id="t-client"><?= $peticion['AreaSolicitante'] ?></td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Subárea Solicitante</td>
                                            <td id="t-client"><?= $peticion['SubareaSolicitante'] ?></td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Delegación Solicitante</td>
                                            <td id="t-client"><?= $peticion['CCSolicitante'] ?></td>
                                        </tr>
                                        <tr class="<?= $estadosPeticion[$peticion['Estado']]['FONDO'] ?> color-white">
                                            <td class="fw-medium">Estado</td>
                                            <td><?= $estadosPeticion[$peticion['Estado']]['PASADO'] ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!--end card-body-->
                    </div>
                    <!--end card-->
                    <?php
                    if(!empty($adjuntosPeticion))
                    {
                    ?>
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title fw-semibold mb-0">Adjuntos Asociados</h6>
                        </div>
                        <div class="card-body">
                            <?php
                            foreach($adjuntosPeticion as $adjuntos)
                            {
                            ?>
                            <div class="d-flex align-items-center border border-dashed p-2 rounded mb-2">
                                <div class="flex-shrink-0 avatar-sm">
                                    <div class="avatar-title bg-light rounded">
                                        <i class="mdi mdi-paperclip fs-20 text-primary"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="mb-1"><a><?= $adjuntos['Nombre'].'.'.$adjuntos['Extension'] ?></a></h6>
                                    <!--<small class="text-muted">3.2 MB</small>-->
                                </div>
                                <div class="hstack gap-3 fs-16">
                                    <a href='<?= base_url().'/public/files/Peticiones/Asociados/'.date("Y", strtotime($adjuntos['FechaCrea'])).'/'.date("m", strtotime($adjuntos['FechaCrea'])).'/'.$adjuntos['IDAdjuntoPeticion'].'-'.$adjuntos['IDPeticion'].'.'.$adjuntos['Extension'] ?>' download='<?= $adjuntos['Nombre'].'.'.$adjuntos['Extension'] ?>' class="text-muted"><i class="ri-download-2-line"></i></a>
                                </div>
                            </div>
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    <?php
                    }
                    ?>
                    <?php
                    if($peticion['LinkAsociado']!='' && $peticion['LinkAsociado']!=null)
                    {
                    ?>
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title fw-semibold mb-0">Links Asociados</h6>
                        </div>
                        <div class="card-body">
                            
                            <div class="d-flex align-items-center border border-dashed p-2 rounded" style="overflow: hidden; white-space: nowrap; text-overflow: ellipsis;">
                                <div class="flex-shrink-0 avatar-sm">
                                    <div class="avatar-title bg-light rounded">
                                        <a href="<?= $peticion['LinkAsociado'] ?>" target="_blank"><i class="mdi mdi-open-in-new fs-20 text-primary"></i></a>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h5 class="mb-1"><?= $peticion['LinkAsociado'] ?></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    }
                    ?>
                </div>
                <!--end col-->
            </div>
            <!--end row-->

        </div><!-- container-fluid -->
        
		<span class="respuesta_global"></span>
    </div><!-- End Page-content -->

    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <script>document.write(new Date().getFullYear())</script>2024 © Velzon.
                </div>
                <div class="col-sm-6">
                    <div class="text-sm-end d-none d-sm-block">
                        Design &amp; Develop by Themesbrand
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- end main content-->

<!-- Modal Asignar Usuario -->
<div class="modal fade zoomIn" id="peticionAsignarUsuario" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplepeticionAsignarUsuario" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplepeticionAsignarUsuario">Asignar usuario a petición</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAsignarUsuarioPeticion" class="formulario" autocomplete="off" action="<?= $baseUrl ?>/cambio-estado-peticion/<?= $peticion['IDPeticion'] ?>" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtEstadoPeticion_i" name="txtEstadoPeticion_i" value="ASIG">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtAsignarUsuarioPeticion_i" class="form-label">Usuario Asignado</label>
								<select class="form-select" aria-label="Usuario Asignado" id="txtAsignarUsuarioPeticion_i" name="txtAsignarUsuarioPeticion_i" data-peticion="<?= $peticion['IDPeticion'] ?>">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtMotivoCambioEstadoPeticion_i" class="form-label">Detalle</label>
								<textarea class="form-control" id="txtMotivoCambioEstadoPeticion_i" name="txtMotivoCambioEstadoPeticion_i" rows="4"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i>Asignar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!--Modal Completar Petición -->
<div class="modal fade zoomIn" id="completarPeticion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplecompletarPeticion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="completarPeticion">Completar la Petición</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formCompletarPeticion" class="formularioCompletarPeticion" autocomplete="off" action="<?= $baseUrl ?>/cambio-estado-peticion/<?= $peticion['IDPeticion'] ?>" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtEstadoPeticion_i" name="txtEstadoPeticion_i" value="COMP">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtMotivoCambioEstadoPeticion_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtMotivoCambioEstadoPeticion_i" name="txtMotivoCambioEstadoPeticion_i" rows="4" placeholder="Observación..."></textarea>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtLinkCompletarPeticion_acp" class="form-label">Link de Referencia</label>
								<input type="text" class="form-control" id="txtLinkCompletarPeticion_acp" name="txtLinkCompletarPeticion_acp" placeholder="Ingrese link asociado">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-0">
							<div>
								<label for="txtAdjunto_cep" class="form-label">Valorizado</label>
            					<div class="col-12 mb-0 d-flex justify-content-center">
            					    <div class="col-12 m-0 p-0">
            					        <input type="file" id="txtAdjunto_cep" data-max-file-size="100MB" data-max-files="4" />
            					    </div>
            					</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!--Modal Aprobar Petición -->
<div class="modal fade zoomIn" id="aprobarPeticion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleaprobarPeticion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleaprobarPeticion">Aprobar la Petición</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAprobarPeticion" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/cambio-estado-peticion/<?= $peticion['IDPeticion'] ?>" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtEstadoPeticion_i" name="txtEstadoPeticion_i" value="APRO">
					<div class="row">
					    <div class="step-arrow-nav mb-4">
                            <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="tabInformacionGeneralOC" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionGeneralOC" type="button" role="tab" aria-controls="tabcontentInformacionGeneralOC" aria-selected="true" data-position="0">Información General</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="tabInformacionProveedorOC" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionProveedorOC" type="button" role="tab" aria-controls="tabcontentInformacionProveedorOC" aria-selected="false" data-position="1">Proveedor</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="tabInformacionItemsOC" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionItemsOC" type="button" role="tab" aria-controls="tabcontentInformacionItemsOC" aria-selected="false" data-position="2">Items</button>
                                </li>
                            </ul>
                        </div>
    
                        <div class="tab-content">
                            <div class="tab-pane fade active show" id="tabcontentInformacionGeneralOC" role="tabpanel" aria-labelledby="tabInformacionGeneralOC">
                                <div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="solicitante">Solicitante</label>
                                                <input type="text" class="form-control" id="solicitante" name="solicitante" value="<?= ucwords(mb_strtolower($nombres.' '.$apellidos)) ?>" placeholder="Solicitante" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="matricula">Matricula</label>
                                                <input type="text" class="form-control" id="matricula" name="matricula" value="<?= $matriculaLog ?>" placeholder="Matricula" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="conceptoOC">Concepto</label>
                                                <input type="text" class="form-control " id="conceptoOC" name="conceptoOC" placeholder="Concepto">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="formgroup">
                                                <label for="txtFechaPedidoOC">Fecha Pedido</label>
                                                <div class="col-auto">

                                                    <div class="input-group mb-2">
                                                        <div class="input-group-prepend">
                                                            <div class="input-group-text contenedorCalendario"><span class="mdi mdi-calendar-month"></span> <!--<img src="<?= $baseUrl ?>/public/images/iconoCalendario2.png" width="17.5" height="20"> <i class="far fa-calendar-alt"></i> --> </div>
                                                        </div>
                                                        <input type="date" class="form-control pull-right " id="txtFechaPedidoOC" name="txtFechaPedidoOC" min="<?= date("Y-m-d") ?>" value="<?= date("Y-m-d") ?>">
                                                    </div>
                                                </div>
                                                <!-- <input type="text" class="form-control pull-right " id="fechapedido" name="fechapedido" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask><i class="far fa-calendar-alt"></i> -->
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboCompradorOC">Comprador</label>
                                                <select class="form-select" id="cboCompradorOC" name="cboCompradorOC">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboEnvioFacturaOC">Envío de Factura</label>
                                                <select class="form-select" id="cboEnvioFacturaOC" name="cboEnvioFacturaOC">
                                                    <option value="" selected>Seleccione una opción</option>
                                                    <option value="SI">SI</option>
                                                    <option value="NO">NO</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboBudgetOC">Budget</label>
                                                <select class="form-select" id="cboBudgetOC" name="cboBudgetOC">
                                                    <option value="" selected>Seleccione una opción</option>
                                                    <option value="SI">SI</option>
                                                    <option value="NO">NO</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboIGVOC">IGV</label>
                                                <select class="form-select" name="cboIGVOC" id="cboIGVOC">
                                                    <option value="Afecta" selected>Afecta</option>
                                                    <option value="Noafecta">No afecta</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="cboCategoriaOC">Categoria</label>
                                                <select class="form-select" id="cboCategoriaOC" name="cboCategoriaOC">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="cboSubcategoriaOC">Subcategoria</label>
                                                <select class="form-select" id="cboSubcategoriaOC" name="cboSubcategoriaOC">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group">
                                                <label for="cboDelegacionOC">CC - LN (Delegación)</label>
                                                <select class="form-select" id="cboDelegacionOC" name="cboDelegacionOC">
                                                </select>
                                                <input type="hidden" id="txtCCOC" name="txtCCOC">
                                                <input type="hidden" id="txtLNOC" name="txtLNOC">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <div class="form-group ">
                                                <label for="cboSubareaOC">Subárea - Área - Dirección</label>
                                                <select class="form-select" id="cboSubareaOC" name="cboSubareaOC">
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-12">
                                            <div class="form-group">
                                                <label for="observaciones">Observaciones</label>
                                                <textarea class="form-control" id="observaciones" name="observaciones" placeholder="Ingresar..." rows="4"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start gap-3 mt-4">
                                    <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionProveedorOC"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Registrar Proveedor</button>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="tabcontentInformacionProveedorOC" role="tabpanel" aria-labelledby="tabInformacionProveedorOC">
                                <div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 col-md-4">
                                            <div class="form-group">
                                                <label for="cboProveedorOC">Proveedor</label>
                                                <select class="form-select" id="cboProveedorOC" name="cboProveedorOC">
                                                </select>
                                                <input type="hidden" id="txtProveedorNombreOC">
                                            </div>
                                        </div>
                                        <!--<div class="col-12 col-md-4">-->
                                        <!--    <div class="form-group">-->
                                        <!--        <label for="proovedor">Nombre Proveedor</label>-->
                                        <!--        <input type="text" class="form-control " id="proovedor_valor" name="proovedor_valor" placeholder="Digite nombre o Ruc">-->
                                        <!--    </div>-->
                                        <!--</div>-->
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblRUCOC">RUC</label>
                                                <input type="text" class="form-control" id="lblRUCOC" name="lblRUCOC" placeholder="RUC" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblContactoOC">Contacto</label>
                                                <input type="text" class="form-control " id="lblContactoOC" name="lblContactoOC" placeholder="Contacto" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblPaisOC">Pais</label>
                                                <input type="text" class="form-control " id="lblPaisOC" name="lblPaisOC" placeholder="Pais" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblDepartamento">Departamento</label>
                                                <input type="text" class="form-control " id="lblDepartamento" name="lblDepartamento" placeholder="Departamento" disabled>
                                                
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblProvincia">Provincia</label>
                                                <input type="text" class="form-control " id="lblProvincia" name="lblProvincia" placeholder="Provincia" disabled>
                                                
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblDistritoOC">Distrito</label>
                                                <input type="text" class="form-control " id="lblDistritoOC" name="lblDistritoOC" placeholder="Distrito" disabled>
                                                
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblDireccionOC">Dirección</label>
                                                <input type="text" class="form-control " id="lblDireccionOC" name="lblDireccionOC" placeholder="Dirección" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblEmailOC">Email</label>
                                                <input type="text" class="form-control " id="lblEmailOC" name="lblEmailOC" placeholder="Correo" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblTelefono01OC">Telefono 01</label>
                                                <input type="text" class="form-control " id="lblTelefono01OC" name="lblTelefono01OC" placeholder="Teléfono 01" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="lblTelefono02OC">Telefono 02</label>
                                                <input type="text" class="form-control " id="lblTelefono02OC" name="lblTelefono02OC" placeholder="Teléfono 02" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="cboFormaPagoOC">Forma de Pago</label>
                                                <select class="form-select" id="cboFormaPagoOC" name="cboFormaPagoOC">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-12 mb-2">
                                            <div class="form-group tipologiaNuevaOc">
                                                <label for="cboMultiTipologiaOC">Tipo</label>
                                                <select class="form-select" id="cboMultiTipologiaOC" name="cboMultiTipologiaOC[]" multiple="multiple" disabled>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 col-md-6 mb-2">
                                            <div class="form-group">
                                                <label for="cboModalidadPagoOC">Modalidad de Pago</label>
                                                <select class="form-select " name="cboModalidadPagoOC" id="cboModalidadPagoOC">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 mb-2">
                                            <div class="form-group">
                                                <label for="cboBancoOC">Banco</label>
                                                <select class="form-select" name="cboBancoOC" id="cboBancoOC">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="cboMonedaOC">Moneda</label>
                                                <select class="form-select moneda-Tipo" name="cboMonedaOC" id="cboMonedaOC">
                                                    
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="txtCuentaOC">Número de Cuenta:</label>
                                                <input type="text" class="form-control validanumericos" id="txtCuentaOC" placeholder="Número de Cuenta" name="txtCuentaOC">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-4 mb-2">
                                            <div class="form-group">
                                                <label for="txtCCIOC">CCI:</label>
                                                <input type="text" class="form-control validanumericos" id="txtCCIOC" placeholder="Número de Cuenta" name="txtCCIOC">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 col-md-6 mb-2">
                                            <div class="form-group">
                                                <label for="txtCuentaDetraccionOC">Cuenta Detracción:</label>
                                                <input type="text" class="form-control validanumericos" id="txtCuentaDetraccionOC" placeholder="Cuenta Detracción" name="txtCuentaDetraccionOC" disabled>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6 mb-2">
                                            <div class="form-group">
                                                <label for="cboCodigoDetraccionOC">Código Detracción</label>
                                                <select class="form-select" name="cboCodigoDetraccionOC" id="cboCodigoDetraccionOC" disabled>
                                                    
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start gap-3 mt-4">
                                    <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionGeneralOC"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información general</button>
                                    <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionItemsOC"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Registrar Items</button>
                                </div>
                            </div>
                            <!-- end tab pane -->
                            <div class="tab-pane fade" id="tabcontentInformacionItemsOC" role="tabpanel" aria-labelledby="tabInformacionItemsOC">
                                <div>
                                    <div class="row g-2 col-md-12 m-0 px-3">
                                        <div class="col-12 m-0 p-0 p-3 border-sistema-2px" style="border-radius: 10px;">
                							<div class="form-group row">
                								<div class="col-4">
                                                    <div class="form-group">
                                                        <label for="descripcionItem">Descripción</label>
                                                        <input type="text" class="form-control validanumericos" id="descripcionItem" name="descripcionItem" placeholder="Descripción">
                                                    </div>
                                                </div>
                                                <div class="col-3">
                                                    <div class="form-group">
                                                        <label for="cantidadItem">Cantidad</label>
                                                        <input type="text" class="form-control" id="cantidadItem" name="cantidadItem" placeholder="Cantidad" onkeypress="return validarNumerosEnteros(event, this);">
                                                    </div>
                                                </div>
                                                <div class="col-3">
                                                    <div class="form-group">
                                                        <label for="precioItem">Precio Unitario</label>
                                                        <input type="text" class="form-control" id="precioItem" name="precioItem" placeholder="Precio" onkeypress="return validarNumerosDecimales(event, this);">
                                                    </div>
                                                </div>
                								<div class="col-2 d-flex justify-content-end align-items-center">
                            					    <button type="button" onclick="agregarItemOC();" class="btn bg-success px-2 py-1 ms-2 d-flex justify-content-center align-items-center color-white" >
                                                        <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i> Agregar
                                                    </button>
                            					</div>
                							</div>
                                        </div>
                                        <div class="col-12">
                                            <span class="respuesta"></span>
                                            <div class="table-responsive">
                                                <div class="row p-3 m-0 d-flex bg-sistema" style="border-radius: 10px;">
                                                    <div class="col-6 m-0 p-0">
                                                        <h5 class="m-0 color-white">Descripción</h5>
                                                    </div>
                                                    <div class="col-1 m-0 p-0">
                                                        <h5 class="m-0 color-white">Cantidad</h5>
                                                    </div>
                                                    <div class="col-2 m-0 p-0">
                                                        <h5 class="m-0 color-white">Precio Unitario</h5>
                                                    </div>
                                                    <div class="col-2 m-0 p-0">
                                                        <h5 class="m-0 color-white">Precio Total</h5>
                                                    </div>
                                                    <div class="col-1 m-0 p-0">
                                                        <h5 class="m-0 color-white">Acciones</h5>
                                                    </div>
                                                </div>
                                                <div class="row p-0 py-3 m-0 d-flex" id="ctnDetalleItemOC">
                                                    
                                                </div>
                                                <div class="row p-3 m-0 d-flex">
                                                    <div class="col-9 m-0 p-0 px-3 d-flex align-items-center justify-content-end">
                                                        <h5 class="m-0 color-sistema">Subtotal</h5>
                                                    </div>
                                                    <div class="col-3 m-0 p-0">
                                                        <div class="input-group">
                                                            <span class="input-group-text lblSimboloMoneda"></span>
                                                            <input type="text" class="form-control" id="subtotaldetalleoc" name="subtotaldetalleoc" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-9 m-0 p-0 px-3 d-flex align-items-center justify-content-end">
                                                        <h5 class="m-0 color-sistema">IGV</h5>
                                                    </div>
                                                    <div class="col-3 m-0 p-0">
                                                        <div class="input-group">
                                                            <span class="input-group-text lblSimboloMoneda"></span>
                                                            <input type="text" class="form-control" id="igvdetalleoc" name="igvdetalleoc" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-9 m-0 p-0 px-3 d-flex align-items-center justify-content-end">
                                                        <h5 class="m-0 color-sistema">Total</h5>
                                                    </div>
                                                    <div class="col-3 m-0 p-0">
                                                        <div class="input-group">
                                                            <span class="input-group-text lblSimboloMoneda"></span>
                                                            <input type="text" class="form-control" id="totaldetalleoc" name="totaldetalleoc" readonly>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start gap-3 mt-4">
                                    <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionProveedorOC"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información de proveedor</button>
                                    <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                                </div>
                            </div>
                            <!-- end tab pane -->
                        </div>
                        <!-- end tab content -->
					</div>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Agregar Comentario Peticion -->
<div class="modal fade zoomIn" id="agregarComentarioPeticion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleagregarComentarioPeticion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleagregarComentarioPeticion">Agregar Comentario</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAgregarComentarioPeticion" class="formularioAgregarComentarioPeticion" autocomplete="off" action="<?= $baseUrl ?>/agregar-comentario-peticion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtNroPeticion_acp" name="txtNroPeticion_acp" value="<?= $peticion['IDPeticion'] ?>">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtComentarioPeticion_acp" class="form-label">Comentario</label>
								<textarea class="form-control" id="txtComentarioPeticion_acp" name="txtComentarioPeticion_acp" rows="4" placeholder="Ingrese su comentario..."></textarea>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtLinkComentarioPeticion_acp" class="form-label">Link de Referencia</label>
								<input type="text" class="form-control" id="txtLinkComentarioPeticion_acp" name="txtLinkComentarioPeticion_acp" placeholder="Ingrese link asociado">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-0">
							<div>
								<label for="txtAdjunto_acp" class="form-label">Adjuntos</label>
            					<div class="col-12 mb-0 d-flex justify-content-center">
            					    <div class="col-12 m-0 p-0">
            					        <input type="file" id="txtAdjunto_acp" data-max-file-size="100MB" data-max-files="4" />
            					    </div>
            					</div>
							</div>
						</div>
					</div>
					<hr class="m-0 p-0">
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?= $this->section('js'); ?>
<script>
	$(function () {
		pondAdjuntosComentario = FilePond.create(
            document.querySelector("#txtAdjunto_acp"), {
                labelIdle: 'Arrastra y suelta los adjuntos necesarios o <span class="filepond--label-action">explora</span>',
                allowMultiple: true,
                instantUpload: false,
                allowProcess: false,
                // acceptedFileTypes: [
                //   'application/vnd.ms-outlook',   // Common MIME type for .msg files
                //   'application/octet-stream',       // Generic MIME type for binary files
                //   'application/x-msg'               // Alternative MIME type
                // ]
            }
        );
        
        pondAdjuntosPeticionCompletada = FilePond.create(
            document.querySelector("#txtAdjunto_cep"), {
                labelIdle: 'Arrastra y suelta el valorizado o <span class="filepond--label-action">explora</span>',
                allowMultiple: true,
                instantUpload: false,
                allowProcess: false,
                // acceptedFileTypes: [
                //   'application/vnd.ms-outlook',   // Common MIME type for .msg files
                //   'application/octet-stream',       // Generic MIME type for binary files
                //   'application/x-msg'               // Alternative MIME type
                // ]
            }
        );
	});
</script>
<?php $this->endSection(); ?>

<?php $this->endSection(); ?>