<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioRutasModel extends Model {
  protected $table = 'usuario_rutas';
  protected $primaryKey = 'IdUsuario';
  protected $allowedFields = ['IdUsuario', 'IDRuta', 'UsuarioRegistra', 'FechaRegistra'];
  protected $useAutoIncrement = false;
  protected $useSoftDeletes = false;
  
  public function listarRutasUsuario($idUsuario)
  {
      $this->select('modulos_rutas.IDRuta,
        modulos_rutas.IDModulo, 
        modulos_rutas.Ruta,
        modulos_rutas.RaizModulo,
        modulos_rutas.TipoRuta,
        IF(usuario_rutas.IdUsuario IS NULL, 0, 1) AS "ACTIVO"');
      $this->join('modulos_rutas', 'usuario_rutas.IDRuta = modulos_rutas.IDRuta AND usuario_rutas.IdUsuario = "'.$idUsuario.'"', 'right');
      
      $datos = $this->findAll();
      return $datos;
  }

  public function navBarUsuario($idUsuario)
  {
      $this->select('modulos_rutas.Ruta, 
        modulos.IDCabecera, 
        modulos.Modulo, 
        modulos.Orden, 
        modulos.Icono');
      $this->join('modulos_rutas', 'usuario_rutas.IDRuta = modulos_rutas.IDRuta AND modulos_rutas.RaizModulo = "Y" AND modulos_rutas.Estado = "A"');
      $this->join('modulos', 'modulos_rutas.IDModulo = modulos.IDModulo AND modulos.Estado = "A"');
      $this->where('usuario_rutas.IdUsuario', $idUsuario);
      $this->orderBy('modulos.Orden', 'ASC');

      $datos = $this->findAll();
      return $datos;
  }

  
}
