<?php namespace App\Models;

use CodeIgniter\Model;

class UsuarioPerfilModel extends Model {
  protected $table = 'usuario_perfil';
  protected $primaryKey = 'IdUsuario';
  protected $allowedFields = ['IdUsuario', 'IDPerfil', 'UsuarioRegistra', 'FechaRegistra'];
  protected $useAutoIncrement = false;
  protected $useSoftDeletes = false;
  
//     public function listadoUsuariosPerfil($idPerfil)
//     {
//         $this->select('
//             dbMASTERUSUARIO.tblusuario.IdUsuario,
//             dbMASTERUSUARIO.tblusuario.Matricula,
//             dbMASTERUSUARIO.tblusuario.Nombres,
//             dbMASTERUSUARIO.tblusuario.Apellidos,
//             dbMASTERUSUARIO.tblusuario.NumeroDoc,
//             dbMASTERUSUARIO.tblusuario.Usuario,
//             usuario_perfil.IDPerfil');
//         $this->join('dbMASTERUSUARIO.tblusuario', 'dbMASTERUSUARIO.tblusuario.IdUsuario = usuario_perfil.IdUsuario');
//         $this->where("usuario_perfil.IDPerfil", $idPerfil);
        
//         $datos = $this->findAll();
//         return $datos;
//   }
  
  public function listarUsuarioPerfil()
  {
      $this->select('usuario_perfil.IdUsuario,
        usuario_perfil.IDPerfil, 
        perfil.Perfil');
      $this->join('perfil', 'usuario_perfil.IDPerfil = perfil.IDPerfil', 'left');
      
      $datos = $this->findAll();
      return $datos;
  }
  
  public function obtenerPerfilUsuario($idUsuario)
  {
      $this->select('usuario_perfil.IdUsuario,
        usuario_perfil.IDPerfil, 
        perfil.Perfil,
        perfil.URLBase');
      $this->join('perfil', 'usuario_perfil.IDPerfil = perfil.IDPerfil', 'left');
      $this->where('usuario_perfil.IdUsuario', $idUsuario);
      
      $datos = $this->first();
      return $datos;
  }

  public function obtenerRutaUsuario($array)
  {
    $this->select('
      (SELECT 
        IF(usuario_rutas.IdUsuario IS NULL, 0, 1)
      FROM 
        usuario_rutas 
      INNER JOIN 
        modulos_rutas ON usuario_rutas.IDRuta = modulos_rutas.IDRuta
      WHERE
        usuario_rutas.IdUsuario = "'.$array['idusuario'].'" AND
        modulos_rutas.Ruta = "'.$array['ruta'].'" LIMIT 1) AS "AUTORIZADO",
      perfil.Perfil,
      perfil.URLBase');
    $this->join('perfil', 'usuario_perfil.IDPerfil = perfil.IDPerfil', 'left');
    $this->where('usuario_perfil.IdUsuario', $array['idusuario']);

    $datos = $this->first();
    return $datos;
  }
}
