<?php
namespace App\Models;
use CodeIgniter\Model;

class DireccionModel extends Model
{
    protected $DBGroup      = 'baseT';
    protected $table        = 'direccion';
    protected $primaryKey   = 'id_direccion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Nombre', 'Direccion', 'id_distrito', 'fechahorareg', 'fija', 'eliminacion_logica', 'codigoSunat'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function obtenerDireccion($idDireccion)
    {
        $this->select('
            direccion.id_direccion,
            direccion.Nombre,
            direccion.Direccion,
            direccion.codigoSunat,
            direccion.eliminacion_logica,
            region_distrito.IDDistrito AS "id_distrito",
            region_distrito.Distrito AS "desc_ubigeo_inei",
            region_distrito.CodigoINEI AS "cod_ubigeo",
            region_provincia.IDProvincia AS "id_prov_inei",
            region_provincia.Provincia AS "desc_prov_inei",
            region_departamento.IDDepartamento AS "id_dep_inei",
            region_departamento.Departamento AS "desc_dep_inei"');
        $this->join('region_distrito', 'direccion.id_distrito = region_distrito.IDDistrito', 'left');
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $this->where("direccion.id_direccion", $idDireccion);
        $datos = $this->first();
        return $datos;
    }
    
    public function listadoDireccion()
    {
        $this->select('
            direccion.id_direccion,
            direccion.Nombre,
            direccion.Direccion,
            direccion.codigoSunat,
            direccion.eliminacion_logica,
            region_distrito.Distrito AS "desc_ubigeo_inei",
            region_provincia.Provincia AS "desc_prov_inei",
            region_departamento.Departamento AS "desc_dep_inei"');
        $this->join('region_distrito', 'direccion.id_distrito = region_distrito.IDDistrito', 'left');
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        $datos = $this->findAll();
        return $datos;
    }
    
    public function listadoDireccionBusqueda($array)
    {
        $this->select('
            direccion.id_direccion,
            direccion.Nombre,
            direccion.Direccion,
            direccion.id_distrito,
            direccion.codigoSunat,
            region_distrito.Distrito,
            region_distrito.CodUbigeoReniec AS "UbigeoDistrito",
            region_distrito.IDProvincia,
            region_provincia.Provincia,
            region_provincia.IDDepartamento,
            region_departamento.Departamento');
            
        $this->join('region_distrito', 'direccion.id_distrito = region_distrito.IDDistrito', 'left');
        $this->join('region_provincia', 'region_distrito.IDProvincia = region_provincia.IDProvincia', 'left');
        $this->join('region_departamento', 'region_provincia.IDDepartamento = region_departamento.IDDepartamento', 'left');
        
        $this->groupStart(); // Inicia un grupo de condiciones
            $this->orLike("direccion.Direccion", $array['variable']);
            $this->orLike("region_distrito.Distrito", $array['variable']);
            $this->orLike("region_provincia.Provincia", $array['variable']);
            $this->orLike("region_departamento.Departamento", $array['variable']);
        $this->groupEnd();
        // $this->get();
        // return $this->getLastQuery();
        $datos = $this->findAll();
        
        return $datos;
    }
}