<?php

use CodeIgniter\Router\RouteCollection;
$routes->get('test-controller', 'TestController::index');
// $routes->add('test', function() {
//     return 'Ruta de prueba funcionando';
// });
/**
 * @var RouteCollection $routes
 */
// $routes->get('/', 'Home::index');
$routes->set404Override(function()
{
    echo view('errors/404');
});
/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Acceso::login');

/* ACCESO */
$routes->add('entrar', 'Acceso::entrar');
$routes->add('salir','Acceso::salir');
$routes->add('iniciar-sesion','Acceso::login');
$routes->add('cambiar-password', 'Acceso::cambiarPasswordUsuario');

/* ADMINISTRACIÓN */
$routes->add('descargatxt/(:any)','Administracion::descargatxt/$1');/* NUEVO */

$routes->add('listar-usuarios','Administracion::listarUsuarios');/* NUEVO */

$routes->add('listar-perfiles','Administracion::listarPerfiles');/* NUEVO */
$routes->add('registrar-perfil','Administracion::registrarPerfil');/* NUEVO */
$routes->add('listado-perfil-select','Administracion::listadoPerfilesSelect');/* NUEVO */
$routes->add('obtener-datos-perfil','Administracion::obtenerDatosPerfil');/* NUEVO */
$routes->add('actualizar-perfil/(:any)','Administracion::actualizarPerfil/$1');/* NUEVO */
$routes->add('cambiar-estado-perfil','Administracion::modificarEstadoPerfil');/* NUEVO */

$routes->add('listar-permisos-perfil/(:any)','Administracion::listarPermisosPerfil/$1');/* NUEVO */
$routes->add('grabar-permisos-perfil/(:any)','Administracion::guardarPermisosPerfil/$1');/* NUEVO */
$routes->add('listar-rutas-perfil/(:any)','Administracion::listarRutasPerfil/$1');/* NUEVO */
$routes->add('grabar-rutas-perfil/(:any)','Administracion::guardarRutasPerfil/$1');/* NUEVO */

$routes->add('obtener-cabecera','Administracion::obtenerCabecera');/* NUEVO */
$routes->add('listar-modulos','Administracion::listarModulos');/* NUEVO */
$routes->add('registrar-modulo','Administracion::registrarModulo');/* NUEVO */
$routes->add('cambiar-estado-modulo','Administracion::modificarEstadoModulo');/* NUEVO */
$routes->add('obtener-datos-modulo','Administracion::obtenerDatosModulo');/* NUEVO */
$routes->add('actualizar-modulo/(:any)','Administracion::modificarModulo/$1');/* NUEVO */
$routes->add('listar-rutas-modulo/(:any)','Administracion::listarRutasModulo/$1');/* NUEVO */
$routes->add('grabar-ruta/(:any)','Administracion::guardarRutaModulo/$1');/* NUEVO */
$routes->add('obtener-datos-ruta-modulo','Administracion::obtenerDatosRutaModulo');/* NUEVO */
$routes->add('actualizar-ruta-modulo/(:any)','Administracion::modificarRutaModulo/$1');/* NUEVO */
$routes->add('cambiar-estado-ruta-modulo','Administracion::modificarEstadoRutaModulo');/* NUEVO */
$routes->add('listar-acciones-modulo/(:any)','Administracion::listarAccionesModulo/$1');/* NUEVO */
$routes->add('grabar-accion/(:any)','Administracion::guardarAccionModulo/$1');/* NUEVO */

/******************************************************************************/
	
/* USUARIOS */
$routes->add('usuariosServerside','Usuarios::listarUsuarioDataTable');/* NUEVO */
$routes->add('obtener-datos-usuario/(:any)','Usuarios::obtenerDatosUsuario/$1');
$routes->add('modificar-usuario/(:any)','Usuarios::modificarUsuario/$1');/* NUEVO */
$routes->add('listado-usuarios-select','Usuarios::listadoUsuariosSelect');
$routes->add('listado-usuarios-comprador','Usuarios::listadoUsuariosComprador');

$routes->add('listar-permisos-usuario/(:any)','Usuarios::listarPermisosUsuario/$1');/* NUEVO */
$routes->add('grabar-permisos-usuario/(:any)','Usuarios::guardarPermisosUsuario/$1');/* NUEVO */
$routes->add('listar-rutas-usuario/(:any)','Usuarios::listarRutasUsuario/$1');/* NUEVO */
$routes->add('grabar-rutas-usuario/(:any)','Usuarios::guardarRutasUsuario/$1');/* NUEVO */

/******************************************************************************/

/*************************** NOTIFICACIONES ***********************************/
$routes->add('cargar-notificaciones-header','Notificaciones::cargarNotificacionesHeader');/* NUEVO */
$routes->add('cantidad-notificaciones-header','Notificaciones::cantidadNotificacionesHeader');/* NUEVO */
$routes->add('registrar-vista-notificacion','Notificaciones::registrarVisualizacionNotificacion');/* NUEVO */

/******************************************************************************/
	
/*************************** REFERIDOS ************************************/

// $routes->add('supercolaborador','Referidos::viewSupercolaborador'); 
// $routes->add('registrar-referido-supercolaborador','Referidos::registrarReferidoSupercolaborador'); 
// $routes->add('nuevo-referido','Referidos::viewReferidoATC'); 

/******************************************************************************/
	
/********************************** PROCESOS **********************************/ 

$routes->add('listar-landing','Landing::listarLanding'); 
// $routes->add('nueva-landing','Landing::nuevaLanding'); 
$routes->add('registrar-landing','Landing::registrarLanding');/* NUEVO */
$routes->add('listado-parametros-landing','Landing::listadoParametrosLanding');/* NUEVO */

/******************************************************************************/
	
/*************************** LANDING PERSONALIZADOS ***************************/

// $routes->add('prueba-verismart','Landing::pruebaVerisMartLanding');/* NUEVO */
// $routes->add('prueba-verismart/(:any)','Landing::pruebaVerisMartLanding/$1');/* NUEVO */
// $routes->add('prueba-verismart/(:any)/(:any)','Landing::pruebaVerisMartLanding/$1/$2');/* NUEVO */
$routes->add('referidos/(:any)/(:any)/(:any)/(:any)/(:any)','Landing::referidosField/$1/$2/$3/$4/$5');/* NUEVO */
$routes->add('guardar-referido-field','Landing::guardarReferidosField');/* NUEVO */
$routes->add('referidostctv/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)','Landing::referidosTCTV/$1/$2/$3/$4/$5/$6');/* NUEVO */
$routes->add('guardar-referido-tctv','Landing::guardarReferidosTCTV');/* NUEVO */
$routes->add('afiliacion/(:any)/(:any)/(:any)/(:any)/(:any)/(:any)','Landing::afiliacionMetodoPago/$1/$2/$3/$4/$5/$6');/* NUEVO */
$routes->add('afiliar-cuenta-bancaria','Landing::afiliarCuentaBancaria');/* NUEVO */
$routes->add('afiliar-diners','Landing::afiliarDiners');/* NUEVO */
$routes->add('afiliar-visa-mastercard','Landing::afiliarNiubis');/* NUEVO */
/******************************************************************************/
	
/****************************** REMOTOS **************************************/

$routes->add('listado-direccion-busqueda','Remotos::listadoDireccionBusqueda');/* NUEVO */
$routes->add('listado-region-pais','Remotos::listadoRegionPais');/* NUEVO */
$routes->add('listado-region-departamentos','Remotos::listadoRegionDepartamento');/* NUEVO */
$routes->add('listado-region-provincias','Remotos::listadoRegionProvincia');/* NUEVO */
$routes->add('listado-region-distritos','Remotos::listadoRegionDistrito');/* NUEVO */

$routes->add('listado-monedas','Remotos::listadoMonedas');/* NUEVO */
$routes->add('listado-tipos-documento','Remotos::listadoTiposDocumento');/* NUEVO */
$routes->add('listado-tipos-documento-sunat','Remotos::listadoTiposDocumentoSunat');/* NUEVO */

$routes->add('listado-direccion-estructura','Remotos::listadoDireccionesEstructura');/* NUEVO */
$routes->add('listado-area-estructura','Remotos::listadoAreasEstructura');/* NUEVO */
$routes->add('listado-subarea-estructura','Remotos::listadoSubareasEstructura');/* NUEVO */
$routes->add('listado-delegacion-estructura','Remotos::listadoDelegacionEstructura');/* NUEVO */
$routes->add('listado-cc-delegacion-estructura','Remotos::listadoCCDelegacionEstructura');/* NUEVO */
$routes->add('listado-estructura-delegacion','Remotos::listadoEstructuraDelegacion');/* NUEVO */
$routes->add('exportar-estructura-departamental','Remotos::exportarEstructuraDepartamental');/* NUEVO */

$routes->add('listado-responsables-direccion-estructura','Remotos::listadoResponsablesDireccionEstructura');/* NUEVO */
$routes->add('listado-responsables-area-estructura','Remotos::listadoResponsablesAreaEstructura');/* NUEVO */
$routes->add('listado-responsables-subarea-estructura','Remotos::listadoResponsablesSubareaEstructura');/* NUEVO */

$routes->add('listado-usuarios','Remotos::listadoUsuarios');/* NUEVO */
