let pondIMGLanding;
// let pondImportarCSVFacturasCondonacion;
let pondAdjuntoMotivoRequerimiento;
let pondImportarCSVCondonaciones;
let pondImportarCSVMatrizCondonaciones;

$(function () {
    FilePond.registerPlugin(
        FilePondPluginFileValidateType,    // Validación de extensión
        FilePondPluginImagePreview,        // Previsualización de imágenes
        FilePondPluginImageExifOrientation // Orientación EXIF de imágenes
    );
});

/* FUNCIONES GENERALES */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

toastr.options = {
    "positionClass": "toast-bottom-center",
    "newestOnTop": true,
    "preventDuplicates": true
}

const tableRequerimientos = new DataTable('#tblRequerimientos');
const tableMotivosRequerimiento = new DataTable('#tblMotivosRequerimiento');
const tablePeticiones = new DataTable('#tblPeticiones', {
    responsive: true,
    columnDefs: [
        { width: '50px', targets: 0 },
        { responsivePriority: 1, targets: 0 },
        { responsivePriority: 2, targets: 1 },
        { width: '50px', targets: 10 },
        { responsivePriority: 1, targets: 10 }
    ]
});
const tableGruposTrabajo = new DataTable('#tblGruposTrabajo');
const tableGruposCarteraCliente = new DataTable('#tblGruposCarteraCliente');
const tableUsuariosGrupoTrabajo = new DataTable('#tblUsuariosGrupoTrabajo');
// const tableHistoricoPeticiones = new DataTable('#tblHistoricoPeticiones');
$(function () {
    $('[data-tooltip="tooltip"]').tooltip();
    $("#txtPerfilUsuario").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Perfil',
        dropdownParent: $('#editarPerfilUsuario .modal-body'),
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-perfil-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $('#txtGruposTrabajoPeticion_i').select2({
        dropdownParent: $('#registrarPeticion .modal-body')
    });
    

   if($("#registrarPeticion").length) {
       $('#txtTipoRequerimiento_i').select2({
            dropdownParent: $('#registrarPeticion .modal-body')
        });
   }
   
       
   if($("#informacionRequerimiento").length) {
       $('#txtTipoRequerimiento_i').select2({
            dropdownParent: $('#informacionRequerimiento .modal-body')
        });
   }
    
    
    $("#txtUsuarioAsociarGrupoTrabajo").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Usuario',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-usuarios-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
    $("#txtAsignarUsuarioPeticion_i").select2({
        dropdownParent: $('#peticionAsignarUsuario .modal-body'),
        minimumInputLength: 2,
        placeholder: 'Seleccione Usuario',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-usuarios-grupotrabajo-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                var peticion = $("#txtAsignarUsuarioPeticion_i").attr("data-peticion");
                term['peticion'] = peticion;
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });
    
});

var arrValoresRandom = [];

function generarRandom(num) {
    const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    const charactersLength = characters.length;
    let result = "";
    for (let i = 0; i < num; i++) {
        result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    
    if(arrValoresRandom.includes(result))
    {
        generarRandom(num);
    }
    else
    {
        arrValoresRandom.push(result);
        return result;    
    }
}

function agregarAdjunto(contenedorElementos)
{
    var random = generarRandom(5);
    
    // let contenedor = `<div id='divImg${contador}' class="col-md-6 col-12"><div id='ImgInstalacion${contador}' class="img-instalacion bg-2" style="background-image: url('');">
    //     <input id='txtImagen${contador}' type='file' name='txtImagen${contador}' accept='image/*' ${capture} onchange='mostrarVistaPreviaImg(${contador})' style='display: none;' />
    //     <div class="cont-resultado-aprobacion">
    //         <label ${action}><i class="fa fa-image" aria-hidden="true"></i> Cambiar imagen</label>
    //     </div>
    // </div></div>`;
    
    let contenedor = `<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="adj${random}" style="border-radius: 10px;">
		<div class="col-xxl-5 col-md-12 col-12 mb-2">
			<div>
				<label for="txtNombreAdjunto_i${random}" class="form-label">Nombre Adjunto:</label>
				<input type="text" class="form-control" id="txtNombreAdjunto_i${random}" name="nombreAdjunto[${random}]">
			</div>
		</div>
		<div class="col-xxl-5 col-md-10 col-10 ">
		    <div>
				<label for="fileAdjunto_i${random}" class="form-label">Seleccione Adjunto:</label>
				<input class="form-control" type="file" id="fileAdjunto_i${random}" name="fileAdjunto[${random}]">
			</div>
		</div>
		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
			<button type="button" class="btn bg-danger px-2 py-1" onclick="return quitarAdjunto('adj${random}');" data-tooltip="tooltip" aria-label="Eliminar Adjunto">
                <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
            </button>
		</div>
	</div>`;

    $("#"+contenedorElementos).append(contenedor);
}

function quitarAdjunto(contenedorEliminar)
{
    $('#'+contenedorEliminar).remove();
    return false;
}

function clickOne(flag){
    
    $("button[type=submit]").prop('disabled',flag);

}

function downloadPDF(idDiv)
{
    var divToPrint = document.getElementById(idDiv);
    var print = 'onload="window.print()"';
    var newWin = window.open('', 'Print-Window');
    newWin.document.open();
    newWin.document.write('<html><head><meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"><title>Descargar Documento</title><meta name="viewport" content="width=device-width, initial-scale=1">\n\
                                <meta http-equiv="cache-control" content="no-cache" />\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css">\n\
                                <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">\n\
                                <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">\n\
                                <link href="'+baseUrl+'/public/css/bootstrap.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/libs/bootstrap-switch/css/bootstrap3/bootstrap-switch.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/icons.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/app.min.css" rel="stylesheet" type="text/css">\n\
                                <link href="'+baseUrl+'/public/css/custom.min.css" rel="stylesheet" type="text/css">\n\
                                <link rel="stylesheet" href="'+baseUrl+'/public/js/pages/plugins/toastr/toastr.min.css">\n\
                                <link rel="stylesheet" href="'+baseUrl+'/public/js/pages/plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css">\n\
                            </head>\n\
                            <body '+ print +' class="'+baseUrl+'">\n\
                                ' + divToPrint.innerHTML + '\n\
                                <script>$(document).ready(function () {$(".table").dataTable().fnDestroy(); $(".table").DataTable({"language": {"url": "//cdn.datatables.net/plug-ins/1.10.15/i18n/Spanish.json"}, responsive: true, stateSave: true});});</script>\n\
                            </body>\n\
                          </html>');
    newWin.document.close();
}

/* ------------------------------- */

function selectDireccionEstructura(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-direccion-estructura', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var direcciones = $.parseJSON(response.listadoDirecciones);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < direcciones.length; i++){
                $("#"+elemento).append('\
                    <option value="' + direcciones[i].id + '" '+(idSeleccionado == direcciones[i].id ? 'selected' : '')+'>' + direcciones[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectAreaEstructura(elemento, idDireccion, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-area-estructura', 
    {
        idDireccion : idDireccion
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var areas = $.parseJSON(response.listadoAreas);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < areas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + areas[i].id + '" '+(idSeleccionado == areas[i].id ? 'selected' : '' )+'>' + areas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */

function selectSubareaEstructura(elemento, idArea, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-subarea-estructura', 
    {
        idArea : idArea
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var subareas = $.parseJSON(response.listadoSubareas);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < subareas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + subareas[i].id + '" '+(idSeleccionado == subareas[i].id ? 'selected' : '' )+'>' + subareas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectDelegacionesSubareaEstructura(elemento, idSubarea, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-delegacion-subarea-estructura', 
    {
        idSubarea : idSubarea
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var delegaciones = $.parseJSON(response.listadoDelegaciones);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < delegaciones.length; i++){
                $("#"+elemento).append('\
                    <option value="' + delegaciones[i].id + '" '+(idSeleccionado == delegaciones[i].id ? 'selected' : '' )+'>' + delegaciones[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectCabeceraModulo(elemento, idSeleccionado, modal)
{
    $.post(baseUrl + '/obtener-cabecera', 
    {}, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var cabecera = $.parseJSON(response.listadoCabecera);

            for(var i = 0; i < cabecera.length; i++){
                $("#"+elemento).append('\
                    <option value="' + cabecera[i].id + '" '+(idSeleccionado == cabecera[i].id ? 'selected' : '')+'>' + cabecera[i].cabecera +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectRequerimientos(elemento, tipoRequerimiento, idSeleccionado, modal,grupoTrabajo= null)
{ 
    $('#'+elemento).empty();
    
    var postData = {
        tipoRequerimiento: tipoRequerimiento
    };
    
    // Agregar grupoTrabajo al objeto postData solo si tiene un valor
    if (grupoTrabajo !== null) {
        postData.grupoTrabajo = grupoTrabajo;
    }
    console.log(postData);
    $.post(baseUrl + '/listado-requerimiento', postData, 
    function(response) 
    { 
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var requerimientos = $.parseJSON(response.listadoRequerimientos);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < requerimientos.length; i++)
            {
                $("#"+elemento).append('\
                    <option value="' + requerimientos[i].id + '" '+(idSeleccionado == requerimientos[i].id ? 'selected' : '')+'>' + requerimientos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== '')
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

function selectTipoRequerimientos(elemento, grupoTrabajo, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-tipo-requerimiento', 
    {
        grupoTrabajo: grupoTrabajo
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var requerimientos = $.parseJSON(response.listadoTipoRequerimientos);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < requerimientos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + requerimientos[i].id + '" '+(idSeleccionado == requerimientos[i].id ? 'selected' : '')+'>' + requerimientos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}


function selectMotivosRequerimiento(elemento, idRequerimiento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-motivo-requerimiento', 
    {
        idRequerimiento: idRequerimiento
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var motivos = $.parseJSON(response.listadoMotivos);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < motivos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + motivos[i].id + '" data-adjunto="'+motivos[i].adjunto+'" '+(idSeleccionado == motivos[i].id ? 'selected' : '')+'>' + motivos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectGruposTrabajoRequerimiento(elemento, idRequerimiento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-grupos-trabajo-requerimiento', 
    {
        idRequerimiento: idRequerimiento
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var gruposTrabajo = $.parseJSON(response.listadoGruposTrabajo);
            
            if(gruposTrabajo.length == 1)
            {
                for(var i = 0; i < gruposTrabajo.length; i++){
                    $("#"+elemento).append('\
                        <option value="' + gruposTrabajo[i].id + '" selected>' + gruposTrabajo[i].text +'</td>\n\
                    ');
                }
            }
            else
            {
                $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
                for(var i = 0; i < gruposTrabajo.length; i++){
                    $("#"+elemento).append('\
                        <option value="' + gruposTrabajo[i].id + '" '+(idSeleccionado == gruposTrabajo[i].id ? 'selected' : '')+'>' + gruposTrabajo[i].text +'</td>\n\
                    ');
                }
            }
            
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}
/* ------------------------------- */

function selectGruposTrabajo(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-grupos-trabajo', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var grupostrabajo = $.parseJSON(response.listadoGruposTrabajo);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < grupostrabajo.length; i++){
                $("#"+elemento).append('\
                    <option value="' + grupostrabajo[i].id + '" '+(idSeleccionado == grupostrabajo[i].id ? 'selected' : '')+'>' + grupostrabajo[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

/* ------------------------------- */
/* ------------------------------- */

$(document).on('submit', '.formularioCambiarPassword', function(event) {
    event.preventDefault();
    
    let actual          = $("#txtPasswordActual").val();
    let nuevo           = $("#txtNuevoPassword").val();
    let confirmacion    = $("#txtConfirmarNuevoPassword").val();
    
    if(actual == "")
    {
        Swal.fire({
            title: 'Debe ingresar su CONTRASEÑA ACTUAL para procesar el cambio.',
            icon: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#282E38',
            confirmButtonText: 'Confirmar'
        });
    }
    else if(nuevo == "")
    {
        Swal.fire({
            title: 'Debe ingresar la CONTRASEÑA NUEVA para procesar el cambio.',
            icon: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#282E38',
            confirmButtonText: 'Confirmar'
        });
    }
    else if(confirmacion == "")
    {
        Swal.fire({
            title: 'Debe ingresar la CONFIRMACIÓN DE LA CONTRASEÑA NUEVA para procesar el cambio.',
            icon: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#282E38',
            confirmButtonText: 'Confirmar'
        });
    }
    else if(confirmacion != nuevo)
    {
        Swal.fire({
            title: 'La NUEVA CONTRASEÑA y la CONTRASEÑA DE CONFIRMACIÓN no coinciden.',
            icon: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#282E38',
            confirmButtonText: 'Confirmar'
        });
    }
    else
    {
        Swal.fire({
            title: '¿Estas seguro que deseas cambiar tu contraseña?',
            text: "Recuerda que este cambio afecta a todos los sistemas asociados (Verismart, Veriactivos, Vericompras, peticiones, etc).",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#282e38',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                var formulario = $(this);
                var metodoEnvio = formulario.attr('method');
                var idForm = formulario.attr('id');
                
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
                
                var formData = new FormData(this);
            
                $.ajax({        
                    url: formulario.attr('action'),
                    type: metodoEnvio,
                    data: formulario.serialize(),
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(response) {
                        Swal.close();
                        $('.respuesta_cambio_password').html(response);
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        Swal.close();
                        
                        Swal.fire({
                            title: 'Ha ocurrido un error interno',
                            text: errorThrown,
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonColor: '#E4002B',
                            confirmButtonText: 'Confirmar'
                        });
                    }
                });
            }
        });
    }

    return false;
});

/* ------------------------------- */
$(document).on('click', '.removerInfo', function(e) {
    e.preventDefault();
    vinculo = $(this).attr("data-url");
    respuesta = $(this).attr("data-response");

    Swal.fire({
        title: '¿Estas seguro que deseas continuar?',
        text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(vinculo, 
                { }, 
                function (response) {
                    $('.'+respuesta).html(response);
                });
                return false;
            }
    });
});
/* ------------------------------- */
$(document).on('click', '.datos-modulo', function(e) {
    $('#btnEjecutarModulo').removeClass("d-none");
    var idModulo = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionModulo').text("Registrar módulo");
        $('#formInformacionModulo').attr('action', baseUrl + '/registrar-modulo');

        $('#btnEjecutarModulo').html('<i class="mdi mdi-content-save"></i> Guardar');

        selectCabeceraModulo("txtCabecera_i", "", "informacionModulo")

        $('#txtModulo_i').removeAttr("disabled");
        $('#txtOrden_i').removeAttr("disabled");
        $('#txtIcono_i').removeAttr("disabled");
        $('#txtObservacionModulo_i').removeAttr("disabled");

        $('#txtModulo_i').val("");
        $('#txtOrden_i').val("");
        $('#txtIcono_i').val("");
        $('#txtObservacionModulo_i').val("");
        $('#txtModulo_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-modulo', 
        {         
            idModulo : idModulo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionModulo').text("Información de módulo");
                    $('#btnEjecutarModulo').addClass("d-none");
                    $('#formInformacionModulo').attr('action', '');

                    $('#txtModulo_i').attr("disabled","disabled");
                    $('#txtIcono_i').attr("disabled","disabled");
                    $('#txtOrden_i').attr("disabled","disabled");
                    $('#txtObservacionModulo_i').attr("disabled","disabled");
                    $('#txtCabecera_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionModulo').text("Actualizar módulo");
                    $('#formInformacionModulo').attr('action', baseUrl + '/actualizar-modulo/' + idModulo);

                    $('#txtIcono_i').removeAttr("disabled");
                    $('#txtModulo_i').removeAttr("disabled");
                    $('#txtOrden_i').removeAttr("disabled");
                    $('#txtObservacionModulo_i').removeAttr("disabled");
                    $('#txtCabecera_i').removeAttr("disabled");
                }

                selectCabeceraModulo("txtCabecera_i", response.cabecera, "informacionModulo")

                $('#txtModulo_i').val(response.modulo);
                $('#txtOrden_i').val(response.orden);
                $('#txtIcono_i').val(response.icono);
                $('#txtObservacionModulo_i').val(response.observacion);
            }
        }, 'json'); 
    }
});
/* ------------------------------- */
$(document).on('click', '#btnAgregarRutasModulo', function(e) {
    var ruta = $("#txtRutaModulo").val();

    if(ruta == '')
    {
        Swal.fire({
            html: 'Debe digitar la ruta perteneciente al módulo.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        tableRutasModuloAgregar.row
            .add([
                ruta+"<input type='hidden' name='rutasModulo[]' value='"+ruta+"'>",
                "<button class='btn btn-danger btnDelete'><span class='mdi mdi-trash-can'></span></button>"
            ])
            .draw(false);
        
        $("#txtRutaModulo").val("");
        $("#txtRutaModulo").focus();
    }
});

// tableRutasModuloAgregar.on('click', 'button.btnDelete', function(e) {
//     e.preventDefault();
//     let $tr = $(this).closest('tr');
  
//     // Le pedimos al DataTable que borre la fila
//     tableRutasModuloAgregar.row($tr).remove().draw(false);
//   });
/* ------------------------------- */
$(document).on('keypress', '#txtCodigoAccionModulo', function(event) {
    var regex = new RegExp("^[a-zA-Z0-9]+$");
    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
      event.preventDefault();
      return false;
    }
    else if(this.value.length >= 6)
    {
        event.preventDefault();
        return false;
    }
  });
/* ------------------------------- */
  $(document).on('click', '#editar-perfil-usuario', function(e) {
    var idUsuario = $(this).data('id');
    $('#formEditarPerfilUsuario').attr('action', baseUrl + '/modificar-usuario/' + idUsuario);
    $('#txtPerfilUsuario').val("");
});
/* ------------------------------- */
$(document).on('click', '.datos-ruta-modulo', function(e) {
    $('#btnEjecutarRutasModulo').removeClass("d-none");
    var idRutaModulo = $(this).data('id');
    var idModulo = $(this).data('modulo');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionRutasModulo').text("Crear Ruta");
        $('#formInformacionRutasModulo').attr('action', baseUrl + '/grabar-ruta/'+idModulo);

        $('#btnEjecutarRutasModulo').html('<i class="mdi mdi-content-save"></i> Guardar');
        $('#txtRutaModulo').removeAttr("disabled");
        $('#txtTipoRuta_i').removeAttr("disabled");
        $('#chkRutaRaiz').removeAttr("disabled");
        $('#chkRutaRaiz').removeAttr("checked", "checked");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-ruta-modulo', 
        {         
            idRutaModulo : idRutaModulo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionRutasModulo').text("Información de Ruta");
                    $('#btnEjecutarRutasModulo').addClass("d-none");
                    $('#formInformacionRutasModulo').attr('action', '');

                    $('#txtRutaModulo').attr("disabled","disabled");
                    $('#txtTipoRuta_i').attr("disabled","disabled");
                    $('#chkRutaRaiz').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionRutasModulo').text("Actualizar Ruta");
                    $('#formInformacionRutasModulo').attr('action', baseUrl + '/actualizar-ruta-modulo/' + idRutaModulo);

                    $('#txtRutaModulo').removeAttr("disabled");
                    $('#txtTipoRuta_i').removeAttr("disabled");
                    $('#chkRutaRaiz').removeAttr("disabled");
                }

                $('#txtIDRutaModulo_i').val(response.idruta);
                $('#txtRutaModulo').val(response.ruta);
                $('#txtTipoRuta_i').val(response.tipo);
                if(response.raiz=='Y')
                {
                    $('#chkRutaRaiz').attr("checked", "checked");
                }
                
            }
        }, 'json'); 
    }
});
/* ------------------------------- */
$(document).on('click', '.cambiar-estado-ruta-modulo', function() {
    var idRutaModulo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la ruta?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idRutaModulo"  : idRutaModulo,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-ruta-modulo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */
$(document).on('click', '.cambiar-estado-modulo', function() {
    var idModulo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el módulo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idModulo"  : idModulo,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-modulo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */
$(document).on('click', '.datos-perfil', function(e) {
    $('#btnEjecutarPerfil').removeClass("d-none");
    var idPerfil = $(this).data('id');
    var accion = $(this).data('accion');
    if(accion == 'crear')
    {
        $('#exampleinformacionPerfil').text("Registrar perfil");
        $('#formInformacionPerfil').attr('action', baseUrl + '/registrar-perfil');

        $('#btnEjecutarPerfil').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtPerfil').removeAttr("disabled");
        $('#txtURLBasePerfil').removeAttr("disabled");
        
        $('#txtPerfil').val("");
        $('#txtURLBasePerfil').val("");
        
        $('#txtPerfil').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-perfil', 
        {         
            idPerfil : idPerfil
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionPerfil').text("Información de perfil");
                    $('#btnEjecutarPerfil').addClass("d-none");
                    $('#formInformacionPerfil').attr('action', '');

                    $('#txtPerfil').attr("disabled","disabled");
                    $('#txtURLBasePerfil').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionPerfil').text("Actualizar perfil");
                    $('#formInformacionPerfil').attr('action', baseUrl + '/actualizar-perfil/' + idPerfil);

                    $('#txtPerfil').removeAttr("disabled");
                    $('#txtURLBasePerfil').removeAttr("disabled");
                }

                $('#txtIDPerfil_i').val(response.idperfil);
                $('#txtPerfil').val(response.perfil);
                $('#txtURLBasePerfil').val(response.url);
            }
        }, 'json'); 
    }
});
/* ------------------------------- */
$(document).on('click', '.cambiar-estado-perfil', function() {
    var idPerfil = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el perfil?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {

            var parametros = {
                "idPerfil"  : idPerfil,
                "estado"        : estado
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-perfil',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});
/* ------------------------------- */

$(document).on('click', '.datos-requerimiento', function(e) {
    $('#btnEjecutarRequerimiento').addClass("d-none");
    var idRequerimiento = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtRequerimiento_ireq').attr("disabled","disabled");
    $('#txtTipoRequerimiento_ireq').attr("disabled","disabled");
    $('#txtObservacionRequerimiento_ireq').attr("disabled","disabled");
    
    $('#txtRequerimiento_ireq').val("");
    $('#txtTipoRequerimiento_ireq').val("");
    $('#txtObservacionRequerimiento_ireq').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionRequerimiento').text("Registrar Requerimiento");
        $('#formInformacionRequerimiento').attr('action', baseUrl + '/registrar-requerimiento');
        $('#btnEjecutarRequerimiento').removeClass("d-none");
        $('#btnEjecutarRequerimiento').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtRequerimiento_ireq').removeAttr("disabled");
        $('#txtTipoRequerimiento_ireq').removeAttr("disabled");
        $('#txtObservacionRequerimiento_ireq').removeAttr("disabled");
        
        $('#txtRequerimiento_ireq').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-requerimiento', 
        {         
            idRequerimiento : idRequerimiento
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionRequerimiento').text("Información del Requerimiento");
                    $('#btnEjecutarRequerimiento').addClass("d-none");
                    $('#formInformacionRequerimiento').attr('action', '');

                    $('#txtRequerimiento_ireq').attr("disabled","disabled");
                    $('#txtTipoRequerimiento_ireq').attr("disabled","disabled");
                    $('#txtObservacionRequerimiento_ireq').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionRequerimiento').text("Actualizar Requerimiento");
                    $('#formInformacionRequerimiento').attr('action', baseUrl + '/actualizar-requerimiento/' + idRequerimiento);
                    $('#btnEjecutarRequerimiento').removeClass("d-none");

                    $('#txtRequerimiento_ireq').removeAttr("disabled");
                    $('#txtTipoRequerimiento_ireq').removeAttr("disabled");
                    $('#txtObservacionRequerimiento_ireq').removeAttr("disabled");
                }

                $('#txtIDRequerimiento_ireq').val(response.idrequerimiento);
                $('#txtRequerimiento_ireq').val(response.requerimiento);
                $('#txtTipoRequerimiento_ireq').val(response.tipo);
                $('#txtObservacionRequerimiento_ireq').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-requerimiento', function() {
    var idRequerimiento = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el requerimiento?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idRequerimiento"   : idRequerimiento,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-requerimiento',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-motivo-requerimiento', function(e) {
    $('#btnEjecutarMotivoRequerimiento').addClass("d-none");
    var idMotivo = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtMotivoRequerimiento_i').attr("disabled","disabled");
    $('#txtObservacionMotivoReq_i').attr("disabled","disabled");
    
    $('#txtMotivoRequerimiento_i').val("");
    $('#txtObservacionMotivoReq_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionMotivoRequerimiento').text("Registrar Motivo Requerimiento");
        $('#formInformacionMotivoRequerimiento').attr('action', baseUrl + '/registrar-motivo-requerimiento');
        $('#btnEjecutarMotivoRequerimiento').removeClass("d-none");
        $('#btnEjecutarMotivoRequerimiento').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtMotivoRequerimiento_i').removeAttr("disabled");
        $('#txtObservacionMotivoReq_i').removeAttr("disabled");
        
        $('#txtMotivoRequerimiento_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-motivo-requerimiento', 
        {         
            idMotivo : idMotivo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionMotivoRequerimiento').text("Información del Motivo de Requerimiento");
                    $('#btnEjecutarMotivoRequerimiento').addClass("d-none");
                    $('#formInformacionMotivoRequerimiento').attr('action', '');

                    $('#txtMotivoRequerimiento_i').attr("disabled","disabled");
                    $('#txtObservacionMotivoReq_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionMotivoRequerimiento').text("Actualizar Motivo del Requerimiento");
                    $('#formInformacionMotivoRequerimiento').attr('action', baseUrl + '/actualizar-motivo-requerimiento/' + idMotivo);
                    $('#btnEjecutarMotivoRequerimiento').removeClass("d-none");

                    $('#txtMotivoRequerimiento_i').removeAttr("disabled");
                    $('#txtObservacionMotivoReq_i').removeAttr("disabled");
                }

                $('#txtIDMotivoRequerimiento_i').val(response.idmotivo);
                $('#txtMotivoRequerimiento_i').val(response.motivo);
                $('#txtObservacionMotivoReq_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-motivo-requerimiento', function() {
    var idMotivo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el motivo del requerimiento?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idMotivo"  : idMotivo,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-motivo-requerimiento',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '.datos-grupo-trabajo', function(e) {
    $('#btnEjecutarGrupoTrabajo').addClass("d-none");
    var idGrupoTrabajo = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtGrupoTrabajo_i').attr("disabled","disabled");
    $('#txtObservacionGrupoTrabajo_i').attr("disabled","disabled");
    
    $('#txtGrupoTrabajo_i').val("");
    $('#txtObservacionGrupoTrabajo_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionGrupoTrabajo').text("Registrar Grupo de Trabajo");
        $('#formInformacionGrupoTrabajo').attr('action', baseUrl + '/registrar-grupo-trabajo');
        $('#btnEjecutarGrupoTrabajo').removeClass("d-none");
        $('#btnEjecutarGrupoTrabajo').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtGrupoTrabajo_i').removeAttr("disabled");
        $('#txtObservacionGrupoTrabajo_i').removeAttr("disabled");
        
        $('#txtGrupoTrabajo_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-grupo-trabajo', 
        {         
            idGrupoTrabajo : idGrupoTrabajo
        }, 
        function(response) {
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionGrupoTrabajo').text("Información del grupo de trabajo");
                    $('#btnEjecutarGrupoTrabajo').addClass("d-none");
                    $('#formInformacionGrupoTrabajo').attr('action', '');

                    $('#txtGrupoTrabajo_i').attr("disabled","disabled");
                    $('#txtObservacionGrupoTrabajo_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionGrupoTrabajo').text("Actualizar Requerimiento");
                    $('#formInformacionGrupoTrabajo').attr('action', baseUrl + '/actualizar-grupo-trabajo/' + idGrupoTrabajo);
                    $('#btnEjecutarGrupoTrabajo').removeClass("d-none");

                    $('#txtGrupoTrabajo_i').removeAttr("disabled");
                    $('#txtObservacionGrupoTrabajo_i').removeAttr("disabled");
                }

                $('#txtIDRequerimiento_i').val(response.idgrupotrabajo);
                $('#txtGrupoTrabajo_i').val(response.grupotrabajo);
                $('#txtObservacionGrupoTrabajo_i').val(response.observacion);
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-grupo-trabajo', function() {
    var idGrupoTrabajo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el grupo de trabajo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idGrupoTrabajo"    : idGrupoTrabajo,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-grupo-trabajo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarUsuarioGrupoTrabajo', function(e) {
    var idUsuario = $("#txtUsuarioAsociarGrupoTrabajo").val();
    var idGrupoTrabajo = $(this).data("grupotrabajo");
    var textUsuario = $("#txtUsuarioAsociarGrupoTrabajo").select2('data')[0]['text'].split("|");

    var nombres = textUsuario[1];
    var matricula = textUsuario[0];
    
    if(idUsuario == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el usuario a asociar.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        Swal.fire({
            title: '¿Estas seguro que deseas asociar al usuario '+nombres+' con matrícula '+matricula+' al Grupo de Trabajo?',
            //text: "Recuerda que esta acción es permanente.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#282e38',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                
                var parametros = {
                    "idUsuario"         : idUsuario,
                    "idGrupoTrabajo"    : idGrupoTrabajo
        		};
                $.ajax({        
                    url: baseUrl + '/asociar-usuario-grupo-trabajo',
                    type: "POST",
                    data: parametros,
                    success: function(response) {
                        $('.respuesta_global').html(response);
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        //$.unblockUI({});
                        Swal.close();
                        alert('Ha ocurrido un error interno.');
                        console.log(jqXHR );
                        console.log(textStatus);
                        console.log(errorThrown);
                    }
                });
            }
        });
    }
});

/* ------------------------------- */

$(document).on('click', '.eliminar-usuario-grupo-trabajo', function() {
    var idUsuario = $(this).data("usuario");
    var idGrupoTrabajo = $(this).data("grupotrabajo");
    
    Swal.fire({
        title: '¿Estas seguro que deseas eliminar el usuario del grupo de trabajo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {
            
            var parametros = {
                "idUsuario"         : idUsuario,
                "idGrupoTrabajo"    : idGrupoTrabajo
    		};
            $.ajax({        
                url: baseUrl + '/eliminar-usuario-grupo-trabajo',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */
$(document).on('change', '#txtGruposTrabajoPeticion_i', function() {
    
    var grupoTrabajo = $(this).val();
    $("#txtTipoRequerimiento_i").empty();
    var modal=$(this).closest('.modal.fade').attr("id");
    selectTipoRequerimientos('txtTipoRequerimiento_i', grupoTrabajo, '', modal);
    
    $(".txtNroProspectoPeticion").addClass('d-none');
    $(".txtNroProspectoPeticion_i").val('');
    $(".txtNroContratoPeticion").addClass('d-none');
    $(".txtNroContratoPeticion_i").val('');
    $(".grupoCompras").addClass('d-none');
    $(".txtPresupuestoAsignado_i").val('');
    $(".txtMarcaModelo_i").val('');
    $(".txtCantidad_i").val('');    
    
    if(grupoTrabajo==1){
        $(".txtNroProspectoPeticion").removeClass('d-none');
        $(".txtNroProspectoPeticion_i").val('');
    }else if(grupoTrabajo==3){
        $(".txtNroContratoPeticion").removeClass('d-none');
        $(".txtNroContratoPeticion_i").val('');
        
    }else if(grupoTrabajo==4){
        $(".grupoCompras").removeClass('d-none');
        $(".txtPresupuestoAsignado_i").val('');
        $(".txtMarcaModelo_i").val('');
        $(".txtCantidad_i").val('');

        selectMoneda("cboMoneda", "", "");
    }
    
});

$(document).on('change', '#txtTipoRequerimiento_i', function() {
   
    var tipoRequerimiento = $(this).val();
    var grupoTrabajo = $("#txtGruposTrabajoPeticion_i option:selected").val();
    $("#txtRequerimiento_i").empty();
    $("#txtMotivoRequerimiento_i").empty();
    var modal=$(this).closest('.modal.fade').attr("id");
    selectRequerimientos('txtRequerimiento_i', tipoRequerimiento, '', modal,grupoTrabajo);
});

$(document).on('change', '#txtRequerimiento_i', function() {
    var idRequerimiento = $(this).val();
    var peticion = $("#txtPeticion_i").val().trim();
    
    $("#txtMotivoRequerimiento_i").empty();
    var modal=$(this).closest('.modal.fade').attr("id");
    selectMotivosRequerimiento('txtMotivoRequerimiento_i', idRequerimiento, '', modal);
    // selectGruposTrabajoRequerimiento('txtGruposTrabajoPeticion_i', idRequerimiento, '', modal);
    
    var textRequerimiento = $("#txtRequerimiento_i option:selected").text();
    $("#txtRequerimientoTextPeticion").val(textRequerimiento);
});
$(document).on('keypress', '#txtNroProspectoPeticion_i', function(event) {
    var regex = new RegExp("^[0-9]+$");
    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
      event.preventDefault();
      return false;
    }
    else if(this.value.length >=6 )
    {
        event.preventDefault();
        return false;
    }
});

$(document).on('keypress', '#txtNroContratoPeticion_i', function(event) {
    var regex = new RegExp("^[0-9]+$");
    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
      event.preventDefault();
      return false;
    }
    else if(this.value.length >=7)
    {
        event.preventDefault();
        return false;
    }
});

// $(document).on('change', '#txtDireccionPeticion_i', function() {
//     var idDireccion = $(this).val();
//     $("#txtAreaPeticion_i").empty();
//     $("#txtSubareaPeticion_i").empty();
//     $("#txtDelegacionPeticion_i").empty();
//     var formulario=$(this).closest('.modal.fade').attr("id");
    
//     selectAreaEstructura('txtAreaPeticion_i', idDireccion, '', formulario);
// });
// $(document).on('change', '#txtAreaPeticion_i', function() {
//     var idArea = $(this).val();
//     $("#txtSubareaPeticion_i").empty();
//     $("#txtDelegacionPeticion_i").empty();
//     var formulario=$(this).closest('.modal.fade').attr("id");
    
//     selectSubareaEstructura('txtSubareaPeticion_i', idArea, '', formulario);
// });
// $(document).on('change', '#txtSubareaPeticion_i', function() {
//     var idSubarea = $(this).val();
//     $("#txtDelegacionPeticion_i").empty();
//     var formulario=$(this).closest('.modal.fade').attr("id");
    
//     selectDelegacionesSubareaEstructura('txtDelegacionPeticion_i', idSubarea, '', formulario);
// });

// $(document).on('change', '#txtDelegacionPeticion_i', function() {
//     var idDelegacion = $(this).val();
//     $("#txtDireccionPeticion_i").empty();
//     $("#txtAreaPeticion_i").empty();
//     $("#txtSubareaPeticion_i").empty();
//     $("#ctnCorreosDelegacion").empty();
    
//     var formulario=$(this).closest('.modal.fade').attr("id");
    
//     $.post(baseUrl + '/listado-estructura-delegacion', 
//     {         
//         idDelegacion : idDelegacion
//     }, 
//     function(response) {
//         if (response.descripcion === 0) {
//             //alert("Ocurrió un error al obtener los datos.");
//         } else {
            
//             var contCorreos = '';
            
//             var direcciones = $.parseJSON(response.listadoDirecciones);
//             var areas = $.parseJSON(response.listadoAreas);
//             var subareas = $.parseJSON(response.listadoSubareas);
//             var correos = $.parseJSON(response.listadoCorreos);
            
//             $("#txtDireccionPeticion_i").append('\
//                 <option value="" selected>Seleccione una opción</td>\n\
//             ');
            
//             $("#txtAreaPeticion_i").append('\
//                 <option value="" selected>Seleccione una opción</td>\n\
//             ');
            
//             $("#txtSubareaPeticion_i").append('\
//                 <option value="" selected>Seleccione una opción</td>\n\
//             ');
            
//             if(direcciones.length > 0)
//             {   
//                 var selected = direcciones.length == 1 ? 'selected' : '';
                
//                 for(var i = 0; i < direcciones.length; i++){
//                     $("#txtDireccionPeticion_i").append('\
//                         <option value="' + direcciones[i].id + '" '+selected+'>' + direcciones[i].text +'</td>\n\
//                     ');
//                 }
//             }
            
//             if(areas.length > 0)
//             {   
//                 var selected = areas.length == 1 ? 'selected' : '';
                
//                 for(var i = 0; i < areas.length; i++){
//                     $("#txtAreaPeticion_i").append('\
//                         <option value="' + areas[i].id + '" '+selected+'>' + areas[i].text +'</td>\n\
//                     ');
//                 }
//             }
            
//             if(subareas.length > 0)
//             {
//                 var selected = subareas.length == 1 ? 'selected' : '';
                
//                 for(var i = 0; i < subareas.length; i++){
//                     $("#txtSubareaPeticion_i").append('\
//                         <option value="' + subareas[i].id + '" '+selected+' >' + subareas[i].text +'</td>\n\
//                     ');
//                 }
//             }
            
//             if(correos.length > 0)
//             {
//                 var checked = correos.length == 1 ? 'checked' : '';
                
//                 for(var i = 0; i < correos.length; i++){
//                     contCorreos += '<div class="col-xxl-12 col-md-12 col-12 my-2 px-3">\n\
//     					<div class="form-check form-switch" style="text-align: right;">\n\
//     						<input class="form-check-input" type="radio" role="switch" name="correoDestino" id="correoDestino'+correos[i].id+'" data-direccion="'+correos[i].iddireccion+'" data-area="'+correos[i].idarea+'" data-subarea="'+correos[i].idsubarea+'" '+checked+'>\n\
//     						<label class="form-check-label" for="correoDestino'+correos[i].id+'">'+correos[i].text+'</label>\n\
//     					</div>\n\
//     				</div>';
//                 }
//             }
//             else
//             {
//                 contCorreos += '<div class="alert alert-danger" role="alert">\n\
//                     No existes subáreas con correo asociados a esta delegación.\n\
//                 </div>';
//             }
            
//             $("#ctnCorreosDelegacion").append(contCorreos);
//         }
//     }, 'json'); 
// });
/* ------------------------------- */

$(document).on('click', '#btnNuevaPeticion', function(e) {
    
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=email]').val("");
    $(formulario + ' input[type=date]').val("");
    $(formulario + ' input[type=file]').val("");
    $(formulario + ' textarea').val("");
    $(formulario + ' select').val("");
    
//     $(formulario + ' #ctnAdjuntosPeticiones').html('<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="adj1" style="border-radius: 10px;">\n\
// 		<div class="col-xxl-5 col-md-12 col-12 mb-2">\n\
// 			<div>\n\
// 				<label for="txtNombreAdjunto_i1" class="form-label">Nombre Adjunto:</label>\n\
// 				<input type="text" class="form-control" id="txtNombreAdjunto_i1" name="nombreAdjunto[1]">\n\
// 			</div>\n\
// 		</div>\n\
// 		<div class="col-xxl-5 col-md-10 col-10 ">\n\
// 		    <div>\n\
// 				<label for="fileAdjuntoPeticion_i1" class="form-label">Seleccione Adjunto:</label>\n\
// 				<input class="form-control" type="file" id="fileAdjuntoPeticion_i1" name="fileAdjunto[1]">\n\
// 			</div>\n\
// 		</div>\n\
// 		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">\n\
// 			<button type="button" class="btn bg-danger px-2 py-1" onclick=\'return quitarAdjunto("adj1");\' data-tooltip="tooltip" aria-label="Eliminar Adjunto">\n\
//                 <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>\n\
//             </button>\n\
// 		</div>\n\
// 	</div>');
    // $(formulario + ' select').val(null).trigger('change');
    
    // selectGruposTrabajo('txtGruposTrabajoPeticion_i', '', formulario.substring(1))
});

/* ------------------------------- */
$(document).on('submit', '.formularioRegistrarPeticion', function() {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    var formData = new FormData(this);

    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        success: function(response) {
            if(response.prospecto)
            {
                Swal.fire({
                    title: 'Se registró la petición con éxito',
                    text: '¿Deseas registrar otra petición manteniendo el número de prospecto?',
                    icon: 'success',
                    showCancelButton: true,
                    cancelButtonText: 'No',
                    confirmButtonColor: '#282e38',
                    cancelButtonColor: '#f35d5d',
                    confirmButtonText: 'Si',
                }).then((result) => {
                    if (result.isConfirmed) {
                        $('#'+idForm+' input[type=text]').val("");
                        $('#'+idForm+' input[type=email]').val("");
                        $('#'+idForm+' input[type=date]').val("");
                        $('#'+idForm+' input[type=file]').val("");
                        $('#'+idForm+' textarea').val("");
                        // $(formulario + ' select').val("").change();
                        $('#'+idForm+' select').val(null).trigger('change');
                        
                        selectGruposTrabajo('txtGruposTrabajoPeticion_i', '', idForm)
                        $('#'+idForm+' #txtNroProspectoPeticion_i').val(formData.get('txtNroProspectoPeticion_i'));
                        Swal.close();
                        formulario.find('.respuesta').html(response.mensaje1);
                        console.log(response.mensaje1);
                    }
                    else
                    {
                        Swal.close();
                        formulario.find('.respuesta').html(response.mensaje2);
                        console.log(response.mensaje2);
                    }
                });
            }
            else
            {
                Swal.close();
                formulario.find('.respuesta').html(response.mensaje2);
                console.log(response.mensaje2);
            }
            //$.unblockUI({});
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            alert('Ha ocurrido un error interno.');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
    return false;
});
/* ------------------------------- */

function confirmarEstadoGestionPeticion(idPeticion, estado, idRequerimiento)
{
    var mensaje = "";
    var checkAnulacion = "";
    
    if(estado == 'INIC')
    {
        mensaje = '¿Todo listo para comenzar la gestión?[INICIADO]';
    }
    else if(estado == 'ESPE')
    {
        mensaje = '¿Deseas poner en pausa la gestión?[EN ESPERA]';
    }
    else if(estado == 'COMP')
    {
        mensaje = '¿Deseas terminar la gestión?[COMPLETADO]';
    }
    else if(estado == 'APRO')
    {
        mensaje = '¿Deseas aprobar la petición gestionada?[APROBADO]';
        checkAnulacion = '<div class="col-12 col-md-12 my-2">\n\
			<div class="col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">\n\
			    <h5 class="color-sistema m-0" for="chkAnulacion_pet">Anular: <span id="spnEstadoChkAnulacion">NO</span></h5>\n\
			    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkAnulacion_pet">\n\
					<input class="form-check-input form-check-input-green" type="checkbox" role="switch" name="chkAnulacion_pet" id="chkAnulacion_pet">\n\
					<label class="form-check-label m-0" for="chkAnulacion_pet"></label>\n\
				</div>\n\
			</div>\n\
		</div>';
    }
    else if(estado == 'REEV')
    {
        mensaje = '¿Deseas reevaluar la petición gestionada?[REEVALUADO]';
    }
    else if(estado == 'RECH')
    {
        mensaje = '¿Deseas rechazar la petición gestionada?[RECHAZADO]';
    }
    else if(estado == 'CANC')
    {
        mensaje = '¿Deseas cancelar la petición gestionada?[CANCELADO]';
    }
    
    
    Swal.fire({
        title: mensaje,
        icon: 'warning',
        html: checkAnulacion,
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // // Si el valor es válido, debes regresar undefined. Si no, una cadena
            // if (!obs) {
            //     return "Por favor escribe el motivo";
            // } else {
            //     return undefined;
            // }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var anulacion = "";
            
            if ($('#chkAnulacion_pet').length) 
            {
                // Si existe, obtenemos si está seleccionado
                var anulacion = $('#chkAnulacion_pet').prop('checked');
            }
            
            var parametros = {
                "txtEstadoPeticion_i"               : estado,
                "txtMotivoCambioEstadoPeticion_i"   : motivo,
                "txtAnulacion"                      : anulacion
    		};
            $.ajax({        
                url: baseUrl + '/cambio-estado-peticion/'+idPeticion,
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
}

/* ------------------------------- */

$(document).on('change', '#chkAnulacion_pet', function() {
    if(this.checked)
    {
        $('#spnEstadoChkAnulacion').html("SI");
    }
    else
    {
        $('#spnEstadoChkAnulacion').html("NO");
    }
});

/* ------------------------------- */

$(document).on('click', '#btnDerivarPeticion', function(e) {
    
    var formulario = $(this).data('bs-target');
    
    selectGruposTrabajo('txtGrupoTrabajoDerivadoPeticion_i', '', formulario.substring(1));
});

/* ------------------------------- */

$(document).on('click', '#navPeticionesHistorico', function(e) {
    if (DataTable.isDataTable('#tblHistoricoPeticiones')) {
        $('#tblHistoricoPeticiones').DataTable().destroy();
    }
    
    serversideHistoricoPeticiones();
});

function serversideHistoricoPeticiones()
{
    /***SERVERSIDE HISTÓRICO PETICIONES***/
	assetListVM = {
		dt: null,
		init: function () {
			dt = $('#tblHistoricoPeticiones').DataTable({
				"serverSide": true,
				"processing": true,
				"ajax": {
					"url": baseUrl + "/peticionesServersideHistorico",
					type: 'GET'
				},
				"columns": [
					{"title": "Nro Petición", "data": "IDPeticion", "class": "text-center", "searchable": true },
					{"title": "Fecha de Creación", "data": "FechaCrea", "class": "text-center", "searchable": true },
					{"title": "Fecha Último Cambio", "data": "FechaEstado", "class": "text-center", "searchable": true },
					{"title": "Delegación Solicitante", "data": "DelegacionSolicitante", "class": "text-center", "searchable": true },
					{"title": "Perfil Solicitante", "data": "PerfilSolicitante", "class": "text-center", "searchable": true },
					{"title": "Prospecto", "data": "NroProspecto", "class": "text-center", "searchable": true },
					{"title": "Requerimiento", "data": "Requerimiento", "class": "text-center", "searchable": true },
					{"title": "Motivo", "data": "Motivo", "class": "text-center", "searchable": true },
					{"title": "Usuario Último Cambio", "data": "NombreUsuarioEstado", "class": "text-center", "searchable": true },
					{"title": "Grupo Encargado", "data": "GrupoTrabajo", "class": "text-center", "searchable": true },
					{"title": "Estado",
						"data": "Estado",
						class: 'text-center',
							render: function(data, type, row){  // con row obtienes la información por fila
							return "<span class='badge "+(row.FondoEstado)+" border-0'>"+row.TextoEstado+"</span>";
						}
					},
					{"title":"Acciones",
						"data": "acciones_usuario",
						class: 'text-center',
							render: function(data, type, row){  // con row obtienes la información por fila
							return "<span class='badge bg-sistema border-0 p-2'>\n\
								<a href='"+baseUrl+"/detalle-peticion/"+row.IDPeticion+"' class='color-white'>\n\
									<i class='ri-eye-fill align-bottom' style='font-size: 18px;'></i>\n\
								</a>\n\
							</span>";
						}
					},
				],
				"lengthMenu": [[10, 25, 50], [10, 25, 50]],
				responsive: true,
				autoWidth: false,
				"aaSorting": [[0, 'desc']],
			});
		}
	}

	assetListVM.init();
	/****FIN SERVERSIDE HISTÓRICO PETICIONES****/
}

/* ------------------------------- */

$(document).on('click', '#btnInformaciónProspectoPeticion', function(e) {
    var prospecto = $(this).attr("data-prospecto");
    
    $.ajax({        
        url: baseUrl + '/informacion-prospecto-peticion/'+prospecto,
        dataType: 'json',
        beforeSend: function() {
            $("#ctnInformacionProspecto").empty();
            $("#ctnInformacionProspecto").html('<div class="alert alert-dark alert-border-left alert-dismissible fade show mb-0" role="alert">\n\
                <i class="ri-refresh-line me-3  align-middle fs-16"></i><strong>BUSCANDO</strong>\n\
                 - Buscando el prospecto solicitado...\n\
            </div>');
        },
        success: function(response) {
            if (response.descripcion === 0) {
                $("#ctnInformacionProspecto").empty();
                $("#ctnInformacionProspecto").html('<div class="alert alert-warning alert-border-left alert-dismissible fade show" role="alert">\n\
                    <i class="ri-alert-line me-3 align-middle fs-16"></i><strong>NO ENCONTRADO</strong>\n\
                    - No se encontró información asociada al prospecto.\n\
                </div>');
            } else {
                $("#ctnInformacionProspecto").empty();
                $("#ctnInformacionProspecto").html('<div class="row col-12 d-flex align-items-end justify-content-end m-0">\n\
					<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">\n\
						<div>\n\
							<label class="form-label color-sistema">Nro Prospecto</label>\n\
							<input type="text" class="form-control color-sistema border-color-sistema" id="txtNroProspecto" value="'+response.nroprospecto+'" disabled>\n\
						</div>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">\n\
					<div>\n\
						<label class="form-label">Cliente</label>\n\
						<input type="text" class="form-control" id="txtNombreCliente" value="'+response.cliente+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-12 col-md-12 col-12 mb-3">\n\
					<div>\n\
						<label class="form-label">Direccion</label>\n\
						<input type="text" class="form-control" id="txtDireccionCliente" value="'+response.direccion+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">\n\
					<div>\n\
						<label class="form-label">Interior</label>\n\
						<input type="text" class="form-control" id="txtInteriorCliente" value="'+response.intCliente+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-12 col-md-12 col-12 mb-3">\n\
					<div>\n\
						<label class="form-label">Referencia</label>\n\
						<textarea class="form-control" rows="4" id="txtReferenciaCliente" disabled>'+response.referencia+'</textarea>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-6 col-md-12 col-12 mb-3">\n\
					<div>\n\
						<label class="form-label">Provincia</label>\n\
						<input type="text" class="form-control" id="txtProvinciaCliente" value="'+response.provincia+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">\n\
					<div>\n\
						<label class="form-label">Distrito</label>\n\
						<input type="text" class="form-control" id="txtDistritoCliente" value="'+response.distrito+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-6 col-md-12 col-12 mb-3">\n\
					<div>\n\
						<label class="form-label">Teléfono 01</label>\n\
						<input type="text" class="form-control" id="txtTelefono01Cliente" value="'+response.t1+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">\n\
					<div>\n\
						<label class="form-label">Teléfono 02</label>\n\
						<input type="text" class="form-control" id="txtTelefono02Cliente" value="'+response.t2+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-12 col-md-12 col-12 mb-3">\n\
					<div>\n\
						<label class="form-label">Correo</label>\n\
						<input type="text" class="form-control" id="txtCorreoCliente" value="'+response.correo+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3">\n\
					<div>\n\
						<label class="form-label">Fecha Visita</label>\n\
						<input type="date" class="form-control" id="txtFechaVisitaCliente" value="'+response.fechavisita+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-4 col-md-12 col-12 mb-3">\n\
					<div>\n\
						<label class="form-label">Hora Visita</label>\n\
						<input type="time" class="form-control" id="txtHoraVisitaCliente" value="'+response.horavisita+'" disabled>\n\
					</div>\n\
				</div>\n\
				<div class="col-xxl-4 col-md-12 col-12 mb-3">\n\
					<div>\n\
						<label class="form-label">Fecha Visita Obras</label>\n\
						<input type="date" class="form-control" id="txtFechaVisitaObrasCliente" value="'+response.visitaobras+'" disabled>\n\
					</div>\n\
				</div>');
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            $("#ctnInformacionProspecto").empty();
            $("#ctnInformacionProspecto").html('<div class="alert alert-danger alert-border-left alert-dismissible fade show mb-xl-0" role="alert">\n\
                <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>ERROR</strong>\n\
                - Hubo un error en la búsqueda del prospecto. Inténtelo luego.\n\
            </div>');
            console.log(jqXHR );
            console.log(textStatus);
            console.log(errorThrown);
        }
    });
});

/* ------------------------------- */

$(document).on('click', '#btnExportarReportePeticiones', function() {
    let fechaInicio = $("#txtFechaInicio_rp").val();
    let fechaFin = $("#txtFechaFin_rp").val();
    
    if(fechaInicio == '')
    {
        Swal.fire({
            html: 'Debe seleccionar una fecha de inicio.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(fechaFin == '')
    {
        Swal.fire({
            html: 'Debe seleccionar una fecha de fin.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else 
    {
        window.open(baseUrl+"/exportar-reporte-peticiones-backoffice/"+fechaInicio+"/"+fechaFin,'_blank');
    }
    
});

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* PETICIÓN - CONDONACIÓN */

/* ------------------------------- */

$(document).on('click', '#btnFacturasCondonacionPeticion', function() 
{
    var modal           = $(this).data('bs-target');
    var idCondonacion   = $(this).data('condonacion');
    
    var parametros = {
        "idCondonacion"  : idCondonacion
	};
    
    $.ajax({        
        url: baseUrl + '/facturas-condonacion-peticion',
        type: 'POST',
        data: parametros,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            $('#ctnFacturasCondonacionPeticion').html(response);
            
            $(modal).modal("show");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    
});

/* ------------------------------- */

function descargarFacturasAprobadasCondonacionPeticion(idCondonacion)
{
    window.open(baseUrl+"/exportar-facturas-condonacion-peticion/"+idCondonacion,'_blank');
}

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

$(document).on('change', "input[name='txtImportarStatusCondonacionFacturaPeticion']", function(e) 
{
    var myFile = $(this).prop('files')[0];
    
    var formData = new FormData();
    formData.append("file", myFile);
    
    $.ajax({        
        url: baseUrl+"/importar-status-facturas-condonacion-peticion",
        type: "POST",
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
});

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* OTROS */

/* ------------------------------- */
function selectMoneda(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-monedas', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } else {
            var monedas = $.parseJSON(response.listadoMonedas);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < monedas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + monedas[i].id + '" data-simbolo="'+monedas[i].simbolo+'" '+(idSeleccionado == monedas[i].id ? 'selected' : '')+'>' + monedas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function validarNumerosDecimales(evt, input) {
    // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
    var key = window.Event ? evt.which : evt.keyCode;
    var chark = String.fromCharCode(key);
    var tempValue = input.value + chark;
    if (key >= 48 && key <= 57) {
        if (formatoDecimal(tempValue) === false) {
            return false;
        } else {
            return true;
        }
    } else {
        if (key == 8 || key == 13 || key == 0) {
            return true;
        } else if (key == 46) {
            if (formatoDecimal(tempValue) === false) {
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }
}
function validarNumerosEnteros(evt, input) {
    // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
    var key = window.Event ? evt.which : evt.keyCode;
    var chark = String.fromCharCode(key);
    var tempValue = input.value + chark;
    if (key >= 48 && key <= 57) {
        return true;
    } else {
        return false;
    }
}
function formatoDecimal(numero) {
    var preg = /^([0-9]+\.?[0-9]{0,4})$/;
    
    if (preg.test(numero) === true) {
        return true;
    } else {
        return false;
    }
}

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FORMATOS DE APROBACIÓN */

/* ------------------------------- */

$(document).on('click', '.datos-formato-aprobacion', function(e) 
{
    var idFormato   = $(this).data('id');
    var accion      = $(this).data('accion');
    var modal       = $(this).data('bs-target');
    var form        = $(this).data('form');
    
    $('#btnEjecutarFormatoAprobacion').addClass("d-none");
    
    $('#txtNombreFormato_rfa').attr("disabled","disabled");
    $('#txtPlantillaFormato_rfa').attr("disabled","disabled");
    $('#txtObservacion_rfa').attr("disabled","disabled");
    
    $('#txtNombreFormato_rfa').val("");
    $('#txtPlantillaFormato_rfa').val("");
    $('#txtObservacion_rfa').val("");
        
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        Swal.close();
        
        $('#exampleregistrarFormatoAprobacion').text("Registrar Formato de Aprobación");
        $(form).attr('action', baseUrl + '/registrar-formato-aprobacion');
        $('#btnEjecutarFormatoAprobacion').removeClass("d-none");
        $('#btnEjecutarFormatoAprobacion').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');

        $('#txtNombreFormato_rfa').removeAttr("disabled");
        $('#txtPlantillaFormato_rfa').removeAttr("disabled");
        $('#txtObservacion_rfa').removeAttr("disabled");
        
        $('#txtNombreFormato_rfa').focus();
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-formato-aprobacion', 
        {         
            idFormato : idFormato
        }, 
        function(response) 
        {
            Swal.close();
            
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleregistrarFormatoAprobacion').text("Información del Formato de Aprobación");
                    $('#btnEjecutarFormatoAprobacion').addClass("d-none");
                    $(form).attr('action', '');

                    $('#txtNombreFormato_rfa').attr("disabled","disabled");
                    $('#txtPlantillaFormato_rfa').attr("disabled","disabled");
                    $('#txtObservacion_rfa').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleregistrarFormatoAprobacion').text("Actualizar Formato de Aprobación");
                    $(form).attr('action', baseUrl + '/actualizar-formato-aprobacion/' + idFormato);
                    $('#btnEjecutarFormatoAprobacion').removeClass("d-none");

                    $('#txtNombreFormato_rfa').removeAttr("disabled");
                    $('#txtPlantillaFormato_rfa').removeAttr("disabled");
                    $('#txtObservacion_rfa').removeAttr("disabled");
                }

                $('#txtNombreFormato_rfa').val(response.formato);
                $('#txtPlantillaFormato_rfa').val(response.plantilla);
                $('#txtObservacion_rfa').val(response.observacion);
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */
$(document).on('click', '.cambiar-estado-formato-aprobacion', function() {
    var idRequerimiento = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el requerimiento?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idRequerimiento"   : idRequerimiento,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-requerimiento',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

function abrirPlantillaFormatoAprobacion(btn)
{
    var url = $(btn).data("url");
    console.log(url);
}

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* CONDONACIONES */

/* ------------------------------- */

$(document).on('click', '#btnRegistrarCondonacion', function() 
{
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    selectRequerimientos("txtRequerimiento_rcond", "CONDONACIÓN", "", modal.substring(1), null)
    $("#txtMotivoRequerimiento_rcond").empty();
    
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('input', '.evaluar-moneda-decimal', function(event) 
{
    // Obtenemos el valor actual del input
    var valor = $(this).val();
    
    // Eliminar cualquier letra o carácter no permitido
    valor = valor.replace(/[^0-9\.]/g, '');  // Solo números y punto decimal
    
    // Asegurarse de que haya al menos un número antes del punto decimal
    if (valor.indexOf('.') === 0) {
      valor = '0' + valor;  // Si el punto es lo primero, agregar 0 al principio
    }

    // Permitir solo un punto decimal
    var partes = valor.split('.');
    if (partes.length > 2) {
      valor = partes[0] + '.' + partes[1];  // Eliminar cualquier punto extra
    }

    // Asignamos el valor limpio al input
    $(this).val(valor);
});

/* ------------------------------- */

function agregarRegistroFacturaCondonacion(contenedorElementos)
{
    var random = generarRandom(5);
    
    let nroContrato     = $("#txtNroContrato_rcond").val();
    let facturaInterna  = $("#txtFacturaInterna_rcond").val();
    let facturaExterna  = $("#txtFacturaExterna_rcond").val();
    let segmento        = $("#txtSegmento_rcond").val();
    let lblsegmento     = $('select[id="txtSegmento_rcond"] option:selected').text();
    let importeCondonar = $("#txtImporte_rcond").val();
    let deudaTotal      = $("#txtDeudaTotal_rcond").val();
    let tipoFactura     = $("#txtTipoFactura_rcond").val();
    let lbltipoFactura  = $('select[id="txtTipoFactura_rcond"] option:selected').text();
    
    let contenedor = `<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="factura${random}" style="border-radius: 10px;">
        <input type="hidden" class="form-control" name="aleatorio[]" value="${random}">
		<div class="col-xxl-10 col-md-12 col-12 mb-2">
			<div>
				<label class="form-label">Nro Contrato:</label>
				<input type="text" class="form-control" name="nrocontrato[${random}]" value="${nroContrato}">
			</div>
		</div>
		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico('factura${random}');" data-tooltip="tooltip" aria-label="Eliminar Factura">
                <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
            </button>
		</div>
		<div class="col-xxl-4 col-md-12 col-12 mb-2">
			<div>
				<label class="form-label">Factura Interna:</label>
				<input type="text" class="form-control" name="facturainterna[${random}]" value="${facturaInterna}">
			</div>
		</div>
		<div class="col-xxl-4 col-md-12 col-12 mb-2">
			<div>
				<label class="form-label">Factura Externa:</label>
				<input type="text" class="form-control" name="facturaexterna[${random}]" value="${facturaExterna}">
			</div>
		</div>
		<div class="col-xxl-4 col-md-12 col-12 mb-2">
			<div>
				<label class="form-label">Tipo de Factura:</label>
				<input type="text" class="form-control" value="${lbltipoFactura}" disabled>
				<input type="hidden" class="form-control" name="tipofactura[${random}]" value="${tipoFactura}">
			</div>
		</div>
		<div class="col-xxl-4 col-md-12 col-12 mb-2">
			<div>
				<label class="form-label">Segmento:</label>
				<input type="text" class="form-control" value="${lblsegmento}" disabled>
				<input type="hidden" class="form-control" name="segmento[${random}]" value="${segmento}">
			</div>
		</div>
		<div class="col-xxl-4 col-md-12 col-12 mb-2">
			<div>
				<label class="form-label">Importe:</label>
				<div class="input-group">
                    <span class="input-group-text">S/.</span>
                    <input type="text" step="0.01" class="form-control" aria-label="Importe" placeholder="Importe" name="importe[${random}]" value="${importeCondonar}">
                </div>
			</div>
		</div>
		<div class="col-xxl-4 col-md-12 col-12 mb-2">
			<div>
				<label class="form-label">Deuda Total:</label>
				<div class="input-group">
                    <span class="input-group-text">S/.</span>
                    <input type="text" step="0.01" class="form-control" aria-label="Deuda Total" placeholder="Deuda Total" name="deudatotal[${random}]" value="${deudaTotal}">
                </div>
			</div>
		</div>
	</div>`;

    $("#"+contenedorElementos).append(contenedor);
    
    $("#txtNroContrato_rcond").val("");
    $("#txtFacturaInterna_rcond").val("");
    $("#txtFacturaExterna_rcond").val("");
    $("#txtSegmento_rcond").val(null).trigger('change');
    $("#txtImporte_rcond").val("");
    $("#txtDeudaTotal_rcond").val("");
    $("#txtTipoFactura_rcond").val(null).trigger('change');
    
}

/* ------------------------------- */

$(document).on('submit', '.formularioRegistrarCondonacion', function(event) 
{
    event.preventDefault();
    
    var formulario  = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm      = formulario.attr('id');
    
    var formData = new FormData(this);
    
    const idMotivoReq = $(this).find('[name="txtMotivoRequerimiento_rcond"]').val();
    
    if(idMotivoReq == "" || idMotivoReq == null)
    {
        Swal.fire({
            text: "Debe seleccionar el Requerimiento y el Motivo de la Condonación.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    else
    {
        const adjuntoMotivoRequerimiento = $(this).find('[name="txtMotivoRequerimiento_rcond"]').find('option:selected').data("adjunto");
        
        formData.append("txtAdjuntoRequeridoMotivo", adjuntoMotivoRequerimiento);
        
        if(adjuntoMotivoRequerimiento == "Y")
        {
            const pondAdjuntoCondonacion = pondAdjuntoMotivoRequerimiento.getFiles();
            
            if (pondAdjuntoCondonacion.length === 0) 
            {
                Swal.fire({
                    text: "Debe adjuntar el correo para la solicitud.",
                    icon: 'warning',
                    showCancelButton: false,
                    cancelButtonText: 'No',
                    confirmButtonColor: '#282e38',
                    confirmButtonText: 'OK'
                });
                return false;
            }
            
            for (var i = 0; i < pondAdjuntoCondonacion.length; i++) {
                formData.append('itemsAdjunto', pondAdjuntoCondonacion[i].file);
            }
        }
        
    }
    
    const activeTab = $('.navFacturasCondonaciones.nav-tabs .nav-link.active').attr('href'); // e.g. '#navFacturasIndividual'
    
    formData.append("tabFacturas", activeTab);
        
    if (activeTab === '#navFacturasIndividual') 
    {
        const aleatorios = $(activeTab).find('input[name="aleatorio[]"]');

        if (aleatorios.length === 0) 
        {
            Swal.fire({
                text: "Si ha seleccionado subir facturas de forma individual, debe ingresar como mínimo uno en el formulario y presionar el botón verde (+).",
                icon: 'warning',
                showCancelButton: false,
                cancelButtonText: 'No',
                confirmButtonColor: '#282e38',
                confirmButtonText: 'OK'
            });
            return false;
        }
    } 
    else if (activeTab === '#navFacturasMasivo')
    {
        const pondFileCSVCond = pondImportarCSVCondonaciones.getFiles();
        
        if (pondFileCSVCond.length === 0) 
        {
            Swal.fire({
                text: "Debe adjuntar la plantilla masiva de condonación.",
                icon: 'warning',
                showCancelButton: false,
                cancelButtonText: 'No',
                confirmButtonColor: '#282e38',
                confirmButtonText: 'OK'
            });
            return false;
        }
        
        for (var i = 0; i < pondFileCSVCond.length; i++) {
            formData.append('itemsFileCSV', pondFileCSVCond[i].file);
        }
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '.cancelar-factura-condonar', function() 
{
    let idCondonacion = $(this).data("condonacion");
    let idFacturaCondonacion = $(this).data("id");
    let facturaInterna = $(this).data("interna");
    let facturaExterna = $(this).data("externa");
    
    Swal.fire({
        title: "Cancelar Condonación de Factura.",
        text: "¿Desea CANCELAR la condonación de la factura (Interna Nro: "+facturaInterna+" | Externa Nro: "+facturaExterna+" ) seleccionada?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#008F39',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            
            var parametros = {
                "txtObservacionFacturaCondonacion"  : motivo,
                "txtEstadoFacturaCondonacion"       : "CANC",
                "txtIDFacturaCondonacion"           : idFacturaCondonacion,
                "txtTipoCambio"                     : "I"
    		};
    		
            $.ajax({        
                url: baseUrl + '/cambiar-estado-factura-condonacion',
                type: "POST",
                data: parametros,
                dataType: 'json',
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    
                    $('.respuesta_global').html(response.mensaje);
                    
                    if(response.result == 1)
                    {
                        recargarFacturasCondonacion(idCondonacion);
                    }
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
            
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });
    
    // return false;
});

/* ------------------------------- */

function recargarFacturasGestorCondonacion(btnFactura)
{
    let idCondonacion = $(btnFactura).data("condonacion");
    recargarFacturasCondonacion(idCondonacion);
}

/* ------------------------------- */

function recargarFacturasCondonacion(idCondonacion)
{
    var parametros = {
        "idCondonacion"  : idCondonacion
	};
	
    $.ajax({        
        url: baseUrl + '/recargar-facturas-condonacion',
        type: "POST",
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            
            $('#condonacion-facturas-gestor').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
    
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

/* ------------------------------- */

function recargarAprobacionesCondonacion(btnAprobacion)
{
    let idCondonacion = $(btnAprobacion).data("condonacion");
    recargarTablaAprobacionesCondonacion(idCondonacion);
    mostrarAcumuladosAprobaciones(idCondonacion);
}

/* ------------------------------- */

function recargarTablaAprobacionesCondonacion(idCondonacion)
{
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    $('#tblFacturasPendientesAprobarCondonacion').DataTable().destroy();
    
    $("#tblFacturasPendientesAprobarCondonacion").DataTable({
        "ajax": {
            "url": baseUrl + "/recargar-aprobaciones-condonacion",
            "type": "POST",
            "data": {
                "idCondonacion" : idCondonacion
            },
            "dataSrc": function (json) 
            {
                // $("#lblSubtitulo").html(json.subtitulo);
                Swal.close();
                
                if(json.sesion === 0)
                {
                    Swal.fire({
                        title: 'Por favor, vuelva a iniciar sesión.',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonColor: '#282E38',
                        confirmButtonText: 'Confirmar'
                    });
                }
                
                return json.data;
            },
            "error": function (xhr, error, thrown) 
            {
                Swal.close();
            
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: thrown.message,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        },
        columnDefs: [
            { className: "text-center align-middle", targets: "_all" },
            { responsivePriority: 1, targets: 0 },
            { responsivePriority: 1, targets: 1 },
            { responsivePriority: 2, targets: 2 },
            { responsivePriority: 2, targets: 3 },
            { responsivePriority: 2, targets: 4 },
            { responsivePriority: 1, targets: 5 },
            { responsivePriority: 1, targets: 6 },
            { responsivePriority: 1, targets: 7 },
            { responsivePriority: 1, targets: 8 }
        ],
        columns: [
           { data: 'nro_contrato' },
           { data: 'factura_interna' },
           { data: 'factura_externa' },
           { data: 'segmento' },
           { data: 'tipo_factura' },
           { data: 'deuda_total' },
           { data: 'importe_condonar' },
           { data: 'decision' },
           { data: 'observacion' }
        ]
    });
    
}

/* ------------------------------- */

$(document).on('click', '#chkAprobarFacturaCondonacionTotal', function() 
{
    if($(this).is(":checked")) 
    {
        $("#chkRechazarFacturaCondonacionTotal").prop("checked", false);
        $(".rdbtnEstadoAprobacionFactura.rb-aprobar").prop("checked", true);
        $(".txtObservacionRechazoFacturaCondonar").prop("disabled", true);
        $(".txtObservacionRechazoFacturaCondonar").val("");
    }
    else
    {
        $(".rdbtnEstadoAprobacionFactura.rb-aprobar").prop("checked", false);
    }
});

/* ------------------------------- */

$(document).on('click', '#chkRechazarFacturaCondonacionTotal', function() 
{
    if($(this).is(":checked")) 
    {
        $("#chkAprobarFacturaCondonacionTotal").prop("checked", false);
        $(".rdbtnEstadoAprobacionFactura.rb-rechazar").prop("checked", true);
        $(".txtObservacionRechazoFacturaCondonar").prop("disabled", false);
        $(".txtObservacionRechazoFacturaCondonar").val("");
    }
    else
    {
        $(".rdbtnEstadoAprobacionFactura.rb-rechazar").prop("checked", false);
        $(".txtObservacionRechazoFacturaCondonar").prop("disabled", true);
        $(".txtObservacionRechazoFacturaCondonar").val("");
    }
});

/* ------------------------------- */

$(document).on('click', '.rdbtnEstadoAprobacionFactura', function() 
{
    let seleccion = $(this).val();
    let idAprobacion = $(this).data("aprobacion");
    
    if(seleccion == "APRO") 
    {
        $("#chkRechazarFacturaCondonacionTotal").prop("checked", false);
        $("#txtObservacionRechazoFacturaCondonar"+idAprobacion).prop("disabled", true);
        $("#txtObservacionRechazoFacturaCondonar"+idAprobacion).val("");
    }
    else
    {
        $("#chkAprobarFacturaCondonacionTotal").prop("checked", false);
        $("#txtObservacionRechazoFacturaCondonar"+idAprobacion).prop("disabled", false);
        $("#txtObservacionRechazoFacturaCondonar"+idAprobacion).val("");
    }
});

/* ------------------------------- */

$(document).on('click', '#btnGuardarStatusMasivoFactura', function() 
{
    let idCondonacion = $(this).data("condonacion");
    
    let radiosSeleccionados = $("input.rdbtnEstadoAprobacionFactura:checked");
    let esValido = true;
    
    let formulario = document.getElementById("formFacturasPendientesAprobar");
    
    let formData = new FormData(formulario);
    
    // Recorremos todos los radios seleccionados con valor RECH
    $("input[type='radio'][value='RECH']:checked").each(function() 
    {
        let idAprobacion = $(this).data("aprobacion");
        let observacionInput = $(`#txtObservacionRechazoFacturaCondonar${idAprobacion}`);
        let observacionValor = observacionInput.val().trim();

        // Validar que esté habilitado y tenga texto
        if (observacionInput.is(":disabled") || observacionValor === "") 
        {
            esValido = false;
            // Resalta el campo
            observacionInput.css("border", "2px solid red");
        } 
        else 
        {
            observacionInput.css("border", ""); // Limpia estilo si está bien
        }
    });
    
    if (radiosSeleccionados.length === 0) 
    {
        Swal.fire({
            title: 'No hay factura seleccionada',
            text: 'No ha aprobado ni rechazado ninguna factura para guardar los cambios.',
            icon: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#E4002B',
            confirmButtonText: 'Entendido'
        });
        return;
    }

    if (!esValido) 
    {
        Swal.fire({
            title: 'Rechazo Personalizado',
            text: 'Debe ingresar una observación personalizada a las facturas rechazadas.',
            icon: 'error',
            showCancelButton: false,
            confirmButtonColor: '#E4002B',
            confirmButtonText: 'Entendido'
        });
        return;
    }
    
    
    Swal.fire({
        title: "Guardar Estatus Masivo",
        html: "¿Desea guardar los cambios masivos realizados en las facturas pendientes por aprobar?<br>La observación solo va a ser ingresada en las facturas aprobadas. Las facturas rechazadas deben tener observaciones personalizadas.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#008F39',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            
    		formData.append('txtObservacionFacturaCondonacion', motivo);
    		formData.append('txtIDCondonacion', idCondonacion);
    		formData.append('txtTipoAprobacion', "M");
    		
            $.ajax({        
                url: baseUrl + '/cambiar-estado-aprobacion-factura-condonacion',
                type: "POST",
                data: formData,
                processData: false, // Importante para enviar FormData
                contentType: false, // Importante para enviar FormData
                dataType: 'json',
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    
                    $('.respuesta_global').html(response.mensaje);
                    
                    if(response.result == 1)
                    {
                        recargarTablaAprobacionesCondonacion(idCondonacion);
                    }
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
            
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });
    
});

/* ------------------------------- */

// $(document).on('click', '#btnAprobacionMasivaCondonacion', function() 
// {
//     var modal           = $(this).data('bs-target');
//     var idCondonacion   = $(this).data('condonacion');
    
//     var parametros = {
//         "idCondonacion"  : idCondonacion
// 	};
    
//     $.ajax({        
//         url: baseUrl + '/facturas-pendientes-condonacion-usuario',
//         type: 'POST',
//         data: parametros,
//         beforeSend: function() {
//             Swal.fire({
//                 html: 'Un momento por favor...',
//                 heightAuto: true,
//                 showConfirmButton: false
//             });
//         },
//         success: function(response) {
//             Swal.close();
            
//             $('#ctnAprobacionMasiva').html(response);
            
//             $(modal).modal("show");
//         }, 
//         error: function(jqXHR, textStatus, errorThrown){
//             Swal.close();
            
//             Swal.fire({
//                 title: 'Ha ocurrido un error interno',
//                 text: errorThrown,
//                 icon: 'error',
//                 showCancelButton: false,
//                 confirmButtonColor: '#E4002B',
//                 confirmButtonText: 'Confirmar'
//             });
//         }
//     });
    
    
// });

/* ------------------------------- */

$(document).on('click', '.datos-factura-condonacion', function() 
{
    var idFactura   = $(this).data('id');
    var accion      = $(this).data('accion');
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    $('#btnEjecutarFacturaCondonacion').addClass("d-none");
    
    $('#txtImporte_ifcond').attr("disabled","disabled");
    
    $('#txtImporte_ifcond').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        Swal.close();
        
        $('#examplemdlFacturaCondonacion').text("Registrar Factura a Condonar");
        $(formulario).attr('action', baseUrl + '/registrar-factura-condonacion');
        $('#btnEjecutarFacturaCondonacion').removeClass("d-none");
        $('#btnEjecutarFacturaCondonacion').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');

        $('#txtImporte_ifcond').removeAttr("disabled");
        
        $('#txtImporte_ifcond').focus();
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-factura-condonacion', 
        {         
            idFactura : idFactura
        }, 
        function(response) 
        {
            Swal.close();
        
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#examplemdlFacturaCondonacion').text("Información de Factura a Condonar");
                    $('#btnEjecutarFacturaCondonacion').addClass("d-none");
                    $(formulario).attr('action', '');

                    $('#txtImporte_ifcond').attr("disabled","disabled");
                }
                else
                {
                    $('#examplemdlFacturaCondonacion').text("Actualizar información de Factura a Condonar");
                    $('#btnEjecutarFacturaCondonacion').removeClass("d-none");
                    $(formulario).attr('action', baseUrl + '/actualizar-factura-condonacion/' + idFactura);

                    $('#txtImporte_ifcond').removeAttr("disabled");
                }

                $('#txtNroContrato_ifcond').val(response.nrocontrato);
                $('#txtFacturaInterna_ifcond').val(response.facturainterna);
                
                $('#txtFacturaExterna_ifcond').val(response.facturaexterna);
                $('#txtTipoFactura_ifcond').val(response.tipofactura);
                
                $('#txtSegmento_ifcond').val(response.segmento);
                $('#txtDeudaTotal_ifcond').val(response.deudatotal);
                
                $('#txtImporte_ifcond').val(response.importecondonar);
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('submit', '.formularioFacturaCondonacion', function() 
{
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idCondonacion = $(this).data('condonacion');
    var modal = $(this).data("modal");
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
                    
            $('.respuesta_global').html(response.mensaje);
            
            if(response.result == 1)
            {
                recargarFacturasCondonacion(idCondonacion);
                
                if ($(modal).hasClass('show')) 
                {
                    // Cierra el modal
                    $(modal).modal('hide');
                }
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

function recargarBitacoraCondonacion(btnBitacora)
{
    let idCondonacion   = $(btnBitacora).data("condonacion");
    let contenedor      = $(btnBitacora).attr("href");
    
    var parametros = {
        "idCondonacion"  : idCondonacion
	};
	
    $.ajax({        
        url: baseUrl + '/recargar-bitacora-condonacion',
        type: "POST",
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            
            $(contenedor).html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
    
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

/* ------------------------------- */

$(document).on('click', '.comentarios-aprobador-factura-condonacion', function() 
{
    var modal           = $(this).data('bs-target');
    var idAprobacion    = $(this).data('aprobacion');
    var idFactura       = $(this).data('factura');
    
    $('#txtIDFacturaCondonacion_rcomaprcond').val(idFactura);
    
    $('#txtIDAprobacionCondonacion_rcomaprcond').val(idAprobacion);
    
    mostrarComentariosAprobadorFacturaCondonacion(idAprobacion, 'ctnComentariosAprobacionFactura')
    
    $(modal).modal("show");
});

/* ------------------------------- */

function mostrarComentariosAprobadorFacturaCondonacion(idAprobacion, contenedor)
{
    var parametros = {
        "idAprobacion"  : idAprobacion
	};
    
    $.ajax({        
        url: baseUrl + '/comentarios-aprobador-factura-condonacion',
        type: 'POST',
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            $('#'+contenedor).html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
}

/* ------------------------------- */

$(document).on('submit', '.formularioRegistrarComentarioAprobacionCondonacion', function() 
{
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var modal = $(this).data("modal");
    var contenedor = $(this).data("contenedor");
    
    var idAprobador = formulario.find("#txtIDAprobacionCondonacion_rcomaprcond").val();
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
                    
            $('.respuesta_global').html(response.mensaje);
            
            if(response.result == 1)
            {
                mostrarComentariosAprobadorFacturaCondonacion(idAprobador, contenedor);
                // $("#txtComentariosFactura_rcomaprcond").val("");
                formulario.find('textarea').val('');
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '.comentarios-factura-condonacion', function() 
{
    var modal       = $(this).data('bs-target');
    var idFactura   = $(this).data('factura');
    
    $('#txtIDFacturaCondonacion_rcomfaccond').val(idFactura);
    
    mostrarComentariosFacturaCondonacion(idFactura);
    
    $(modal).modal("show");
});

/* ------------------------------- */

function mostrarComentariosFacturaCondonacion(idFactura)
{
    var parametros = {
        "idFactura"  : idFactura
	};
    
    $.ajax({        
        url: baseUrl + '/comentarios-factura-condonacion',
        type: 'POST',
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            $('#ctnComentariosFactura').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
}

/* ------------------------------- */

$(document).on('submit', '.formularioRegistrarComentarioFacturaCondonacion', function() 
{
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var modal = $(this).data("modal");
    
    var idFactura = formulario.find("#txtIDFacturaCondonacion_rcomfaccond").val();
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: new FormData(this),
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
                    
            $('.respuesta_global').html(response.mensaje);
            
            if(response.result == 1)
            {
                mostrarComentariosFacturaCondonacion(idFactura);
                $("#txtComentariosFactura_rcomfaccond").val("");
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '.solicitar-reaprobacion', function() 
{
    let idAprobacion    = $(this).data("aprobacion");
    let idCondonacion   = $(this).data("condonacion");
    
    let formData = new FormData();
    
    Swal.fire({
        title: "Solicitar Reaprobación",
        html: "¿Estas seguro de solicitar la re-aprobación?<br>Valida que las modificaciones necesarias se hayan realizado para que la solicitud sea aprobada.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#008F39',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe alguna observación";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            
    		formData.append('txtObservacionFacturaCondonacion', motivo);
    		formData.append('txtIDCondonacion', idCondonacion);
    		formData.append('txtIDAprobacionCondonacion', idAprobacion);
    		formData.append('txtTipoAprobacion', "I");
    		formData.append('txtEstadoAprobacion', "PEND");
    		
            $.ajax({        
                url: baseUrl + '/cambiar-estado-aprobacion-factura-condonacion',
                type: "POST",
                data: formData,
                processData: false, // Importante para enviar FormData
                contentType: false, // Importante para enviar FormData
                dataType: 'json',
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    
                    $('.respuesta_global').html(response.mensaje);
                    
                    if(response.result == 1)
                    {
                        recargarFacturasCondonacion(idCondonacion);
                    }
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
            
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });
    
});

/* ------------------------------- */

function mostrarBotonSolicitarPeticionCondonacion(idCondonacion)
{
    var parametros = {
        "idCondonacion"  : idCondonacion
	};
    
    $.ajax({        
        url: baseUrl + '/validar-boton-peticion-condonacion',
        type: 'POST',
        data: parametros,
        success: function(response) 
        {
            if(response === "true")
            {
                $('#btnSolicitarPeticionCondonacion').removeClass('d-none');
            }
            else
            {
                if (!$('#btnSolicitarPeticionCondonacion').hasClass('d-none')) {
                    $('#btnSolicitarPeticionCondonacion').addClass('d-none');
                }
            }
            
            console.log(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
}

/* ------------------------------- */

/* ------------------------------- */
/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* OFERTAS */

/* ------------------------------- */

$(document).on('click', '#btnRegistrarOferta', function() 
{
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    selectRequerimientos("txtRequerimiento_rcond", "OFERTA", "", modal.substring(1), null)
    $("#txtMotivoRequerimiento_rcond").empty();
    
    $(modal).modal("show");
});

/* ------------------------------- */

/* Grupo Cartera Cliente */

/* ------------------------------- */

$(document).on('click', '.datos-grupo-cartera-cliente', function(e) {
    $('#btnEjecutarGrupoCarteraCliente').addClass("d-none");
    var idGrupoCarteraCliente = $(this).data('id');
    var accion = $(this).data('accion');
    
    $('#txtGrupoCarteraCliente_i').attr("disabled","disabled");
    $('#txtObservacionGrupoCarteraCliente_i').attr("disabled","disabled");
    
    $('#txtGrupoCarteraCliente_i').val("");
    $('#txtObservacionGrupoCarteraCliente_i').val("");
        
    if(accion == 'crear')
    {
        $('#exampleinformacionGrupoCarteraCliente').text("Registrar Grupo Cartera Cliente");
        $('#formInformacionGrupoCarteraCliente').attr('action', baseUrl + '/registrar-grupo-cartera-cliente');
        $('#btnEjecutarGrupoCarteraCliente').removeClass("d-none");
        $('#btnEjecutarGrupoCarteraCliente').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtGrupoCarteraCliente_i').removeAttr("disabled");
        $('#txtObservacionGrupoCarteraCliente_i').removeAttr("disabled");
        
        $('#txtGrupoCarteraCliente_i').focus();
        
    }else if (accion == 'asociar') {
        
        $("#txtIDGrupoCarteraClienteItem_i").val(idGrupoCarteraCliente);

        var multiselectElement = document.getElementById('multiselect-basic');
            
            if (multiselectElement) {
                $('#multiselect-basic').empty();

                if (multiselectElement.multi) {
                    multiselectElement.multi.destroy();
                }
            }

            $.post(baseUrl + '/listado-item-oferta-asociados', 
            {
                idGrupoCarteraCliente: idGrupoCarteraCliente
            }, 
            function(response) {
                
                var horariosSeleccionados = [];
                
                // Si hay horarios asociados, agregarlos al array de seleccionados | si hay Item asociados agregarlos
                if (response.itemGrupoCarteraCliente.length > 0) {
                    response.itemGrupoCarteraCliente.forEach(function(item) {
                        horariosSeleccionados.push(item.IDOfertaNomenclatura);
                    });
                }
                
                $('#multiselect-basic').empty();
                
                
                // Recorrer todos los horarios disponibles | recorrer todos los Item Oferta
                response.listadoItemOferta.forEach(function(item) {
                    // Si el horario está en los seleccionados, marcarlo como seleccionado
                    var selected = horariosSeleccionados.includes(item.IDOfertaNomenclatura) ? 'selected' : '';
                    
                    // Agregar cada opción al select
                    $('#multiselect-basic').append(
                        '<option value="' + item.IDOfertaNomenclatura + '" ' + selected + '>' +
                        item.Revntype + ' | ' + item.DescripcionSBN + '</option>'
                    );
                });

                // Inicializar multi.js después de agregar las opciones
                multi(multiselectElement, {
                    search_placeholder: 'Buscar Item...',
                    non_selected_header: 'Items Disponibles',
                    selected_header: 'Items Seleccionados'
                });

                // Refrescar multi.js para reflejar las selecciones
                multiselectElement.dispatchEvent(new Event('change'));
                
            }, 'json');
        
        // Mostrar el modal
        $('#asociarItemOferta').modal('show');
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-grupo-cartera-cliente', 
        {         
            idGrupoCarteraCliente : idGrupoCarteraCliente
        }, 
        function(response) {
            if (response.descripcion === 0) {
                
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionGrupoCarteraCliente').text("Información del grupo cartera cliente");
                    $('#btnEjecutarGrupoCarteraCliente').addClass("d-none");
                    $('#formInformacionGrupoCarteraCliente').attr('action', '');

                    $('#txtGrupoCarteraCliente_i').attr("disabled","disabled");
                    $('#txtObservacionGrupoCarteraCliente_i').attr("disabled","disabled");
                }
                else
                {
                    console.log( baseUrl + '/actualizar-grupo-cartera-cliente/' + idGrupoCarteraCliente);
                    $('#exampleinformacionGrupoCarteraCliente').text("Actualizar Requerimiento");
                    $('#formInformacionGrupoCarteraCliente').attr('action', baseUrl + '/actualizar-grupo-cartera-cliente/' + idGrupoCarteraCliente);
                    $('#btnEjecutarGrupoCarteraCliente').removeClass("d-none");

                    $('#txtGrupoCarteraCliente_i').removeAttr("disabled");
                    $('#txtObservacionGrupoCarteraCliente_i').removeAttr("disabled");
                }

                $('#txtIDRequerimiento_i').val(response.idgrupotrabajo);
                $('#txtGrupoCarteraCliente_i').val(response.grupotrabajo);
                $('#txtObservacionGrupoCarteraCliente_i').val(response.observacion);
            }
        }, 'json'); 
    }
});


/* ------------------------------------------------------------------------ */
$(document).on('click', '.cambiar-estado-grupo-cartera-cliente', function() {
    var idGrupoCarteraCliente = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el grupo cartera cliente?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idGrupoCarteraCliente"    : idGrupoCarteraCliente,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-grupo-cartera-cliente',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------------------------------------------------ */

    $("#txtUsuarioAsociarGrupoCarteraCliente").select2({
        minimumInputLength: 2,
        placeholder: 'Seleccione Usuario',
        allowClear: true,
        language: {
            errorLoading: function() {
                return "La carga falló";
            },
            noResults: function() {
                return "No hay resultado";
            },
            searching: function() {
                return "Buscando..";
            }
        },
        ajax: {
            url: baseUrl + '/listado-usuarios-select',
            dataType: 'json',
            type: "POST",
            quietMillis: 50,
            data: function (term) {
                return {
                    term: term
                };
            },
            processResults: function (data) {
                return {
                    results: data
                };
            }
        }
    });

/* ------------------------------- */

$(document).on('click', '#btnAgregarUsuarioGrupoCarteraCliente', function(e) {
    var idUsuario = $("#txtUsuarioAsociarGrupoCarteraCliente").val();
    var idGrupoCarteraCliente = $(this).data("grupocarteracliente");
    var textUsuario = $("#txtUsuarioAsociarGrupoCarteraCliente").select2('data')[0]['text'].split("|");

    var nombres = textUsuario[1];
    var matricula = textUsuario[0];
    
    if(idUsuario == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el usuario a asociar.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        Swal.fire({
            title: '¿Estas seguro que deseas asociar al usuario '+nombres+' con matrícula '+matricula+' al Grupo Cartera Cliente?',
            //text: "Recuerda que esta acción es permanente.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#282e38',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                
                var parametros = {
                    "idUsuario"         : idUsuario,
                    "idGrupoCarteraCliente"    : idGrupoCarteraCliente
        		};
                $.ajax({        
                    url: baseUrl + '/asociar-usuario-grupo-cartera-cliente',
                    type: "POST",
                    data: parametros,
                    success: function(response) {
                        $('.respuesta_global').html(response);
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        //$.unblockUI({});
                        Swal.close();
                        alert('Ha ocurrido un error interno.');
                        console.log(jqXHR );
                        console.log(textStatus);
                        console.log(errorThrown);
                    }
                });
            }
        });
    }
});

/* ------------------------------- */

$(document).on('click', '.eliminar-usuario-grupo-cartera-cliente', function() {
    var idUsuario = $(this).data("usuario");
    var idGrupoCarteraCliente = $(this).data("grupocarteracliente");
    
    Swal.fire({
        title: '¿Estas seguro que deseas eliminar el usuario del grupo cartera cliente?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {
            
            var parametros = {
                "idUsuario"         : idUsuario,
                "idGrupoCarteraCliente"    : idGrupoCarteraCliente
    		};
            $.ajax({        
                url: baseUrl + '/eliminar-usuario-grupo-cartera-cliente',
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    //$.unblockUI({});
                    Swal.close();
                    alert('Ha ocurrido un error interno.');
                    console.log(jqXHR );
                    console.log(textStatus);
                    console.log(errorThrown);
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

    $('#btnGuardarItemOferta').on('click', function(e) { 
        e.preventDefault(); // Prevenir el comportamiento predeterminado del formulario
        
        // Obtener los valores seleccionados del multi-select
        var itemsSeleccionados = $('#multiselect-basic').val();
        var idGrupoCarteraCliente = $('#txtIDGrupoCarteraClienteItem_i').val(); // Obtener el ID del grupo de trabajo

        // Verificar que haya al menos un horario seleccionado
        if (itemsSeleccionados.length === 0) {
            alert('Por favor selecciona al menos un horario.');
            return;
        }
        
        // Preparar los datos para enviar
        var dataToSend = {
            idGrupoCarteraCliente: idGrupoCarteraCliente,
            itemsSeleccionados: itemsSeleccionados // Enviar como un array
        };


        // Enviar los datos al servidor mediante AJAX
        $.ajax({
            url: baseUrl + '/guardar-items-asociados', // URL de tu controlador
            type: 'POST',
            data: {
                idGrupoCarteraCliente: idGrupoCarteraCliente,
                itemsSeleccionados: itemsSeleccionados // Enviar como un array
            },
            success: function(response) { console.log(response);
                $('.respuesta_global').html(response);
                // if (response.status === 'success') {
                //     alert('Horarios guardados exitosamente.');
                //     $('#asociarHorarios').modal('hide'); // Cerrar el modal
                // } else {
                //     alert('Ocurrió un error al guardar los horarios.');
                // }
            },
            error: function() {
                alert('Error en la solicitud. Por favor intenta de nuevo.');
            }
        });
    });


/* ------------------------------- */

    // $(document).ready(function () {
    //     function obtenerDatosSolicitud() {
    //         // Captura de datos
    //         const area = $.trim($("input:disabled").filter(function () {
    //             return $(this).closest("div").find("label").text().includes("Área");
    //         }).val());
    
    //         const matricula = $.trim($("input:disabled").filter(function () {
    //             return $(this).closest("div").find("label").text().includes("Matrícula");
    //         }).val());
    
    //         const requerimiento = $("#txtRequerimiento_rcond").val();
    //         const motivo = $("#txtMotivoRequerimiento_rcond").val();
    
    //         return {
    //             area: area,
    //             matricula: matricula,
    //             requerimiento: requerimiento,
    //             motivo: motivo
    //         };
    //     }
    

    //     function enviarDatosOfertaAlServidor(datos) {
    //         $.ajax({
    //              url: baseUrl + '/analizar-datos-matriz-oferta',
    //             type: 'POST',
    //             data: datos,
    //             dataType: 'json',
    //             success: function (respuesta) {
    //                 console.log("Respuesta del servidor:", respuesta);
    //                 // Aquí puedes llenar inputs, tablas u ofertas con los datos que te devuelva
    //             },
    //             error: function (xhr, status, error) {
    //                 console.error("Error en la petición:", error);
    //             }
    //         });
    //     }
    
    //     // Evento al hacer clic en el botón "Ingresar Oferta"
    //     $("#btnNextTab").on("click", function () {
    //         const datos = obtenerDatosSolicitud(); console.log(datos);
    //         enviarDatosOfertaAlServidor(datos);
    //     });
    
    //     // También capturamos cuando el usuario hace clic directamente en la pestaña
    //     $("#tabDetalleOfertas").on("click", function () {
    //         const datos = obtenerDatosSolicitud(); console.log(datos);
    //         enviarDatosOfertaAlServidor(datos);
    //     });
    // });

/* ------------------------------- */

/* ------------------------------- */
    
    $(document).on('change', '#txtTipoCartera_rcond', function () { console.log('hola');
        // Resetear campos relacionados
        $('#txtTiempoOferta_rcond').val('').trigger('change');
        $('#txtItemOferta_rcond').val('').trigger('change');
        $('#txtNroContrato_rcond').val('').trigger('input');
        $('#txtTipoDescuento_rcond').val('').trigger('change');
        $('#selectCantidadMeses').empty().append('<option value="">Seleccione una opción</option>');
        $('.valorDescuentoCaja').addClass('d-none');
        $('.cuotaMonitoreoCaja').addClass('d-none');
        $('.permanenciaClienteCaja').addClass('d-none');
        
        $("#txtTipoOferta_rcond").val('').trigger('change');
        $("#txtCodigoInfoPoint_rcond").val('');
        
        const picker = document.querySelector("#fechaInicio")._flatpickr;
        if (picker) {
            picker.clear(); // Limpia la fecha y deja el input vacío
        }

    
        // Ocultar el slider
        $('.descuentoValor').addClass('d-none');
    
        // (Opcional) destruir el slider si existe
        if (document.getElementById('nonlinear').noUiSlider) {
            document.getElementById('nonlinear').noUiSlider.destroy();
        }
    
        // (Opcional) Limpiar valores visibles
        $('#lower-value, #middle-value, #upper-value').text('');
        $('#tituloDescuento').text('Valor Con Descuento (%)');

        
        // $('#'+elemento).empty();
        // $.post(baseUrl + '/listado-tipo-cartera', 
        // {
            // grupoTipoCartera: grupoTipoCartera,
            // tiempoOferta: tiempoOferta
        // }, 
        // function(response) { console.log(response);
            // if (response.descripcion === 0) {
            //     //alert("Ocurrió un error al obtener los datos.");
            // } else {
            //     var items = $.parseJSON(response.listadoItemOferta);
            //     $("#"+elemento).append('\
            //         <option value="">Seleccione una opción</td>\n\
            //     ');
            //     for(var i = 0; i < items.length; i++){
            //         $("#"+elemento).append('\
            //             <option value="' + items[i].id + '" '+'>' + items[i].text +'</td>\n\
            //         ');
            //     }
            // }
        
        // }, 'json');
    
    });

/* ------------------------------- */

    $(document).on('change', '#tiempoOfertaEditar', function() { 
        
        var grupoTipoCartera = $("#grupoCartera").val(); console.log(grupoTipoCartera);
        var tiempoOferta = $(this).val(); console.log(tiempoOferta);
        
        selectItemOferta("itemOfertaEditar", grupoTipoCartera, tiempoOferta,'');
        
        const picker = document.querySelector("#fechaImpactoEditar")._flatpickr;
        if (picker) {
            picker.setDate('', true); // true = trigger change
        }
        
        $('#tipoOfertaEditar').val('');
        
        $('#cantidadMesesEditar').empty().append('<option value="">Seleccione una opción</option>');
    
        // Ocultar el slider 
        // $('.descuentoValor').addClass('d-none');
    
        // (Opcional) destruir el slider si existe
        if (document.getElementById('nonlinearEditar').noUiSlider) {
            document.getElementById('nonlinearEditar').noUiSlider.destroy();
        }
    
        // (Opcional) Limpiar valores visibles
        $('#lower-value-editar, #middle-value-editar, #upper-value-editar').text('');
        // validarContrato();
    });
    
/* ------------------------------- */

    $(document).on('change', '#txtTiempoOferta_rcond', function() {
        
        var grupoTipoCartera = $("#txtTipoCartera_rcond").val();
        var tiempoOferta = $(this).val();
        
        selectItemOferta("txtItemOferta_rcond", grupoTipoCartera, tiempoOferta, '');
        
        $('#txtItemOferta_rcond').val('').trigger('change');
        $('#txtNroContrato_rcond').val('').trigger('input');
        $('#txtTipoDescuento_rcond').val('').trigger('change');
        $('#selectCantidadMeses').empty().append('<option value="">Seleccione una opción</option>');
        $('.valorDescuentoCaja').addClass('d-none');
        $('.cuotaMonitoreoCaja').addClass('d-none');
        $('.permanenciaClienteCaja').addClass('d-none');
        
        $("#txtTipoOferta_rcond").val('').trigger('change');
        $("#txtCodigoInfoPoint_rcond").val('');
        
        const picker = document.querySelector("#fechaInicio")._flatpickr;
        if (picker) {
            picker.clear(); // Limpia la fecha y deja el input vacío
        }
        
    
        // Ocultar el slider
        $('.descuentoValor').addClass('d-none');
    
        // (Opcional) destruir el slider si existe
        if (document.getElementById('nonlinear').noUiSlider) {
            document.getElementById('nonlinear').noUiSlider.destroy();
        }
    
        // (Opcional) Limpiar valores visibles
        $('#lower-value, #middle-value, #upper-value').text('');
        $('#tituloDescuento').text('Valor Con Descuento (%)');
        // validarContrato();
    });
    
/* ------------------------------- */

    $(document).on('change', '#txtItemOferta_rcond', function() {
        
        $('#txtNroContrato_rcond').val('').trigger('input');
        $('#txtTipoDescuento_rcond').val('').trigger('change');
        $('#selectCantidadMeses').empty().append('<option value="">Seleccione una opción</option>');
        $('.valorDescuentoCaja').addClass('d-none');
        $('.cuotaMonitoreoCaja').addClass('d-none');
        $('.permanenciaClienteCaja').addClass('d-none');
    
        $("#txtTipoOferta_rcond").val('').trigger('change');
        $("#txtCodigoInfoPoint_rcond").val('');
        
        const picker = document.querySelector("#fechaInicio")._flatpickr;
        if (picker) {
            picker.clear(); // Limpia la fecha y deja el input vacío
        }
        
        // Ocultar el slider
        $('.descuentoValor').addClass('d-none');
    
        // (Opcional) destruir el slider si existe
        if (document.getElementById('nonlinear').noUiSlider) {
            document.getElementById('nonlinear').noUiSlider.destroy();
        }
    
        // (Opcional) Limpiar valores visibles
        $('#lower-value, #middle-value, #upper-value').text('');
        $('#tituloDescuento').text('Valor Con Descuento (%)');
        // validarContrato();
    });
    

    function selectItemOferta(elemento, grupoTipoCartera, tiempoOferta, idSeleccionado)
    {
        $('#'+elemento).empty();
        $.post(baseUrl + '/listado-item-oferta', 
        {
            grupoTipoCartera: grupoTipoCartera,
            tiempoOferta: tiempoOferta
        }, 
        function(response) { console.log(response);
            if (response.descripcion === 0) {
                //alert("Ocurrió un error al obtener los datos.");
            } else {
                var items = $.parseJSON(response.listadoItemOferta);
                $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
                for(var i = 0; i < items.length; i++){
                    $("#"+elemento).append('\
                        <option value="' + items[i].id + '" '+(idSeleccionado == items[i].id ? 'selected' : '')+'>' + items[i].text +'</td>\n\
                    ');
                }
            }
        
        }, 'json');
    
        // $('#'+elemento).select2({
        //     dropdownParent: $('#'+modal+' .modal-body')
        // });
    }
    
    
    
