<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ADDOFE", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#registrarOferta" data-form="#formRegistrarOferta" id="btnRegistrarOferta" data-toggle="tooltip" data-placement="top" title="Registrar Ofertas" aria-label="Registrar Ofertas">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblOfertas" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
/*** SERVERSIDE LISTADO DE CONDONACIONES ***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblOfertas').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/ofertas-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDOfertas", "class": "text-center", "searchable": true },
						{"title": "Fecha Registro", "data": "FechaRegistro", "class": "text-center", "searchable": true },
						{"title": "Nombre Gestor", "data": "NombreGestor", "class": "text-center", "searchable": true },
						{"title": "Matrícula Gestor", "data": "MatriculaCreador", "class": "text-center", "searchable": true },
						{"title": "Dirección", "data": "DireccionSolicitanteCreador", "class": "text-center", "searchable": true },
						{"title": "Área", "data": "AreaSolicitanteCreador", "class": "text-center", "searchable": true },
						{"title": "Subárea", "data": "SubareaSolicitanteCreador", "class": "text-center", "searchable": true },
						{"title": "Observación", "data": "Observacion", "class": "text-center", "searchable": true },
						{"title": "Tipo Requerimiento", "data": "TipoRequerimiento", "class": "text-center", "searchable": true },
						{"title": "Requerimiento", "data": "Requerimiento", "class": "text-center", "searchable": true },
						{"title": "Motivo Requerimiento", "data": "MotivoRequerimiento", "class": "text-center", "searchable": true },
						{"title": "Estado", "data": "Estado", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		
		/****FIN SERVERSIDE LISTADO CARGOS****/
		
		$('#txtTiempoOferta_rcond').select2({
            dropdownParent: $('#registrarOferta .modal-body')
        });
        
        $('#txtItemOferta_rcond').select2({
            dropdownParent: $('#registrarOferta .modal-body')
        });
        
        $('#txtTipoDescuento_rcondVisible').select2({
            dropdownParent: $('#registrarOferta .modal-body')
        });
		
		$('#txtTipoFactura_rcond').select2({
            dropdownParent: $('#registrarOferta .modal-body')
        });
		
		$('#txtMotivoRequerimiento_rcond').select2({
            dropdownParent: $('#registrarOferta .modal-body')
        });
		
        $(document).on('change', '#txtRequerimiento_rcond', function() 
        {
            var modal = $(this).attr("data-modal");
            var idRequerimiento = $(this).val();
            
            $("#txtMotivoRequerimiento_rcond").empty();
            
            selectMotivosRequerimiento('txtMotivoRequerimiento_rcond', idRequerimiento, '', modal.substring(1));
        });
        
        $(document).on('change', '#txtMotivoRequerimiento_rcond', function() 
        {
            var idMotivo = $(this).val();
            var adjunto = $(this).find('option:selected').data("adjunto");
            
            pondAdjuntoMotivoRequerimiento.removeFiles();
            
            if(adjunto == "Y")
            {
                $("#ctnAdjuntoMotivoRequerimiento_rcond").removeClass("d-none");
            }
            else
            {
                $("#ctnAdjuntoMotivoRequerimiento_rcond").addClass("d-none");
            }
            
        });
        
        $(document).on('change', '#txtTipoDescuento_rcond', function() 
        {
            // var tipoDescuento = $(this).val();
            // console.log(tipoDescuento);
            // if(tipoDescuento == "porcentaje")
            // {
            //     $(".descuentoPorcentaje").removeClass("d-none");
            //     $(".descuentoSoles").addClass("d-none");
            // }
            // else
            // {
            //     $(".descuentoSoles").removeClass("d-none");
            //     $(".descuentoPorcentaje").addClass("d-none");
            // }
            
        });
        
        pondAdjuntoMotivoRequerimiento = FilePond.create(
            document.querySelector("#fileAdjuntoMotivoRequermiento_rcond"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false
            }
        );
        
        pondImportarCSVCondonaciones = FilePond.create(
            document.querySelector("#fileCSVCondonaciones"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarCSVCondonaciones.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
        
        

        
        // Al digitar en el input de número de contrato (como ya hacías)
        $(document).on('input', '#txtNroContrato_rcond', validarContrato);
        
        // $(document).on('change', '#sliderContainer', function () {
        //     var valorCuotaMonitoreo = $("#cuotaMonitoreo").val(); console.log(valorCuotaMonitoreo);
        //     var tipo = $("#txtTipoDescuento_rcond").val(); console.log(tipo);
        //     var descuento = $(this).val(); console.log(descuento);

        // });
        
        
	});
	
    function validarContrato() {
        let valor = $('#txtNroContrato_rcond').val().replace(/\D/g, '');
        $('#txtNroContrato_rcond').val(valor);
        
        $("#txtTipoOferta_rcond").val('').trigger('change');
        $("#txtCodigoInfoPoint_rcond").val('');
        
        const picker = document.querySelector("#fechaInicio")._flatpickr;
        if (picker) {
            picker.clear(); // Limpia la fecha y deja el input vacío
        }
    
        $('#txtTipoDescuento_rcondVisible').val('').trigger('change');
        $('#selectCantidadMeses').empty().append('<option value="">Seleccione una opción</option>');
        $('.valorDescuentoCaja, .cuotaMonitoreoCaja, .permanenciaClienteCaja, .descuentoValor').addClass('d-none');
        $('#txtMatriz_rcond').prop('checked', false); // lo desactiva
        
        if (valor.length >= 7) {
            let grupoTipoCartera = parseInt($("#txtTipoCartera_rcond").val()); 
            let tiempoOferta = $("#txtTiempoOferta_rcond").val();
            let itemOferta = $("#txtItemOferta_rcond").val();
    
            if (grupoTipoCartera && tiempoOferta) {
                $.ajax({
                    url: baseUrl + "/validar-contrato",
                    type: "POST",
                    dataType: "json",
                    data: {
                        grupoTipoCartera,
                        tiempoOferta,
                        itemOferta,
                        nroContrato: valor
                    },
                    beforeSend: function () {
                        Swal.fire({
                            html: 'Un momento por favor...',
                            heightAuto: true,
                            allowOutsideClick: false,
                            showConfirmButton: false,
                            didOpen: () => Swal.showLoading()
                        });
                    },
                    complete: function () {
                        Swal.close();
                    },
                    success: function (response) {
                        if (response.status === 'ok') {
                            let tipo = response.tipoDescuento;
                            let valores = response.valorDescuento;
                            let cuotaMonitoreo = response.cuotaMonitoreo;
                            let permanenciaCliente = response.permanenciaCliente;
                            let minDescuento = response.min;
                            let maxDescuento = response.max;
                            
                            $("#tipoDeOferta").val(tipo);
                            $("#minDescuento").val(minDescuento);
                            $("#maxDescuento").val(maxDescuento);
    
                            $("#cuotaMonitoreo, #cuotaMonitoreoVisible").val(cuotaMonitoreo);
                            $("#permanenciaCliente, #permanenciaClienteVisible").val(permanenciaCliente);
    
                            // let selectMeses = $('#selectCantidadMeses');
                            // selectMeses.empty().append('<option value="">Seleccione una opción</option>');
    
                            // if (tiempoOferta === 'Permanente') {
                            //     selectMeses.append('<option value="-1" selected>Permanente</option>');
                            // } else if (Array.isArray(response.cantidadMeses)) {
                            //     response.cantidadMeses.forEach(mes => {
                            //         let isPermanente = mes === 'permanente' || mes === -1;
                            //         let label = isPermanente ? 'Permanente' : `${mes} meses`;
                            //         selectMeses.append(`<option value="${mes}">${label}</option>`);
                            //     });
                            // }
                            
                            
    
                            $('.descuentoValor').removeClass('d-none');
                            $("#txtTipoDescuento_rcondVisible").val(tipo).trigger('change');
    
                            let simbolo = tipo === 'soles' ? 'S/ ' : '%';
                            let titulo = tipo === 'soles' ? 'Descuento (S/.)' : 'Descuento (%)';
                            $('#tituloDescuento').text(titulo);
                            $("#txtTipoDescuento_rcond").val(tipo);
                            
                            /*******************/
                 
                            let inicioMes = response.cantidadMeses[0]; 
                            let finMes = response.cantidadMeses[1]; 
                            let steps;
                            let recorreMes;
                            if ([8, 9, 10].includes(grupoTipoCartera)) {
                                steps = 1;
                                recorreMes = 1;
                            } else if ([1, 3, 4, 6].includes(grupoTipoCartera)) {
                                steps = tipo === 'soles' ? 10 : 5;
                                recorreMes = 3;
                            } else {
                                steps = 1; // valor por defecto, puedes cambiarlo si deseas otro
                                recorreMes = 1;
                            } 
                            
                            let selectMeses = $('#selectCantidadMeses');
                            selectMeses.empty().append('<option value="">Seleccione una opción</option>');
                            
                            if (tiempoOferta === 'Permanente') {
                                // Solo mostrar la opción "Permanente"
                                selectMeses.append('<option value="-1" selected>Permanente</option>');
                            } else {
                                for (let mes = inicioMes; mes <= finMes; mes = mes + recorreMes) {
                                    selectMeses.append('<option value="' + mes + '">' + mes + ' meses</option>');
                                }
                            }
                            
                            /*******************/
    
                            let minValor = Math.min(...valores);
                            let maxValor = Math.max(...valores);
                            let startValor = valores[0];
    
                            let sliderEl = document.getElementById('nonlinear');
                            if (sliderEl.noUiSlider) {
                                sliderEl.noUiSlider.destroy();
                            }
    
                            noUiSlider.create(sliderEl, {
                                start: [startValor],
                                connect: [true, false],
                                range: {
                                    min: minValor,
                                    max: maxValor
                                },
                                // step: tipo === 'soles' ? 10 : 5,
                                step: steps,
                                tooltips: true,
                                format: {
                                    to: value => simbolo + Math.round(value),
                                    from: value => Number(value.replace(/[^0-9.-]+/g, ""))
                                }
                            });
    
                            $('#lower-value').text(simbolo + minValor);
                            $('#upper-value').text(simbolo + maxValor);
                            $('#middle-value').text(simbolo + startValor);
    
                            sliderEl.noUiSlider.on('update', function (values, handle) {
                                let descuentoTexto = values[handle];
                                let descuento = parseFloat(descuentoTexto.replace(/[^0-9.]/g, ''));
                                let valorCuotaMonitoreo = parseFloat($('#cuotaMonitoreo').val());
    
                                $("#input-middle-value").val(descuento);
    
                                let montoCalculado = tipo === 'porcentaje'
                                    ? (valorCuotaMonitoreo * descuento / 100)
                                    : (valorCuotaMonitoreo - descuento);
    
                                montoCalculado = Math.max(0, montoCalculado).toFixed(2);
    
                                $('#valorDescuento, #valorDescuentoVisible').val(montoCalculado);
                                $('#middle-value').text(descuentoTexto);
    
                                $('.valorDescuentoCaja, .cuotaMonitoreoCaja, .permanenciaClienteCaja').removeClass('d-none');
                            });
                        } else {
                            Swal.fire({
                                icon: 'warning',
                                title: 'Advertencia',
                                text: response.message || 'No se pudo validar el contrato. Intenta nuevamente.'
                            });
                        }
                    },
                    error: function (xhr, status, error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Ocurrió un error al validar el contrato. Intenta nuevamente.',
                            footer: `<code>${status} - ${error}</code>`
                        });
                        console.error("AJAX Error:", status, error);
                    }
                });
            }
        }
    }


        
    $('#txtMatriz_rcond').on('change', function () {
        if ($(this).is(':checked')) {
            // Modo "Fuera de matriz"
            setValoresMatrizExterna();
        } else {
            // Si quieres revalidar el contrato normal cuando se desactiva
            validarContrato(); // Llama la función original para valores por defecto
        }
    });
    
    function setValoresMatrizExterna() {
        let tipo = $("#tipoDeOferta").val();
        // let tipo = 'porcentaje'; // o 'soles', según el diseño
        
        let grupoTipoCartera = parseInt($("#txtTipoCartera_rcond").val()); console.log(grupoTipoCartera);
        let minDescuento = parseInt($("#minDescuento").val()); console.log(minDescuento);
        let maxDescuento = parseInt($("#maxDescuento").val()); console.log(maxDescuento);
    
        
        let tiempoOferta = $("#txtTiempoOferta_rcond").val();
        // 2. Setear cantidad de meses
        
        let recorreMes, steps;
        if ([8, 9, 10].includes(grupoTipoCartera)) {
            steps = 1;
            recorreMes = 1;
            tipo = 'soles';
        } else if ([1, 3, 4, 6].includes(grupoTipoCartera)) {
            steps = tipo === 'soles' ? 10 : 5;
            recorreMes = 3;
        } else {
            steps = 1; // valor por defecto, puedes cambiarlo si deseas otro
            recorreMes = 1;
        } 
        
        // 1. Setear tipo descuento
        $('#txtTipoDescuento_rcond').val(tipo).trigger('change');
        
        let selectMeses = $('#selectCantidadMeses');
        selectMeses.empty().append('<option value="">Seleccione una opción</option>');
        
        if (tiempoOferta === 'Permanente') {
            // Solo mostrar la opción "Permanente"
            selectMeses.append('<option value="-1" selected>Permanente</option>');
        } else {
            for (let mes = recorreMes; mes <= 12; mes = mes + recorreMes) {
                selectMeses.append('<option value="' + mes + '">' + mes + ' meses</option>');
            }
        }
        
        let simbolo = tipo === 'soles' ? 'S/ ' : '%';
        let titulo = tipo === 'soles' ? 'Descuento (S/.)' : 'Descuento (%)';
        $('#tituloDescuento').text(titulo);
                            
        
        // 3. Slider de 0 a 100
        var sliderEl = document.getElementById('nonlinear');
        if (sliderEl.noUiSlider) {
            sliderEl.noUiSlider.destroy();
        }
    
        noUiSlider.create(sliderEl, {
            start: [0],
            connect: [true, false],
            range: {
                min: minDescuento,
                max: maxDescuento
            },
            step: steps,
            tooltips: true,
            format: {
                to: function (value) {
                    return simbolo + Math.round(value);
                },
                from: function (value) {
                    return Number(value.replace(/[^0-9.-]+/g, ""));
                }
            }
        });
    
        $('#lower-value').text(simbolo + minDescuento);
        $('#upper-value').text(simbolo + maxDescuento);
        $('#middle-value').text(simbolo + '0');
        $("#input-middle-value").val(0);
        $("#valorDescuento").val("");
    
        // Mostrar cajas ocultas
        $('.descuentoValor').removeClass('d-none');
        $('.valorDescuentoCaja').removeClass('d-none');
        $('.cuotaMonitoreoCaja').removeClass('d-none');
        $('.permanenciaClienteCaja').removeClass('d-none');
    
        // Listener para actualizar descuento
        sliderEl.noUiSlider.on('update', function (values, handle) {
            const descuentoTexto = values[handle]; // Ej: "50%"
            const descuento = parseFloat(descuentoTexto.replace(/[^0-9.]/g, ''));
            $("#input-middle-value").val(descuento);
    
            let valorCuotaMonitoreo = parseFloat($('#cuotaMonitoreo').val());
            let montoCalculado = valorCuotaMonitoreo;
    
            if (!isNaN(descuento) && !isNaN(valorCuotaMonitoreo)) {
                montoCalculado = (tipo === 'porcentaje')
                    ? (valorCuotaMonitoreo * (descuento / 100))
                    : (valorCuotaMonitoreo - descuento);
    
                montoCalculado = Math.max(0, montoCalculado).toFixed(2);
                $('#valorDescuento').val(montoCalculado);
                $('#valorDescuentoVisible').val(montoCalculado);
            } else {
                $('#valorDescuento').val('');
                $('#valorDescuentoVisible').val('');
            }
    
            $('#middle-value').text(descuentoTexto);
            
        });
    }
 
$(document).ready(function () {
    $("#fechaInicio").flatpickr({
        locale: "es",
        plugins: [
            new monthSelectPlugin({
                shorthand: false,
                dateFormat: "Y-m-d",     // <- formato para guardar en BD (2025-06-01)
                altFormat: "F Y",        // <- formato visual en español (junio 2025)
                theme: "light"
            })
        ],
        altInput: true,
        defaultDate: new Date() // O usa un valor desde PHP si estás editando
    });
});


	
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->

<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Registrar Condonación -->
<div class="modal fade zoomIn" id="registrarOferta" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleregistrarOferta" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleregistrarOferta">Registrar Oferta</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formRegistrarOferta" class="formularioRegistrarOferta formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/registrar-oferta" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="step-arrow-nav mb-4">
                        <ul class="nav nav-pills custom-nav nav-border-top nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionCondonacion" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionCondonacion" type="button" role="tab" aria-controls="tabcontentInformacionCondonacion" aria-selected="true" data-position="0">Información de Solicitud</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabDetalleOfertas" data-bs-toggle="pill" data-bs-target="#tabcontenDetalleOfertas" type="button" role="tab" aria-controls="tabcontenDetalleOfertas" aria-selected="false" data-position="1">Ofertas</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionCondonacion" role="tabpanel" aria-labelledby="tabInformacionCondonacion">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Fecha Solicitud</label>
            								<input type="text" class="form-control" value="<?= date("d-m-Y") ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Nombre Solicitante</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Nombres'])) ?>" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label">Apellido Solicitante</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Apellidos'])) ?>" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Matrícula Solicitante</label>
            								<input type="text" id="inputMatricula" class="form-control" style="color: #0000FF" value="<?= $usuarioSolicitante['Matricula'] ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Dirección</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Direccion'])) ?>" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label">Área</label>
            								<input type="text" class="form-control" id="inputArea" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Area'])) ?>" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label">Subárea</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Subarea'])) ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label">Cargo</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Cargo'])) ?>" disabled >
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3 ">
            						    <div>
            								<label for="txtRequerimiento_rcond" class="form-label">Requerimiento</label>
            								<select class="form-select" aria-label="Requerimiento" id="txtRequerimiento_rcond" name="txtRequerimiento_rcond" data-modal="#registrarOferta">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            								<input type="hidden" id="txtRequerimientoTextPeticion" name="txtRequerimientoTextPeticion">
            							</div>
            						</div>
            				        <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3 ">
            						    <div>
            								<label for="txtMotivoRequerimiento_rcond" class="form-label">Motivo del Requerimiento</label>
            								<select class="form-select" aria-label="Motivo del Requerimiento" id="txtMotivoRequerimiento_rcond" name="txtMotivoRequerimiento_rcond" data-modal="#registrarOferta">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 d-flex justify-content-center align-items-center d-none" id="ctnAdjuntoMotivoRequerimiento_rcond">
        					        <div class="col-7 m-0 p-0">
            					        <input type="file" id="fileAdjuntoMotivoRequermiento_rcond" class="filepond" name="fileAdjuntoMotivoRequermiento_rcond" data-max-file-size="100MB" data-max-files="1" />
            					    </div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div>
        								<label for="txtObservaciones_rcond" class="form-label">Observaciones</label>
        								<textarea class="form-control validarNextTab" id="txtObservaciones_rcond" name="txtObservaciones_rcond" rows="4"></textarea>
        							</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabDetalleOfertas" id="btnNextTab"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar Oferta</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontenDetalleOfertas" role="tabpanel" aria-labelledby="tabDetalleOfertas">
                            <div class="px-3">
                                <div class="tab-content px-3">
                                    <div class="tab-pane active show" id="navOfertasIndividual" role="tabpanel">
                                        <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
                    					    Oferta
                    					</div>
                					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
                					        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3  ">
                    							<div>
                    								<label for="txtTipoCartera_rcond" class="form-label">Tipo Cartera</label>
                    								<!-- <input type="text" class="form-control" id="txtTipoCartera_rcond" > -->
                    								<select class="form-select" aria-label="Segmento" id="txtTipoCartera_rcond" name="txtTipoCartera_rcond" data-modal="#registrarOferta">
                                                        <option value="" selected>Seleccione una opción</option>
                                                        <?php foreach ($datosGrupoCarteraCliente as $carteraCliente): ?>
                                                            <option value="<?= $carteraCliente['IDGrupoCarteraCliente'] ?>">
                                                                <?= esc($carteraCliente['CarteraCliente']) ?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                    							</div>
                    						</div>
                					        <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                    								<label for="txtTiempoOferta_rcond" class="form-label">Tiempo de Oferta</label>
                    								<select class="form-select" aria-label="Segmento" id="txtTiempoOferta_rcond" name="txtTiempoOferta_rcond" data-modal="#registrarOferta">
                    									<option value="" selected="">Seleccione una opción</option>
                    									<option value="Temporal">Temporal</option>
                                                        <option value="Permanente">Permanente</option>
                    								</select>
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                    								<label for="txtItemOferta_rcond" class="form-label">Item Oferta</label>
                    								<select class="form-select" aria-label="Segmento" id="txtItemOferta_rcond" name="txtItemOferta_rcond" data-modal="#registrarOferta">
                    									<option value="" selected="">Seleccione una opción</option>
                    								</select>
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3  ">
                    							<div>
                    								<label for="txtNroContrato_rcond" class="form-label">Nro Contrato</label>
                    								<input type="numeric" class="form-control" id="txtNroContrato_rcond" name="txtNroContrato_rcond" required>
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 cuotaMonitoreoCaja"> 
                    							<div>
                    								<label for="cuotaMonitoreo" class="form-label" >Cuota Monitoreo</label>
                    								<input type="text" class="form-control" id="cuotaMonitoreoVisible" disabled >
                    								<input type="hidden" class="form-control" id="cuotaMonitoreo" name="cuotaMonitoreo" >
                    								<input type="hidden" id="minDescuento">
                    								<input type="hidden" id="maxDescuento">
                    								<input type="hidden" id="tipoDeOferta">
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 permanenciaClienteCaja">
                    							<div>
                    								<label class="form-label" >Permanencia Cliente (meses)</label>
                    								<input type="text" class="form-control" id="permanenciaClienteVisible" disabled >
                    								<input type="hidden" class="form-control" id="permanenciaCliente" name="permanenciaCliente" >
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                                                    <label for="txtTipoDescuento_rcond" class="form-label">Tipo de Descuento</label>
                                                    <select id="txtTipoDescuento_rcondVisible" class="form-select" disabled>
                                                      <option value="">Seleccione una opción</option>
                                                      <option value="porcentaje">Porcentaje (%)</option>
                                                      <option value="soles">Soles (S/)</option>
                                                    </select>
                                                    <input type="hidden" class="form-control" id="txtTipoDescuento_rcond" name="txtTipoDescuento_rcond"  readonly>
                                                    <!--<input type="text" class="form-control" id="txtTipoDescuento_rcondVisible" disabled >  -->
                                                </div>
                                            </div>
                                            
                                            <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 descuentoValor d-none">
                    						    <!-- Slider para Porcentaje -->
                                                <div id="sliderContainer" class="my-4">
                                                    <div class="row">
                                                        <div class="col-lg-3">
                                                            <h5 class="fs-14" id="tituloDescuento">Valor con Descuento (%)</h5>
                                                        </div>
                                                        <div class="col-lg-9">
                                                            <div id="nonlinear"></div>
                                                            <div class="d-flex justify-content-between align-items-center mt-2">
                                                                <div>
                                                                    <strong>Min:</strong> <span id="lower-value"></span>
                                                                </div>
                                                                <div>
                                                                    <strong>Valor:</strong> <span id="middle-value"></span>
                                                                </div>
                                                                <div>
                                                                    <strong>Máx:</strong> <span id="upper-value"></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- Este input es invisible pero es el que se enviará por POST -->
                                                    <input type="hidden" name="input-middle-value" id="input-middle-value">
                                                </div>
                                            </div>
                                            <div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 valorDescuentoCaja">
                    							<div>
                    								<label for="valorDescuento" class="form-label" >Valor con descuento</label>
                    								    <div class="input-group">
                                                          <span class="input-group-text">S/</span>
                                                          <input type="text" class="form-control" id="valorDescuentoVisible" disabled>
                                                          <input type="hidden" class="form-control" id="valorDescuento" name="valorDescuento" readonly>
                                                        </div>
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div class="form-group">
                                                    <label for="selectCantidadMeses">Cantidad de Meses</label>
                                                    <select id="selectCantidadMeses" name="selectCantidadMeses" class="form-control">
                                                        <option value="">Seleccione una opción</option>
                                                    </select>
                                                </div>
                                            </div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    							<div>
                    								<label for="fechaInicio" class="form-label" >Mes de Impacto</label>
                    								<input 
                                                        type="text" 
                                                        id="fechaInicio"
                                                        name="fechaInicio"
                                                        class="form-control" 
                                                        placeholder="Mes - Año"
                                                        readonly
                                                    />

                    							</div>
                    						</div>

                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                    								<label for="txtTipoOferta_rcond" class="form-label">Tipo de Oferta</label>
                    								<select class="form-select" aria-label="Segmento" id="txtTipoOferta_rcond" name="txtTipoOferta_rcond" data-modal="#registrarOferta">
                    									<option value="" selected="">Seleccione una opción</option>
                    									<option value="nuevaOferta">Nueva Oferta</option>
                                                        <option value="remplazoOferta">Reemplazo Oferta</option>
                    								</select>
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                    								<label for="txtImpacto_rcond" class="form-label">Impacto Oferta</label>
                    								<input type="text" class="form-control" id="txtImpacto_rcond" value="Cuota de Monitoreo" disabled>
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                    								<label for="txtCodigoInfoPoint_rcond" class="form-label">Número de aviso</label>
                    								<input type="text" class="form-control" id="txtCodigoInfoPoint_rcond" name="txtCodigoInfoPoint_rcond">
                    							</div>
                    						</div>
                    						<!--<div class="row col-12 m-0 p-0 mb-3 d-flex">-->
                        		<!--				<div>-->
                    						<!--		<label for="txtObservacionesOfertas_rcond" class="form-label">Comentarios</label>-->
                    						<!--		<textarea class="form-control validarNextTab" id="txtObservacionesOfertas_rcond" name="txtObservacionesOfertas_rcond" rows="4"></textarea>-->
                    						<!--	</div>-->
                    					 <!--   </div>-->
                    					  
                    					    <div class="col-xxl-3 col-md-12 col-12 px-1 mb-0">
                                                <div class="border-sistema-2px p-1 d-flex justify-content-center align-items-center" style="border-radius: 15px;">
                                                    <div class="text-center">
                                                        <div class="form-check form-switch form-switch-secondary m-0">
                                                            <input class="form-check-input" type="checkbox" role="switch" id="txtMatriz_rcond" name="txtMatriz_rcond">
                                                            <label class="form-check-label ms-2" for="txtMatriz_rcond">Excepción</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                					    </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionCondonacion"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>