<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ADDGCC", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-grupo-cartera-cliente" data-bs-toggle="modal" data-bs-target="#informacionGrupoCarteraCliente" data-id="0" data-accion="crear" id="crear-grupo-cartera-cliente">
									<i class="mdi mdi-plus-circle"></i> Añadir
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblGruposCarteraCliente" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Grupo de Cartera Cliente</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach($listadoGruposCarteraCliente as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDGrupoCarteraCliente'] ?></td>
										<td class="text-center align-middle"><?= $items['CarteraCliente'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
											<?php
											if (in_array("ESTGCC", $permisos))  
											{
											?>
											<button class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-grupo-cartera-cliente" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IDGrupoCarteraCliente'] ?>">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</button>
											<?php
											}
											else
											{
											?>
											<span class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
												<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-grupo-cartera-cliente" data-bs-toggle="modal" data-bs-target="#informacionGrupoCarteraCliente" data-id="<?= $items['IDGrupoCarteraCliente'] ?>" data-accion="ver" id="ver-grupo-cartera-cliente">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDGCC", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-grupo-cartera-cliente" data-bs-toggle="modal" data-bs-target="#informacionGrupoCarteraCliente" data-id="<?= $items['IDGrupoCarteraCliente'] ?>" data-accion="editar" id="editar-grupo-cartera-cliente">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													
													if (in_array("ASUSCC", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-usuarios-grupo-cartera-cliente/<?= $items['IDGrupoCarteraCliente'] ?>" class="dropdown-item">
															<i class="mdi mdi-account align-bottom me-2 text-muted"></i> Usuarios
														</a>
													</li>
													<?php
													}
													
													if (in_array("ASUGNO", $permisos)) // asociar usuario grupo nomenclarura oferta
													{
													?>
													<li>
														<a href="#!" class="dropdown-item datos-grupo-cartera-cliente" data-bs-toggle="modal" data-bs-target="#asociarItemOferta" data-id="<?= $items['IDGrupoCarteraCliente'] ?>" data-accion="asociar" id="asociar-item-oferta">
															<i class="ri-calendar-check-line me-2 text-muted"></i> Item Oferta
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <script>document.write(new Date().getFullYear())</script> © Verisure Peru.
                </div>
                <div class="col-sm-6">
                    <div class="text-sm-end d-none d-sm-block">Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- end main content-->
<!-- Modal Información Requerimiento -->
<div class="modal fade" id="informacionGrupoCarteraCliente" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionGrupoCarteraCliente" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionGrupoCarteraCliente">Información de Grupo Cartera Cliente</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionGrupoCarteraCliente" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDGrupoCarteraCliente_i" name="txtIDGrupoCarteraCliente_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtGrupoCarteraCliente_i" class="form-label">Grupo de Cartera Cliente</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Grupo de Cartera Cliente" id="txtGrupoCarteraCliente_i" name="txtGrupoCarteraCliente_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionGrupoCarteraCliente_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionGrupoCarteraCliente_i" name="txtObservacionGrupoCarteraCliente_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarGrupoCarteraCliente" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Asociar Item Oferta - Grupo Cartera Cliente -->
<div class="modal fade modal-xl" id="asociarItemOferta" tabindex="-1" role="dialog" aria-labelledby="exampleasociarItemOferta" aria-hidden="true" data-bs-backdrop="static">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleasociarItemOferta">Asociar Item Oferta - Grupo Cartera Cliente</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAsociarItemOferta" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDGrupoCarteraClienteItem_i" name="txtIDGrupoCarteraClienteItem_i">
					<div class="row">
					    <div class="col-xxl-12 col-md-12 col-12">
                            <label for="multiselect-basic" class="form-label">Selecciona Item Oferta</label>
                            <form>
                                <select required="" multiple="multiple" name="horarios[]" id="multiselect-basic">
                                   
                                </select>                           
                            </form>
                        </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnGuardarItemOferta" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>