<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("EXPRCO", $permisos)) 
								{
								?>
                                <button class="btn bg-warning d-flex justify-content-center align-items-center mx-1 color-white" id="btnRegistrarPregestionCondonacionCobranza" data-toggle="tooltip" data-placement="top" title="Descargar información Pregestión Condonación Cobranza" aria-label="Descargar información Pregestión Condonación Cobranza">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Exportar PreGestión Cobranza
								</button>
								<?php
								}
								
								if (in_array("ADDCON", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#registrarCondonacion" data-form="#formRegistrarCondonacion" id="btnRegistrarCondonacion" data-toggle="tooltip" data-placement="top" title="Registrar Condonación" aria-label="Registrar Condonación">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblCondonaciones" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE CONDONACIONES***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblCondonaciones').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/condonaciones-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDCondonacion", "class": "text-center", "searchable": true },
						{"title": "Fecha Registro", "data": "FechaRegistro", "class": "text-center", "searchable": true },
						{"title": "Nombre Gestor", "data": "NombreGestor", "class": "text-center", "searchable": true },
						{"title": "Matrícula Gestor", "data": "Matricula", "class": "text-center", "searchable": true },
						{"title": "Dirección", "data": "DireccionSolicitante", "class": "text-center", "searchable": true },
						{"title": "Área", "data": "AreaSolicitante", "class": "text-center", "searchable": true },
						{"title": "Subárea", "data": "SubareaSolicitante", "class": "text-center", "searchable": true },
						{"title": "Observación", "data": "Observacion", "class": "text-center", "searchable": true },
						{"title": "Tipo Requerimiento", "data": "TipoRequerimiento", "class": "text-center", "searchable": true },
						{"title": "Requerimiento", "data": "Requerimiento", "class": "text-center", "searchable": true },
						{"title": "Motivo Requerimiento", "data": "MotivoRequerimiento", "class": "text-center", "searchable": true },
						{"title": "Estado", "data": "EstadoCondonacion", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO CARGOS****/
		
		$('#txtSegmento_rcond').select2({
            dropdownParent: $('#registrarCondonacion .modal-body')
        });
		
		$('#txtTipoFactura_rcond').select2({
            dropdownParent: $('#registrarCondonacion .modal-body')
        });
		
		$('#txtMotivoRequerimiento_rcond').select2({
            dropdownParent: $('#registrarCondonacion .modal-body')
        });
		
        $(document).on('change', '#txtRequerimiento_rcond', function() 
        {
            var modal = $(this).attr("data-modal");
            var idRequerimiento = $(this).val();
            
            $("#txtMotivoRequerimiento_rcond").empty();
            
            selectMotivosRequerimiento('txtMotivoRequerimiento_rcond', idRequerimiento, '', modal.substring(1));
        });
        
        $(document).on('change', '#txtMotivoRequerimiento_rcond', function() 
        {
            var idMotivo = $(this).val();
            var adjunto = $(this).find('option:selected').data("adjunto");
            
            pondAdjuntoMotivoRequerimiento.removeFiles();
            
            if(adjunto == "Y")
            {
                $("#ctnAdjuntoMotivoRequerimiento_rcond").removeClass("d-none");
            }
            else
            {
                $("#ctnAdjuntoMotivoRequerimiento_rcond").addClass("d-none");
            }
            
        });
        
        pondAdjuntoMotivoRequerimiento = FilePond.create(
            document.querySelector("#fileAdjuntoMotivoRequermiento_rcond"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false
            }
        );
        
        pondImportarCSVCondonaciones = FilePond.create(
            document.querySelector("#fileCSVCondonaciones"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarCSVCondonaciones.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
        
        $(document).on('click', '#btnRegistrarPregestionCondonacionCobranza', function() 
        {
            window.open(baseUrl+"/exportar-pregestion-condonacion-cobranza",'_blank');
        });
        
        
        
        
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->

<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>


<!-- Modal Registrar Condonación -->
<div class="modal fade zoomIn" id="registrarCondonacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleregistrarCondonacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleregistrarCondonacion">Registrar Condonación</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formRegistrarCondonacion" class="formularioRegistrarCondonacion form-steps" autocomplete="off" action="<?= $baseUrl ?>/registrar-condonacion" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="step-arrow-nav mb-4">
                        <ul class="nav nav-pills custom-nav nav-border-top nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionCondonacion" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionCondonacion" type="button" role="tab" aria-controls="tabcontentInformacionCondonacion" aria-selected="true" data-position="0">Información de Condonación</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabDetalleFacturas" data-bs-toggle="pill" data-bs-target="#tabcontenDetalleFacturas" type="button" role="tab" aria-controls="tabcontenDetalleFacturas" aria-selected="false" data-position="1">Facturas</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionCondonacion" role="tabpanel" aria-labelledby="tabInformacionCondonacion">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Fecha Solicitud</label>
            								<input type="text" class="form-control" value="<?= date("d-m-Y") ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Nombre Solicitante</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Nombres'])) ?>" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label">Apellido Solicitante</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Apellidos'])) ?>" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Matrícula Solicitante</label>
            								<input type="text" class="form-control" style="color: #0000FF" value="<?= $usuarioSolicitante['Matricula'] ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Dirección</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Direccion'])) ?>" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label">Área</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Area'])) ?>" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label">Subárea</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Subarea'])) ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label">Cargo</label>
            								<input type="text" class="form-control" value="<?= ucwords(mb_strtolower($usuarioSolicitante['Cargo'])) ?>" disabled >
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3 ">
            						    <div>
            								<label for="txtRequerimiento_rcond" class="form-label">Requerimiento</label>
            								<select class="form-select" aria-label="Requerimiento" id="txtRequerimiento_rcond" name="txtRequerimiento_rcond" data-modal="#registrarCondonacion">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            								<input type="hidden" id="txtRequerimientoTextPeticion" name="txtRequerimientoTextPeticion">
            							</div>
            						</div>
            				        <div class="col-xxl-6 col-md-12 col-12 px-3 mb-3 ">
            						    <div>
            								<label for="txtMotivoRequerimiento_rcond" class="form-label">Motivo del Requerimiento</label>
            								<select class="form-select" aria-label="Motivo del Requerimiento" id="txtMotivoRequerimiento_rcond" name="txtMotivoRequerimiento_rcond" data-modal="#registrarCondonacion">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 d-flex justify-content-center align-items-center d-none" id="ctnAdjuntoMotivoRequerimiento_rcond">
        					        <div class="col-7 m-0 p-0">
            					        <input type="file" id="fileAdjuntoMotivoRequermiento_rcond" class="filepond" name="fileAdjuntoMotivoRequermiento_rcond" data-max-file-size="100MB" data-max-files="1" />
            					    </div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div>
        								<label for="txtObservaciones_rcond" class="form-label">Observaciones</label>
        								<textarea class="form-control validarNextTab" id="txtObservaciones_rcond" name="txtObservaciones_rcond" rows="4"></textarea>
        							</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabDetalleFacturas" id="btnNextTab"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar Facturas</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontenDetalleFacturas" role="tabpanel" aria-labelledby="tabDetalleFacturas">
                            <div class="px-3">
                                <div class="row col-12 m-0 p-0 mb-0 d-flex justify-content-center align-items-center">
                                    <div class="col-8 m-0 p-0">
            					        <div class="alert alert-info border-0 text-center" role="alert">
            					            <strong>Para poder subir las facturas a condonar, tienes dos opciones:</strong>
                                            <li>Si son pocas facturas, puedes utilizar el formulario individual para registrar las facturas.</li>
                                            <li>Si las facturas a registrar son varias, puedes utilizar la plantilla masiva para subir un CSV.</li>
                                        </div>
                                    </div>
        					    </div>
                                <ul class="navFacturasCondonaciones nav nav-tabs custom-nav nav-justified animation-nav mb-3" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link active" data-bs-toggle="tab" href="#navFacturasIndividual" role="tab" aria-selected="true">
                                            Individual
                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link" data-bs-toggle="tab" href="#navFacturasMasivo" role="tab" aria-selected="false" tabindex="-1">
                                            Masivo
                                        </a>
                                    </li>
                                </ul>
                                <div class="tab-content px-3">
                                    <div class="tab-pane active show" id="navFacturasIndividual" role="tabpanel">
                                        <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
                    					    Facturas
                    					    <button type="button" class="badge bg-success border-0 p-2" onclick="return agregarRegistroFacturaCondonacion('ctnRegistrosFacturasCondonacion');" data-tooltip="tooltip" aria-label="Agregar Factura">
                                                <i class="mdi mdi-plus" style="font-size: 20px; color: #FFF"></i>
                                            </button>
                    					</div>
                					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
                    						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3 ">
                    							<div>
                    								<label for="txtNroContrato_rcond" class="form-label">Nro Contrato</label>
                    								<input type="text" class="form-control" id="txtNroContrato_rcond" >
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    							<div>
                    								<label for="txtFacturaInterna_rcond" class="form-label">Factura Interna</label>
                    								<input type="text" class="form-control" id="txtFacturaInterna_rcond">
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    							<div>
                    								<label for="txtFacturaExterna_rcond" class="form-label">Factura Externa</label>
                    								<input type="text" class="form-control" id="txtFacturaExterna_rcond">
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                    								<label for="txtTipoFactura_rcond" class="form-label">Tipo de Factura</label>
                    								<select class="form-select" aria-label="Tipo de Factura" id="txtTipoFactura_rcond" data-modal="#registrarCondonacion">
                    									<option value="" selected="">Seleccione una opción</option>
                    									<option value="ND">ND</option>
                    									<option value="O">O</option>
                    									<option value="C">C</option>
                    									<option value="OT">OT</option>
                    									<option value="OI">OI</option>
                    								</select>
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                    								<label for="txtSegmento_rcond" class="form-label">Segmento</label>
                    								<select class="form-select" aria-label="Segmento" id="txtSegmento_rcond" data-modal="#registrarCondonacion">
                    									<option value="" selected="">Seleccione una opción</option>
                    									<option value="HBFEPE">HBFEPE</option>
                    									<option value="HBFDPE">HBFDPE</option>
                    								</select>
                    							</div>
                    						</div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                        							<label for="txtDeudaTotal_rcond" class="form-label">Deuda Total Factura</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">S/.</span>
                                                        <input type="text" step="0.01" class="form-control evaluar-moneda-decimal" aria-label="Deuda Total" id="txtDeudaTotal_rcond" placeholder="Deuda Total" pattern="^\d+(\.\d+)?$"  title="Solo números y un punto decimal">
                                                    </div>
                                                </div>
                                            </div>
                    						<div class="col-xxl-4 col-md-12 col-12 px-3 mb-3 ">
                    						    <div>
                        							<label for="txtImporte_rcond" class="form-label">Importe Condonar</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">S/.</span>
                                                        <input type="text" step="0.01" class="form-control evaluar-moneda-decimal" aria-label="Importe" id="txtImporte_rcond" placeholder="Importe" pattern="^\d+(\.\d+)?$"  title="Solo números y un punto decimal">
                                                    </div>
                                                </div>
                                            </div>
                					    </div>
                					    <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
                    					    Registros
                    					</div>
                    					<div class="row col-12 m-0 p-0 mb-3 d-flex" id="ctnRegistrosFacturasCondonacion">
                    						
                					    </div>
                                    </div>
                                    <div class="tab-pane" id="navFacturasMasivo" role="tabpanel">
                                        <div class="col-12 mb-3">
                						<h4>Consideraciones:</h4>
                						<ol>
                						    <li>Información de columna [FACTURA INTERNA]: Factura interna a condonar.</li>
                						    <li>Información de columna [FACTURA EXTERNA]: Factura externa a condonar.</li>
                						    <li>Información de columna [SEGMENTO]: [HBFEPE, HBFDPE].</li>
                						    <li>Información de columna [IMPORTE]: Importe en soles a condonar.</li>
                						    <li>Información de columna [TIPO DE FACTURA]: [ND, O, C, OT, OI]</li>
                						    <li>Información de columna [MES DE CAMPAÑA]: Mes de campaña de la oferta de condonaciones (COBRANZAS)</li>
                						</ol>
                						<ul>
                						    <li style="color: blue;">Los valores de monedas deben ser enteros (no 3,999 para indicar 3999) y solo usar punto(.) para separar enteros de decimales (3999.99).</li>
                						    <li style="color: blue;">Evitar espacios en blanco al inicio y al final del campo</li>
                						    <li style="color: red;">Si deja vacío la columna [MES DE CAMPAÑA], se va a considerar nulo.</li>
                						</ul>
                					</div>
                					<hr>
                					<h4 class="mb-3">Plantillas:</h4>
                					<div class="row col-12 m-0 p-0">
                					    <div class="col-lg-12 col-12 d-flex justify-content-center align-items-center">
                					        <div class="card card-light">
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-shrink-0">
                                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                                        </div>
                                                        <div class="flex-grow-1 ms-3">
                                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación CSV de Condonaciones</strong> presione el enlace de abajo.</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card-footer">
                                                    <div class="text-center">
                                                        <a class="text-body" href='<?= base_url().'/'.$basePublic.'/docs/Plantillas/plantilla csv condonaciones.csv' ?>' download='Plantilla CSV Condonaciones'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                                    </div>
                                                </div>
                                            </div>
                					    </div>
                					</div>
                					<hr>
                    				<h4 class="mb-3">Importar archivo:</h4>
                					<div class="col-12 mb-0 d-flex justify-content-center">
                					    <div class="col-7 m-0 p-0">
                					        <input type="file" id="fileCSVCondonaciones" class="filepond" name="fileCSVCondonaciones" data-max-file-size="100MB" data-max-files="1" />
                					    </div>
                					</div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionCondonacion"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>