<?php
namespace App\Models;
use CodeIgniter\Model;

class RequerimientosMotivoModel extends Model
{
    protected $table        = 'requerimientos_motivos';
    protected $primaryKey   = 'IDMotivo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDRequerimiento', 'Motivo', 'Observacion', 'RequiereAdjunto', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function buscarMotivoRequerimiento($array)
    {
        $this->select('requerimientos_motivos.IDMotivo,
            requerimientos_motivos.IDRequerimiento,
            requerimientos_motivos.Motivo,
            requerimientos_motivos.RequiereAdjunto,
            requerimientos.Requerimiento,
            requerimientos.Tipo');
        $this->join('requerimientos', 'requerimientos_motivos.IDRequerimiento = requerimientos.IDRequerimiento', 'left');
        
        if(!empty($array))
        {
            if(isset($array['NombreMotivo']) && $array['NombreMotivo'] != '' && $array['NombreMotivo'] != null)
            {
                $this->where('requerimientos_motivos.Motivo', $array['NombreMotivo']);
            }
            
            if(isset($array['IDRequerimiento']) && $array['IDRequerimiento'] != '' && $array['IDRequerimiento'] != null)
            {
                $this->where('requerimientos_motivos.IDRequerimiento', $array['IDRequerimiento']);
            }
            
        }
        
        $datos = $this->first();
        return $datos;
    }
    
    // public function listadoCargosSelect($variable)
    // {
    //     $this->select('IDCargo,
    //         Cargo,
    //         Categoria');
    //     $this->like("Cargo", $variable);
    //     $this->orLike("Categoria", $variable);
        
    //     $datos = $this->findAll();
    //     return $datos;
    // }
}