<?php
namespace App\Models;
use CodeIgniter\Model;

class MatrizCondonacionCobranzaModel extends Model
{
    protected $table        = 'matriz_condonacion_cobranza';
    protected $primaryKey   = 'IDMatriz';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['NroContrato', 'NombreCliente', 'NIF', 'Cartera', 'Descuento', 'DeudaVencida', 'UsuarioRegistra', 'FechaRegistra', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralMatrizCondonacionCobranza($get, $adicionales)
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'NroContrato', 
            1 => 'NombreCliente', 
            2 => 'NIF', 
            3 => 'Cartera', 
            4 => 'Descuento', 
            5 => 'DeudaVencida');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('IDMatriz,
            NroContrato,
            NombreCliente,
            NIF,
            Cartera,
            Descuento,
            DeudaVencida');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('IDMatriz,
            NroContrato,
            NombreCliente,
            NIF,
            Cartera,
            Descuento,
            DeudaVencida');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw' => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal' => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered' => $filteredRecords, // Total de registros después de aplicar filtros
            'data' => $result // Los datos actuales para mostrar
        ];
    }
    
}