<?php namespace App\Models;

use CodeIgniter\Model;

class ItemOfertaGrupoCarteraClienteModel extends Model {
    protected $table = 'ofertanomenclatura_gruposcarteracliente';
    protected $primaryKey = 'IDOfertaNomenclatura';
    protected $allowedFields = ['IDGrupoCarteraCliente', 'IDOfertaNomenclatura', 'UsuarioRegistra', 'FechaRegistra'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes = false;
    
    public function obtenerItemsOferta($grupoTipoCartera,$tiempoOferta)
    {
        $this->select('oferta_nomenclatura.DescripcionSBN, oferta_nomenclatura.IDOfertaNomenclatura, oferta_nomenclatura.Revntype');
        $this->join('oferta_nomenclatura', 'oferta_nomenclatura.IDOfertaNomenclatura = ofertanomenclatura_gruposcarteracliente.IDOfertaNomenclatura');
        $this->where('ofertanomenclatura_gruposcarteracliente.IDGrupoCarteraCliente', $grupoTipoCartera);
        $this->where('oferta_nomenclatura.Duracion', $tiempoOferta);
        $datos = $this->findAll();
        return $datos;
    }
}
