<?php
namespace App\Models;
use CodeIgniter\Model;

class EstructuraSubareaResponsableModel extends Model
{
    protected $DBGroup      = 'baseT';
    protected $table        = 'estructura_subarea_responsable';
    protected $primaryKey   = 'IDSubarea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDSubarea', 'IDResponsable', 'Principal', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoResponsablesSubarea($idSubarea)
    {
        $this->select('
            estructura_subarea_responsable.IDSubarea,
            estructura_subarea_responsable.IDResponsable,
            estructura_subarea_responsable.Principal,
            CONCAT(tblusuario.Nombres, " ", tblusuario.Apellidos) AS "NombreResponsable",
            tblusuario.Matricula AS "MatriculaResponsable",
            tblusuario.Usuario AS "UsuarioResponsable",
            tblusuario.Correo AS "CorreoResponsable",
            cargos.Cargo AS "CargoResponsable"');
        $this->join('tblusuario', 'estructura_subarea_responsable.IDResponsable = tblusuario.IdUsuario', 'left');
        $this->join('cargos', 'tblusuario.IDCargo = cargos.IDCargo', 'left');
        $this->where('estructura_subarea_responsable.IDSubarea', $idSubarea);
        $datos = $this->findAll();
        return $datos;
    }
    
}