<?php
namespace App\Models;
use CodeIgniter\Model;

class CondonacionesCobranzasModel extends Model
{
    protected $table        = 'condonaciones_cobranzas';
    protected $primaryKey   = 'IDSolicitudCobranza';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['NroContrato', 'Cliente', 'NIF', 'Cartera', 'Descuento', 'DeudaVencida', 'ImporteTotalCondonar', 'MesCampana', 'FechaCompromisoPago', 'Observacion', 'UsuarioCrea', 'IDDireccionCrea', 'IDAreaCrea', 'IDSubareaCrea', 'IDDelegacionCrea', 'IDCargoCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listaGeneralCondonacionesCobranzas($get, $adicionales)
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
        
        $fields = array(
            0 => 'IDSolicitudCobranza', 
            1 => 'FechaCrea', 
            2 => 'NroContrato', 
            2 => 'Cartera', 
            3 => 'DeudaVencida', 
            4 => 'ImporteTotalCondonar', 
            5 => 'Descuento', 
            6 => 'MesCampana', 
            7 => 'FechaCompromisoPago', 
            8 => 'Observacion');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('IDSolicitudCobranza,
            FechaCrea,
            NroContrato,
            Cartera,
            DeudaVencida,
            ImporteTotalCondonar,
            Descuento,
            MesCampana,
            FechaCompromisoPago,
            Observacion,
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('IDSolicitudCobranza,
            FechaCrea,
            NroContrato,
            Cartera,
            DeudaVencida,
            ImporteTotalCondonar,
            Descuento,
            MesCampana,
            FechaCompromisoPago,
            Observacion,
            Estado');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
            
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * LIMITAR CANTIDAD DE RESULTADOS DE QUERY
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->limit($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Antes de Codeiginiter 4.5.4*/
        // $this->get();
        // return $this->getLastQuery();
        
        // $result = $this->get()->getResultArray();
        // return $result;
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        // echo $this->getLastQuery();
        // exit;
        
        // return $result;
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw' => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal' => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered' => $filteredRecords, // Total de registros después de aplicar filtros
            'data' => $result // Los datos actuales para mostrar
        ];
    }
    
    public function obtenerCondonacionCobranza($array)
    {
        $builder = $this->db->table('vista_general_condonaciones_cobranza');
        
        if(!empty($array))
        {
            if(isset($array['IDSolicitudCobranza']) && $array['IDSolicitudCobranza'] != '' && $array['IDSolicitudCobranza'] != null)
            {
                $builder->where('IDSolicitudCobranza', $array['IDSolicitudCobranza']);
            }
            
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getRowArray();
        
        return $datos;
    }
}