<?php
namespace App\Models;
use CodeIgniter\Model;

class CondonacionesCobranzasAprobacionModel extends Model
{
    protected $table        = 'condonaciones_cobranzas_aprobacion';
    protected $primaryKey   = 'IDAprobacionCobranza';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDSolicitudCobranza', 'IDUsuarioAprobacion', 'IDDireccionAprobacion', 'IDAreaAprobacion', 'IDSubareaAprobacion', 'IDDelegacionAprobacion', 'IDCargoAprobacion', 'Observacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarAprobadoresCondonacionCobranza($array)
    {
        $builder = $this->db->table('vista_aprobadores_condonaciones_cobranza');
        
        if(!empty($array))
        {
            if(isset($array['arrayIDSolicitudCobranza']) && $array['arrayIDSolicitudCobranza'] != '' && $array['arrayIDSolicitudCobranza'] != null)
            {
                $builder->whereIn('IDSolicitudCobranza', $array['arrayIDSolicitudCobranza']);
            }
            
            if(isset($array['IDSolicitudCobranza']) && $array['IDSolicitudCobranza'] != '' && $array['IDSolicitudCobranza'] != null)
            {
                $builder->where('IDSolicitudCobranza', $array['IDSolicitudCobranza']);
            }
            
            if(isset($array['Estado']) && $array['Estado'] != '' && $array['Estado'] != null)
            {
                $builder->where('EstadoAprobacionCobranza', $array['Estado']);
            }
            
            if(isset($array['Aprobador']) && $array['Aprobador'] != '' && $array['Aprobador'] != null)
            {
                $builder->where('IDUsuarioAprobacionCobranza', $array['Aprobador']);
            }
            
            if(isset($array['IDAprobacionCobranza']) && $array['IDAprobacionCobranza'] != '' && $array['IDAprobacionCobranza'] != null)
            {
                $builder->where('IDAprobacionCobranza', $array['IDAprobacionCobranza']);
            }
        }
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
}