<?php
namespace App\Models;
use CodeIgniter\Model;

class CondonacionesBitacoraModel extends Model
{
    protected $table        = 'condonaciones_bitacora';
    protected $primaryKey   = 'IDBitacoraCondonacion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDCondonacion', 'IDFacturaCondonacion', 'IDAprobacion', 'Accion', 'ValorBitacora', 'Comentario', 'Link', 'UsuarioRegistra', 'FechaRegistra', 'Localhost', 'Estado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarBitacoraCondonacion($array)
    {
        $builder = $this->db->table('vista_condonaciones_bitacora');
        
        if(!empty($array))
        {
            if(isset($array['idCondonacion']) && $array['idCondonacion'] != '' && $array['idCondonacion'] != null)
            {
                $builder->where('IDCondonacion', $array['idCondonacion']);
                
                if(isset($array['exCondonacion']) && $array['exCondonacion'] == 'Y')
                {
                    $builder->where('IDAprobacion IS NULL');
                    $builder->where('IDFacturaCondonacion IS NULL');
                }
            }
            
            if(isset($array['idAprobacion']) && $array['idAprobacion'] != '' && $array['idAprobacion'] != null)
            {
                $builder->where('IDAprobacion', $array['idAprobacion']);
            }
            
            if(isset($array['idFactura']) && $array['idFactura'] != '' && $array['idFactura'] != null)
            {
                $builder->where('IDFacturaCondonacion', $array['idFactura']);
            }
            
        }
        
        $builder->orderBy('FechaRegistra', 'DESC');
        
        $sql = $builder->getCompiledSelect();
        $datos = $this->db->query($sql)->getResultArray();
        
        return $datos;
    }
    
}