<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ADDREQ", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-requerimiento" data-bs-toggle="modal" data-bs-target="#informacionRequerimiento" data-id="0" data-accion="crear" id="crear-requerimiento">
									<i class="mdi mdi-plus-circle"></i> Añadir
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblRequerimientos" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Requerimiento</th>
										<th class="text-center align-middle">Tipo</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach($listadoRequerimientos as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDRequerimiento'] ?></td>
										<td class="text-center align-middle"><?= $items['Requerimiento'] ?></td>
										<td class="text-center align-middle"><?= $items['Tipo'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle">
											<?php
											if (in_array("ESTREQ", $permisos)) 
											{
											?>
											<button class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0 cambiar-estado-requerimiento" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IDRequerimiento'] ?>">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</button>
											<?php
											}
											else
											{
											?>
											<span class="badge <?= $items['Estado'] == 'A' ? 'bg-success' : 'bg-warning' ?> border-0">
												<?= $items['Estado'] == 'A' ? 'ACTIVO' : 'INACTIVO' ?>
											</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
												<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-requerimiento" data-bs-toggle="modal" data-bs-target="#informacionRequerimiento" data-id="<?= $items['IDRequerimiento'] ?>" data-accion="ver" id="ver-requerimiento">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDREQ", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-requerimiento" data-bs-toggle="modal" data-bs-target="#informacionRequerimiento" data-id="<?= $items['IDRequerimiento'] ?>" data-accion="editar" id="editar-requerimiento">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													
													if (in_array("ADMORE", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-motivos-requerimiento/<?= $items['IDRequerimiento'] ?>" class="dropdown-item">
															<i class="mdi mdi-graph align-bottom me-2 text-muted"></i> Motivos
														</a>
													</li>
													<?php
													}
													
													if (in_array("ASPERE", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-perfiles-requerimiento/<?= $items['IDRequerimiento'] ?>" class="dropdown-item">
															<i class="mdi mdi-scale-balance align-bottom me-2 text-muted"></i> Perfiles
														</a>
													</li>
													<?php
													}
													
													if (in_array("ASGTRE", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/listar-grupos-trabajo-requerimiento/<?= $items['IDRequerimiento'] ?>" class="dropdown-item">
															<i class="mdi mdi-account-group align-bottom me-2 text-muted"></i> Grupos de Trabajo
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <script>document.write(new Date().getFullYear())</script> © Verisure Peru.
                </div>
                <div class="col-sm-6">
                    <div class="text-sm-end d-none d-sm-block">Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</div>
<!-- end main content-->
<!-- Modal Información Requerimiento -->
<div class="modal fade" id="informacionRequerimiento" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionRequerimiento" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionRequerimiento">Información de Requerimiento</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionRequerimiento" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDRequerimiento_i" name="txtIDRequerimiento_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtRequerimiento_i" class="form-label">Requerimiento</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Requerimiento" id="txtRequerimiento_i" name="txtRequerimiento_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtTipoRequerimiento_i" class="form-label">Tipo</label>
								<select class="form-select" aria-label="Cabecera" id="txtTipoRequerimiento_i" name="txtTipoRequerimiento_i">
									<option selected="" value="">Seleccione una opción</option>
									<option value="SOLICITUD">Solicitud</option>
									<option value="RECLAMO">Reclamo</option>
									<option value="OTROS">Otros</option>
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<div>
								<label for="txtObservacionRequerimiento_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionRequerimiento_i" name="txtObservacionRequerimiento_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarRequerimiento" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>