<?php namespace App\Models;

use CodeIgniter\Model;

class RequerimientosGruposTrabajoModel extends Model {
    
    protected $table = 'requerimientos_grupostrabajo';
    protected $primaryKey = 'IDRequerimiento';
    protected $allowedFields = ['IDRequerimiento', 'IDGrupoTrabajo', 'UsuarioRegistra', 'FechaRegistra'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes = false;
    
    public function listarGruposTrabajoRequerimiento($idRequerimiento)
    {
      $this->select('grupostrabajo.IDGrupoTrabajo,
        grupostrabajo.GrupoTrabajo,
        IF(requerimientos_grupostrabajo.IDGrupoTrabajo IS NULL, 0, 1) AS "ACTIVO"');
      $this->join('grupostrabajo', 'requerimientos_grupostrabajo.IDGrupoTrabajo = grupostrabajo.IDGrupoTrabajo AND requerimientos_grupostrabajo.IDRequerimiento = "'.$idRequerimiento.'"', 'right');
      
      $datos = $this->findAll();
      return $datos;
    }
    
    public function listarGruposTrabajoRequerimientoXRequerimiento($idRequerimiento)
    {
      $this->select('grupostrabajo.IDGrupoTrabajo,
        grupostrabajo.GrupoTrabajo');
      $this->join('grupostrabajo', 'requerimientos_grupostrabajo.IDGrupoTrabajo = grupostrabajo.IDGrupoTrabajo AND requerimientos_grupostrabajo.IDRequerimiento = "'.$idRequerimiento.'"');
      
      $datos = $this->findAll();
      return $datos;
    }

    public function listadoTipoRequerimientos($array)
    {
        $this->distinct();
        $this->select('requerimientos.Tipo');
        $this->join('requerimientos', 'requerimientos.IDRequerimiento = requerimientos_grupostrabajo.IdRequerimiento');
        $this->where('requerimientos_grupostrabajo.IDGrupoTrabajo', $array['grupoTrabajo']);
        
        if(!empty($array))
        {
            if(isset($array['estado']) && !empty($array['estado']))
            {
                $this->where('requerimientos.Estado', $array['estado']);
            }
            
        }
        $datos = $this->findAll();
        return $datos;
    }      
    
}
