<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Globales;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Peticiones extends BaseController
{
	public function __construct(){
	    $this->peticiones = new \App\Models\PeticionesModel();
	    $this->peticionesComentarios = new \App\Models\PeticionesComentariosModel();
	    $this->peticionesAdjuntos = new \App\Models\PeticionesAdjuntosModel();
	    
        $this->usuarios = new \App\Models\UsuarioModel();
	    
        $this->estructuraDirecciones = new \App\Models\EstructuraDireccionModel();
        $this->estructuraAreas = new \App\Models\EstructuraAreaModel();
        $this->estructuraSubareas = new \App\Models\EstructuraSubareaModel();
        $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
        $this->cargos = new \App\Models\CargosModel();
        
        $this->grupostrabajo = new \App\Models\GruposTrabajoModel();
		$this->gruposTrabajoUsuario = new \App\Models\UsuarioGruposTrabajoModel();
		
        $this->auditoria = new \App\Models\AuditoriaModel();
        $this->notificaciones = new \App\Models\NotificacionesModel();
        $this->notificacionesVistos = new \App\Models\NotificacionesVisualizadasModel();
//  		$this->requerimientos = new \App\Models\RequerimientosModel();
//  		$this->requerimientosPerfil = new \App\Models\RequerimientosPerfilModel();
		$this->requerimientosMotivo = new \App\Models\RequerimientosMotivoModel();
//         $this->usuarioPerfil = new \App\Models\UsuarioPerfilModel();
//         $this->usuarioPermisos = new \App\Models\UsuarioPermisosModel();
//         $this->usuarioRutas = new \App\Models\UsuarioRutasModel();
	}
	
	public function insertarNotificacion($array)
	{
	    $tablaReferencia        = $array['tabla'];
        $idReferencia           = $array['idreferencia'];
        $mensaje                = $array['mensaje'];
        $url                    = $array['url'];
        $usuarioDestino         = $array['usuariodestino'];
        $idGrupoTrabajoDestino  = $array['gtdestino'];
        $idPerfilDestino        = $array['perfildestino'];
        $usuarioRegistra        = $array['usuarioregistra'];
        $fechaRegistra          = $array['fecharegistra'];
        
        $dataNotificacion = array (
            'TablaReferencia'       => $tablaReferencia, 
            'IDReferencia'          => $idReferencia,
            'Mensaje'               => $mensaje, 
            'URL'                   => $url, 
            'IDUsuarioDestino'      => $usuarioDestino, 
            'IDGrupoTrabajoDestino' => $idGrupoTrabajoDestino, 
            'IDPerfilDestino'       => $idPerfilDestino,
            'UsuarioRegistra'       => $usuarioRegistra,
            'FechaRegistra'         => $fechaRegistra
        );
        
        $this->notificaciones->insert($dataNotificacion, TRUE);
	}
	
	public function marcarVisualizadoNotificacionMasivo($array)
	{
	    $fechaActual = date("Y-m-d H:i:s");

	    $notificaciones = $this->notificaciones->listarNotificaciones($array);
	    
	    if(!empty($notificaciones))
	    {
		    $dataNotifVistos = array();
		    
            foreach($notificaciones as $item)
            {
                $dataNotifVistos[] = array (
                    'IDNotificacion'    => $item['IDNotificacion'], 
                    'UsuarioVisualizado'=> $this->items['id'],  
                    'FechaVisualizado'  => $fechaActual
                );

            }
            
            $this->notificacionesVistos->insertBatch($dataNotifVistos);
	    }
	}

    public function listarPeticiones(){
		if(isset($this->items['id'])){

			/* ACCIONES */
			
		    //GRUPO QUE PERTENEZCO Y ASIGNADOS
			$gruposTrabajoHabilitados = $this->gruposTrabajoUsuario->where("IdUsuario", $this->items['id'])->findAll();
			$gruposTrabajoHabilitadosActivos = $this->grupostrabajo->where("Estado", "A")->findAll();
			$obtenerDelegacionesUsuario = $this->usuarios->obtenerDelegacionesUsuario($this->items['id']);
// 			if($this->items['id'] == "3660")
// 			{
// 			    var_dump($obtenerDelegacionesUsuario); exit;
// 			}
			
			
            $where = array(
		        "IDUsuario"      => $this->items['id'],
		        "IDPerfil"      => $this->items['idPerfil'],
		        "IDArea"        => $this->items['idArea'],
		        "asignado"      => $this->items['id'],
			    "grupoTrabajo"  => array_column($gruposTrabajoHabilitados,"IDGrupoTrabajo"),
			    "delegaciones"  => array_column($obtenerDelegacionesUsuario, "IDDelegacion")
		    );
            
			$listadoPeticiones = $this->peticiones->listadoPeticiones($where);
// 						if($this->items['id'] == "3660")
// 			{
// 			    echo $listadoPeticiones; exit;
// 			}
// 			if($this->items['id'] == "4373")
// 			{
            $whereTotal = array(
		        "idperfil"      => $this->items['idPerfil'],
		        "idusuario"     => $this->items['id'],
			    "grupostrabajo" => array_column($gruposTrabajoHabilitados,"IDGrupoTrabajo"),
			    "delegaciones"  => array_column($obtenerDelegacionesUsuario, "IDDelegacion")
		    );
            
            $whereMes = array(
		        "idperfil"      => $this->items['idPerfil'],
		        "idusuario"     => $this->items['id'],
			    "grupostrabajo" => array_column($gruposTrabajoHabilitados,"IDGrupoTrabajo"),
			    "delegaciones"  => array_column($obtenerDelegacionesUsuario, "IDDelegacion"),
		        "mes"           => date("m")
		    );
            
            $wherePendientes = array(
		        "idperfil"      => $this->items['idPerfil'],
		        "idusuario"     => $this->items['id'],
			    "grupostrabajo" => array_column($gruposTrabajoHabilitados,"IDGrupoTrabajo"),
			    "delegaciones"  => array_column($obtenerDelegacionesUsuario, "IDDelegacion"),
		        "estadosno"     => array("COMP", "APRO", "CANC", "AA"),
		    );
            
            $whereSinIniciar = array(
		        "idperfil"      => $this->items['idPerfil'],
		        "idusuario"     => $this->items['id'],
			    "grupostrabajo" => array_column($gruposTrabajoHabilitados,"IDGrupoTrabajo"),
			    "delegaciones"  => array_column($obtenerDelegacionesUsuario, "IDDelegacion"),
		        "estado"        => "CREA"
		    );
            // var_dump($this->peticiones->obtenerCantidadPeticiones($whereTotal)); exit;
			$totalTickets = count($this->peticiones->obtenerCantidadPeticiones($whereTotal));
			$totalMes = count($this->peticiones->obtenerCantidadPeticiones($whereMes));
			$pendientesGeneral = count($this->peticiones->obtenerCantidadPeticiones($wherePendientes));
			$noIniciados = count($this->peticiones->obtenerCantidadPeticiones($whereSinIniciar));
			
// 			}
// 			else
// 			{
// 			$totalTickets = count($this->peticiones->findAll());
// 			$totalMes = count($this->peticiones->where("MONTH(FechaCrea)", date("m"))->findAll());
// 			$pendientesGeneral = count($this->peticiones->whereNotIn("Estado", array("COMP", "APRO", "CANC", "AA"))->findAll());
// 			$noIniciados = count($this->peticiones->where("Estado", "CREA")->findAll());
// 			}
			
			$cantidadesGenerales = array(
			    "Totales"       => $totalTickets,
			    "Mes"           => $totalMes,
			    "Pendientes"    => $pendientesGeneral,
			    "NoIniciados"   => $noIniciados
			);
			
            foreach($listadoPeticiones as $key=>$item)
            {
                $array = array(
                    "idusuario"         => $this->items['id'],
                    "grupoTrabajo"      => array_column($gruposTrabajoHabilitados,"IDGrupoTrabajo"),
                    "idperfil"          => $this->items['idPerfil'],
                    "solonovisto"       => "Y",
                    "idreferencia"      => $item['IDPeticion'],
                    "tablareferencia"   => "peticiones"
                );
                
    		    $notificaciones = $this->notificaciones->listarNotificaciones($array);
    		    
                $listadoPeticiones[$key]['NotificacionesNoVistas'] = count($notificaciones);
    		    
                $solicitante = $this->usuarios->where("IdUsuario ", $item['UsuarioCrea'])->first();
                $listadoPeticiones[$key]['UsuarioSolicitante'] = $solicitante['Nombres'].' '.$solicitante['Apellidos'];
                $listadoPeticiones[$key]['MatriculaSolicitante'] = $solicitante['Matricula'];
                
                $direccionSolicitante = $this->estructuraDirecciones->where("IDDireccion", $item['IDDireccionCrea'])->first();
                $areaSolicitante = $this->estructuraAreas->where("IDArea", $item['IDAreaCrea'])->first();
                $subareaSolicitante = $this->estructuraSubareas->where("IDSubarea", $item['IDSubareaCrea'])->first();
                $delegacionSolicitante = $this->estructuraDelegaciones->where("IDDelegacion", $item['IDDelegacionCrea'])->first();
                
                $listadoPeticiones[$key]['DireccionSolicitante'] = $direccionSolicitante['Direccion'];
                $listadoPeticiones[$key]['AreaSolicitante'] = $areaSolicitante['Area'];
                $listadoPeticiones[$key]['SubareaSolicitante'] = $subareaSolicitante['Subarea'];
                $listadoPeticiones[$key]['DelegacionSolicitante'] = $delegacionSolicitante['CC'].' - '.$delegacionSolicitante['LN'].' | '.$delegacionSolicitante['Delegacion'];
            
                $cambio = $this->usuarios->where("IdUsuario ", $item['UsuarioEstado'])->first();
                $listadoPeticiones[$key]['NombreUsuarioEstado'] = $cambio['Nombres'].' '.$cambio['Apellidos'];
                $listadoPeticiones[$key]['MatriculaUsuarioEstado'] = $cambio['Matricula'];
            }
            
            $estados = $this->globales->estadosPeticion();
    
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Peticiones | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de Peticiones',
				'listadoPeticiones'     => $listadoPeticiones,
				'estadosPeticion'       => $estados,
				'cantidadesGenerales'   => $cantidadesGenerales,
				'listadoGruposTrabajos' => $gruposTrabajoHabilitadosActivos
			);
			
			$data = array_merge($data, $this->items);
			return view('peticiones/listar_peticiones',$data);			
		} else {
			return view('errors/500');
		}
	}
	
	public function peticionesServersideHistorico()
	{
	    $busqueda = false;
	    $orderBy = " ORDER BY ";
	    
	    $gruposTrabajoHabilitados = $this->gruposTrabajoUsuario->where("IdUsuario", $this->items['id'])->findAll();
	    $gtusuario = array_column($gruposTrabajoHabilitados,"IDGrupoTrabajo");

        foreach ($this->request->getGet('order') as $order) {
            $orderBy .= $order['column'] + 1 . " {$order['dir']}, ";
        }

        $orderBy = substr($orderBy, 0, -2);
        $columns = $this->request->getGet('columns');
        $fields = ['IDPeticion', 'FechaCrea', 'FechaEstado', 'DelegacionSolicitante', 'PerfilSolicitante', 'NroProspecto', 'Requerimiento', 'Motivo', 'NombreUsuarioEstado', 'GrupoTrabajo', 'Estado', 'acciones_usuario'];
        $where = '';
        // echo $this->items['idPerfil']; exit;
		if($this->items['idPerfil'] != 1)
		{
            if(empty($gtusuario))
            {
                $where .= '(UsuarioCrea = "'.$this->items['id'].'") AND (';
            }
            else
            {
                $where .= '(UsuarioCrea = "'.$this->items['id'].'" OR IDGrupoTrabajoDestino IN ("'.implode('","',$gtusuario).'") ) AND (';
            }
		}
        
        foreach ($columns as $k => $column) {
            if ($this->request->getGet('search')['value']!="") {
                $busqueda = true;
                if($k == 11){}
                else
                {
                    $where .= $fields[$k]." LIKE '%".$this->request->getGet('search')['value']."%' OR ";
                }
                
            }
        }
        
        if($busqueda)
        {
            $where = substr($where, 0, -4);
            
            if($this->items['idPerfil'] != 1)
		    {
                $where.=')';
		    }
        }
        else
        {
            $where = substr($where, 0, -6);
        }

        $length = $this->request->getGet('length');
        $start = $this->request->getGet('start'); 

        /* LISTAR ORDEN DE COMPRA */
        $listaPeticiones = $this->peticiones->listaGeneralPeticiones($orderBy,$where,$length,$start);
        // echo $listaPeticiones; exit;
        echo json_encode($listaPeticiones, JSON_NUMERIC_CHECK);
	}
	
	public function registrarPeticionoficial()
	{
	    $fechaActual = date("Y-m-d H:i:s");
	    $peticion       = $this->request->getPost('nombreAdjunto');
	    $adjuntos = $this->request->getFiles("fileAdjunto"); 
	    $message = '';
	    if(!empty($adjuntos))
	    {
	        foreach ($adjuntos['fileAdjunto'] as $key => $value) 
	        {
	           // echo $key."<br>";
                if ($value->isValid() && ! $value->hasMoved()) 
                {
                    if($value->guessExtension() != null)
                    {
                        $extensionDoc = $value->guessExtension();
                    }
                    else
                    {
                        $nombre_original = $value->getBasename();
                        $fileNameCmps = explode(".", $nombre_original);
                        $extensionDoc = strtolower(end($fileNameCmps));
                    }
                    
                    /*
                    * ----------------------------
                    * GUARDAR ARCHIVO ADJUNTO
                    * ----------------------------
                    */
                    $ruta = "app/Files/Peticiones/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                    $nombreArchivo = $peticion[$key];
            
                    if(!file_exists($ruta))
                    {
                        @mkdir($ruta, 0777, true);
                    }
            
            		# si exsite la carpeta o se ha creado
            		if (file_exists($ruta) || @mkdir($ruta)) 
                    {
                        $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
                        
                        $estadoMove = $value->move($ruta, $nuevonombre);
                        
                        if (!$estadoMove) {
                            $message .= sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC1]");
                            $resultado = array(
                				'prospecto' => (string) false,
                				'mensaje1'  => (string) "",
                				'mensaje2'  => (string) $this->alertas->alertaError($message)
                			);
                        }
                        else
                        {
                            $message .= sprintf($this->mensajeError->msg201, "IMAGEN GUARDADA, CONTADOR");
                            $resultado = array(
                				'prospecto' => (string) false,
                				'mensaje1'  => (string) "",
                				'mensaje2'  => (string) $this->alertas->alertaExito($message)
                			);
                        }
                    }
                    else
                    {
                        $message .= sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. <br>Ruta no encontrada.[SAVEDOC2]");
                        
                        $resultado = array(
            				'prospecto' => (string) false,
            				'mensaje1'  => (string) "",
            				'mensaje2'  => (string) $this->alertas->alertaError($message)
            			);
                    }
                }
            }
	    }
	    else
	    {
	        $message .= sprintf($this->mensajeError->msg201, "No hay archivos adjuntos.");
	        $resultado = array(
				'prospecto' => (string) false,
				'mensaje1'  => (string) "",
				'mensaje2'  => (string) $this->alertas->alertaError($message)
			);
	    }
			echo json_encode($resultado);
			EXIT;
	   // if ( $adjunto->isValid())
	   // {
	        
	   // }
	    
	}
	
	public function registrarPeticion()
	{
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $lblRequerimiento   = $this->request->getPost('txtRequerimientoTextPeticion');
        $peticion       = $this->request->getPost('txtPeticion_i');
        $prospecto      = $this->request->getPost('txtNroProspectoPeticion_i');
        $motivoReq      = $this->request->getPost('txtMotivoRequerimiento_i');
        $req            = $this->request->getPost('txtRequerimiento_i');
        $detalleReq     = $this->request->getPost('txtDetallePeticion_i');
        $linkReq        = $this->request->getPost('txtLinkPeticion_i');
        $grupoTrabajo   = $this->request->getPost('txtGruposTrabajoPeticion_i');
        $formulario     = $this->request->getPost('txtFormularioRegistrarPeticion');
        $contrato      = $this->request->getPost('txtNroContratoPeticion_i');
	    $nombresAdjuntos= $this->request->getPost('nombreAdjunto');

        $presupuestoasignado = $this->request->getPost('txtPresupuestoAsignado_i');
        $producto      = $this->request->getPost('txtMarcaModelo_i');
        $cantidad      = $this->request->getPost('txtCantidad_i');
        $moneda        = $this->request->getPost('cboMoneda');

	    $adjuntos       = $this->request->getFiles("fileAdjunto"); 
        
        if($peticion == '')
        {
            $peticion = trim($lblRequerimiento);
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($peticion, 'required|trim|alphaspecial', 'Petición');
        
        $error .= $this->complementos->validaCampo($motivoReq, 'required|trim|numeric', 'Motivo del Requerimiento');
        $error .= $this->complementos->validaCampo($linkReq, 'trim|url', 'Link Asociado');
        $error .= $this->complementos->validaCampo($grupoTrabajo, 'required|trim|numeric', 'Grupo Destino');
        

        if($grupoTrabajo==1){
            if($prospecto != '')
            {
                $error .= $this->complementos->validaCampo($prospecto, 'required|trim|numeric|minlength[6]|maxlength[6]', 'Nro Prospecto');
            }            
        }
        if($grupoTrabajo==3){
            if($contrato != '')
            {
                $error .= $this->complementos->validaCampo($contrato, 'required|trim|numeric|minlength[7]|maxlength[7]', 'Nro Contrato');
            }            
        }
        
        if($grupoTrabajo==4){
            $error .= $this->complementos->validaCampo($presupuestoasignado, 'required|trim|float', 'Presupuesto Asignado');
            $error .= $this->complementos->validaCampo($producto, 'required|trim|minlength[1]|maxlength[200]', 'Marca / Modelo');
            $error .= $this->complementos->validaCampo($cantidad, 'required|trim|numeric|minlength[1]', 'Cantidad');
            $error .= $this->complementos->validaCampo($moneda,  'required|trim|alpha|minlength[1]|maxlength[5]', 'Tipo Moneda');
            
        }


        
        if($req != 1)
        {
            $error .= $this->complementos->validaCampo($detalleReq, 'required|trim', 'Detalle del requerimiento');
        }
        
    //     if(empty($adjuntos))
	   // {
	   //     $error .= "<li>No hay archivos adjuntos. [CAMPO] <small>ARCHIVOS ADJUNTOS</small></li>";
	   // }
	    
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            // echo $this->alertas->alertaError($message);
            // EXIT;
            $resultado = array(
				'prospecto' => (string) false,
				'mensaje1'  => (string) "",
				'mensaje2'  => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */
        $message = '';
        
        $idVentaProspecto = NULL;
        
        if($prospecto != "" && $prospecto != null)
        {
            $infoProspecto = $this->peticiones->buscarInformacionProspectoPeticion($prospecto);
            if(!empty($infoProspecto))
            {
                $idVentaProspecto = $infoProspecto['VENTA'];
            }
        }
        
        $dataPeticion = array (
            'Peticion'              => $peticion, 
            'NroProspecto'          => $prospecto == '' ? null : $prospecto,
            'IDVentaProspecto'      => $idVentaProspecto,
            'IDMotivo'              => $motivoReq, 
            'Detalle'               => $detalleReq, 
            'LinkAsociado'          => $linkReq, 
            'IDGrupoTrabajoDestino' => $grupoTrabajo, 
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,
            'IDSubareaCrea'         => $this->items['idSubarea'], 
            'IDAreaCrea'            => $this->items['idArea'], 
            'IDDireccionCrea'       => $this->items['dpto'], 
            'IDPerfilCrea'          => $this->items['idPerfil'],
            'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
            'IDCargoCrea'           => $this->items['idCargoLog'],
            'Estado'                => "CREA", 
            'UsuarioEstado'         => $this->items['id'],
            'IDDireccionEstado'     => $this->items['dpto'], 
            'IDAreaEstado'          => $this->items['idArea'], 
            'IDSubareaEstado'       => $this->items['idSubarea'], 
            'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
            'IDPerfilEstado'        => $this->items['idPerfil'],
            'IDCargoEstado'         => $this->items['idCargoLog'],
            'FechaEstado'           => $fechaActual,
            'MotivoEstado'          => $peticion.': '.$detalleReq,
            'Localhost'             => $this->request->getIPAddress(),
            'NroContrato'           => $contrato == '' ? null : $contrato,
            'PresupuestoAsignado'   => $presupuestoasignado == '' ? null : $presupuestoasignado,
            'Producto'              => $producto == '' ? null : $producto,
            'Cantidad'              => $cantidad == '' ? null : $cantidad,
            'TipoMoneda'            => $moneda == '' ? null : $moneda

        );
        
        $lastId = $this->peticiones->insert($dataPeticion, TRUE);
		if($lastId !== FALSE)
		{
		    /*
            * ----------------------------
            * INSERCIÓN DE NOTIFICACIÓN
            * ----------------------------
            */
		    $nuevaNotificacion = array (
                'tabla'             => 'peticiones', 
                'idreferencia'      => $lastId,
                'mensaje'           => "Se ha <span class='color-crea'>CREADO</span> una nueva petición.", 
                'url'               => "detalle-peticion/".$lastId, 
                'usuariodestino'    => null, 
                'gtdestino'         => $grupoTrabajo, 
                'perfildestino'     => null,
                'usuarioregistra'   => $this->items['id'],
                'fecharegistra'     => $fechaActual
            );
		    $this->insertarNotificacion($nuevaNotificacion);
		    
		    /*
            * ----------------------------
            * INSERTAR ADJUNTOS SI ES QUE HAY
            * ----------------------------
            */
            
		    if(!empty($adjuntos))
    	    {
    	        $adjuntosGuardados = 0;
    	        $adjuntosNoGuardados = 0;
    	        foreach ($adjuntos['fileAdjunto'] as $key => $value) 
    	        {
    	           // echo $key."<br>";
                    if ($value->isValid() && ! $value->hasMoved()) 
                    {
                        if($value->guessExtension() != null)
                        {
                            $extensionDoc = $value->guessExtension();
                        }
                        else
                        {
                            $nombre_original = $value->getBasename();
                            $fileNameCmps = explode(".", $nombre_original);
                            $extensionDoc = strtolower(end($fileNameCmps));
                        }
                        
                        $nombreArchivo = $nombresAdjuntos[$key];
                        /*
                        * ----------------------------
                        * GUARDAR ARCHIVO ADJUNTO
                        * ----------------------------
                        */
                        $dataAdjunto = array (
                            'IDPeticion'            => $lastId, 
                            'Nombre'                => $nombreArchivo,
                            'Extension'             => $extensionDoc, 
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,
                            'Localhost'             => $this->request->getIPAddress()
                        );
                        
                        $lastIdAdjunto = $this->peticionesAdjuntos->insert($dataAdjunto, TRUE);
                        
                        if($lastIdAdjunto !== FALSE)
		                {
                            /*
                            * ----------------------------
                            * GUARDAR ARCHIVO ADJUNTO
                            * ----------------------------
                            */
                            $ruta = "public/files/Peticiones/".date("Y", strtotime($fechaActual))."/".date("m", strtotime($fechaActual))."/";
                            
                            if(!file_exists($ruta))
                            {
                                @mkdir($ruta, 0777, true);
                            }
                    
                    		# si exsite la carpeta o se ha creado
                    		if (file_exists($ruta) || @mkdir($ruta)) 
                            {
                                $nuevonombre = $lastIdAdjunto.'-'.$lastId.'-'.$nombreArchivo.'.'.$extensionDoc;
                                
                                $estadoMove = $value->move($ruta, $nuevonombre);
                                
                                if (!$estadoMove) {
                                    $adjuntosNoGuardados++;
                                }
                                else
                                {
                                    $adjuntosGuardados++;
                                }
                            }
                            else
                            {
                                $adjuntosNoGuardados++;
                            }
		                }
                        else
                        {
                            $adjuntosNoGuardados++;
                        }
                    }
                    else
                    {
                        $adjuntosNoGuardados++;
                    }
                }
    	    }
    	    
            $message = sprintf($this->mensajeError->msg502, $peticion);
            
            if(!empty($adjuntos) && $adjuntosNoGuardados > 0)
    	    {
    	        $message .= "<li>No se pudo guardar (".$adjuntosNoGuardados.") adjuntos solicitado. Inténtelo luego.</li>";
    	    }
    	    
            
            if($prospecto!='')
            {
                $resultado = array(
    				'prospecto' => (string) true,
    				'mensaje1'  => (string) $this->alertas->alertaExito($message),
    				'mensaje2'  => (string) $this->alertas->alertaExito($message).$this->alertas->refrescar(1)
    			);
            }
            else
            {
                $resultado = array(
    				'prospecto' => (string) false,
    				'mensaje1'  => (string) "",
    				'mensaje2'  => (string) $this->alertas->alertaExito($message).$this->alertas->refrescar(1)
    			);
            }
            
            echo json_encode($resultado);
		} 
		
	}

    public function detallePeticion($idPeticion)
    {
        if(isset($this->items['id']))
        {
			// ACCIONES
            $peticion = $this->peticiones->obtenerPeticion($idPeticion);
            
            if(empty($peticion))
            {
                return view('errors/404');
            }
            else
            {
                if($peticion['NroProspecto'] != '' && $peticion['NroProspecto'] != null)
                {
		            $datosProspecto = $this->peticiones->buscarInformacionProspectoPeticion($peticion['NroProspecto']);
		            $peticion['EstadoVisitaProspecto'] = $datosProspecto['EstadoVisita'];
                }
                else
                {
                    $peticion['EstadoVisitaProspecto'] = '';
                }
                
            
                $solicitante = $this->usuarios->where("IdUsuario ", $peticion['UsuarioCrea'])->first();
                $peticion['UsuarioSolicitante'] = $solicitante['Nombres'].' '.$solicitante['Apellidos'];
                $peticion['MatriculaSolicitante'] = $solicitante['Matricula'];
                
                $direccionSolicitante = $this->estructuraDirecciones->where("IDDireccion", $peticion['IDDireccionCrea'])->first();
                $areaSolicitante = $this->estructuraAreas->where("IDArea", $peticion['IDAreaCrea'])->first();
                $subareaSolicitante = $this->estructuraSubareas->where("IDSubarea", $peticion['IDSubareaCrea'])->first();
                $delegacionSolicitante = $this->estructuraDelegaciones->where("IDDelegacion", $peticion['IDDelegacionCrea'])->first();
                
                $peticion['DireccionSolicitante'] = $direccionSolicitante['Direccion'];
                $peticion['AreaSolicitante'] = $areaSolicitante['Area'];
                $peticion['SubareaSolicitante'] = $subareaSolicitante['Subarea'];
                $peticion['DelegacionSolicitante'] = $delegacionSolicitante['CC'].' - '.$delegacionSolicitante['LN'].' | '.$delegacionSolicitante['Delegacion'];
                $peticion['CCSolicitante'] = $delegacionSolicitante['CC'];
                
                if($peticion['TipoMoneda'] != '' && $peticion['TipoMoneda'] != null)
                {
		            
                    $listadoMonedas = array(
                        "PEN" => array(
                            "NOMBRE" => "Soles",
                            "SIMBOLO" => "S/"
                            ),
                        "USD" => array(
                            "NOMBRE" => "Dólares Americanos",
                            "SIMBOLO" => "$"
                            ),
                        "EUR" => array(
                            "NOMBRE" => "Euros",
                            "SIMBOLO" => "€"
                            )
                    );
                    
                    if (array_key_exists($peticion['TipoMoneda'], $listadoMonedas)) {
                        $items = $listadoMonedas[$peticion['TipoMoneda']];
                        $peticion['TipoMonedaText'] = "(".$items['SIMBOLO'].") ".$items['NOMBRE'];
                    } else {
                        $peticion['TipoMonedaText'] = '';
                    }
                }
                else
                {
                    $peticion['TipoMonedaText'] = '';
                }                


                $estados = $this->globales->estadosPeticion();
                
                $gruposTrabajoHabilitados = $this->gruposTrabajoUsuario->where("IdUsuario", $this->items['id'])->findAll();
                
                $auditoriaPeticion = $this->auditoria->listarAuditoriaEstadosPeticion($idPeticion);
                $comentariosPeticion = $this->peticionesComentarios->listadoComentariosPeticion($idPeticion);
                $adjuntosPeticion = $this->peticionesAdjuntos->where("IDPeticion", $idPeticion)->findAll();
			
                $timelinePeticion = array_merge($comentariosPeticion, $auditoriaPeticion);
                
                $fechaAud = array_column($timelinePeticion, 'Fecha');
                array_multisort($fechaAud, SORT_DESC, $timelinePeticion);
                
                foreach($timelinePeticion as $key=>$value)
                {
                    $modifica = $this->usuarios->where("IdUsuario ", $value['IDUsuario'])->first();
                    $timelinePeticion[$key]['NombreUsuarioModifica'] = $modifica['Nombres'].' '.$modifica['Apellidos'];
                    $timelinePeticion[$key]['MatriculaUsuarioModifica'] = $modifica['Matricula'];
                    
                    $direccion = $this->estructuraDirecciones->where("IDDireccion", $value['IDDireccion'])->first();
                    $area = $this->estructuraAreas->where("IDArea", $value['IDArea'])->first();
                    $subarea = $this->estructuraSubareas->where("IDSubarea", $value['IDSubarea'])->first();
                    $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $value['IDDelegacion'])->first();
                    $cargo = $this->cargos->where("IDCargo", $value['IDCargo'])->first();
                    
                    $timelinePeticion[$key]['DireccionModifica'] = $direccion['Direccion'];
                    $timelinePeticion[$key]['AreaModifica'] = $area['Area'];
                    $timelinePeticion[$key]['SubareaModifica'] = $subarea['Subarea'];
                    $timelinePeticion[$key]['DelegacionModifica'] = $delegacion['CC'].' - '.$delegacion['LN'].' | '.$delegacion['Delegacion'];
                    $timelinePeticion[$key]['CargoModifica'] = $cargo['Cargo'];
                    
                }
                
                foreach($comentariosPeticion as $key=>$value)
                {
                    $modifica = $this->usuarios->where("IdUsuario ", $value['IDUsuario'])->first();
                    $comentariosPeticion[$key]['NombreUsuario'] = $modifica['Nombres'].' '.$modifica['Apellidos'];
                    $comentariosPeticion[$key]['MatriculaUsuario'] = $modifica['Matricula'];
                    
                    $direccion = $this->estructuraDirecciones->where("IDDireccion", $value['IDDireccion'])->first();
                    $area = $this->estructuraAreas->where("IDArea", $value['IDArea'])->first();
                    $subarea = $this->estructuraSubareas->where("IDSubarea", $value['IDSubarea'])->first();
                    $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $value['IDDelegacion'])->first();
                    $cargo = $this->cargos->where("IDCargo", $value['IDCargo'])->first();
                    
                    $comentariosPeticion[$key]['Direccion'] = $direccion['Direccion'];
                    $comentariosPeticion[$key]['Area'] = $area['Area'];
                    $comentariosPeticion[$key]['Subarea'] = $subarea['Subarea'];
                    $comentariosPeticion[$key]['Delegacion'] = $delegacion['CC'].' - '.$delegacion['LN'].' | '.$delegacion['Delegacion'];
                    $comentariosPeticion[$key]['Cargo'] = $cargo['Cargo'];
                    
                }
                
                /*
                * ----------------------------
                * ACTUALIZAR VISUALIZACION NOTIFICACIONES
                * ----------------------------
                */
                $array = array(
                    "idusuario"         => $this->items['id'],
                    "grupoTrabajo"      => array_column($gruposTrabajoHabilitados,"IDGrupoTrabajo"),
                    "idperfil"          => $this->items['idPerfil'],
                    "solonovisto"       => "Y",
                    "idreferencia"      => $idPeticion,
                    "tablareferencia"   => "peticiones"
                );
                
                $this->marcarVisualizadoNotificacionMasivo($array);
                
                /*
                * ----------------------------
                * ARMAR INFORMACIÓN A MOSTRAR
                * ----------------------------
                */
    			$data = array (
    				'session'                   => 'on',
    				'titulo'                    => 'Detalle de Petición | Verisure',
    				'breadcrumb'                => $this->items['modulo'],
    				'breadcrumb_alias'          => 'Detalle de Petición | '.$peticion['Peticion'],
                    'previo'                    => 'listar-peticiones',
    				'estadosPeticion'           => $estados,
                    'peticion'                  => $peticion,
                    'gruposTrabajoHabilitados'  => $gruposTrabajoHabilitados,
                    'timelinePeticion'          => $timelinePeticion,
                    'comentariosPeticion'       => $comentariosPeticion,
                    'adjuntosPeticion'          => $adjuntosPeticion
    			);
    			$data = array_merge($data, $this->items);
    			return view('peticiones/ver_detalle_peticion',$data);	
            }
		} else {
			return view('errors/500');
		}
    }

    public function modificarEstadoPeticion($idPeticion)
    {
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
	    $nuevaNotificacion = array (
            'tabla'             => 'peticiones', 
            'idreferencia'      => $idPeticion,
            'url'               => "detalle-peticion/".$idPeticion, 
            'usuarioregistra'   => $this->items['id'],
            'fecharegistra'     => $fechaActual
        );
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $estado         = $this->request->getPost('txtEstadoPeticion_i');
        $motivo         = $this->request->getPost('txtMotivoCambioEstadoPeticion_i');
        $usuarioAsignado= $this->request->getPost('txtAsignarUsuarioPeticion_i');
        $gpDestino      = $this->request->getPost('txtGrupoTrabajoDerivadoPeticion_i');
        $anulacion      = $this->request->getPost('txtAnulacion');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idPeticion, 'required|trim|numeric', 'ID Petición');
        // $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[4]|maxlength[4]', 'Estado');

        if($estado == 'ASIG')
        {
            $error .= $this->complementos->validaCampo($usuarioAsignado, 'required|trim|numeric', 'Usuario Asignado');
        }
        
        if($estado == 'DERI')
        {
            $error .= $this->complementos->validaCampo($gpDestino, 'required|trim|numeric', 'Grupo de Trabajo Derivado');
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        $dataPeticion = array (
            'UsuarioModifica'       => $this->items['id'],
            'Estado'                => $estado, 
            'UsuarioEstado'         => $this->items['id'],
            'IDSubareaEstado'       => $this->items['idSubarea'], 
            'IDAreaEstado'          => $this->items['idArea'], 
            'IDDireccionEstado'     => $this->items['dpto'], 
            'IDPerfilEstado'        => $this->items['idPerfil'],
            'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
            'IDCargoEstado'         => $this->items['idCargoLog'],
            'Localhost'             => $this->request->getIPAddress()
        );
        
        $infoPeticion = $this->peticiones->where("IDPeticion", $idPeticion)->first();
        
        if($estado == 'ASIG')
        {
            if($infoPeticion['Estado'] != 'CREA' && $infoPeticion['Estado'] != 'DERI' && $infoPeticion['Estado'] != 'COMP' && $infoPeticion['Estado'] != 'ESPE')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $asignado = $this->usuarios->where("IdUsuario ", $usuarioAsignado)->first();
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "El usuario ".$asignado['Nombres']." ".$asignado['Apellidos']." (".$asignado['Matricula'].") ha sido asignado a esta petición.";
                $dataPeticion['UsuarioAsignado']= $usuarioAsignado;
                
                $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                $nuevaNotificacion['gtdestino'] = null;
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>ASIGNADO</span> la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'INIC')
        {
            if(!(
                ($infoPeticion['Estado'] == 'CREA' || $infoPeticion['Estado'] == 'DERI' || $infoPeticion['Estado'] == 'COMP' || $infoPeticion['Estado'] == 'ESPE') && 
                ($infoPeticion['UsuarioAsignado'] == '' || $infoPeticion['UsuarioAsignado'] == null)
                ) && 
                $infoPeticion['Estado'] != 'ASIG' && $infoPeticion['Estado'] != 'REEV')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                if($infoPeticion['UsuarioAsignado'] != '' && $infoPeticion['UsuarioAsignado'] != null)
                {
                    $dataPeticion['FechaModifica']  = $fechaActual;
                    $dataPeticion['FechaEstado']    = $fechaActual;
                    $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Iniciada.";
                    
                    $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                    $nuevaNotificacion['gtdestino'] = null;
                    $nuevaNotificacion['perfildestino'] = null;
                    $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>INICIADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
                }
                else
                {
                    $dataPeticionPrev = array (
                        'UsuarioAsignado'       => $this->items['id'],
                        'UsuarioModifica'       => $this->items['id'],
                        'FechaModifica'         => $fechaActual,
                        'Estado'                => 'ASIG', 
                        'FechaEstado'           => $fechaActual,
                        'UsuarioEstado'         => $this->items['id'],
                        'IDSubareaEstado'       => $this->items['idSubarea'], 
                        'IDAreaEstado'          => $this->items['idArea'], 
                        'IDDireccionEstado'     => $this->items['dpto'], 
                        'IDPerfilEstado'        => $this->items['idPerfil'],
                        'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                        'IDCargoEstado'         => $this->items['idCargoLog'],
                        'MotivoEstado'          => "El usuario ".$this->items['nombres']." ".$this->items['apellidos']." ha sido asignado a esta petición.",
                        'Localhost'             => $this->request->getIPAddress()
                    );
                    $lastIdPrev = $this->peticiones->update([$idPeticion], $dataPeticionPrev);
                    
                    if($lastIdPrev !== FALSE){
            			$dataPeticion['FechaModifica']  = $fechaActualAdd;
                        $dataPeticion['FechaEstado']    = $fechaActualAdd;
                        $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Iniciada.";
                        
                        $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                        $nuevaNotificacion['gtdestino'] = null;
                        $nuevaNotificacion['perfildestino'] = null;
                        $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>INICIADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            		}
            		else
            		{
            		    $message = sprintf($this->mensajeError->msg201, "No se puede gestionar la asignación del usuario. Inténtelo luego.[".$estado."]");
                        echo $this->alertas->alertaError($message);
            			exit;
            		}
                }
            }
        }
        else if($estado == 'ESPE')
        {
            if($infoPeticion['Estado'] == 'INIC')
            {
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión en espera.";
                $dataPeticion['UsuarioAsignado']= NULL;
                
                $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                $nuevaNotificacion['gtdestino'] = null;
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se encuentra <span class='color-espe'>EN ESPERA LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "No cuenta con estado previo autorizado para pausar la petición. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
        }
        else if($estado == 'COMP')
        {
            if($infoPeticion['Estado'] != 'INIC')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Terminada.";
                $dataPeticion['UsuarioAsignado']= NULL;
                
                $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                $nuevaNotificacion['gtdestino'] = null;
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-comp'>COMPLETADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'APRO')
        {
            if($infoPeticion['Estado'] != 'COMP')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Aprobada.";
                $dataPeticion['UsuarioAsignado']= NULL;
                
                $nuevaNotificacion['usuariodestino'] = null;
                $nuevaNotificacion['gtdestino'] = $infoPeticion['IDGrupoTrabajoDestino'];
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-apro'>APROBADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'REEV')
        {
            if($infoPeticion['Estado'] != 'COMP')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Gestión Reevaluada.";
                $dataPeticion['UsuarioAsignado']= NULL;
                
                $nuevaNotificacion['usuariodestino'] = null;
                $nuevaNotificacion['gtdestino'] = $infoPeticion['IDGrupoTrabajoDestino'];
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-reev'>REEVALUADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'DERI')
        {
            if(!in_array($infoPeticion['Estado'], array('COMP', 'REEV', 'ASIG', 'CREA', 'DERI')))
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $grupoTrabajo = $this->grupostrabajo->where("IDGrupoTrabajo", $gpDestino)->first();
                $dataPeticion['FechaModifica']          = $fechaActual;
                $dataPeticion['FechaEstado']            = $fechaActual;
                $dataPeticion['MotivoEstado']           = $motivo != '' && $motivo != null ? $motivo." Gestión Derivada al grupo de trabajo '".$grupoTrabajo['GrupoTrabajo']."'." : "Gestión Derivada al grupo de trabajo '".$grupoTrabajo['GrupoTrabajo']."'.";
                $dataPeticion['UsuarioAsignado']        = NULL;
                $dataPeticion['IDGrupoTrabajoDestino']  = $gpDestino;
                
                $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                $nuevaNotificacion['gtdestino'] = $gpDestino;
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-deri'>DERIVADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'CANC')
        {
                $dataPeticion['FechaModifica']  = $fechaActual;
                $dataPeticion['FechaEstado']    = $fechaActual;
                $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Petición Cancelada.";
                $dataPeticion['UsuarioAsignado']= NULL;
                
                $nuevaNotificacion['usuariodestino'] = $infoPeticion['UsuarioCrea'];
                $nuevaNotificacion['gtdestino'] = $infoPeticion['IDGrupoTrabajoDestino'];
                $nuevaNotificacion['perfildestino'] = null;
                $nuevaNotificacion['mensaje'] = "Se ha <span class='color-canc'>CANCELADO</span> la petición #".$idPeticion.".";
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "No se encontró gestión para el estado solicitado. Inténtelo luego.[".$estado."]");
            echo $this->alertas->alertaError($message);
			exit;
        }
    //     else if($estado == 'CERR')
    //     {
    //         if($infoPeticion['Estado'] == 'INIC')
    //         {
    //             $dataPeticionPrev = array (
    //                 'UsuarioAsignado'       => NULL,
    //                 'UsuarioModifica'       => $this->items['id'],
    //                 'FechaModifica'         => $fechaActual,
    //                 'Estado'                => 'COMP', 
    //                 'FechaEstado'           => $fechaActual,
    //                 'UsuarioEstado'         => $this->items['id'],
    //                 'IDSubareaEstado'       => $this->items['idSubarea'], 
    //                 'IDAreaEstado'          => $this->items['idArea'], 
    //                 'IDDireccionEstado'     => $this->items['dpto'], 
    //                 'IDPerfilEstado'        => $this->items['idPerfil'],
    //                 'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
    //                 'IDCargoEstado'         => $this->items['idCargoLog'],
    //                 'MotivoEstado'          => "Gestión Terminada.",
    //                 'Localhost'             => $this->request->getIPAddress()
    //             );
                
    //             $lastIdPrev = $this->peticiones->update([$idPeticion], $dataPeticionPrev);
                
    //             if($lastIdPrev !== FALSE){
    //     			$dataPeticion['FechaModifica']  = $fechaActualAdd;
    //                 $dataPeticion['FechaEstado']    = $fechaActualAdd;
    //                 $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Petición cerrada.";
    //     		}
    //     		else
    //     		{
    //     		    $message = sprintf($this->mensajeError->msg201, "No se puede gestionar la culminación de la gestión. Inténtelo luego.[".$estado."]");
    //                 echo $this->alertas->alertaError($message);
    //     			exit;
    //     		}
    //         }
    //         else if($infoPeticion['Estado'] != 'CREA' && $infoPeticion['Estado'] != 'COMP')
    //         {
    //             $message = sprintf($this->mensajeError->msg201, "No cuenta con estado previo autorizado para cerrar la petición. Inténtelo luego.[".$estado."]");
    //             echo $this->alertas->alertaError($message);
    // 			exit;
    //         }
    //         else
    //         {
    //             $dataPeticion['FechaModifica']  = $fechaActual;
    //             $dataPeticion['FechaEstado']    = $fechaActual;
    //             $dataPeticion['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Petición cerrada.";
    //         }
    //     }
        
        $lastId = $this->peticiones->update([$idPeticion], $dataPeticion);

		if($lastId !== FALSE){
		    
		    /*
            * ----------------------------
            * INSERCIÓN DE NOTIFICACIÓN
            * ----------------------------
            */
            
            if($estado != 'INIC')
            {
                $this->insertarNotificacion($nuevaNotificacion);
            }
		    
		    if($anulacion === true)
		    {
		        $peticionActual = $this->peticiones->obtenerPeticion($idPeticion);
		        
		        $arrayMotivo = array(
		            "NombreMotivo"      => $peticionActual['Motivo'],
		            "IDRequerimiento"   => 2
		        );
		        
		        $motivoNuevo = $this->requerimientosMotivo->buscarMotivoRequerimiento($arrayMotivo);
                /*
                * ----------------------------
                * INSERCIÓN DE DATOS
                * ----------------------------
                */
                $message = '';
                
                $dataPeticion = array (
                    'Peticion'              => "Anulación: ".$peticionActual['Peticion'], 
                    'NroProspecto'          => $peticionActual['NroProspecto'],
                    'IDMotivo'              => !empty($motivoNuevo) ? $motivoNuevo['IDMotivo'] : 29, 
                    'Detalle'               => $peticionActual['Detalle'], 
                    'LinkAsociado'          => $this->items['baseUrl'].'/detalle-peticion/'.$idPeticion, 
                    'IDGrupoTrabajoDestino' => 1, 
                    'UsuarioCrea'           => $this->items['id'],
                    'FechaCrea'             => $fechaActual,
                    'IDSubareaCrea'         => $this->items['idSubarea'], 
                    'IDAreaCrea'            => $this->items['idArea'], 
                    'IDDireccionCrea'       => $this->items['dpto'], 
                    'IDPerfilCrea'          => $this->items['idPerfil'],
                    'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
                    'IDCargoCrea'           => $this->items['idCargoLog'],
                    'Estado'                => "CREA", 
                    'UsuarioEstado'         => $this->items['id'],
                    'IDDireccionEstado'     => $this->items['dpto'], 
                    'IDAreaEstado'          => $this->items['idArea'], 
                    'IDSubareaEstado'       => $this->items['idSubarea'], 
                    'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                    'IDPerfilEstado'        => $this->items['idPerfil'],
                    'IDCargoEstado'         => $this->items['idCargoLog'],
                    'FechaEstado'           => $fechaActual,
                    'MotivoEstado'          => "Anulación: ".$peticionActual['Peticion'].': '.$peticionActual['Detalle'],
                    'Localhost'             => $this->request->getIPAddress(),
                    'NroContrato'           => NULL,
                    'PresupuestoAsignado'   => NULL,
                    'Producto'              => NULL,
                    'Cantidad'              => NULL,
                    'TipoMoneda'            => NULL
        
                );
                
                $lastIdAnulacion = $this->peticiones->insert($dataPeticion, TRUE);
                
        		if($lastIdAnulacion !== FALSE)
        		{
        		    /*
                    * ----------------------------
                    * INSERCIÓN DE NOTIFICACIÓN
                    * ----------------------------
                    */
        		    $nuevaNotificacionAnulacion = array (
                        'tabla'             => 'peticiones', 
                        'idreferencia'      => $lastIdAnulacion,
                        'mensaje'           => "Se ha <span class='color-crea'>CREADO</span> una nueva petición.", 
                        'url'               => "detalle-peticion/".$lastIdAnulacion, 
                        'usuariodestino'    => null, 
                        'gtdestino'         => 1, 
                        'perfildestino'     => null,
                        'usuarioregistra'   => $this->items['id'],
                        'fecharegistra'     => $fechaActual
                    );
                    
        		    $this->insertarNotificacion($nuevaNotificacionAnulacion);
        		    
        		} 
        		
		    }
		    
			$message = sprintf($this->mensajeError->msg503, $idPeticion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
		
	public function registrarComentarioPeticion($idPeticion)
	{
	    $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $comentario     = $this->request->getPost('txtComentarioPeticion_i');
        $linkComentario = $this->request->getPost('txtLinkComentarioPeticion_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($comentario, 'required|trim', 'Comentario');
        $error .= $this->complementos->validaCampo($linkComentario, 'trim|url', 'Link asociado');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * INSERCIÓN DE DATOS
        * ----------------------------
        */
        $message = '';
        
        $dataComentario = array (
            'IDPeticion'            => $idPeticion, 
            'Comentario'            => $comentario,
            'Link'                  => $linkComentario, 
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,
            'IDSubareaCrea'         => $this->items['idSubarea'], 
            'IDAreaCrea'            => $this->items['idArea'], 
            'IDDireccionCrea'       => $this->items['dpto'], 
            'IDPerfilCrea'          => $this->items['idPerfil'],
            'IDDelegacionCrea'      => $this->items['idDelegacionLog'],
            'IDCargoCrea'           => $this->items['idCargoLog'],
            'Estado'                => "A", 
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,
            'MotivoEstado'          => $comentario,
            'Localhost'             => $this->request->getIPAddress()
        );
        
        $lastId = $this->peticionesComentarios->insert($dataComentario, TRUE);
		if($lastId !== FALSE)
		{
		    /*
            * ----------------------------
            * INSERCIÓN DE NOTIFICACIÓN
            * ----------------------------
            */
            // $gruposTrabajoHabilitados = $this->gruposTrabajoUsuario->where("IdUsuario", $this->items['id'])->findAll();
            $infPeticion = $this->peticiones->where("IDPeticion", $idPeticion)->first();
            
		    $nuevaNotificacion = array (
                'tabla'             => 'peticiones', 
                'idreferencia'      => $idPeticion,
                'mensaje'           => "Se ha <span class='color-come'>COMENTADO</span> la petición #".$idPeticion.".", 
                'url'               => "detalle-peticion/".$idPeticion, 
                'usuarioregistra'   => $this->items['id'],
                'fecharegistra'     => $fechaActual
            );
            
            if($this->items['id'] == $infPeticion['UsuarioCrea'])
            {
                $asignado = $infPeticion['UsuarioAsignado'] != '' && $infPeticion['UsuarioAsignado'] != null ? $infPeticion['UsuarioAsignado'] : null;
                $nuevaNotificacion['usuariodestino'] = $asignado;
                $nuevaNotificacion['gtdestino'] = $infPeticion['IDGrupoTrabajoDestino'];
                $nuevaNotificacion['perfildestino'] = null;
            }
            else if($this->items['id'] == $infPeticion['UsuarioAsignado'])
            {
                $nuevaNotificacion['usuariodestino'] = $infPeticion['UsuarioCrea'];
                $nuevaNotificacion['gtdestino'] = null;
                $nuevaNotificacion['perfildestino'] = null;
            }
            else
            {
                $nuevaNotificacion['usuariodestino'] = $infPeticion['UsuarioCrea'];
                $nuevaNotificacion['gtdestino'] = $infPeticion['IDGrupoTrabajoDestino'];
                $nuevaNotificacion['perfildestino'] = null;
            }
            
		    $this->insertarNotificacion($nuevaNotificacion);
		    
			$message .= sprintf($this->mensajeError->msg201, "El comentario fue agregado con éxito.");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		} 
	}
	
	public function informacionProspectoPeticion($numProspecto)
	{
		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosProspecto = $this->peticiones->buscarInformacionProspectoPeticion($numProspecto);

		if(!empty($datosProspecto)){
			$resultado = array(
				'nroprospecto'  => (string) $numProspecto,
				'venta'         => (string) $datosProspecto['VENTA'],
				'cliente'       => (string) $datosProspecto['NombCliente'],
				'direccion'     => (string) $datosProspecto['DirCliente'],
				'intCliente'    => (string) $datosProspecto['IntCliente'],
				'referencia'    => (string) $datosProspecto['RefCliente'],
				'distrito'      => (string) $datosProspecto['DistCliente'],
				'provincia'     => (string) $datosProspecto['ProvCliente'],
				't1'            => (string) $datosProspecto['T1Cliente'],
				't2'            => (string) $datosProspecto['T2Cliente'],
				'correo'        => (string) $datosProspecto['CorreoCliente'],
				'fechavisita'   => (string) $datosProspecto['FechaVisita'],
				'horavisita'    => (string) $datosProspecto['HoraVisita'],
				'visitaobras'   => (string) $datosProspecto['FVisitaObras']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);	
	}
	
	public function exportarReportePeticionesBackOffice($fechaInicio, $fechaFin)
	{
	    $arrayFechas = array(
	        "fechaInicio"  => $fechaInicio,
	        "fechaFin"  => $fechaFin
	    );
	    
	    $listado = $this->peticiones->exportarReporteBackOffice($arrayFechas);
	    
        $filename = "ReportePeticiones.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("ID PETICIÓN"),
            WriterEntityFactory::createCell("FECHA PETICIÓN"),
            WriterEntityFactory::createCell("DELEGACIÓN"),
            WriterEntityFactory::createCell("MATRÍCULA RESP. DC"),
            WriterEntityFactory::createCell("RESP. DC"),
            WriterEntityFactory::createCell("PROSPECTO"),
            WriterEntityFactory::createCell("MATRÍCULA AGENTE"),
            WriterEntityFactory::createCell("AGENTE"),
            WriterEntityFactory::createCell("T1CLIENTE"),
            WriterEntityFactory::createCell("REQUERIMIENTO"),
            WriterEntityFactory::createCell("MOTIVO"),
            WriterEntityFactory::createCell("ESTADO"),
            WriterEntityFactory::createCell("MATRÍCULA USUARIO GESTIÓN"),
            WriterEntityFactory::createCell("USUARIO GESTIÓN"),
            WriterEntityFactory::createCell("INICIO GESTIÓN"),
            WriterEntityFactory::createCell("FIN GESTIÓN"),
            WriterEntityFactory::createCell("TIEMPO GESTIÓN")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listado as $key=>$item)
        {
            $creacion = date("Y-m-d", strtotime($item['FECHA_CREACION']));
			$cells = [
                WriterEntityFactory::createCell($item['IDPETICION']),
                WriterEntityFactory::createCell($creacion),
                WriterEntityFactory::createCell($item['DELEGACION']),
                WriterEntityFactory::createCell($item['MATRICULA_RESP_DC']),
                WriterEntityFactory::createCell($item['RESP_DC']),
                WriterEntityFactory::createCell($item['PROSPECTO']),
                WriterEntityFactory::createCell($item['MATRICULA_AGENTE']),
                WriterEntityFactory::createCell($item['AGENTE']),
                WriterEntityFactory::createCell($item['T1CLIENTE']),
                WriterEntityFactory::createCell($item['REQUERIMIENTO']),
                WriterEntityFactory::createCell($item['MOTIVO']),
                WriterEntityFactory::createCell($item['ESTADO']),
                WriterEntityFactory::createCell($item['MATRICULA_USUARIO_GESTION']),
                WriterEntityFactory::createCell($item['USUARIO_GESTION']),
                WriterEntityFactory::createCell($item['INICIO_GESTION']),
                WriterEntityFactory::createCell($item['FIN_GESTION']),
                WriterEntityFactory::createCell($item['TIEMPO_GESTION'])
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
	}
	
	public function listadoMonedas()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $listadoMonedas = array(
            "PEN" => array(
                "NOMBRE" => "Soles",
                "SIMBOLO" => "S/"
                ),
            "USD" => array(
                "NOMBRE" => "Dólares Americanos",
                "SIMBOLO" => "$"
                ),
            "EUR" => array(
                "NOMBRE" => "Euros",
                "SIMBOLO" => "€"
                )
        );
        
        $monedas = array();

		if (!empty($listadoMonedas)) {
    //         foreach ($listadoDistritos as $items) {
    //             $distritos[] = array(
				// 	'id'    => (string) $items['IDDistrito'],
    //      	        'text'  => (string) $items['Distrito'],
    //             );
    //         }
                
            foreach ($listadoMonedas as $key => $items) {
                $monedas[] = array(
					'id'    => (string) $key,
         	        'text'  => (string) "(".$items['SIMBOLO'].") ".$items['NOMBRE'],
         	        'simbolo'   => (string) $items['SIMBOLO']
                );
            }
            
            $resultado = array(
				'listadoMonedas' => json_encode($monedas)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}	
	
	
}