<?php

use CodeIgniter\Router\RouteCollection;
$routes->get('test-controller', 'TestController::index');
// $routes->add('test', function() {
//     return 'Ruta de prueba funcionando';
// });
/**
 * @var RouteCollection $routes
 */
// $routes->get('/', 'Home::index');
$routes->set404Override(function()
{
    echo view('errors/404');
});
/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Acceso::login');

/* ACCESO */
$routes->add('entrar', 'Acceso::entrar');
$routes->add('salir','Acceso::salir');
$routes->add('iniciar-sesion','Acceso::login');
$routes->add('cambiar-password', 'Acceso::cambiarPasswordUsuario');

/* ADMINISTRACIÓN */
$routes->add('descargatxt/(:any)','Administracion::descargatxt/$1');/* NUEVO */

$routes->add('listar-usuarios','Administracion::listarUsuarios');/* NUEVO */

$routes->add('listar-perfiles','Administracion::listarPerfiles');/* NUEVO */
$routes->add('registrar-perfil','Administracion::registrarPerfil');/* NUEVO */
$routes->add('listado-perfil-select','Administracion::listadoPerfilesSelect');/* NUEVO */
$routes->add('obtener-datos-perfil','Administracion::obtenerDatosPerfil');/* NUEVO */
$routes->add('actualizar-perfil/(:any)','Administracion::actualizarPerfil/$1');/* NUEVO */
$routes->add('cambiar-estado-perfil','Administracion::modificarEstadoPerfil');/* NUEVO */

$routes->add('listar-permisos-perfil/(:any)','Administracion::listarPermisosPerfil/$1');/* NUEVO */
$routes->add('grabar-permisos-perfil/(:any)','Administracion::guardarPermisosPerfil/$1');/* NUEVO */
$routes->add('listar-rutas-perfil/(:any)','Administracion::listarRutasPerfil/$1');/* NUEVO */
$routes->add('grabar-rutas-perfil/(:any)','Administracion::guardarRutasPerfil/$1');/* NUEVO */

$routes->add('obtener-cabecera','Administracion::obtenerCabecera');/* NUEVO */
$routes->add('listar-modulos','Administracion::listarModulos');/* NUEVO */
$routes->add('registrar-modulo','Administracion::registrarModulo');/* NUEVO */
$routes->add('cambiar-estado-modulo','Administracion::modificarEstadoModulo');/* NUEVO */
$routes->add('obtener-datos-modulo','Administracion::obtenerDatosModulo');/* NUEVO */
$routes->add('actualizar-modulo/(:any)','Administracion::modificarModulo/$1');/* NUEVO */
$routes->add('listar-rutas-modulo/(:any)','Administracion::listarRutasModulo/$1');/* NUEVO */
$routes->add('grabar-ruta/(:any)','Administracion::guardarRutaModulo/$1');/* NUEVO */
$routes->add('obtener-datos-ruta-modulo','Administracion::obtenerDatosRutaModulo');/* NUEVO */
$routes->add('actualizar-ruta-modulo/(:any)','Administracion::modificarRutaModulo/$1');/* NUEVO */
$routes->add('cambiar-estado-ruta-modulo','Administracion::modificarEstadoRutaModulo');/* NUEVO */
$routes->add('listar-acciones-modulo/(:any)','Administracion::listarAccionesModulo/$1');/* NUEVO */
$routes->add('grabar-accion/(:any)','Administracion::guardarAccionModulo/$1');/* NUEVO */

/******************************************************************************/
	
/* USUARIOS */
$routes->add('usuariosServerside','Usuarios::listarUsuarioDataTable');/* NUEVO */
$routes->add('obtener-datos-usuario/(:any)','Usuarios::obtenerDatosUsuario/$1');
$routes->add('modificar-usuario/(:any)','Usuarios::modificarUsuario/$1');/* NUEVO */
$routes->add('listado-usuarios-select','Usuarios::listadoUsuariosSelect');
$routes->add('listado-usuarios-comprador','Usuarios::listadoUsuariosComprador');

$routes->add('listar-permisos-usuario/(:any)','Usuarios::listarPermisosUsuario/$1');/* NUEVO */
$routes->add('grabar-permisos-usuario/(:any)','Usuarios::guardarPermisosUsuario/$1');/* NUEVO */
$routes->add('listar-rutas-usuario/(:any)','Usuarios::listarRutasUsuario/$1');/* NUEVO */
$routes->add('grabar-rutas-usuario/(:any)','Usuarios::guardarRutasUsuario/$1');/* NUEVO */

/******************************************************************************/

/*************************** NOTIFICACIONES ***********************************/
$routes->add('cargar-notificaciones-header','Notificaciones::cargarNotificacionesHeader');/* NUEVO */
$routes->add('cantidad-notificaciones-header','Notificaciones::cantidadNotificacionesHeader');/* NUEVO */
$routes->add('registrar-vista-notificacion','Notificaciones::registrarVisualizacionNotificacion');/* NUEVO */

/******************************************************************************/
	
/*************************** REFERIDOS ************************************/

// $routes->add('supercolaborador','Referidos::viewSupercolaborador'); 
// $routes->add('registrar-referido-supercolaborador','Referidos::registrarReferidoSupercolaborador'); 
// $routes->add('nuevo-referido','Referidos::viewReferidoATC'); 

/******************************************************************************/
	
/********************************** PROCESOS **********************************/ 

$routes->add('listar-requerimientos','Configuracion::listarRequerimientos');/* NUEVO */
$routes->add('registrar-requerimiento','Configuracion::registrarRequerimiento');/* NUEVO */
$routes->add('obtener-datos-requerimiento','Configuracion::obtenerDatosRequerimiento');/* NUEVO */
$routes->add('actualizar-requerimiento/(:any)','Configuracion::modificarRequerimiento/$1');/* NUEVO */
$routes->add('cambiar-estado-requerimiento','Configuracion::modificarEstadoRequerimiento');/* NUEVO */
$routes->add('listado-requerimiento','Configuracion::listadoRequerimientos');/* NUEVO */
$routes->add('listado-tipo-requerimiento','Configuracion::listadoTipoRequerimientos');/* NUEVO */

$routes->add('listar-motivos-requerimiento/(:any)','Configuracion::listarMotivosRequerimiento/$1');/* NUEVO */
$routes->add('registrar-motivo-requerimiento','Configuracion::registrarMotivoRequerimiento');/* NUEVO */
$routes->add('obtener-datos-motivo-requerimiento','Configuracion::obtenerDatosMotivoRequerimiento');/* NUEVO */
$routes->add('actualizar-motivo-requerimiento/(:any)','Configuracion::modificarMotivoRequerimiento/$1');/* NUEVO */
$routes->add('cambiar-estado-motivo-requerimiento','Configuracion::modificarEstadoMotivoRequerimiento');/* NUEVO */
$routes->add('listado-motivo-requerimiento','Configuracion::listadoMotivosRequerimiento');/* NUEVO */

$routes->add('listar-perfiles-requerimiento/(:any)','Configuracion::listarPerfilesRequerimiento/$1');/* NUEVO */
$routes->add('grabar-perfiles-requerimiento/(:any)','Configuracion::guardarPerfilesRequerimiento/$1');/* NUEVO */

$routes->add('listar-grupos-trabajo-requerimiento/(:any)','Configuracion::listarGruposTrabajoRequerimiento/$1');/* NUEVO */
$routes->add('grabar-grupos-trabajo-requerimiento/(:any)','Configuracion::guardarGruposTrabajoRequerimiento/$1');/* NUEVO */
$routes->add('listado-grupos-trabajo-requerimiento','Configuracion::listadoGruposTrabajoRequerimiento');/* NUEVO */

$routes->add('listar-grupos-trabajo','Configuracion::listarGruposTrabajo');/* NUEVO */
$routes->add('registrar-grupo-trabajo','Configuracion::registrarGrupoTrabajo');/* NUEVO */
$routes->add('obtener-datos-grupo-trabajo','Configuracion::obtenerDatosGrupoTrabajo');/* NUEVO */
$routes->add('actualizar-grupo-trabajo/(:any)','Configuracion::modificarGrupoTrabajo/$1');/* NUEVO */
$routes->add('cambiar-estado-grupo-trabajo','Configuracion::modificarEstadoGrupoTrabajo');/* NUEVO */
$routes->add('listado-grupos-trabajo','Configuracion::listadoGruposTrabajo');/* NUEVO */

$routes->add('listar-usuarios-grupo-trabajo/(:any)','Configuracion::listarUsuariosGrupoTrabajo/$1');/* NUEVO */
$routes->add('asociar-usuario-grupo-trabajo','Configuracion::asociarUsuarioGrupoTrabajo');/* NUEVO */
$routes->add('eliminar-usuario-grupo-trabajo','Configuracion::eliminarUsuarioGrupoTrabajo');/* NUEVO */
$routes->add('listado-usuarios-grupotrabajo-select','Configuracion::listarUsuariosGrupoTrabajoSelect');/* NUEVO */

/* PETICIONES */

$routes->add('listar-peticiones','Peticiones::listarPeticiones');/* NUEVO */
$routes->add('grabar-peticion','Peticiones::registrarPeticion');/* NUEVO */
$routes->add('detalle-peticion/(:any)','Peticiones::detallePeticion/$1');/* NUEVO */
$routes->add('cambio-estado-peticion/(:any)','Peticiones::modificarEstadoPeticion/$1');/* NUEVO */
$routes->add('agregar-comentario-peticion/(:any)','Peticiones::registrarComentarioPeticion/$1');/* NUEVO */
$routes->add('peticionesServersideHistorico','Peticiones::peticionesServersideHistorico');/* NUEVO */
$routes->add('informacion-prospecto-peticion/(:any)','Peticiones::informacionProspectoPeticion/$1');/* NUEVO */
$routes->add('exportar-reporte-peticiones-backoffice/(:any)/(:any)','Peticiones::exportarReportePeticionesBackOffice/$1/$2');/* NUEVO */

$routes->add('listado-monedas','Peticiones::listadoMonedas');/* NUEVO */

/******************************************************************************/
	
/*************************** LANDING PERSONALIZADOS ***************************/

/******************************************************************************/
	
/****************************** REMOTOS **************************************/

$routes->add('listado-direccion-busqueda','Remotos::listadoDireccionBusqueda');/* NUEVO */
$routes->add('listado-region-pais','Remotos::listadoRegionPais');/* NUEVO */
$routes->add('listado-region-departamentos','Remotos::listadoRegionDepartamento');/* NUEVO */
$routes->add('listado-region-provincias','Remotos::listadoRegionProvincia');/* NUEVO */
$routes->add('listado-region-distritos','Remotos::listadoRegionDistrito');/* NUEVO */

$routes->add('listado-monedas','Remotos::listadoMonedas');/* NUEVO */
$routes->add('listado-tipos-documento','Remotos::listadoTiposDocumento');/* NUEVO */
$routes->add('listado-tipos-documento-sunat','Remotos::listadoTiposDocumentoSunat');/* NUEVO */

$routes->add('listado-direccion-estructura','Remotos::listadoDireccionesEstructura');/* NUEVO */
$routes->add('listado-area-estructura','Remotos::listadoAreasEstructura');/* NUEVO */
$routes->add('listado-subarea-estructura','Remotos::listadoSubareasEstructura');/* NUEVO */
$routes->add('listado-delegacion-estructura','Remotos::listadoDelegacionEstructura');/* NUEVO */
$routes->add('listado-cc-delegacion-estructura','Remotos::listadoCCDelegacionEstructura');/* NUEVO */
$routes->add('listado-estructura-delegacion','Remotos::listadoEstructuraDelegacion');/* NUEVO */
$routes->add('exportar-estructura-departamental','Remotos::exportarEstructuraDepartamental');/* NUEVO */

$routes->add('listado-responsables-direccion-estructura','Remotos::listadoResponsablesDireccionEstructura');/* NUEVO */
$routes->add('listado-responsables-area-estructura','Remotos::listadoResponsablesAreaEstructura');/* NUEVO */
$routes->add('listado-responsables-subarea-estructura','Remotos::listadoResponsablesSubareaEstructura');/* NUEVO */

$routes->add('listado-usuarios','Remotos::listadoUsuarios');/* NUEVO */
