<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
								<?php
								if (in_array("ADDBAN", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-banco" data-bs-target="#informacionBanco" data-id="0" data-accion="crear" id="crear-banco">
									<i class="mdi mdi-plus-circle"></i> Agregar 
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblBancos" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Correlativo</th>
										<th class="text-center align-middle">Código Interno</th>
										<th class="text-center align-middle">Banco</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listadoBancos as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDBanco'] ?></td>
										<td class="text-center align-middle"><?= $items['CodigoInterno'] ?></td>
										<td class="text-center align-middle"><?= $items['Nombre'] ?></td>
										<td class="text-center align-middle">
										<?php
										if (in_array("ESTBAN", $permisos)) 
										{
										?>
											<button class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-danger' ?> border-0 cambiar-estado-banco" data-estado="<?= $items['Estado'] ?>" data-id="<?= $items['IDBanco'] ?>"><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></button>
										<?php
										}
										else
										{
										?>
											<span class="badge <?= $items['Estado'] == "A" ? 'bg-success' : 'bg-danger' ?> border-0" ><?= $items['Estado'] == "A" ? 'ACTIVO' : 'INACTIVO' ?></span>
										<?php
										}
										?>	
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-banco" data-bs-target="#informacionBanco" data-id="<?= $items['IDBanco'] ?>" data-accion="ver" id="ver-banco">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDBAN", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-banco" data-bs-target="#informacionBanco" data-id="<?= $items['IDBanco'] ?>" data-accion="editar" id="editar-banco">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													?>	
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Tipologia -->
<div class="modal fade zoomIn" id="informacionBanco" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionBanco" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionBanco">Información de Banco</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionBanco" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDBanco_i" name="txtIDBanco_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtCodigoInternoBanco_i" class="form-label">Código Interno</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Código Interno" id="txtCodigoInternoBanco_i" name="txtCodigoInternoBanco_i">
							</div>
						</div>
					    <div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtNombreBanco_i" class="form-label">Nombre Banco</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Nombre Banco" id="txtNombreBanco_i" name="txtNombreBanco_i">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" id="btnEjecutarBanco" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>