<?php namespace App\Models;

use CodeIgniter\Model;

class VentasModel extends Model {
    protected $DBGroup = 'verismart';
    protected $table = 'tblventa';
    protected $primaryKey = 'IdVenta';
    protected $allowedFields = ['IdVenta', 'IdUsuario', 'IdCliente', 'FechaHoraREG', 'FechaHoraMod', 'Matricula', 'Comercial', 'CC', 'JefeVenta', 'CategoriaVenta', 'TipoVenta', 'Segmento', 'NProspecto', 'NContrato', 'N590', 'PrecioKit', 'TotalExtra', 'IngresoKIT', 'IngresoExtras', 'IngresoTotal', 'EstadoVenta', 'ExtraAutorizado', 'MesesAutorizado', 'FormaPago', 'PAI', 'ResumenVenta', 'EstadoVisita', 'FechaVisita', 'HoraVisita', 'FVencimientoVisita', 'MotivoAnuladaVisita', 'GestorMKT', 'OrigenVisita', 'ComentarioVisita', 'FObras', 'FVisitaObras', 'CodScoring', 'GestorOrigen', 'TCTipoVenta', 'TCGestor', 'TCComentario', 'EstadoTelecierre', 'TCMotivoNoVenta', 'PrecioKITOriginal', 'TotalExtraOriginal', 'ResumenVentaOriginal', 'ExtraAutorizadoOriginal', 'FormaPagoOriginal', 'MesesAutorizadoOriginal', 'PAIOriginal', 'CCOriginal', 'IMP', 'AutorizacionScoring', 'SinFoto', 'GestFotoCorreo', 'Checkin', 'InfoCheckIn', 'CheckOut', 'InfoCheckOut', 'totalHistorial', 'VisitaNoVisitable', 'infoVNOV', 'MesVisita', 'ContactadoCO', 'ComentarioCO', 'TCVisitado', 'TCScoring', 'TCCompetencia', 'MotivoNoVenta', 'Competencia', 'IdProspectoRP', 'VTAConfirmadaCO', 'TipoTV', 'NProspectoCC', 'MesTeleventa', 'LeadID', 'TCFechaRellamada', 'TCHoraRellamada', 'FechaGestionTC', 'HojaCertificacion', 'CertificadoValidado', 'TipoKIT', 'CantidadExtras', 'CantidadRegalo', 'Prioridad', 'HabilitadoTV', 'FormaPagoCuota', 'DescMeses', 'TipoKITOriginal', 'ClosingPack', 'PrecioEspecial', 'CantidadExtrasOriginal', 'CantidadRegaloOriginal', 'ScoringRP', 'TotalCuotaMonitoreo', 'IdLead', 'Accion', 'PerfilScoring', 'IdConsultaScoring', 'objCotizacion', 'TotalIntentos', 'CantidadDiasA', 'GGCC', 'Observacion', 'IdGGCC', 'IdConsultaScoringRP', 'MotivoDifDelegacion', 'GestorCertVenta', 'IdCertVenta', 'FechaApertura', 'RegalosAutorizados', 'ExtrasAutorizados', 'Nivel_1', 'Nivel_2', 'PerfilScoringOriginal', 'CategoriaPrecio', 'referidoHabilitado', 'GrupoACD', 'CalificacionVisita', 'dsctCuota', 'DetalleObservaciones', 'FechaHoraAsignacion', 'Vueltas', 'FechaUltimaGestion', 'ProspectoAbierto', 'VisitaExpress', 'ClosingpackAutorizados', 'CategoriaKitAutorizados', 'DescuentoCuotaAutorizados', 'TipoCamaraKit', 'FechaTCFI', 'IteraccionAgenda', 'SegundaAlarma', 'IteraccionAttec', 'IdConsultaScoringTCTV', 'FechaHoraTransferenciaTC', 'TCAcuerdoComercial', 'referidoHabilitadoTVTC', 'ComentarioCancelacion', 'ContratoEnviado', 'ContratoCorrecto', 'MotivoTransferencia', 'FechaContratoEnviado', 'FechaProspectoAbierto', 'MotivoAsignacion', 'pagoAdelantado', 'ContactoAsignacion', 'CumpleRanking', 'MatriculaOriginal', 'visePiso', 'rubroNeg', 'puertaCalle', 'nobleParedes', 'nobleTecho', 'metros', 'motivoInteres', 'conSistema', 'empresaSistema', 'bancarizado', 'Renove', 'RCompetencia', 'RVencimiento', 'IdTCTVgestion', 'Visibilidad', 'FechaSolicitudAnulacion', 'SeAnula', 'ComentariosAnulacion', 'DetalleAnulacion', 'errorGestion', 'pagoenviadoCO', 'montoCO', 'motivoincidenciaCO', 'contratocorregidoenviadoCO', 'fechadiferenciaCO', 'fechaenviocontratocorregidofinalCO', 'diferenciamontoCO', 'comentarior2CO', 'fechagestiondocCO', 'fechagestiondocr2CO', 'CCTVTC', 'FechaHoraTransferenciaTCTeleventa', 'FechaHoraTransferenciaTVRemarketing', 'FechaHoraTransferenciaTelecierredos', 'horarioSugerido', 'IdVentaVREL', 'segundaDireccion', 'IdLeadEXT', 'FechaHoraTransferenciaTCRemarketing', 'OPENumber', 'FechaVenta', 'FechaHoraTransferenciaTVBaseexterna'];

    public function obtenerVentaPorId($idVenta)
    {
        $this->select('tblventa.NContrato,
        tbltmpscoring.NumeroDocumento AS DocumentoScoring,
        CASE 
            WHEN tbltmpscoring.TipoDocumento = 6 AND (tbltmpscoring.Nombres IS NULL OR tbltmpscoring.Nombres = "") AND (tbltmpscoring.ApellidoPaterno IS NULL OR tbltmpscoring.ApellidoPaterno = "") 
                THEN tbltmpscoring.RazonSocial 
            ELSE CONCAT(tbltmpscoring.Nombres, " ", tbltmpscoring.ApellidoPaterno, " ", tbltmpscoring.ApellidoMaterno) 
        END AS NombreScoring,
        tblcliente.Direccion,
        tblfacturacion.TipoComprobante,
        DATE_FORMAT(tblagenda.FechaInst, "%d/%m/%Y") AS fechainstalacionver,
        tblcliente.Correo,
        tblcliente.Telefonouno AS movil,
        tblventa.TipoKIT,
        tblventa.TotalCuotaMonitoreo,
        tblventa.FormaPagoCuota,
        tblventa.PrecioKit,
        tblventa.TotalExtra,
        tblventacotizacion.DetalleRegalos,
        tblventa.dsctCuota,
        tblventa.PAI');
        
        $this->join('tblcliente', 'tblventa.IdCliente = tblcliente.IdCliente', 'left');
        $this->join('tbltmpscoring', 'tbltmpscoring.IdConsultaScoring=tblventa.IdConsultaScoringRP', 'left');
        $this->join('tblagenda', 'tblventa.IdVenta = tblagenda.IdVenta', 'left');
        $this->join('tblfacturacion', 'tblventa.IdVenta = tblfacturacion.IdVenta', 'left');
        $this->join('tblventacotizacion', 'tblventa.IdVenta = tblventacotizacion.IdVenta', 'left');
        $this->where('tblventa.IdVenta', $idVenta);

        $datos = $this->first();
        return $datos;
    }

    
}
